/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.sentence.VDRSentence;
import net.sf.marineapi.nmea.util.Units;

class VDRParser
extends SentenceParser
implements VDRSentence {
    private static final int TRUE_DIRECTION = 0;
    private static final int TRUE_INDICATOR = 1;
    private static final int MAGN_DIRECTION = 2;
    private static final int MAGN_INDICATOR = 3;
    private static final int SPEED = 4;
    private static final int SPEED_UNITS = 5;

    public VDRParser(String nmea) {
        super(nmea);
    }

    public VDRParser(TalkerId tid) {
        super(tid, SentenceId.VDR, 6);
        this.setCharValue(1, 'T');
        this.setCharValue(3, 'M');
        this.setCharValue(5, Units.KNOT.toChar());
    }

    @Override
    public double getMagneticDirection() {
        return this.getDoubleValue(2);
    }

    @Override
    public double getSpeed() {
        return this.getDoubleValue(4);
    }

    @Override
    public double getTrueDirection() {
        return this.getDoubleValue(0);
    }

    @Override
    public void setMagneticDirection(double direction) {
        this.setDegreesValue(2, direction);
    }

    @Override
    public void setSpeed(double speed) {
        this.setDoubleValue(4, speed, 0, 1);
    }

    @Override
    public void setTrueDirection(double direction) {
        this.setDegreesValue(0, direction);
    }
}

