/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.util.ArrayList;
import net.sf.marineapi.nmea.parser.DataNotAvailableException;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.RTESentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.RouteType;

class RTEParser
extends SentenceParser
implements RTESentence {
    private static final int NUMBER_OF_SENTENCES = 0;
    private static final int SENTENCE_NUMBER = 1;
    private static final int STATUS = 2;
    private static final int ROUTE_ID = 3;
    private static final int FIRST_WPT = 4;

    public RTEParser(String nmea) {
        super(nmea, SentenceId.RTE);
    }

    public RTEParser(TalkerId talker) {
        super(talker, SentenceId.RTE, 4);
    }

    @Override
    public int addWaypointId(String id) {
        String[] ids = this.getWaypointIds();
        String[] newIds = new String[ids.length + 1];
        System.arraycopy(ids, 0, newIds, 0, ids.length);
        newIds[newIds.length - 1] = id;
        this.setStringValues(4, newIds);
        return newIds.length;
    }

    @Override
    public String getRouteId() {
        return this.getStringValue(3);
    }

    @Override
    public int getSentenceCount() {
        return this.getIntValue(0);
    }

    @Override
    public int getSentenceIndex() {
        return this.getIntValue(1);
    }

    @Override
    public int getWaypointCount() {
        return this.getWaypointIds().length;
    }

    @Override
    public String[] getWaypointIds() {
        ArrayList<String> temp = new ArrayList<String>();
        int i = 4;
        while (i < this.getFieldCount()) {
            try {
                temp.add(this.getStringValue(i));
            }
            catch (DataNotAvailableException dataNotAvailableException) {
                // empty catch block
            }
            ++i;
        }
        return temp.toArray(new String[temp.size()]);
    }

    @Override
    public boolean isActiveRoute() {
        return this.getCharValue(2) == RouteType.ACTIVE.toChar();
    }

    @Override
    public boolean isFirst() {
        return this.getSentenceIndex() == 1;
    }

    @Override
    public boolean isLast() {
        return this.getSentenceIndex() == this.getSentenceCount();
    }

    @Override
    public boolean isWorkingRoute() {
        return this.getCharValue(2) == RouteType.WORKING.toChar();
    }

    @Override
    public void setRouteId(String id) {
        this.setStringValue(3, id);
    }

    @Override
    public void setRouteType(RouteType type) {
        this.setCharValue(2, type.toChar());
    }

    @Override
    public void setSentenceCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count cannot be negative");
        }
        this.setIntValue(0, count);
    }

    @Override
    public void setSentenceIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index cannot be negative");
        }
        this.setIntValue(1, index);
    }

    @Override
    public void setWaypointIds(String[] ids) {
        this.setStringValues(4, ids);
    }
}

