/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.ROTSentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.DataStatus;

class ROTParser
extends SentenceParser
implements ROTSentence {
    private static final int RATE_OF_TURN = 0;
    private static final int STATUS = 1;

    public ROTParser(String nmea) {
        super(nmea, SentenceId.ROT);
    }

    public ROTParser(TalkerId talker) {
        super(talker, SentenceId.ROT, 2);
    }

    @Override
    public double getRateOfTurn() {
        return this.getDoubleValue(0);
    }

    @Override
    public DataStatus getStatus() {
        return DataStatus.valueOf(this.getCharValue(1));
    }

    @Override
    public void setRateOfTurn(double rot) {
        this.setDegreesValue(0, rot);
    }

    @Override
    public void setStatus(DataStatus status) {
        this.setCharValue(1, status.toChar());
    }
}

