/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.parser;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.sf.marineapi.nmea.parser.ParseException;
import net.sf.marineapi.nmea.parser.SentenceParser;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.TalkerId;
import net.sf.marineapi.nmea.util.CompassPoint;
import net.sf.marineapi.nmea.util.Position;

abstract class PositionParser
extends SentenceParser {
    protected PositionParser(String nmea, SentenceId type) {
        super(nmea, type);
    }

    protected PositionParser(TalkerId talker, SentenceId type, int size) {
        super(talker, type, size);
    }

    protected CompassPoint parseHemisphereLat(int index) {
        char ch = this.getCharValue(index);
        CompassPoint d = CompassPoint.valueOf(ch);
        if (d != CompassPoint.NORTH && d != CompassPoint.SOUTH) {
            throw new ParseException("Invalid latitude hemisphere '" + ch + "'");
        }
        return d;
    }

    protected CompassPoint parseHemisphereLon(int index) {
        char ch = this.getCharValue(index);
        CompassPoint d = CompassPoint.valueOf(ch);
        if (d != CompassPoint.EAST && d != CompassPoint.WEST) {
            throw new ParseException("Invalid longitude hemisphere " + ch + "'");
        }
        return d;
    }

    protected double parseLatitude(int index) {
        String field = this.getStringValue(index);
        int deg = Integer.parseInt(field.substring(0, 2));
        double min = Double.parseDouble(field.substring(2));
        return (double)deg + min / 60.0;
    }

    protected double parseLongitude(int index) {
        String field = this.getStringValue(index);
        int deg = Integer.parseInt(field.substring(0, 3));
        double min = Double.parseDouble(field.substring(3));
        return (double)deg + min / 60.0;
    }

    protected Position parsePosition(int latIndex, int latHemIndex, int lonIndex, int lonHemIndex) {
        double lat = this.parseLatitude(latIndex);
        double lon = this.parseLongitude(lonIndex);
        CompassPoint lath = this.parseHemisphereLat(latHemIndex);
        CompassPoint lonh = this.parseHemisphereLon(lonHemIndex);
        if (lath.equals((Object)CompassPoint.SOUTH)) {
            lat = -lat;
        }
        if (lonh.equals((Object)CompassPoint.WEST)) {
            lon = -lon;
        }
        return new Position(lat, lon);
    }

    protected void setLatHemisphere(int field, CompassPoint hem) {
        if (hem != CompassPoint.NORTH && hem != CompassPoint.SOUTH) {
            throw new IllegalArgumentException("Invalid latitude hemisphere: " + (Object)((Object)hem));
        }
        this.setCharValue(field, hem.toChar());
    }

    protected void setLatitude(int index, double lat) {
        int deg = (int)Math.floor(lat);
        double min = (lat - (double)deg) * 60.0;
        DecimalFormat df = new DecimalFormat("00.000");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        String result = String.format("%02d%s", deg, df.format(min));
        this.setStringValue(index, result);
    }

    protected void setLongitude(int index, double lon) {
        int deg = (int)Math.floor(lon);
        double min = (lon - (double)deg) * 60.0;
        DecimalFormat nf = new DecimalFormat("00.000");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        nf.setDecimalFormatSymbols(dfs);
        String result = String.format("%03d%s", deg, nf.format(min));
        this.setStringValue(index, result);
    }

    protected void setLonHemisphere(int field, CompassPoint hem) {
        if (hem != CompassPoint.EAST && hem != CompassPoint.WEST) {
            throw new IllegalArgumentException("Invalid longitude hemisphere: " + (Object)((Object)hem));
        }
        this.setCharValue(field, hem.toChar());
    }

    protected void setPositionValues(Position p, int latIndex, int latHemIndex, int lonIndex, int lonHemIndex) {
        this.setLatitude(latIndex, Math.abs(p.getLatitude()));
        this.setLongitude(lonIndex, Math.abs(p.getLongitude()));
        this.setLatHemisphere(latHemIndex, p.getLatitudeHemisphere());
        this.setLonHemisphere(lonHemIndex, p.getLongitudeHemisphere());
    }
}

