/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.ais.parser;

import java.util.ArrayList;
import java.util.List;
import net.sf.marineapi.ais.message.AISMessage;
import net.sf.marineapi.ais.util.Sixbit;
import net.sf.marineapi.ais.util.Violation;

public class AISMessageParser
implements AISMessage {
    private String message = "";
    private int fillbits;
    private int lastFragmentNr;
    private Sixbit decoder;
    private int messageType;
    private int repeatIndicator;
    private int mmsi;
    private static int MESSAGE_TYPE = 0;
    private static int REPEAT_INDICATOR = 1;
    private static int MMSI = 2;
    private static int[] FROM;
    private static int[] TO;
    protected List<Violation> fViolations = new ArrayList<Violation>();

    static {
        int[] nArray = new int[3];
        nArray[1] = 6;
        nArray[2] = 8;
        FROM = nArray;
        TO = new int[]{6, 8, 38};
    }

    public AISMessageParser() {
    }

    protected AISMessageParser(Sixbit sb) {
        this.decoder = sb;
    }

    public void addViolation(Violation v) {
        this.fViolations.add(v);
    }

    public int getNrOfViolations() {
        return this.fViolations.size();
    }

    public List<Violation> getViolations() {
        return this.fViolations;
    }

    @Override
    public int getMessageType() {
        this.parseAIS();
        return this.messageType;
    }

    @Override
    public int getRepeatIndicator() {
        this.parseAIS();
        return this.repeatIndicator;
    }

    @Override
    public int getMMSI() {
        this.parseAIS();
        return this.mmsi;
    }

    public Sixbit getMessageBody() {
        this.parseAIS();
        return this.decoder;
    }

    public void append(String fragment, int fragmentIndex, int fillBits) {
        this.lastFragmentNr = fragmentIndex;
        this.message = String.valueOf(this.message) + fragment;
        this.fillbits = fillBits;
    }

    private void parseAIS() {
        if (this.decoder == null) {
            this.decoder = new Sixbit(this.message, this.fillbits);
            this.messageType = this.decoder.getInt(FROM[MESSAGE_TYPE], TO[MESSAGE_TYPE]);
            this.repeatIndicator = this.decoder.getInt(FROM[REPEAT_INDICATOR], TO[REPEAT_INDICATOR]);
            this.mmsi = this.decoder.getInt(FROM[MMSI], TO[MMSI]);
        }
    }
}

