/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.aiagent.gateway.impl;

import com.sap.sailing.aiagent.interfaces.AIAgent;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.shared.server.gateway.jaxrs.SharedAbstractSailingServerResource;
import com.sap.sse.ServerInfo;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.util.Collections;
import java.util.UUID;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.SecurityUtils;
import org.osgi.util.tracker.ServiceTracker;

@Path(value="/api/v1/aiagent")
public class AIAgentResource
extends SharedAbstractSailingServerResource {
    protected static final String AI_AGENT = "/aiagent";

    private AIAgent getAIAgent() {
        ServiceTracker tracker = (ServiceTracker)this.getServletContext().getAttribute("aiAgentServiceTracker");
        return (AIAgent)tracker.getService();
    }

    @Path(value="/startcommenting/{eventUUID}")
    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    public Response startCommentingEvent(@PathParam(value="eventUUID") String eventUUID) {
        Response response;
        SecurityUtils.getSubject().checkPermission(SecuredSecurityTypes.SERVER.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)SecuredSecurityTypes.ServerActions.CONFIGURE_AI_AGENT, new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()})));
        AIAgent aiAgent = this.getAIAgent();
        if (aiAgent != null) {
            RacingEventService racingEventService = this.getService();
            Event event = (Event)Util.first((Iterable)racingEventService.getEventsSelectively(true, Collections.singleton(UUID.fromString(eventUUID))));
            if (event != null) {
                this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)event);
                aiAgent.startCommentingOnEvent(event);
                response = Response.ok().build();
            } else {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Event with the requested ID not found").build();
            }
        } else {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"AI Agent not found; perhaps no credentials provided?").build();
        }
        return response;
    }

    @Path(value="/stopcommenting/{eventUUID}")
    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    public Response stopCommentingEvent(@PathParam(value="eventUUID") String eventUUID) {
        Response response;
        SecurityUtils.getSubject().checkPermission(SecuredSecurityTypes.SERVER.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)SecuredSecurityTypes.ServerActions.CONFIGURE_AI_AGENT, new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()})));
        AIAgent aiAgent = this.getAIAgent();
        if (aiAgent != null) {
            RacingEventService racingEventService = this.getService();
            Event event = (Event)Util.first((Iterable)racingEventService.getEventsSelectively(true, Collections.singleton(UUID.fromString(eventUUID))));
            if (event != null) {
                this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)event);
                aiAgent.stopCommentingOnEvent(event);
                response = Response.ok().build();
            } else {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Event with the requested ID not found").build();
            }
        } else {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"AI Agent not found; perhaps no credentials provided?").build();
        }
        return response;
    }
}

