/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.aiagent.impl.rules;

import com.sap.sailing.aiagent.impl.AIAgentImpl;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.tagging.RaceLogNotFoundException;
import com.sap.sailing.domain.common.tagging.ServiceNotFoundException;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sse.common.TimePoint;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.http.client.ClientProtocolException;
import org.json.simple.parser.ParseException;

public abstract class Rule
extends AbstractRaceChangeListener {
    private final AIAgentImpl aiAgent;
    private final Leaderboard leaderboard;
    private final RaceColumn raceColumn;
    private final Fleet fleet;
    private final TrackedRace trackedRace;

    protected Rule(AIAgentImpl aiAgent, Leaderboard leaderboard, RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        this.aiAgent = aiAgent;
        this.leaderboard = leaderboard;
        this.raceColumn = raceColumn;
        this.fleet = fleet;
        this.trackedRace = trackedRace;
    }

    protected void produceComment(String topic, String prompt, TimePoint raceTimepoint, String tagIdentifier) throws UnsupportedOperationException, ClientProtocolException, URISyntaxException, IOException, ParseException, RaceLogNotFoundException, ServiceNotFoundException {
        this.aiAgent.produceCommentFromPrompt(topic, prompt, this.leaderboard.getName(), this.raceColumn.getName(), this.fleet.getName(), raceTimepoint, tagIdentifier);
    }

    protected AIAgentImpl getAiAgent() {
        return this.aiAgent;
    }

    protected Leaderboard getLeaderboard() {
        return this.leaderboard;
    }

    protected RaceColumn getRaceColumn() {
        return this.raceColumn;
    }

    protected Fleet getFleet() {
        return this.fleet;
    }

    protected TrackedRace getTrackedRace() {
        return this.trackedRace;
    }

    protected StringBuilder appendCompetitorToPromptBuilder(Competitor competitor, StringBuilder promptBuilder) {
        promptBuilder.append(competitor.getName());
        if (competitor.hasBoat()) {
            promptBuilder.append(" with sail number ").append(((CompetitorWithBoat)competitor).getBoat().getSailID());
        }
        return promptBuilder;
    }
}

