/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.aiagent.impl;

import com.sap.sailing.aiagent.impl.AIAgentImpl;
import com.sap.sailing.aiagent.interfaces.AIAgent;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.aicore.AICore;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final String MODEL_NAME_SYSTEM_PROPERTY_NAME = "sap.sailing.aiagent.modelname";
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private static BundleContext context;
    private static Activator instance;
    private static final String SYSTEM_PROMPT = "You are an experienced sailing commentator with your own sailing history. You have been hired to write intelligent live commentary for people who follow the race tracking. Your comments will appear in a side bar of a race viewer and therefore have to be exciting, yet very concise. Make good use also of information about prior races to put the live performance into context.";
    private ServiceTracker<RacingEventService, RacingEventService> racingEventServiceTracker;
    private AIAgent aiAgent;

    public Activator() {
        instance = this;
    }

    static BundleContext getContext() {
        return context;
    }

    public static Activator getInstance() {
        return instance;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.racingEventServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, RacingEventService.class);
        AICore aiCore = AICore.getDefault();
        if (aiCore != null) {
            this.aiAgent = new AIAgentImpl(this.racingEventServiceTracker, aiCore, System.getProperty(MODEL_NAME_SYSTEM_PROPERTY_NAME), SYSTEM_PROMPT);
            logger.info("Created AI Agent " + this.aiAgent);
            bundleContext.registerService(AIAgent.class, (Object)this.aiAgent, null);
        } else {
            logger.warning("Didn't find any AICore service; is the com.sap.sse.aicore bundle missing?");
        }
    }

    public RacingEventService getRacingEventService() {
        return (RacingEventService)this.racingEventServiceTracker.getService();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }
}

