/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.TackType;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.tracking.BravoFixTrack;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sailing.domain.tracking.impl.TrackedLegImpl;
import com.sap.sailing.domain.tracking.impl.TrackedRaceImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;

public class TrackedLegOfCompetitorImpl
implements TrackedLegOfCompetitor {
    private static final long serialVersionUID = -7060076837717432808L;
    private static final Bearing MAX_REACHING_TOLERANCE_AWAY_FROM_WAYPOINT = new DegreeBearingImpl(10.0);
    private final TrackedLegImpl trackedLeg;
    private final Competitor competitor;
    private final Boat boat;

    public TrackedLegOfCompetitorImpl(TrackedLegImpl trackedLeg, Competitor competitor, Boat boat) {
        this.trackedLeg = trackedLeg;
        this.competitor = competitor;
        this.boat = boat;
    }

    @Override
    public TrackedLegImpl getTrackedLeg() {
        return this.trackedLeg;
    }

    @Override
    public Competitor getCompetitor() {
        return this.competitor;
    }

    @Override
    public Boat getBoat() {
        return this.boat;
    }

    @Override
    public Leg getLeg() {
        return this.trackedLeg.getLeg();
    }

    private TrackedRaceImpl getTrackedRace() {
        return this.getTrackedLeg().getTrackedRace();
    }

    @Override
    public TimePoint getTimePointNotAfterFinishingOfLeg(TimePoint timePoint) {
        MarkPassing passedEndWaypoint;
        MarkPassing passedStartWaypoint = this.getTrackedRace().getMarkPassing(this.getCompetitor(), this.getTrackedLeg().getLeg().getFrom());
        TimePoint result = passedStartWaypoint != null && !passedStartWaypoint.getTimePoint().after(timePoint) ? ((passedEndWaypoint = this.getMarkPassingForLegEnd()) != null && timePoint.after(passedEndWaypoint.getTimePoint()) ? passedEndWaypoint.getTimePoint() : (this.getTrackedRace().getEndOfTracking() != null && timePoint.after(this.getTrackedRace().getEndOfTracking()) ? this.getTrackedRace().getEndOfTracking() : timePoint)) : null;
        return result;
    }

    @Override
    public Duration getTime(TimePoint timePoint) {
        TimePoint timePointNotAfterFinishingOfLeg;
        MarkPassing passedStartWaypoint = this.getMarkPassingForLegStart();
        Duration result = passedStartWaypoint == null ? null : ((timePointNotAfterFinishingOfLeg = this.getTimePointNotAfterFinishingOfLeg(timePoint)) == null ? null : passedStartWaypoint.getTimePoint().until(timePointNotAfterFinishingOfLeg));
        return result;
    }

    @Override
    public Distance getDistanceTraveled(TimePoint timePoint) {
        MarkPassing legStart = this.getMarkPassingForLegStart();
        if (legStart == null) {
            return null;
        }
        MarkPassing legEnd = this.getMarkPassingForLegEnd();
        TimePoint end = timePoint;
        if (legEnd != null && timePoint.compareTo((Object)legEnd.getTimePoint()) > 0) {
            end = legEnd.getTimePoint();
        }
        return this.getTrackedRace().getTrack(this.getCompetitor()).getDistanceTraveled(legStart.getTimePoint(), end);
    }

    @Override
    public Distance getDistanceTraveledConsideringGateStart(TimePoint timePoint) {
        Distance preResult = this.getDistanceTraveled(timePoint);
        Waypoint from = this.getLeg().getFrom();
        Distance result = preResult != null && from == this.getTrackedRace().getRace().getCourse().getFirstWaypoint() ? preResult.add(this.getTrackedRace().getAdditionalGateStartDistance(this.getCompetitor(), timePoint)) : preResult;
        return result;
    }

    private MarkPassing getMarkPassingForLegStart() {
        MarkPassing legStart = this.getTrackedRace().getMarkPassing(this.getCompetitor(), this.getLeg().getFrom());
        return legStart;
    }

    private MarkPassing getMarkPassingForLegEnd() {
        MarkPassing legEnd = this.getTrackedRace().getMarkPassing(this.getCompetitor(), this.getLeg().getTo());
        return legEnd;
    }

    @Override
    public Speed getAverageSpeedOverGround(TimePoint timePoint) {
        Speed result;
        MarkPassing legStart = this.getMarkPassingForLegStart();
        if (legStart == null) {
            result = null;
        } else {
            GPSFixMoving lastFix;
            Object timePointToUse = this.hasFinishedLeg(timePoint) ? this.getMarkPassingForLegEnd().getTimePoint() : ((lastFix = (GPSFixMoving)this.getTrackedRace().getTrack(this.getCompetitor()).getLastRawFix()) == null ? null : (lastFix.getTimePoint().compareTo((Object)timePoint) < 0 ? lastFix.getTimePoint() : timePoint));
            if (timePointToUse != null) {
                Distance d = this.getDistanceTraveled((TimePoint)timePointToUse);
                result = d.inTime(legStart.getTimePoint().until(timePointToUse));
            } else {
                result = null;
            }
        }
        return result;
    }

    @Override
    public Distance getAverageRideHeight(TimePoint timePoint) {
        BravoFixTrack track;
        MarkPassing legStart = this.getMarkPassingForLegStart();
        if (legStart != null && (track = (BravoFixTrack)this.getTrackedRace().getSensorTrack(this.getCompetitor(), "BravoFixTrack")) != null) {
            TimePoint endTimePoint = this.hasFinishedLeg(timePoint) ? this.getMarkPassingForLegEnd().getTimePoint() : timePoint;
            return track.getAverageRideHeight(legStart.getTimePoint(), endTimePoint);
        }
        return null;
    }

    @Override
    public Util.Pair<GPSFixMoving, Speed> getMaximumSpeedOverGround(TimePoint timePoint) {
        MarkPassing legStart = this.getMarkPassingForLegStart();
        if (legStart == null) {
            return null;
        }
        MarkPassing legEnd = this.getMarkPassingForLegEnd();
        TimePoint to = legEnd == null || legEnd.getTimePoint().compareTo((Object)timePoint) >= 0 ? timePoint : legEnd.getTimePoint();
        GPSFixTrack<Competitor, GPSFixMoving> track = this.getTrackedRace().getTrack(this.getCompetitor());
        return track.getMaximumSpeedOverGround(legStart.getTimePoint(), to);
    }

    @Override
    public Distance getWindwardDistanceToGo(LegType legTypeOrNull, TimePoint timePoint, WindPositionMode windPositionMode, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Object result = this.hasFinishedLeg(timePoint) ? Distance.NULL : this.getWindwardDistanceTo(legTypeOrNull, this.getLeg().getTo(), timePoint, windPositionMode, cache);
        return result;
    }

    @Override
    public Distance getWindwardDistanceToGo(TimePoint timePoint, WindPositionMode windPositionMode, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getWindwardDistanceToGo(null, timePoint, windPositionMode, cache);
    }

    @Override
    public Distance getWindwardDistanceToGo(TimePoint timePoint, WindPositionMode windPositionMode) {
        return this.getWindwardDistanceToGo(timePoint, windPositionMode, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    private Distance getWindwardDistanceTo(LegType legTypeOrNull, Waypoint waypoint, TimePoint at, WindPositionMode windPositionMode, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Position approximateWaypointPosition;
        Position estimatedPosition = this.getTrackedRace().getTrack(this.getCompetitor()).getEstimatedPosition(at, false);
        if (!this.hasStartedLeg(at) || estimatedPosition == null) {
            estimatedPosition = this.getTrackedRace().getOrCreateTrack((Mark)this.getLeg().getFrom().getMarks().iterator().next()).getEstimatedPosition(at, false);
        }
        Distance result = estimatedPosition == null ? null : ((approximateWaypointPosition = this.getTrackedRace().getApproximatePosition(waypoint, at)) == null ? null : this.getTrackedLeg().getWindwardDistance(legTypeOrNull, estimatedPosition, approximateWaypointPosition, at, windPositionMode, cache));
        return result;
    }

    private SpeedWithBearing getWindwardSpeed(SpeedWithBearing speed, TimePoint at, WindPositionMode windPositionMode, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        KnotSpeedWithBearingImpl result;
        if (speed != null) {
            Bearing projectToBearing;
            try {
                if (cache.getLegType(this.getTrackedLeg(), at) != LegType.REACHING) {
                    Wind wind = this.getTrackedRace().getWind(windPositionMode, this.getTrackedLeg(), this.getCompetitor(), at, cache);
                    if (wind == null) {
                        throw new NoWindException("Need at least wind direction to determine windward speed");
                    }
                    projectToBearing = wind.getBearing();
                } else {
                    projectToBearing = cache.getLegBearing(this.getTrackedLeg(), at);
                }
            }
            catch (NoWindException nwe) {
                projectToBearing = cache.getLegBearing(this.getTrackedLeg(), at);
            }
            if (speed.getBearing() != null && projectToBearing != null) {
                double cos = Math.cos(speed.getBearing().getRadians() - projectToBearing.getRadians());
                if (cos < 0.0) {
                    projectToBearing = projectToBearing.reverse();
                }
                result = new KnotSpeedWithBearingImpl(Math.abs(speed.getKnots() * cos), projectToBearing);
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public int getRank(TimePoint timePoint) {
        return this.getRank(timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public int getRank(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        int result = 0;
        if (this.hasStartedLeg(timePoint)) {
            List<TrackedLegOfCompetitor> competitorTracksByRank = this.getTrackedLeg().getCompetitorTracksOrderedByRank(timePoint, cache);
            result = competitorTracksByRank.indexOf(this) + 1;
        }
        return result;
    }

    @Override
    public Speed getAverageVelocityMadeGood(TimePoint timePoint) {
        return this.getAverageVelocityMadeGood(timePoint, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public Speed getAverageVelocityMadeGood(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Speed result = null;
        MarkPassing start = this.getMarkPassingForLegStart();
        if (start != null && start.getTimePoint().compareTo((Object)timePoint) <= 0) {
            Position startPos;
            MarkPassing end = this.getMarkPassingForLegEnd();
            TimePoint to = end != null && timePoint.compareTo((Object)end.getTimePoint()) >= 0 ? end.getTimePoint() : timePoint;
            Position endPos = this.getTrackedRace().getTrack(this.getCompetitor()).getEstimatedPosition(to, false);
            if (endPos != null && (startPos = this.getTrackedRace().getTrack(this.getCompetitor()).getEstimatedPosition(start.getTimePoint(), false)) != null) {
                Distance d = this.getTrackedLeg().getAbsoluteWindwardDistance(startPos, endPos, to, WindPositionMode.EXACT, cache);
                result = d == null ? null : d.inTime(to.asMillis() - start.getTimePoint().asMillis());
            }
        }
        return result;
    }

    @Override
    public Integer getNumberOfTacks(TimePoint timePoint, boolean waitForLatest) throws NoWindException {
        Integer result = null;
        if (this.hasStartedLeg(timePoint)) {
            Iterable<Maneuver> maneuvers = this.getManeuvers(timePoint, waitForLatest);
            result = 0;
            for (Maneuver maneuver : maneuvers) {
                if (maneuver.getType() != ManeuverType.TACK) continue;
                result = result + 1;
            }
        }
        return result;
    }

    @Override
    public Iterable<Maneuver> getManeuvers(TimePoint timePoint, boolean waitForLatest) throws NoWindException {
        Iterable<Maneuver> maneuvers;
        MarkPassing legStart = this.getMarkPassingForLegStart();
        if (legStart == null) {
            maneuvers = Collections.emptyList();
        } else {
            TimePoint start = legStart.getTimePoint();
            MarkPassing legEnd = this.getMarkPassingForLegEnd();
            TimePoint end = timePoint;
            if (legEnd != null && timePoint.compareTo((Object)legEnd.getTimePoint()) > 0) {
                end = legEnd.getTimePoint();
            }
            maneuvers = this.getTrackedRace().getManeuvers(this.getCompetitor(), start, end, waitForLatest);
        }
        return maneuvers;
    }

    @Override
    public Integer getNumberOfJibes(TimePoint timePoint, boolean waitForLatest) throws NoWindException {
        Integer result = null;
        if (this.hasStartedLeg(timePoint)) {
            Iterable<Maneuver> maneuvers = this.getManeuvers(timePoint, waitForLatest);
            result = 0;
            for (Maneuver maneuver : maneuvers) {
                if (maneuver.getType() != ManeuverType.JIBE) continue;
                result = result + 1;
            }
        }
        return result;
    }

    @Override
    public Integer getNumberOfPenaltyCircles(TimePoint timePoint, boolean waitForLatest) throws NoWindException {
        Integer result = null;
        if (this.hasStartedLeg(timePoint)) {
            Iterable<Maneuver> maneuvers = this.getManeuvers(timePoint, waitForLatest);
            result = 0;
            for (Maneuver maneuver : maneuvers) {
                if (maneuver.getType() != ManeuverType.PENALTY_CIRCLE) continue;
                result = result + 1;
            }
        }
        return result;
    }

    @Override
    public Distance getWindwardDistanceToCompetitorFarthestAhead(TimePoint timePoint, WindPositionMode windPositionMode, RankingMetric.RankingInfo rankingInfo) {
        return this.getWindwardDistanceToCompetitorFarthestAhead(timePoint, windPositionMode, rankingInfo, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public Distance getWindwardDistanceToCompetitorFarthestAhead(TimePoint timePoint, WindPositionMode windPositionMode, RankingMetric.RankingInfo rankingInfo, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Distance.NullDistance result;
        assert (rankingInfo.getTimePoint().equals(timePoint));
        TimePoint competitorLegStartTime = this.getStartTime();
        if (competitorLegStartTime != null && !timePoint.before(competitorLegStartTime)) {
            RankingMetric.RankingInfo effectiveRankingInfo;
            TimePoint effectiveTimePoint;
            TimePoint competitorLegFinishTime = this.getFinishTime();
            if (competitorLegFinishTime != null && timePoint.after(competitorLegFinishTime)) {
                effectiveTimePoint = competitorLegFinishTime;
                effectiveRankingInfo = this.getTrackedRace().getRankingMetric().getRankingInfo(effectiveTimePoint);
            } else {
                effectiveTimePoint = timePoint;
                effectiveRankingInfo = rankingInfo;
            }
            Competitor competitorFarthestAhead = effectiveRankingInfo.getCompetitorFarthestAhead();
            if (competitorFarthestAhead == this.getCompetitor()) {
                result = Distance.NULL;
            } else {
                TrackedLegOfCompetitor leaderLeg = this.getTrackedRace().getCurrentLeg(competitorFarthestAhead, effectiveTimePoint);
                Position leaderPosition = this.getTrackedRace().getTrack(competitorFarthestAhead).getEstimatedPosition(effectiveTimePoint, false);
                Position currentPosition = this.getTrackedRace().getTrack(this.getCompetitor()).getEstimatedPosition(effectiveTimePoint, false);
                if (leaderPosition != null && currentPosition != null) {
                    result = Distance.NULL;
                    boolean foundCompetitorsLeg = false;
                    this.getTrackedRace().getRace().getCourse().lockForRead();
                    try {
                        for (Leg leg : this.getTrackedRace().getRace().getCourse().getLegs()) {
                            if (leg == this.getLeg()) {
                                foundCompetitorsLeg = true;
                            }
                            if (!foundCompetitorsLeg) continue;
                            if (leaderLeg == null || leg != leaderLeg.getLeg()) {
                                Position nextMarkPosition = cache.getApproximatePosition(this.getTrackedRace(), leg.getTo(), effectiveTimePoint);
                                if (nextMarkPosition == null) {
                                    result = null;
                                }
                                Distance distanceToNextMark = this.getTrackedRace().getTrackedLeg(leg).getAbsoluteWindwardDistance(currentPosition, nextMarkPosition, effectiveTimePoint, windPositionMode, cache);
                                if (distanceToNextMark == null) {
                                    result = null;
                                }
                                result = result.add(distanceToNextMark);
                                currentPosition = nextMarkPosition;
                                continue;
                            }
                            Distance absoluteWindwardDistance = this.getTrackedRace().getTrackedLeg(leg).getAbsoluteWindwardDistance(currentPosition, leaderPosition, effectiveTimePoint, windPositionMode, cache);
                            if (absoluteWindwardDistance != null) {
                                result = result.add(absoluteWindwardDistance);
                            }
                            result = null;
                        }
                    }
                    finally {
                        this.getTrackedRace().getRace().getCourse().unlockAfterRead();
                    }
                } else {
                    result = null;
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    public Distance getAverageAbsoluteCrossTrackError(TimePoint timePoint, boolean waitForLatestAnalysis) {
        TimePoint to;
        MarkPassing legStart = this.getMarkPassingForLegStart();
        Distance result = legStart != null ? ((to = this.getTimePointNotAfterFinishingOfLeg(timePoint)) != null ? this.getTrackedRace().getAverageAbsoluteCrossTrackError(this.competitor, legStart.getTimePoint(), to, false, waitForLatestAnalysis) : null) : null;
        return result;
    }

    @Override
    public Distance getAverageSignedCrossTrackError(TimePoint timePoint, boolean waitForLatestAnalysis) {
        Distance result;
        MarkPassing legStartMarkPassing = this.getMarkPassingForLegStart();
        if (legStartMarkPassing != null) {
            TimePoint legStart = legStartMarkPassing.getTimePoint();
            TimePoint to = this.getTimePointNotAfterFinishingOfLeg(timePoint);
            result = to != null ? this.getTrackedRace().getAverageSignedCrossTrackError(this.competitor, legStart, to, false, waitForLatestAnalysis) : null;
        } else {
            result = null;
        }
        return result;
    }

    private Distance getSomeCrossTrackError(TimePoint timePoint, BiFunction<TrackedLeg, Position, Distance> crossTrackCalculatorAtTimePoint) {
        Position estimatedPosition;
        GPSFixTrack<Competitor, GPSFixMoving> track = this.getTrackedRace().getTrack(this.getCompetitor());
        Distance result = track != null ? ((estimatedPosition = track.getEstimatedPosition(timePoint, true)) != null ? crossTrackCalculatorAtTimePoint.apply(this.getTrackedLeg(), estimatedPosition) : null) : null;
        return result;
    }

    @Override
    public Distance getAbsoluteCrossTrackError(TimePoint timePoint) {
        return this.getSomeCrossTrackError(timePoint, (trackedLeg, estimatedPosition) -> this.getTrackedLeg().getAbsoluteCrossTrackError((Position)estimatedPosition, timePoint));
    }

    @Override
    public Distance getSignedCrossTrackError(TimePoint timePoint) {
        return this.getSomeCrossTrackError(timePoint, (trackedLeg, estimatedPosition) -> this.getTrackedLeg().getSignedCrossTrackError((Position)estimatedPosition, timePoint));
    }

    @Override
    public Distance getUnsignedCrossTrackErrorToWindAxis(TimePoint timePoint) {
        return this.getSomeCrossTrackError(timePoint, (trackedLeg, estimatedPosition) -> this.getTrackedLeg().getUnsignedCrossTrackErrorToWindAxis((Position)estimatedPosition, timePoint));
    }

    @Override
    public Distance getSignedCrossTrackErrorToWindAxis(TimePoint timePoint) {
        return this.getSomeCrossTrackError(timePoint, (trackedLeg, estimatedPosition) -> this.getTrackedLeg().getSignedCrossTrackErrorToWindAxis((Position)estimatedPosition, timePoint));
    }

    @Override
    public Duration getGapToLeader(TimePoint timePoint, Competitor leaderInLegAtTimePoint, RankingMetric.RankingInfo rankingInfo, WindPositionMode windPositionMode) throws NoWindException {
        return this.getGapToLeader(timePoint, leaderInLegAtTimePoint, windPositionMode, rankingInfo, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public Duration getGapToLeader(TimePoint timePoint, Competitor leaderInLegAtTimePoint, WindPositionMode windPositionMode, RankingMetric.RankingInfo rankingInfo, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getGapToLeader(timePoint, () -> leaderInLegAtTimePoint, windPositionMode, rankingInfo, cache);
    }

    @Override
    public Duration getGapToLeader(TimePoint timePoint, RankingMetric.RankingInfo rankingInfo, WindPositionMode windPositionMode) {
        return this.getGapToLeader(timePoint, windPositionMode, rankingInfo, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public Duration getGapToLeader(TimePoint timePoint, WindPositionMode windPositionMode, RankingMetric.RankingInfo rankingInfo, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getGapToLeader(timePoint, () -> this.getTrackedLeg().getLeader(this.hasFinishedLeg(timePoint) ? this.getFinishTime() : timePoint), windPositionMode, rankingInfo, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    private Duration getGapToLeader(TimePoint timePoint, LeaderGetter leaderGetter, WindPositionMode windPositionMode, RankingMetric.RankingInfo rankingInfo, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Iterable markPassingsInOrder;
        Speed windwardSpeed = this.getAverageVelocityMadeGood(timePoint, cache);
        if (this.hasStartedLeg(timePoint) && (markPassingsInOrder = this.getTrackedRace().getMarkPassingsInOrder(this.getLeg().getTo())) != null) {
            TimePoint whenLeaderFinishedLeg;
            MarkPassing firstMarkPassing = null;
            this.getTrackedRace().lockForRead(markPassingsInOrder);
            try {
                Iterator markPassingsForLegEnd = markPassingsInOrder.iterator();
                if (markPassingsForLegEnd.hasNext()) {
                    firstMarkPassing = (MarkPassing)markPassingsForLegEnd.next();
                }
            }
            finally {
                this.getTrackedRace().unlockAfterRead(markPassingsInOrder);
            }
            if (firstMarkPassing != null && (whenLeaderFinishedLeg = firstMarkPassing.getTimePoint()).compareTo((Object)timePoint) <= 0) {
                if (this.hasFinishedLeg(timePoint)) {
                    return whenLeaderFinishedLeg.until(this.getMarkPassingForLegEnd().getTimePoint());
                }
                if (windwardSpeed == null) {
                    return null;
                }
                Distance windwardDistanceToGo = this.getWindwardDistanceToGo(timePoint, windPositionMode);
                Duration durationSinceLeaderPassedMarkToTimePoint = whenLeaderFinishedLeg.until(timePoint);
                return windwardSpeed.getDuration(windwardDistanceToGo).plus(durationSinceLeaderPassedMarkToTimePoint);
            }
            Competitor leader = leaderGetter.getLeader();
            if (leader == this.getCompetitor()) {
                return Duration.NULL;
            }
            if (windwardSpeed == null) {
                return null;
            }
            Position ourEstimatedPosition = this.getTrackedRace().getTrack(this.getCompetitor()).getEstimatedPosition(timePoint, false);
            Position leaderEstimatedPosition = this.getTrackedRace().getTrack(leader).getEstimatedPosition(timePoint, false);
            if (ourEstimatedPosition == null || leaderEstimatedPosition == null) {
                return null;
            }
            Distance windwardDistanceToGo = this.getTrackedLeg().getAbsoluteWindwardDistance(ourEstimatedPosition, leaderEstimatedPosition, timePoint, windPositionMode);
            return windwardSpeed.getDuration(windwardDistanceToGo);
        }
        return null;
    }

    @Override
    public boolean hasStartedLeg(TimePoint timePoint) {
        MarkPassing markPassingForLegStart = this.getMarkPassingForLegStart();
        return markPassingForLegStart != null && markPassingForLegStart.getTimePoint().compareTo((Object)timePoint) <= 0;
    }

    @Override
    public boolean hasFinishedLeg(TimePoint timePoint) {
        MarkPassing markPassingForLegEnd = this.getMarkPassingForLegEnd();
        return markPassingForLegEnd != null && markPassingForLegEnd.getTimePoint().compareTo((Object)timePoint) <= 0;
    }

    @Override
    public TimePoint getStartTime() {
        MarkPassing markPassingForLegStart = this.getMarkPassingForLegStart();
        return markPassingForLegStart == null ? null : markPassingForLegStart.getTimePoint();
    }

    @Override
    public TimePoint getFinishTime() {
        MarkPassing markPassingForLegEnd = this.getMarkPassingForLegEnd();
        return markPassingForLegEnd == null ? null : markPassingForLegEnd.getTimePoint();
    }

    @Override
    public Speed getVelocityMadeGood(TimePoint at, WindPositionMode windPositionMode) {
        return this.getVelocityMadeGood(at, windPositionMode, new LeaderboardDTOCalculationReuseCache(at));
    }

    @Override
    public SpeedWithBearing getVelocityMadeGood(TimePoint at, WindPositionMode windPositionMode, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        if (this.hasStartedLeg(at)) {
            TimePoint timePoint = this.hasFinishedLeg(at) ? this.getMarkPassingForLegEnd().getTimePoint() : at;
            SpeedWithBearing speedOverGround = this.getSpeedOverGround(timePoint);
            return speedOverGround == null ? null : this.getWindwardSpeed(speedOverGround, timePoint, windPositionMode, cache);
        }
        return null;
    }

    @Override
    public SpeedWithBearing getSpeedOverGround(TimePoint at) {
        if (this.hasStartedLeg(at)) {
            TimePoint timePoint = this.hasFinishedLeg(at) ? this.getMarkPassingForLegEnd().getTimePoint() : at;
            return this.getTrackedRace().getTrack(this.getCompetitor()).getEstimatedSpeed(timePoint);
        }
        return null;
    }

    @Override
    public Bearing getHeel(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getHeel);
    }

    @Override
    public Bearing getPitch(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getPitch);
    }

    @Override
    public Distance getRideHeight(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getRideHeight);
    }

    @Override
    public Distance getDistanceFoiled(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getDistanceSpentFoiling);
    }

    @Override
    public Duration getDurationFoiled(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getTimeSpentFoiling);
    }

    @Override
    public Duration getEstimatedTimeToNextMark(TimePoint timePoint, WindPositionMode windPositionMode) {
        return this.getEstimatedTimeToNextMark(timePoint, windPositionMode, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public Duration getEstimatedTimeToNextMark(TimePoint timePoint, WindPositionMode windPositionMode, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Duration result;
        if (this.hasFinishedLeg(timePoint)) {
            result = Duration.NULL;
        } else if (this.hasStartedLeg(timePoint)) {
            Distance windwardDistanceToGo = this.getWindwardDistanceToGo(timePoint, windPositionMode);
            SpeedWithBearing vmg = this.getVelocityMadeGood(timePoint, windPositionMode, cache);
            result = vmg == null ? null : vmg.getDuration(windwardDistanceToGo);
        } else {
            result = null;
        }
        return result;
    }

    public String toString() {
        return "TrackedLegOfCompetitor for " + this.getCompetitor() + " in leg " + this.getLeg();
    }

    @Override
    public Double getExpeditionAWA(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionAWAIfAvailable);
    }

    @Override
    public Double getExpeditionAWS(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionAWSIfAvailable);
    }

    @Override
    public Double getExpeditionTWA(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionTWAIfAvailable);
    }

    @Override
    public Double getExpeditionTWS(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionTWSIfAvailable);
    }

    @Override
    public Double getExpeditionTWD(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionTWDIfAvailable);
    }

    @Override
    public Double getExpeditionTargTWA(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionTargTWAIfAvailable);
    }

    @Override
    public Double getExpeditionBoatSpeed(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionBoatSpeedIfAvailable);
    }

    @Override
    public Double getExpeditionTargBoatSpeed(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionTargBoatSpeedIfAvailable);
    }

    @Override
    public Double getExpeditionSOG(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionSOGIfAvailable);
    }

    @Override
    public Double getExpeditionCOG(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionCOGIfAvailable);
    }

    @Override
    public Double getExpeditionForestayLoad(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionForestayLoadIfAvailable);
    }

    @Override
    public Double getExpeditionRake(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionRakeIfAvailable);
    }

    @Override
    public Double getExpeditionCourseDetail(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionCourseDetailIfAvailable);
    }

    @Override
    public Double getExpeditionHeading(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionHeadingIfAvailable);
    }

    @Override
    public Double getExpeditionVMG(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionVMGIfAvailable);
    }

    @Override
    public Double getExpeditionVMGTargVMGDelta(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionVMGTargVMGDeltaIfAvailable);
    }

    @Override
    public Double getExpeditionRateOfTurn(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionRateOfTurnIfAvailable);
    }

    @Override
    public Double getExpeditionRudderAngle(TimePoint at) {
        Double result = null;
        Bearing valueOrNull = this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getRudderIfAvailable);
        if (valueOrNull != null) {
            result = valueOrNull.getDegrees();
        }
        return result;
    }

    @Override
    public Double getExpeditionTargetHeel(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionTargetHeelIfAvailable);
    }

    @Override
    public Double getExpeditionTimeToPortLayline(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionTimeToPortLaylineIfAvailable);
    }

    @Override
    public Double getExpeditionTimeToStbLayline(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionTimeToStbLaylineIfAvailable);
    }

    @Override
    public Double getExpeditionDistToPortLayline(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionDistToPortLaylineIfAvailable);
    }

    @Override
    public Double getExpeditionDistToStbLayline(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionDistToStbLaylineIfAvailable);
    }

    @Override
    public Double getExpeditionTimeToGunInSeconds(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionTimeToGunInSecondsIfAvailable);
    }

    @Override
    public Double getExpeditionTimeToCommitteeBoat(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionTimeToCommitteeBoatIfAvailable);
    }

    @Override
    public Double getExpeditionTimeToPin(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionTimeToPinIfAvailable);
    }

    @Override
    public Double getExpeditionTimeToBurnToLineInSeconds(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionTimeToBurnToLineInSecondsIfAvailable);
    }

    @Override
    public Double getExpeditionTimeToBurnToCommitteeBoat(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionTimeToBurnToCommitteeBoatIfAvailable);
    }

    @Override
    public Double getExpeditionTimeToBurnToPin(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionTimeToBurnToPinIfAvailable);
    }

    @Override
    public Double getExpeditionDistanceToCommitteeBoat(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionDistanceToCommitteeBoatIfAvailable);
    }

    @Override
    public Double getExpeditionDistanceToPinDetail(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionDistanceToPinDetailIfAvailable);
    }

    @Override
    public Double getExpeditionDistanceBelowLineInMeters(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionDistanceBelowLineInMetersIfAvailable);
    }

    @Override
    public Double getExpeditionLineSquareForWindDirection(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionLineSquareForWindIfAvailable);
    }

    @Override
    public Double getExpeditionBaroIfAvailable(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionBaroIfAvailable);
    }

    @Override
    public Double getExpeditionLoadSIfAvailable(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionLoadSIfAvailable);
    }

    @Override
    public Double getExpeditionLoadPIfAvailable(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionLoadPIfAvailable);
    }

    @Override
    public Double getExpeditionJibCarPortIfAvailable(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionJibCarPortIfAvailable);
    }

    @Override
    public Double getExpeditionJibCarStbdIfAvailable(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionJibCarStbdIfAvailable);
    }

    @Override
    public Double getExpeditionMastButtIfAvailable(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionMastButtIfAvailable);
    }

    @Override
    public Double getExpeditionKickerTensionIfAvailable(TimePoint at) {
        return this.getExpeditionValueFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getExpeditionKickerTensionIfAvailable);
    }

    @Override
    public Double getAverageExpeditionAWA(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionAWAIfAvailable);
    }

    @Override
    public Double getAverageExpeditionAWS(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionAWSIfAvailable);
    }

    @Override
    public Double getAverageExpeditionTWA(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionTWAIfAvailable);
    }

    @Override
    public Double getAverageExpeditionTWS(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionTWSIfAvailable);
    }

    @Override
    public Double getAverageExpeditionTWD(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionTWDIfAvailable);
    }

    @Override
    public Double getAverageExpeditionTargTWA(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionTargTWAIfAvailable);
    }

    @Override
    public Double getAverageExpeditionBoatSpeed(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionBoatSpeedIfAvailable);
    }

    @Override
    public Double getAverageExpeditionTargBoatSpeed(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionTargBoatSpeedIfAvailable);
    }

    @Override
    public Double getAverageExpeditionSOG(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionSOGIfAvailable);
    }

    @Override
    public Double getAverageExpeditionCOG(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionCOGIfAvailable);
    }

    @Override
    public Double getAverageExpeditionForestayLoad(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionForestayLoadIfAvailable);
    }

    @Override
    public Double getAverageExpeditionRake(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionRakeIfAvailable);
    }

    @Override
    public Double getAverageExpeditionCourseDetail(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionCourseDetailIfAvailable);
    }

    @Override
    public Double getAverageExpeditionHeading(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionHeadingIfAvailable);
    }

    @Override
    public Double getAverageExpeditionVMG(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionVMGIfAvailable);
    }

    @Override
    public Double getAverageExpeditionVMGTargVMGDelta(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionVMGTargVMGDeltaIfAvailable);
    }

    @Override
    public Double getAverageExpeditionRateOfTurn(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionRateOfTurnIfAvailable);
    }

    @Override
    public Double getAverageExpeditionRudderAngle(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionRudderAngleIfAvailable);
    }

    @Override
    public Double getAverageExpeditionTargetHeel(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionTargetHeelIfAvailable);
    }

    @Override
    public Double getAverageExpeditionTimeToPortLayline(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionTimeToPortLaylineIfAvailable);
    }

    @Override
    public Double getAverageExpeditionTimeToStbLayline(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionTimeToStbLaylineIfAvailable);
    }

    @Override
    public Double getAverageExpeditionDistToPortLayline(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionDistToPortLaylineIfAvailable);
    }

    @Override
    public Double getAverageExpeditionDistToStbLayline(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionDistToStbLaylineIfAvailable);
    }

    @Override
    public Double getAverageExpeditionTimeToGunInSeconds(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionTimeToGunInSecondsIfAvailable);
    }

    @Override
    public Double getAverageExpeditionTimeToCommitteeBoat(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionTimeToCommitteeBoatIfAvailable);
    }

    @Override
    public Double getAverageExpeditionTimeToPin(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionTimeToPinIfAvailable);
    }

    @Override
    public Double getAverageExpeditionTimeToBurnToLineInSeconds(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionTimeToBurnToLineInSecondsIfAvailable);
    }

    @Override
    public Double getAverageExpeditionTimeToBurnToCommitteeBoat(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionTimeToBurnToCommitteeBoatIfAvailable);
    }

    @Override
    public Double getAverageExpeditionTimeToBurnToPin(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionTimeToBurnToPinIfAvailable);
    }

    @Override
    public Double getAverageExpeditionDistanceToCommitteeBoat(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionDistanceToCommitteeBoatIfAvailable);
    }

    @Override
    public Double getAverageExpeditionDistanceToPinDetail(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionDistanceToPinDetailIfAvailable);
    }

    @Override
    public Double getAverageExpeditionDistanceBelowLineInMeters(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionDistanceBelowLineInMetersIfAvailable);
    }

    @Override
    public Double getAverageExpeditionLineSquareForWindDirection(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionLineSquareForWindIfAvailable);
    }

    @Override
    public Double getAverageExpeditionBaroIfAvailable(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionBaroIfAvailable);
    }

    @Override
    public Double getAverageExpeditionLoadSIfAvailable(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionLoadSIfAvailable);
    }

    @Override
    public Double getAverageExpeditionLoadPIfAvailable(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionLoadPIfAvailable);
    }

    @Override
    public Double getAverageExpeditionJibCarPortIfAvailable(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionJibCarPortIfAvailable);
    }

    @Override
    public Double getAverageExpeditionJibCarStbdIfAvailable(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionJibCarStbdIfAvailable);
    }

    @Override
    public Double getAverageExpeditionMastButtIfAvailable(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionMastButtIfAvailable);
    }

    @Override
    public Double getAverageExpeditionKickerTensionIfAvailable(TimePoint at) {
        return this.getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(at, BravoFixTrack::getAverageExpeditionKickerTensionIfAvailable);
    }

    private <R> R getExpeditionValueFromBravoFixTrackIfLegIsStarted(TimePoint at, BiFunction<BravoFixTrack<Competitor>, TimePoint, R> valueExtractor) {
        Object result;
        if (this.hasStartedLeg(at)) {
            TimePoint timePoint = this.hasFinishedLeg(at) ? this.getMarkPassingForLegEnd().getTimePoint() : at;
            BravoFixTrack track = (BravoFixTrack)this.getTrackedRace().getSensorTrack(this.competitor, "BravoFixTrack");
            result = track == null ? null : valueExtractor.apply(track, timePoint);
        } else {
            result = null;
        }
        return result;
    }

    private <R> R getAverageExpeditionValueWithTimeRangeFromBravoFixTrackIfLegIsStarted(TimePoint at, BravoTrackValueExtractor<R> valueExtractor) {
        BravoFixTrack track;
        if (this.hasStartedLeg(at) && (track = (BravoFixTrack)this.getTrackedRace().getSensorTrack(this.getCompetitor(), "BravoFixTrack")) != null) {
            TimePoint endTimePoint = this.hasFinishedLeg(at) ? this.getMarkPassingForLegEnd().getTimePoint() : at;
            return valueExtractor.getValue(track, this.getMarkPassingForLegStart().getTimePoint(), endTimePoint);
        }
        return null;
    }

    @Override
    public TackType getTackType(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) throws NoWindException {
        TackType result;
        MarkPassing start = this.getMarkPassingForLegStart();
        MarkPassing end = this.getMarkPassingForLegEnd();
        if (start != null && !timePoint.before(start.getTimePoint()) && (end == null || timePoint.before(end.getTimePoint()))) {
            Position waypointPosition = cache.getApproximatePosition(this.getTrackedRace(), this.getLeg().getTo(), timePoint);
            Wind wind = cache.getWind(this.getTrackedRace(), this.competitor, timePoint);
            Position competitorPosition = this.getTrackedRace().getTrack(this.competitor).getEstimatedPosition(timePoint, true);
            if (waypointPosition != null && wind != null && competitorPosition != null) {
                LegType legType = cache.getLegType(this.getTrackedLeg(), timePoint);
                Bearing windBearing = legType == LegType.UPWIND ? wind.getFrom() : wind.getBearing();
                SpeedWithBearing cogSog = this.getSpeedOverGround(timePoint);
                if (cogSog != null) {
                    Bearing cog = cogSog.getBearing();
                    Bearing bearingToWaypoint = competitorPosition.getBearingGreatCircle(waypointPosition);
                    Bearing diffWindToBoat = legType == LegType.REACHING ? MAX_REACHING_TOLERANCE_AWAY_FROM_WAYPOINT : windBearing.getDifferenceTo(cog).abs();
                    Bearing diffMarkToBoat = bearingToWaypoint.getDifferenceTo(cog).abs();
                    result = diffMarkToBoat.compareTo((Object)diffWindToBoat) < 0 ? TackType.LONGTACK : TackType.SHORTTACK;
                } else {
                    result = null;
                }
            } else {
                result = null;
            }
        } else {
            result = null;
        }
        return result;
    }

    private static interface BravoTrackValueExtractor<R> {
        public R getValue(BravoFixTrack<Competitor> var1, TimePoint var2, TimePoint var3);
    }

    @FunctionalInterface
    private static interface LeaderGetter {
        public Competitor getLeader();
    }
}

