/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.impl.NonCachingMarkPositionAtTimePointCache;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import java.util.HashMap;
import java.util.Map;

public class MarkPositionAtTimePointCacheImpl
extends NonCachingMarkPositionAtTimePointCache {
    private final Map<Mark, Position> estimatedMarkPositions = new HashMap<Mark, Position>();
    private final Map<Waypoint, Position> approximateWaypointPositions = new HashMap<Waypoint, Position>();
    private final Map<TrackedLeg, Bearing> legBearings = new HashMap<TrackedLeg, Bearing>();

    public MarkPositionAtTimePointCacheImpl(TrackedRace trackedRace, TimePoint timePoint) {
        super(trackedRace, timePoint);
    }

    @Override
    public Position getEstimatedPosition(Mark mark) {
        Position result;
        if (this.estimatedMarkPositions.containsKey(mark)) {
            result = this.estimatedMarkPositions.get(mark);
        } else {
            result = super.getEstimatedPosition(mark);
            this.estimatedMarkPositions.put(mark, result);
        }
        return result;
    }

    @Override
    public Position getApproximatePosition(Waypoint waypoint) {
        Position result;
        if (this.approximateWaypointPositions.containsKey(waypoint)) {
            result = this.approximateWaypointPositions.get(waypoint);
        } else {
            result = super.getApproximatePosition(waypoint);
            this.approximateWaypointPositions.put(waypoint, result);
        }
        return result;
    }

    @Override
    public Bearing getLegBearing(TrackedLeg trackedLeg) {
        Bearing result;
        if (this.legBearings.containsKey(trackedLeg)) {
            result = this.legBearings.get(trackedLeg);
        } else {
            result = super.getLegBearing(trackedLeg);
            this.legBearings.put(trackedLeg, result);
        }
        return result;
    }
}

