/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sse.common.Bearing;

public class CourseChangeCalculator {
    private static final double THRESHOLD_UP_TO_WHICH_TO_ACCEPT_DIRECTION_IN_DEGREES = 90.0;

    public double getTotalCourseChange(Bearing courseBeforeManeuver, Bearing currentCourse, double courseChangeInDegreesSoFar, NauticalSide maneuverDirection) {
        double lastCourseInDegrees = (courseBeforeManeuver.getDegrees() + courseChangeInDegreesSoFar) % 360.0;
        double diffToCurrentCourseInDegrees = currentCourse.getDegrees() % 360.0 - lastCourseInDegrees;
        if (Math.abs(diffToCurrentCourseInDegrees) > 90.0) {
            if (diffToCurrentCourseInDegrees < 0.0 && maneuverDirection == NauticalSide.STARBOARD) {
                diffToCurrentCourseInDegrees = 360.0 - diffToCurrentCourseInDegrees;
            } else if (diffToCurrentCourseInDegrees > 0.0 && maneuverDirection == NauticalSide.PORT) {
                diffToCurrentCourseInDegrees += -360.0;
            }
        }
        double result = courseChangeInDegreesSoFar + diffToCurrentCourseInDegrees;
        return result;
    }
}

