/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.impl.WindComparator;
import com.sap.sailing.domain.tracking.impl.WindTrackImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.util.impl.ArrayListNavigableSet;
import com.sap.sse.shared.util.impl.UnmodifiableNavigableSet;
import java.util.NavigableSet;

public class CourseBasedWindTrackImpl
extends WindTrackImpl {
    private static final long serialVersionUID = -729439204216641791L;
    private final long MILLISECONDS_AROUND_START_TO_TRACK = 30000L;
    private final TrackedRace trackedRace;
    private static final NavigableSet<Wind> empty = new UnmodifiableNavigableSet((NavigableSet)new ArrayListNavigableSet(WindComparator.INSTANCE));

    public CourseBasedWindTrackImpl(TrackedRace trackedRace, long millisecondsOverWhichToAverage, double baseConfidence) {
        super(millisecondsOverWhichToAverage, baseConfidence, WindSourceType.COURSE_BASED.useSpeed(), String.valueOf(CourseBasedWindTrackImpl.class.getSimpleName()) + " for race " + trackedRace.getRace().getName());
        this.trackedRace = trackedRace;
    }

    protected NavigableSet<Wind> getInternalRawFixes() {
        ArrayListNavigableSet result;
        this.assertReadLock();
        if (this.trackedRace.raceIsKnownToStartUpwind()) {
            TimePoint startTime = this.trackedRace.getStartOfRace();
            if (startTime != null) {
                result = new ArrayListNavigableSet(3, WindComparator.INSTANCE);
                long t = startTime.asMillis() - 30000L;
                while (t <= startTime.asMillis() + 30000L) {
                    Wind directionFromStartToNextMark = this.trackedRace.getDirectionFromStartToNextMark((TimePoint)new MillisecondsTimePoint(t));
                    if (directionFromStartToNextMark != null) {
                        result.add(directionFromStartToNextMark);
                    }
                    t += 30000L;
                }
            } else {
                result = empty;
            }
        } else {
            result = empty;
        }
        return result;
    }
}

