/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.common.confidence.impl.ScalableDouble;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableDistance;
import com.sap.sailing.domain.common.tracking.BravoExtendedFix;
import com.sap.sailing.domain.common.tracking.BravoFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.shared.tracking.AddResult;
import com.sap.sailing.domain.shared.tracking.Track;
import com.sap.sailing.domain.shared.tracking.impl.TimeRangeCache;
import com.sap.sailing.domain.tracking.DynamicBravoFixTrack;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.GPSTrackListener;
import com.sap.sailing.domain.tracking.impl.SensorFixTrackImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.WithID;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.scalablevalue.ScalableValue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.function.Function;

public class BravoFixTrackImpl<ItemType extends WithID & Serializable>
extends SensorFixTrackImpl<ItemType, BravoFix>
implements DynamicBravoFixTrack<ItemType> {
    private static final long serialVersionUID = 460944392510182976L;
    private final boolean hasExtendedFixes;
    private transient TimeRangeCache<Duration> foilingTimeCache;
    private transient TimeRangeCache<Distance> foilingDistanceCache;
    private transient TimeRangeCache<Util.Pair<Distance, Long>> averageRideHeightCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionAWACache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionAWSCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionTWACache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionTWSCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionTWDCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionBoatSpeedCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionTargBoatSpeedCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionSOGCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionCOGCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionForestayLoadCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionRakeCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionCourseDetailCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionBaroCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionLoadSCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionLoadPCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionJibCarPortCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionJibCarStbdCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionMastButtCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionHeadingCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionTimeToGunCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionRudderCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionRateOfTurnCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionTimeToBurnToLineCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionDistanceBelowLineInMetersCache;
    private transient TimeRangeCache<Util.Pair<Double, Long>> expeditionKickerTensionCache;
    private transient GPSFixTrack<ItemType, GPSFixMoving> gpsTrack;

    public BravoFixTrackImpl(ItemType trackedItem, String trackName, boolean hasExtendedFixes) {
        this(trackedItem, trackName, hasExtendedFixes, null);
    }

    public BravoFixTrackImpl(ItemType trackedItem, String trackName, boolean hasExtendedFixes, GPSFixTrack<ItemType, GPSFixMoving> gpsTrack) {
        super(trackedItem, trackName, "BravoFixTrack for " + trackedItem);
        this.hasExtendedFixes = hasExtendedFixes;
        this.initCaches(trackedItem);
        this.setGpsTrack(gpsTrack);
    }

    private void initCaches(ItemType trackedItem) {
        this.foilingTimeCache = this.createTimeRangeCache(trackedItem, "foilingTimeCache");
        this.foilingDistanceCache = this.createTimeRangeCache(trackedItem, "foilingDistanceCache");
        this.averageRideHeightCache = this.createTimeRangeCache(trackedItem, "averageRideHeightCache");
        this.expeditionAWACache = this.createTimeRangeCache(trackedItem, "expeditionAWACache");
        this.expeditionAWSCache = this.createTimeRangeCache(trackedItem, "expeditionAWSCache");
        this.expeditionTWACache = this.createTimeRangeCache(trackedItem, "expeditionTWACache");
        this.expeditionTWSCache = this.createTimeRangeCache(trackedItem, "expeditionTWSCache");
        this.expeditionTWDCache = this.createTimeRangeCache(trackedItem, "expeditionTWDCache");
        this.expeditionBoatSpeedCache = this.createTimeRangeCache(trackedItem, "expeditionBoatSpeedCache");
        this.expeditionTargBoatSpeedCache = this.createTimeRangeCache(trackedItem, "expeditionTargBoatSpeedCache");
        this.expeditionSOGCache = this.createTimeRangeCache(trackedItem, "expeditionSOGCache");
        this.expeditionCOGCache = this.createTimeRangeCache(trackedItem, "expeditionCOGCache");
        this.expeditionForestayLoadCache = this.createTimeRangeCache(trackedItem, "expeditionForestayLoadCache");
        this.expeditionRakeCache = this.createTimeRangeCache(trackedItem, "expeditionRakeCache");
        this.expeditionCourseDetailCache = this.createTimeRangeCache(trackedItem, "expeditionCourseDetailCache");
        this.expeditionBaroCache = this.createTimeRangeCache(trackedItem, "expeditionBaroCache");
        this.expeditionLoadSCache = this.createTimeRangeCache(trackedItem, "expeditionLoadSCache");
        this.expeditionLoadPCache = this.createTimeRangeCache(trackedItem, "expeditionLoadPCache");
        this.expeditionJibCarPortCache = this.createTimeRangeCache(trackedItem, "expeditionJibCarPortCache");
        this.expeditionJibCarStbdCache = this.createTimeRangeCache(trackedItem, "expeditionJibCarStbdCache");
        this.expeditionMastButtCache = this.createTimeRangeCache(trackedItem, "expeditionMastButtCache");
        this.expeditionHeadingCache = this.createTimeRangeCache(trackedItem, "expeditionHeadingCache");
        this.expeditionTimeToGunCache = this.createTimeRangeCache(trackedItem, "expeditionTimeToGunCache");
        this.expeditionRudderCache = this.createTimeRangeCache(trackedItem, "expeditionRudderCache");
        this.expeditionRateOfTurnCache = this.createTimeRangeCache(trackedItem, "expeditionRateOfTurnCache");
        this.expeditionTimeToBurnToLineCache = this.createTimeRangeCache(trackedItem, "expeditionTimeToBurnToLineCache");
        this.expeditionDistanceBelowLineInMetersCache = this.createTimeRangeCache(trackedItem, "expeditionDistanceBelowLineCache");
    }

    public GPSFixTrack<ItemType, GPSFixMoving> getGpsTrack() {
        return this.gpsTrack;
    }

    protected void setGpsTrack(GPSFixTrack<ItemType, GPSFixMoving> gpsTrack) {
        if (gpsTrack != null) assert (this.gpsTrack == null);
        this.gpsTrack = gpsTrack;
        if (gpsTrack != null) {
            gpsTrack.addListener(new CacheInvalidationGpsTrackListener());
        }
    }

    protected <T> TimeRangeCache<T> createTimeRangeCache(ItemType trackedItem, String cacheName) {
        return new TimeRangeCache(String.valueOf(cacheName) + " for " + trackedItem);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.initCaches((WithID)this.getTrackedItem());
    }

    @Override
    public Distance getRideHeight(TimePoint timePoint) {
        return this.getValueFromBravoFixSkippingNullValues(timePoint, BravoFix::getRideHeight, ScalableDistance::new);
    }

    @Override
    public Bearing getHeel(TimePoint timePoint) {
        return this.getValueFromBravoFixSkippingNullValues(timePoint, BravoFix::getHeel, NaivelyScalableBearing::new);
    }

    @Override
    public Bearing getPitch(TimePoint timePoint) {
        return this.getValueFromBravoFixSkippingNullValues(timePoint, BravoFix::getPitch, NaivelyScalableBearing::new);
    }

    @Override
    public boolean isFoiling(TimePoint timePoint) {
        Distance rideHeight = this.getRideHeight(timePoint);
        return rideHeight != null && rideHeight.compareTo((Object)BravoFix.MIN_FOILING_HEIGHT_THRESHOLD) >= 0;
    }

    @Override
    public boolean add(BravoFix fix, boolean replace) {
        boolean added = super.add(fix, replace);
        if (added) {
            TimePoint fixTimePoint = fix.getTimePoint();
            this.invalidateAllAtOrLaterThanForCaches(fixTimePoint, this.averageRideHeightCache, this.foilingDistanceCache, this.foilingTimeCache, this.expeditionAWACache, this.expeditionAWSCache, this.expeditionTWACache, this.expeditionTWSCache, this.expeditionTWDCache, this.expeditionBoatSpeedCache, this.expeditionTargBoatSpeedCache, this.expeditionSOGCache, this.expeditionCOGCache, this.expeditionForestayLoadCache, this.expeditionRakeCache, this.expeditionCourseDetailCache, this.expeditionBaroCache, this.expeditionJibCarPortCache, this.expeditionJibCarStbdCache, this.expeditionLoadPCache, this.expeditionLoadSCache, this.expeditionMastButtCache, this.expeditionHeadingCache, this.expeditionTimeToGunCache, this.expeditionRudderCache, this.expeditionRateOfTurnCache);
        }
        return added;
    }

    private void invalidateAllAtOrLaterThanForCaches(TimePoint fixTimePoint, TimeRangeCache<?> ... caches) {
        TimeRangeCache<?>[] timeRangeCacheArray = caches;
        int n = caches.length;
        int n2 = 0;
        while (n2 < n) {
            TimeRangeCache<?> timeRangeCache = timeRangeCacheArray[n2];
            timeRangeCache.invalidateAllAtOrLaterThan(fixTimePoint);
            ++n2;
        }
    }

    @Override
    public Distance getAverageRideHeight(TimePoint from, TimePoint to) {
        Util.Pair nullElement = new Util.Pair((Object)Distance.NULL, (Object)0L);
        Util.Pair rideHeightSumAndCount = (Util.Pair)this.getValueSum(from, to, nullElement, (a, b) -> new Util.Pair((Object)((Distance)a.getA()).add((Distance)b.getA()), (Object)((Long)a.getB() + (Long)b.getB())), this.averageRideHeightCache, (Track.TimeRangeValueCalculator)new Track.TimeRangeValueCalculator<Util.Pair<Distance, Long>>(){

            public Util.Pair<Distance, Long> calculate(TimePoint from, TimePoint to) {
                Distance.NullDistance sum = Distance.NULL;
                long count = 0L;
                for (BravoFix fix : BravoFixTrackImpl.this.getFixes(from, true, to, true)) {
                    Distance rideHeight = fix.getRideHeight();
                    if (rideHeight == null) continue;
                    sum = sum.add(rideHeight);
                    ++count;
                }
                return new Util.Pair((Object)sum, (Object)count);
            }
        });
        return (Long)rideHeightSumAndCount.getB() == 0L ? null : ((Distance)rideHeightSumAndCount.getA()).scale(1.0 / (double)((Long)rideHeightSumAndCount.getB()).longValue());
    }

    private boolean isFoiling(BravoFix fix) {
        return fix.isFoiling();
    }

    @Override
    public Duration getTimeSpentFoiling(TimePoint from, TimePoint to) {
        return (Duration)this.getValueSum(from, to, Duration.NULL, Duration::plus, this.foilingTimeCache, (Track.TimeRangeValueCalculator)new Track.TimeRangeValueCalculator<Duration>(){

            public Duration calculate(TimePoint from, TimePoint to) {
                Duration result = Duration.NULL;
                TimePoint last = from;
                boolean isFoiling = false;
                for (BravoFix fix : BravoFixTrackImpl.this.getFixes(from, true, to, true)) {
                    boolean fixFoils = BravoFixTrackImpl.this.isFoiling(fix);
                    if (isFoiling && fixFoils) {
                        result = result.plus(last.until(fix.getTimePoint()));
                    }
                    last = fix.getTimePoint();
                    isFoiling = fixFoils;
                }
                return result;
            }
        });
    }

    @Override
    public Distance getDistanceSpentFoiling(TimePoint from, TimePoint to) {
        return this.getGpsTrack() == null ? null : (Distance)this.getValueSum(from, to, Distance.NULL, Distance::add, this.foilingDistanceCache, (Track.TimeRangeValueCalculator)new Track.TimeRangeValueCalculator<Distance>(){

            public Distance calculate(TimePoint from, TimePoint to) {
                Distance.NullDistance result = Distance.NULL;
                TimePoint last = from;
                boolean isFoiling = false;
                for (BravoFix fix : BravoFixTrackImpl.this.getFixes(from, true, to, true)) {
                    boolean fixFoils = BravoFixTrackImpl.this.isFoiling(fix);
                    if (isFoiling && fixFoils) {
                        result = result.add(BravoFixTrackImpl.this.getGpsTrack().getDistanceTraveled(last, fix.getTimePoint()));
                    }
                    last = fix.getTimePoint();
                    isFoiling = fixFoils;
                }
                return result;
            }
        });
    }

    @Override
    public boolean hasExtendedFixes() {
        return this.hasExtendedFixes;
    }

    private <T, I> T getValueFromExtendedFixSkippingNullValues(TimePoint timePoint, Function<BravoExtendedFix, T> getter, Function<T, ScalableValue<I, T>> converterToScalableValue) {
        if (!this.hasExtendedFixes) {
            return null;
        }
        Function<BravoFix, ScalableValue> converter = fix -> {
            if (!(fix instanceof BravoExtendedFix)) {
                return null;
            }
            BravoExtendedFix castFix = (BravoExtendedFix)fix;
            return (ScalableValue)converterToScalableValue.apply(getter.apply(castFix));
        };
        return (T)this.getInterpolatedValue(timePoint, converter, fix -> {
            if (!(fix instanceof BravoExtendedFix)) {
                return false;
            }
            BravoExtendedFix castFix = (BravoExtendedFix)fix;
            return getter.apply(castFix) != null;
        });
    }

    private <T, I> T getValueFromBravoFixSkippingNullValues(TimePoint timePoint, Function<BravoFix, T> getter, Function<T, ScalableValue<I, T>> converterToScalableValue) {
        Function<BravoFix, ScalableValue> converter = fix -> (ScalableValue)converterToScalableValue.apply(getter.apply((BravoFix)fix));
        return (T)this.getInterpolatedValue(timePoint, converter, fix -> getter.apply((BravoFix)fix) != null);
    }

    public BravoExtendedFix getFirstFixAtOrAfterIfExtended(TimePoint timePoint) {
        BravoFix fix = (BravoFix)this.getFirstFixAtOrAfter(timePoint);
        return fix instanceof BravoExtendedFix ? (BravoExtendedFix)fix : null;
    }

    public BravoExtendedFix getLastFixAtOrBeforeIfExtended(TimePoint timePoint) {
        BravoFix fix = (BravoFix)this.getLastFixAtOrBefore(timePoint);
        return fix instanceof BravoExtendedFix ? (BravoExtendedFix)fix : null;
    }

    @Override
    public Double getPortDaggerboardRakeIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getPortDaggerboardRake, ScalableDouble::new);
    }

    @Override
    public Double getStbdDaggerboardRakeStbdIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getStbdDaggerboardRake, ScalableDouble::new);
    }

    @Override
    public Double getPortRudderRakeIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getPortRudderRake, ScalableDouble::new);
    }

    @Override
    public Double getStbdRudderRakeIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getStbdRudderRake, ScalableDouble::new);
    }

    @Override
    public Bearing getMastRotationIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getMastRotation, NaivelyScalableBearing::new);
    }

    @Override
    public Bearing getLeewayIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getLeeway, NaivelyScalableBearing::new);
    }

    @Override
    public Double getSetIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getSet, ScalableDouble::new);
    }

    @Override
    public Bearing getDriftIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getDrift, NaivelyScalableBearing::new);
    }

    @Override
    public Distance getDepthIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getDepth, ScalableDistance::new);
    }

    @Override
    public Bearing getRudderIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getRudder, NaivelyScalableBearing::new);
    }

    @Override
    public Double getForestayLoadIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getForestayLoad, ScalableDouble::new);
    }

    @Override
    public Double getForestayPressureIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getForestayPressure, ScalableDouble::new);
    }

    @Override
    public Bearing getTackAngleIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getTackAngle, NaivelyScalableBearing::new);
    }

    @Override
    public Bearing getRakeIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getRake, NaivelyScalableBearing::new);
    }

    @Override
    public Double getDeflectorPercentageIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getDeflectorPercentage, ScalableDouble::new);
    }

    @Override
    public Bearing getTargetHeelIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getTargetHeel, NaivelyScalableBearing::new);
    }

    @Override
    public Distance getDeflectorIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getDeflector, ScalableDistance::new);
    }

    @Override
    public Double getTargetBoatspeedPIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getTargetBoatspeedP, ScalableDouble::new);
    }

    @Override
    public Double getExpeditionKickerTensionIfAvailable(TimePoint timePoint) {
        return this.getValueFromExtendedFixSkippingNullValues(timePoint, BravoExtendedFix::getExpeditionKickerTension, ScalableDouble::new);
    }

    @Override
    public Double getAverageExpeditionKickerTensionIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionKickerTension, this.expeditionKickerTensionCache);
    }

    @Override
    public Double getAverageExpeditionAWAIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionAWA, this.expeditionAWACache);
    }

    @Override
    public Double getAverageExpeditionAWSIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionAWS, this.expeditionAWSCache);
    }

    @Override
    public Double getAverageExpeditionTWAIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionTWA, this.expeditionTWACache);
    }

    @Override
    public Double getAverageExpeditionTWSIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionTWS, this.expeditionTWSCache);
    }

    @Override
    public Double getAverageExpeditionTWDIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionTWD, this.expeditionTWDCache);
    }

    @Override
    public Double getAverageExpeditionTargTWAIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionTWA, this.expeditionTWACache);
    }

    @Override
    public Double getAverageExpeditionBoatSpeedIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionBSP, this.expeditionBoatSpeedCache);
    }

    @Override
    public Double getAverageExpeditionTargBoatSpeedIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionBSP_TR, this.expeditionTargBoatSpeedCache);
    }

    @Override
    public Double getAverageExpeditionSOGIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionSOG, this.expeditionSOGCache);
    }

    @Override
    public Double getAverageExpeditionCOGIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionCOG, this.expeditionCOGCache);
    }

    @Override
    public Double getAverageExpeditionForestayLoadIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionForestayLoad, this.expeditionForestayLoadCache);
    }

    @Override
    public Double getAverageExpeditionRakeIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionRake, this.expeditionRakeCache);
    }

    @Override
    public Double getAverageExpeditionCourseDetailIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionCourse, this.expeditionCourseDetailCache);
    }

    @Override
    public Double getAverageExpeditionBaroIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionBARO, this.expeditionBaroCache);
    }

    @Override
    public Double getAverageExpeditionLoadSIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionLoadS, this.expeditionLoadSCache);
    }

    @Override
    public Double getAverageExpeditionLoadPIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionLoadP, this.expeditionLoadPCache);
    }

    @Override
    public Double getAverageExpeditionJibCarPortIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionJibCarPort, this.expeditionJibCarPortCache);
    }

    @Override
    public Double getAverageExpeditionJibCarStbdIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionJibCarStbd, this.expeditionJibCarStbdCache);
    }

    @Override
    public Double getAverageExpeditionMastButtIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionMastButt, this.expeditionMastButtCache);
    }

    @Override
    public Double getAverageExpeditionHeadingIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionHDG, this.expeditionHeadingCache);
    }

    @Override
    public Double getAverageExpeditionVMGIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return null;
    }

    @Override
    public Double getAverageExpeditionVMGTargVMGDeltaIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return null;
    }

    @Override
    public Double getAverageExpeditionRateOfTurnIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionRateOfTurn, this.expeditionRateOfTurnCache);
    }

    @Override
    public Double getAverageExpeditionRudderAngleIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, new Function<BravoExtendedFix, Double>(){

            @Override
            public Double apply(BravoExtendedFix t) {
                Bearing rudder = t.getRudder();
                Double result = null;
                if (rudder != null) {
                    result = rudder.getDegrees();
                }
                return result;
            }
        }, this.expeditionRudderCache);
    }

    @Override
    public Double getAverageExpeditionTargetHeelIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return null;
    }

    @Override
    public Double getAverageExpeditionTimeToPortLaylineIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return null;
    }

    @Override
    public Double getAverageExpeditionTimeToStbLaylineIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return null;
    }

    @Override
    public Double getAverageExpeditionDistToPortLaylineIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return null;
    }

    @Override
    public Double getAverageExpeditionDistToStbLaylineIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return null;
    }

    @Override
    public Double getAverageExpeditionTimeToGunInSecondsIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionTmToGunInSeconds, this.expeditionTimeToGunCache);
    }

    @Override
    public Double getAverageExpeditionTimeToCommitteeBoatIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return null;
    }

    @Override
    public Double getAverageExpeditionTimeToPinIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return null;
    }

    @Override
    public Double getAverageExpeditionTimeToBurnToLineInSecondsIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionTmToBurnInSeconds, this.expeditionTimeToBurnToLineCache);
    }

    @Override
    public Double getAverageExpeditionTimeToBurnToCommitteeBoatIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return null;
    }

    @Override
    public Double getAverageExpeditionTimeToBurnToPinIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return null;
    }

    @Override
    public Double getAverageExpeditionDistanceToCommitteeBoatIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return null;
    }

    @Override
    public Double getAverageExpeditionDistanceToPinDetailIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return null;
    }

    @Override
    public Double getAverageExpeditionDistanceBelowLineInMetersIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return this.getAverageOfBravoExtenededFixValueWithCachingForDouble(start, endTimePoint, BravoExtendedFix::getExpeditionBelowLnInMeters, this.expeditionDistanceBelowLineInMetersCache);
    }

    @Override
    public Double getAverageExpeditionLineSquareForWindIfAvailable(TimePoint start, TimePoint endTimePoint) {
        return null;
    }

    public Double getExpeditionValueForDouble(TimePoint timePoint, Function<BravoExtendedFix, Double> getter) {
        if (this.hasExtendedFixes) {
            return this.getValueFromExtendedFixSkippingNullValues(timePoint, getter, ScalableDouble::new);
        }
        return null;
    }

    @Override
    public Double getExpeditionAWAIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionAWA);
    }

    @Override
    public Double getExpeditionAWSIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionAWS);
    }

    @Override
    public Double getExpeditionTWAIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionTWA);
    }

    @Override
    public Double getExpeditionTWSIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionTWS);
    }

    @Override
    public Double getExpeditionTWDIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionTWD);
    }

    @Override
    public Double getExpeditionTargTWAIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionTWA);
    }

    @Override
    public Double getExpeditionBoatSpeedIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionBSP);
    }

    @Override
    public Double getExpeditionTargBoatSpeedIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionBSP_TR);
    }

    @Override
    public Double getExpeditionSOGIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionSOG);
    }

    @Override
    public Double getExpeditionCOGIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionCOG);
    }

    @Override
    public Double getExpeditionForestayLoadIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionForestayLoad);
    }

    @Override
    public Double getExpeditionRakeIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionRake);
    }

    @Override
    public Double getExpeditionCourseDetailIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionCourse);
    }

    @Override
    public Double getExpeditionBaroIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionBARO);
    }

    @Override
    public Double getExpeditionLoadSIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionLoadS);
    }

    @Override
    public Double getExpeditionLoadPIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionLoadP);
    }

    @Override
    public Double getExpeditionJibCarPortIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionJibCarPort);
    }

    @Override
    public Double getExpeditionJibCarStbdIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionJibCarStbd);
    }

    @Override
    public Double getExpeditionMastButtIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionMastButt);
    }

    @Override
    public Double getExpeditionHeadingIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionHDG);
    }

    @Override
    public Double getExpeditionVMGIfAvailable(TimePoint at) {
        return null;
    }

    @Override
    public Double getExpeditionVMGTargVMGDeltaIfAvailable(TimePoint at) {
        return null;
    }

    @Override
    public Double getExpeditionRateOfTurnIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionRateOfTurn);
    }

    @Override
    public Double getExpeditionTargetHeelIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, bravoExtendedFix -> {
            Bearing targetHeel = bravoExtendedFix.getTargetHeel();
            return targetHeel == null ? null : Double.valueOf(targetHeel.getDegrees());
        });
    }

    @Override
    public Double getExpeditionTimeToPortLaylineIfAvailable(TimePoint at) {
        return null;
    }

    @Override
    public Double getExpeditionTimeToStbLaylineIfAvailable(TimePoint at) {
        return null;
    }

    @Override
    public Double getExpeditionDistToPortLaylineIfAvailable(TimePoint at) {
        return null;
    }

    @Override
    public Double getExpeditionDistToStbLaylineIfAvailable(TimePoint at) {
        return null;
    }

    @Override
    public Double getExpeditionTimeToGunInSecondsIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionTmToGunInSeconds);
    }

    @Override
    public Double getExpeditionTimeToCommitteeBoatIfAvailable(TimePoint at) {
        return null;
    }

    @Override
    public Double getExpeditionTimeToPinIfAvailable(TimePoint at) {
        return null;
    }

    @Override
    public Double getExpeditionTimeToBurnToLineInSecondsIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionTmToBurnInSeconds);
    }

    @Override
    public Double getExpeditionTimeToBurnToCommitteeBoatIfAvailable(TimePoint at) {
        return null;
    }

    @Override
    public Double getExpeditionTimeToBurnToPinIfAvailable(TimePoint at) {
        return null;
    }

    @Override
    public Double getExpeditionDistanceToCommitteeBoatIfAvailable(TimePoint at) {
        return null;
    }

    @Override
    public Double getExpeditionDistanceToPinDetailIfAvailable(TimePoint at) {
        return null;
    }

    @Override
    public Double getExpeditionDistanceBelowLineInMetersIfAvailable(TimePoint at) {
        return this.getExpeditionValueForDouble(at, BravoExtendedFix::getExpeditionBelowLnInMeters);
    }

    @Override
    public Double getExpeditionLineSquareForWindIfAvailable(TimePoint at) {
        return null;
    }

    private Double getAverageOfBravoExtenededFixValueWithCachingForDouble(TimePoint from, TimePoint to, final Function<BravoExtendedFix, Double> valueProvider, TimeRangeCache<Util.Pair<Double, Long>> rangeCache) {
        Util.Pair nullElement = new Util.Pair((Object)0.0, (Object)0L);
        Util.Pair cacheValue = (Util.Pair)this.getValueSum(from, to, nullElement, (a, b) -> new Util.Pair((Object)((Double)a.getA() + (Double)b.getA()), (Object)((Long)a.getB() + (Long)b.getB())), rangeCache, (Track.TimeRangeValueCalculator)new Track.TimeRangeValueCalculator<Util.Pair<Double, Long>>(){

            public Util.Pair<Double, Long> calculate(TimePoint from, TimePoint to) {
                Double sumValue = 0.0;
                long count = 0L;
                for (BravoFix fix : BravoFixTrackImpl.this.getFixes(from, true, to, true)) {
                    Double value;
                    if (!(fix instanceof BravoExtendedFix) || (value = (Double)valueProvider.apply((BravoExtendedFix)fix)) == null) continue;
                    sumValue = sumValue + value;
                    ++count;
                }
                return new Util.Pair((Object)sumValue, (Object)count);
            }
        });
        return (Long)cacheValue.getB() == 0L ? null : Double.valueOf((Double)cacheValue.getA() * (1.0 / (double)((Long)cacheValue.getB()).longValue()));
    }

    private class CacheInvalidationGpsTrackListener
    implements GPSTrackListener<ItemType, GPSFixMoving> {
        private static final long serialVersionUID = 6395529765232404414L;

        private CacheInvalidationGpsTrackListener() {
        }

        @Override
        public boolean isTransient() {
            return true;
        }

        @Override
        public void gpsFixReceived(GPSFixMoving fix, ItemType item, boolean firstFixInTrack, AddResult addedOrReplaced) {
            assert (item == BravoFixTrackImpl.this.getTrackedItem());
            BravoFixTrackImpl.this.foilingDistanceCache.invalidateAllAtOrLaterThan(fix.getTimePoint());
        }

        @Override
        public void speedAveragingChanged(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
        }
    }

    private static class NaivelyScalableBearing
    implements ScalableValue<Double, Bearing> {
        private final double deg;

        public NaivelyScalableBearing(Bearing b) {
            this.deg = b.getDegrees();
        }

        private NaivelyScalableBearing(double deg) {
            this.deg = deg;
        }

        public ScalableValue<Double, Bearing> multiply(double factor) {
            return new NaivelyScalableBearing(this.deg * factor);
        }

        public ScalableValue<Double, Bearing> add(ScalableValue<Double, Bearing> t) {
            return new NaivelyScalableBearing(this.deg + (Double)t.getValue());
        }

        public Bearing divide(double divisor) {
            return new DegreeBearingImpl(this.deg / divisor);
        }

        public Double getValue() {
            return this.deg;
        }
    }
}

