/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking.impl;

import com.sap.sailing.domain.tracking.impl.RunnableExecutor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsynchronousRunnableExecutor
implements RunnableExecutor {
    private static final Logger LOG = Logger.getLogger(AsynchronousRunnableExecutor.class.getName());
    private final LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();
    private Thread workThread;

    @Override
    public synchronized void addWork(Runnable workToAdd) {
        this.queue.add(workToAdd);
        if (this.workThread == null) {
            this.workThread = new Thread(this::doWork);
            this.workThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() {
        while (true) {
            Runnable workToDo;
            AsynchronousRunnableExecutor asynchronousRunnableExecutor = this;
            synchronized (asynchronousRunnableExecutor) {
                workToDo = this.queue.poll();
                if (workToDo == null) {
                    this.workThread = null;
                    break;
                }
            }
            if (workToDo == null) continue;
            try {
                workToDo.run();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error while executing work in queue", e);
            }
        }
    }
}

