/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.WindSourceImpl;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.impl.CombinedWindTrackImpl;
import com.sap.sailing.domain.tracking.impl.DummyWindTrackImpl;
import com.sap.sailing.domain.tracking.impl.LegMiddleWindTrackImpl;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import difflib.PatchFailedException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;

public abstract class TrackedRaceWithWindEssentials
implements TrackedRace {
    private static final long serialVersionUID = -3937032323498604671L;
    private static final Logger logger = Logger.getLogger(TrackedRaceWithWindEssentials.class.getName());
    private final NamedReentrantReadWriteLock serializationLock;
    private transient CombinedWindTrackImpl combinedWindTrack;
    protected transient ConcurrentMap<WindSource, WindTrack> windTracks;
    private transient ConcurrentMap<WindSourceType, ConcurrentMap<WindSource, WindSource>> windSourcesByType;
    protected final RaceDefinition race;
    protected transient WindStore windStore;
    protected final TrackedRegatta trackedRegatta;
    protected long millisecondsOverWhichToAverageWind;

    public TrackedRaceWithWindEssentials(RaceDefinition race, TrackedRegatta trackedRegatta, WindStore windStore, long millisecondsOverWhichToAverageWind) {
        this.race = race;
        this.millisecondsOverWhichToAverageWind = millisecondsOverWhichToAverageWind;
        this.windTracks = new ConcurrentHashMap<WindSource, WindTrack>();
        this.windSourcesByType = new ConcurrentHashMap<WindSourceType, ConcurrentMap<WindSource, WindSource>>();
        this.windStore = windStore;
        this.trackedRegatta = trackedRegatta;
        this.serializationLock = new NamedReentrantReadWriteLock("Serialization lock for tracked race " + race.getName(), true);
    }

    @Override
    public WindTrack getOrCreateWindTrack(WindSource windSource, long delayForWindEstimationCacheInvalidation) {
        WindTrack result;
        if (windSource.getType() == WindSourceType.COMBINED) {
            if (this.combinedWindTrack == null) {
                this.combinedWindTrack = new CombinedWindTrackImpl(this, WindSourceType.COMBINED.getBaseConfidence());
            }
            result = this.combinedWindTrack;
        } else if (windSource.getType() == WindSourceType.LEG_MIDDLE && windSource instanceof WindSourceWithAdditionalID) {
            result = this.getLegMiddleWindTrack((WindSourceWithAdditionalID)windSource);
        } else {
            WindTrack[] windTrackCreated = new WindTrack[1];
            LockUtil.lockForRead((NamedReentrantReadWriteLock)this.getSerializationLock());
            try {
                result = this.windTracks.computeIfAbsent(windSource, ws -> {
                    windTrackArray[0] = windSource.getType() == WindSourceType.MANEUVER_BASED_ESTIMATION ? new DummyWindTrackImpl() : this.createWindTrack(windSource, delayForWindEstimationCacheInvalidation == -1L ? this.getMillisecondsOverWhichToAverageWind() / 2L : delayForWindEstimationCacheInvalidation);
                    return windTrackArray[0];
                });
            }
            finally {
                LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.getSerializationLock());
            }
            if (windTrackCreated[0] != null) {
                this.notifyWindTrackHasBeenCreatedAndAddedToWindTracks(windSource, windTrackCreated[0]);
            }
        }
        return result;
    }

    protected void notifyWindTrackHasBeenCreatedAndAddedToWindTracks(WindSource windSource, WindTrack windTrack) {
        logger.info("Wind track created and added to race " + this.getRace().getName() + " for wind source " + windSource);
    }

    @Override
    public WindTrack getOrCreateWindTrack(WindSource windSource) {
        return this.getOrCreateWindTrack(windSource, -1L);
    }

    private WindTrack createWindTrack(WindSource windSource, long delayForWindEstimationCacheInvalidation) {
        WindTrack result = this.windStore.getWindTrack(this.trackedRegatta.getRegatta().getName(), this, windSource, this.millisecondsOverWhichToAverageWind, delayForWindEstimationCacheInvalidation);
        this.updateWindSourcesByType(windSource);
        return result;
    }

    protected void updateWindSourcesByType(WindSource windSource) {
        ConcurrentHashMap<WindSource, WindSource> windSourcesOfType = (ConcurrentHashMap<WindSource, WindSource>)this.windSourcesByType.get(windSource.getType());
        if (windSourcesOfType == null) {
            windSourcesOfType = new ConcurrentHashMap<WindSource, WindSource>();
            this.windSourcesByType.put(windSource.getType(), windSourcesOfType);
        }
        windSourcesOfType.put(windSource, windSource);
    }

    private WindSource getLegMiddleWindSource(TrackedLeg trackedLeg) {
        return new WindSourceWithAdditionalID(WindSourceType.LEG_MIDDLE, this.getWindSourceIdForLegMiddle(trackedLeg));
    }

    private String getWindSourceIdForLegMiddle(TrackedLeg trackedLeg) {
        return Integer.toString(this.getRace().getCourse().getIndexOfWaypoint(trackedLeg.getLeg().getFrom()));
    }

    private WindTrack getLegMiddleWindTrack(WindSourceWithAdditionalID windSource) {
        assert (windSource.getType() == WindSourceType.LEG_MIDDLE);
        String id = windSource.getId();
        Integer zeroBasedLegIndex = Integer.valueOf(id);
        TrackedLeg trackedLeg = this.getTrackedLeg(this.getRace().getCourse().getLeg(zeroBasedLegIndex));
        return new LegMiddleWindTrackImpl(this, trackedLeg, WindSourceType.LEG_MIDDLE.getBaseConfidence());
    }

    @Override
    public Set<WindSource> getWindSources(WindSourceType type) {
        HashSet<WindSource> result;
        block3: {
            block4: {
                block2: {
                    result = new HashSet<WindSource>();
                    if (type != WindSourceType.COMBINED) break block2;
                    result.add((WindSource)new WindSourceImpl(WindSourceType.COMBINED));
                    break block3;
                }
                if (type != WindSourceType.LEG_MIDDLE) break block4;
                for (TrackedLeg trackedLeg : this.getTrackedLegs()) {
                    result.add(this.getLegMiddleWindSource(trackedLeg));
                }
                break block3;
            }
            ConcurrentMap windSourcesOfType = (ConcurrentMap)this.windSourcesByType.get(type);
            if (windSourcesOfType == null) break block3;
            for (WindSource windSource : windSourcesOfType.keySet()) {
                result.add(windSource);
            }
        }
        return result;
    }

    @Override
    public Set<WindSource> getWindSources() {
        return this.windTracks.keySet();
    }

    protected NamedReentrantReadWriteLock getSerializationLock() {
        return this.serializationLock;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.getSerializationLock());
        try {
            s.defaultWriteObject();
            HashMap<WindSource, WindTrack> windTracksToSerialize = new HashMap<WindSource, WindTrack>();
            for (Map.Entry entry : this.windTracks.entrySet()) {
                if (((WindSource)entry.getKey()).getType() == WindSourceType.MANEUVER_BASED_ESTIMATION) continue;
                windTracksToSerialize.put((WindSource)entry.getKey(), (WindTrack)entry.getValue());
            }
            s.writeObject(windTracksToSerialize);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.getSerializationLock());
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException, PatchFailedException {
        ois.defaultReadObject();
        Map windTracks = (Map)ois.readObject();
        this.windTracks = new ConcurrentHashMap<WindSource, WindTrack>(windTracks);
        this.windSourcesByType = new ConcurrentHashMap<WindSourceType, ConcurrentMap<WindSource, WindSource>>();
        for (WindSource windSource : windTracks.keySet()) {
            this.updateWindSourcesByType(windSource);
        }
    }
}

