/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.tracking.RaceTracker;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class RaceTrackerListeners
implements RaceTracker.Listener {
    private final HashSet<RaceTracker.Listener> registeredListeners = new HashSet();
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private final AtomicBoolean isStoppedPreemptive = new AtomicBoolean(false);

    public synchronized boolean addListener(RaceTracker.Listener listener) {
        if (this.isStopped.get()) {
            return false;
        }
        this.registeredListeners.add(listener);
        return true;
    }

    public synchronized void removeListener(RaceTracker.Listener listener) {
        this.registeredListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTrackerWillStop(boolean preemptive, boolean willBeRemoved) {
        HashSet<RaceTracker.Listener> listenersToInform;
        RaceTrackerListeners raceTrackerListeners = this;
        synchronized (raceTrackerListeners) {
            this.isStopped.set(true);
            this.isStoppedPreemptive.set(preemptive);
            listenersToInform = new HashSet<RaceTracker.Listener>(this.registeredListeners);
        }
        listenersToInform.forEach(l -> l.onTrackerWillStop(preemptive, willBeRemoved));
    }
}

