/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;

public class ManeuverLoss {
    private final Distance distanceSailedProjectedOnMiddleManeuverAngle;
    private final Distance distanceSailedIfNotManeuveringProjectedOnMiddeManeuverAngle;
    private final Position maneuverStartPosition;
    private final Position maneuverEndPosition;
    private final Duration maneuverDuration;
    private final SpeedWithBearing speedWithBearingBefore;
    private final Bearing middleManeuverAngle;

    public ManeuverLoss(Distance distanceSailedProjectedOnMiddleManeuverAngle, Distance distanceSailedIfNotManeuveringProjectedOnMiddleManeuverAngle, Position maneuverStartPosition, Position maneuverEndPosition, Duration maneuverDuration, SpeedWithBearing speedWithBearingBefore, Bearing middleManeuverAngle) {
        this.distanceSailedProjectedOnMiddleManeuverAngle = distanceSailedProjectedOnMiddleManeuverAngle;
        this.distanceSailedIfNotManeuveringProjectedOnMiddeManeuverAngle = distanceSailedIfNotManeuveringProjectedOnMiddleManeuverAngle;
        this.maneuverStartPosition = maneuverStartPosition;
        this.maneuverEndPosition = maneuverEndPosition;
        this.maneuverDuration = maneuverDuration;
        this.speedWithBearingBefore = speedWithBearingBefore;
        this.middleManeuverAngle = middleManeuverAngle;
    }

    public Distance getDistanceSailedProjectedOnMiddleManeuverAngle() {
        return this.distanceSailedProjectedOnMiddleManeuverAngle;
    }

    public Distance getDistanceSailedIfNotManeuveringProjectedOnMiddleManeuverAngle() {
        return this.distanceSailedIfNotManeuveringProjectedOnMiddeManeuverAngle;
    }

    public Distance getProjectedDistanceLost() {
        return this.distanceSailedIfNotManeuveringProjectedOnMiddeManeuverAngle.add(this.distanceSailedProjectedOnMiddleManeuverAngle.scale(-1.0));
    }

    public double getRatioBetweenDistanceSailedWithAndWithoutManeuver() {
        return this.getDistanceSailedProjectedOnMiddleManeuverAngle().getMeters() / this.getDistanceSailedIfNotManeuveringProjectedOnMiddleManeuverAngle().getMeters();
    }

    public Position getManeuverStartPosition() {
        return this.maneuverStartPosition;
    }

    public Position getManeuverEndPosition() {
        return this.maneuverEndPosition;
    }

    public Duration getManeuverDuration() {
        return this.maneuverDuration;
    }

    public SpeedWithBearing getSpeedWithBearingBefore() {
        return this.speedWithBearingBefore;
    }

    public Bearing getMiddleManeuverAngle() {
        return this.middleManeuverAngle;
    }
}

