/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tracking;

import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.NauticalSide;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sailing.domain.tracking.ManeuverLoss;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.datamining.annotations.Dimension;
import com.sap.sse.datamining.annotations.Statistic;

public interface Maneuver
extends GPSFix {
    @Dimension(messageKey="ManeuverType", ordinal=12)
    public ManeuverType getType();

    @Dimension(messageKey="Tack", ordinal=14)
    public Tack getNewTack();

    public ManeuverLoss getManeuverLoss();

    public TimePoint getTimePoint();

    public ManeuverCurveBoundaries getMainCurveBoundaries();

    public ManeuverCurveBoundaries getManeuverCurveWithStableSpeedAndCourseBoundaries();

    public ManeuverCurveBoundaries getManeuverBoundaries();

    @Statistic(messageKey="MaxTurningRateInDegreesPerSecond", resultDecimals=4, ordinal=4)
    public double getMaxTurningRateInDegreesPerSecond();

    public SpeedWithBearing getSpeedWithBearingBefore();

    public SpeedWithBearing getSpeedWithBearingAfter();

    @Statistic(messageKey="DirectionChange", resultDecimals=2, ordinal=2)
    public double getDirectionChangeInDegrees();

    public Speed getLowestSpeed();

    public Duration getDuration();

    public MarkPassing getMarkPassing();

    @Dimension(messageKey="MarkPassing", ordinal=13)
    public boolean isMarkPassing();

    @Dimension(messageKey="ToSide", ordinal=16)
    public NauticalSide getToSide();

    @Statistic(messageKey="AvgTurningRateInDegreesPerSecond", resultDecimals=4)
    public double getAvgTurningRateInDegreesPerSecond();
}

