/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.trackfiles;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TrackFileImportDeviceIdentifierImpl
implements TrackFileImportDeviceIdentifier {
    private static final long serialVersionUID = 552465264341485161L;
    private final UUID id;
    private final String fileName;
    private final String trackName;
    private final TimePoint timePoint;
    private final String stringRepresentation;
    private static final ConcurrentMap<UUID, TrackFileImportDeviceIdentifier> cache = new ConcurrentHashMap<UUID, TrackFileImportDeviceIdentifier>();

    public static TrackFileImportDeviceIdentifier getOrCreate(UUID uuid) {
        if (cache.containsKey(uuid)) {
            return (TrackFileImportDeviceIdentifier)cache.get(uuid);
        }
        return new TrackFileImportDeviceIdentifierImpl(uuid, null, null, null);
    }

    public TrackFileImportDeviceIdentifierImpl(String fileName, String trackName) {
        this(UUID.randomUUID(), fileName, trackName, MillisecondsTimePoint.now());
    }

    public TrackFileImportDeviceIdentifierImpl(UUID id, String fileName, String trackName, TimePoint timePoint) {
        this(id, TrackFileImportDeviceIdentifierImpl.computeStringRepresentation(id, fileName, trackName, timePoint), fileName, trackName, timePoint);
        cache.put(id, this);
    }

    public TrackFileImportDeviceIdentifierImpl(UUID id, String stringRepresentation, String fileName, String trackName, TimePoint timePoint) {
        this.id = id;
        this.fileName = fileName;
        this.trackName = trackName;
        this.timePoint = timePoint;
        this.stringRepresentation = stringRepresentation;
        cache.put(id, this);
    }

    public String getIdentifierType() {
        return "FILE";
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String toString() {
        return this.id.toString();
    }

    public String getStringRepresentation() {
        return this.stringRepresentation;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TrackFileImportDeviceIdentifier) {
            return this.id.equals(((TrackFileImportDeviceIdentifier)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getTrackName() {
        return this.trackName;
    }

    @Override
    public TimePoint getUploadedAt() {
        return this.timePoint;
    }

    public static TrackFileImportDeviceIdentifier cast(DeviceIdentifier deviceIdentifier) throws TransformationException {
        if (!(deviceIdentifier instanceof TrackFileImportDeviceIdentifier)) {
            throw new TransformationException("Expected TrackFileImportDeviceIdentifier, but got " + deviceIdentifier.getClass());
        }
        return (TrackFileImportDeviceIdentifier)deviceIdentifier;
    }

    private static final String computeStringRepresentation(UUID id, String fileName, String trackName, TimePoint timePoint) {
        StringBuilder sb = new StringBuilder();
        sb.append(id.toString()).append(": ");
        sb.append(trackName);
        sb.append("\n  ");
        sb.append("@").append(fileName);
        sb.append("(uploaded ").append(DateTimeFormatter.ISO_INSTANT.format(timePoint.asDate().toInstant())).append(")");
        return sb.toString();
    }
}

