/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelog;

import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class RaceStateOfSameDayHelper {
    public static boolean isRaceStateOfSameDay(TimePoint raceStartTimePoint, TimePoint raceFinishedTimePoint, TimePoint abortingTimePoint, Calendar now, Duration clientTimeZoneOffset) {
        Date raceStartTime = null;
        Date raceFinishedTime = null;
        Date abortingTime = null;
        if (raceStartTimePoint != null) {
            raceStartTime = raceStartTimePoint.asDate();
        }
        if (raceFinishedTimePoint != null) {
            raceFinishedTime = raceFinishedTimePoint.asDate();
        }
        if (abortingTimePoint != null) {
            abortingTime = abortingTimePoint.asDate();
        }
        return RaceStateOfSameDayHelper.isRaceStateOfSameDay(raceStartTime, raceFinishedTime, abortingTime, now, clientTimeZoneOffset);
    }

    public static boolean isRaceStateOfSameDay(Date raceStartTime, Date raceFinishedTime, Calendar now, Duration clientTimeZoneOffset) {
        boolean result;
        String[] availableTimeZoneIDsForOffset;
        Calendar timeToCheck = Calendar.getInstance();
        if (clientTimeZoneOffset != null && (availableTimeZoneIDsForOffset = TimeZone.getAvailableIDs((int)(-clientTimeZoneOffset.asMillis()))) != null && availableTimeZoneIDsForOffset.length > 0) {
            TimeZone tz = TimeZone.getTimeZone(availableTimeZoneIDsForOffset[0]);
            timeToCheck.setTimeZone(tz);
            now.setTimeZone(tz);
        }
        if (raceFinishedTime != null || raceStartTime != null) {
            if (raceFinishedTime != null) {
                timeToCheck.setTime(raceFinishedTime);
            } else if (raceStartTime != null) {
                timeToCheck.setTime(raceStartTime);
            }
            result = RaceStateOfSameDayHelper.isSameDay(now, timeToCheck);
        } else {
            result = false;
        }
        return result;
    }

    public static boolean isRaceStateOfSameDay(Date raceStartTime, Date raceFinishedTime, Date abortingTime, Calendar now, Duration clientTimeZoneOffset) {
        boolean result = RaceStateOfSameDayHelper.isRaceStateOfSameDay(raceStartTime, raceFinishedTime, now, clientTimeZoneOffset);
        if (!result && abortingTime != null) {
            Calendar abortingTimeCal = Calendar.getInstance();
            abortingTimeCal.setTime(abortingTime);
            if (RaceStateOfSameDayHelper.isSameDay(now, abortingTimeCal)) {
                result = true;
            }
        }
        return result;
    }

    private static boolean isSameDay(Calendar cal1, Calendar cal2) {
        return cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }
}

