/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.orc.impl;

import com.sap.sailing.domain.orc.impl.AbstractORCCertificatesImporter;
import com.sap.sailing.domain.orc.impl.ORCCertificatesCollectionRMS;
import com.sap.sse.common.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ORCCertificatesRmsImporter
extends AbstractORCCertificatesImporter {
    private static final String NAME_OF_COLUMN_HEADER_WHERE_THINGS_GET_WEIRD = "DD_MM_yyYY";

    @Override
    public ORCCertificatesCollectionRMS read(Reader reader) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(reader);
        String header = br.readLine();
        LinkedHashMap<String, Util.Pair<Integer, Integer>> columnNamesAndFieldNameStartInHeader = this.readColumnHeaderFieldNameStartColumnsAndLengthFromFirstLine(header);
        HashMap<String, Map<String, String>> certificateValuesByCertificateId = new HashMap<String, Map<String, String>>();
        while ((line = br.readLine()) != null) {
            if (line.trim().isEmpty()) continue;
            Map<String, String> parsedLine = this.parseLine(line, columnNamesAndFieldNameStartInHeader);
            certificateValuesByCertificateId.put(parsedLine.get("ReferenceNo"), parsedLine);
        }
        return new ORCCertificatesCollectionRMS(certificateValuesByCertificateId);
    }

    @Override
    public ORCCertificatesCollectionRMS read(InputStream in) throws IOException {
        return this.read(this.getReaderForInputStream(in));
    }

    private Map<String, String> parseLine(String line, LinkedHashMap<String, Util.Pair<Integer, Integer>> columnNamesAndFieldNameStartAndLengthInHeader) {
        assert (columnNamesAndFieldNameStartAndLengthInHeader != null);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        boolean leftAligned = true;
        for (Map.Entry<String, Util.Pair<Integer, Integer>> columnNameAndFieldNameStartInHeader : columnNamesAndFieldNameStartAndLengthInHeader.entrySet()) {
            String value;
            int end;
            int start = (Integer)columnNameAndFieldNameStartInHeader.getValue().getA();
            if (leftAligned) {
                end = start + (Integer)columnNameAndFieldNameStartInHeader.getValue().getB();
                value = line.substring(start, end).trim();
            } else {
                end = start + columnNameAndFieldNameStartInHeader.getKey().length();
                value = this.expandFromNonSpaceCharacterInRange(line, start, end);
            }
            result.put(columnNameAndFieldNameStartInHeader.getKey(), value);
            if (!columnNameAndFieldNameStartInHeader.getKey().equals(NAME_OF_COLUMN_HEADER_WHERE_THINGS_GET_WEIRD)) continue;
            leftAligned = false;
        }
        return result;
    }

    private String expandFromNonSpaceCharacterInRange(String line, int start, int end) {
        String result;
        if (start >= line.length()) {
            result = null;
        } else {
            int left = start;
            while (left < line.length() && left < end && left < line.length() && Character.isWhitespace(line.charAt(left))) {
                ++left;
            }
            if (left >= end) {
                result = null;
            } else {
                int right = left + 1;
                while (left > 0 && !Character.isWhitespace(line.charAt(left - 1))) {
                    --left;
                }
                while (right < line.length() && !Character.isWhitespace(line.charAt(right))) {
                    ++right;
                }
                result = line.substring(left, right);
            }
        }
        return result;
    }

    private LinkedHashMap<String, Util.Pair<Integer, Integer>> readColumnHeaderFieldNameStartColumnsAndLengthFromFirstLine(String readLine) {
        LinkedHashMap<String, Util.Pair<Integer, Integer>> result = new LinkedHashMap<String, Util.Pair<Integer, Integer>>();
        Pattern p = Pattern.compile("([^ ]+ *)");
        Matcher m = p.matcher(readLine);
        int start = 0;
        while (m.find(start)) {
            String fieldNameTrimmed = m.group(1).trim();
            result.put(fieldNameTrimmed, (Util.Pair<Integer, Integer>)new Util.Pair((Object)m.start(1), (Object)m.group(1).length()));
            start += m.group(1).length();
        }
        return result;
    }
}

