/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.orc.impl;

import com.sap.sailing.domain.orc.ORCCertificatesCollection;
import com.sap.sailing.domain.orc.ORCCertificatesImporter;
import com.sap.sailing.domain.orc.impl.ORCCertificatesCollectionJSON;
import com.sap.sailing.domain.orc.impl.ORCCertificatesCollectionRMS;
import com.sap.sailing.domain.orc.impl.ORCCertificatesJsonImporter;
import com.sap.sailing.domain.orc.impl.ORCCertificatesRmsImporter;
import com.sap.sse.common.Util;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.json.simple.parser.ParseException;

public class FormatProbingORCCertificatesImporter
implements ORCCertificatesImporter {
    private static final Logger logger = Logger.getLogger(FormatProbingORCCertificatesImporter.class.getName());
    private final ORCCertificatesJsonImporter jsonImporter = new ORCCertificatesJsonImporter();
    private final ORCCertificatesRmsImporter rmsImporter = new ORCCertificatesRmsImporter();
    final ScheduledExecutorService executor = ThreadPoolUtil.INSTANCE.getDefaultForegroundTaskThreadPoolExecutor();

    @Override
    public ORCCertificatesCollection read(InputStream inputStream) throws IOException, ParseException {
        byte[] content = IOUtils.toByteArray((InputStream)inputStream);
        Future<ORCCertificatesCollectionJSON> jsonFuture = this.executor.submit(() -> this.jsonImporter.read(new ByteArrayInputStream(content)));
        Future<ORCCertificatesCollectionRMS> rmsFuture = this.executor.submit(() -> this.rmsImporter.read(new ByteArrayInputStream(content)));
        return this.getResultFromFutures(jsonFuture, rmsFuture);
    }

    @Override
    public ORCCertificatesCollection read(Reader reader) throws IOException, ParseException {
        char[] content = IOUtils.toCharArray((Reader)reader);
        Future<ORCCertificatesCollectionJSON> jsonFuture = this.executor.submit(() -> this.jsonImporter.read(new CharArrayReader(content)));
        Future<ORCCertificatesCollectionRMS> rmsFuture = this.executor.submit(() -> this.rmsImporter.read(new CharArrayReader(content)));
        return this.getResultFromFutures(jsonFuture, rmsFuture);
    }

    private ORCCertificatesCollection getResultFromFutures(Future<ORCCertificatesCollectionJSON> jsonFuture, Future<ORCCertificatesCollectionRMS> rmsFuture) {
        ORCCertificatesCollection result = null;
        try {
            result = jsonFuture.get();
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Couldn't read ORC certificates from input stream as JSON: " + e.getMessage());
        }
        if (result == null || Util.isEmpty(result.getCertificateIds())) {
            try {
                result = rmsFuture.get();
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Couldn't read ORC certificates from input stream as RMS either: " + e.getMessage());
            }
        }
        return result;
    }
}

