/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.markpassingcalculation.splining;

import com.sap.sailing.domain.markpassingcalculation.splining.Vector2D;

public class StraightLine {
    private final Vector2D locationVector;
    private final Vector2D directionVector;

    public StraightLine(Vector2D locationVector, Vector2D directionVector) {
        this.locationVector = locationVector;
        this.directionVector = directionVector;
    }

    public Vector2D getLocationVector() {
        return this.locationVector;
    }

    public Vector2D getDirectionVector() {
        return this.directionVector;
    }

    public double getDistanceToPoint(Vector2D point) {
        Vector2D normal = this.getDirectionVector().getPerpendicularVector();
        Vector2D perpendicularFoot = point.subtract(normal.multiply(point.subtract(this.getDirectionVector()).dotProduct(normal) / normal.dotProduct(normal)));
        return perpendicularFoot.getDistanceToPoint(point);
    }

    public String toString() {
        String p = "p = (" + this.getLocationVector().x() + "/" + this.getLocationVector().y() + ")";
        String d = "d = (" + this.getDirectionVector().x() + "/" + this.getDirectionVector().y() + ")";
        return "StraightLine: " + p + ", " + d;
    }
}

