/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.markpassingcalculation.splining;

import com.sap.sailing.domain.markpassingcalculation.splining.DoubleMatrix;
import com.sap.sailing.domain.markpassingcalculation.splining.StraightLine;
import com.sap.sailing.domain.markpassingcalculation.splining.Vector2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HermiteCurve {
    private final DoubleMatrix hermiteBaseMatrix = new DoubleMatrix(4, 4, 2.0, -2.0, 1.0, 1.0, -3.0, 3.0, -2.0, -1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0);
    private final List<Double> exponents = Arrays.asList(3.0, 2.0, 1.0, 0.0);
    private final DoubleMatrix geometryMatrix;

    public HermiteCurve(Vector2D point1, Vector2D point2, Vector2D tangent1, Vector2D tangent2) {
        this.geometryMatrix = new DoubleMatrix(2, 4, point1.x(), point1.y(), point2.x(), point2.y(), tangent1.x(), tangent1.y(), tangent2.x(), tangent2.y());
    }

    public Map<Vector2D, Double> intersectWith(StraightLine line) {
        Vector2D p0 = this.getFirstPoint();
        Vector2D p1 = this.getSecondPoint();
        Vector2D m0 = this.getTangentAtFirstPoint();
        Vector2D m1 = this.getTangentAtSecondPoint();
        Vector2D p2 = line.getLocationVector();
        Vector2D d = line.getDirectionVector();
        double s3 = -d.y() * (2.0 * p0.x() - 2.0 * p1.x() + m0.x() + m1.x()) + d.x() * (2.0 * p0.y() - 2.0 * p1.y() + m0.y() + m1.y());
        double s2 = -d.y() * (-3.0 * p0.x() + 3.0 * p1.x() - 2.0 * m0.x() - m1.x()) + d.x() * (-3.0 * p0.y() + 3.0 * p1.y() - 2.0 * m0.y() - m1.y());
        double s1 = -d.y() * m0.x() + d.x() * m0.y();
        double s0 = -d.y() * p0.x() + d.x() * p0.y() + d.y() * p2.x() - d.x() * p2.y();
        double a = s2 / s3;
        double b = s1 / s3;
        double c = s0 / s3;
        double p = b - Math.pow(a, 2.0) / 3.0;
        double q = 2.0 * Math.pow(a, 3.0) / 27.0 - a * b / 3.0 + c;
        double discriminant = Math.pow(q / 2.0, 2.0) + Math.pow(p / 3.0, 3.0);
        ArrayList<Double> zResults = new ArrayList<Double>();
        if (discriminant > 0.0) {
            double u = Math.pow(-q / 2.0 + Math.sqrt(discriminant), 0.0);
            double v = Math.pow(-q / 2.0 - Math.sqrt(discriminant), 0.0);
            zResults.add(u + v);
        } else if (discriminant < 0.0) {
            zResults.add(-Math.sqrt(-1.3333333333333333 * p) * Math.cos(0.3333333333333333 * Math.acos(-q / 2.0 * Math.sqrt(-27.0 / Math.pow(p, 3.0))) + 1.0471975511965976));
            zResults.add(Math.sqrt(-1.3333333333333333 * p) * Math.cos(0.3333333333333333 * Math.acos(-q / 2.0 * Math.sqrt(-27.0 / Math.pow(p, 3.0)))));
            zResults.add(-Math.sqrt(-1.3333333333333333 * p) * Math.cos(0.3333333333333333 * Math.acos(-q / 2.0 * Math.sqrt(-27.0 / Math.pow(p, 3.0))) - 1.0471975511965976));
        } else if (discriminant == 0.0) {
            if (p == 0.0 && q == 0.0) {
                zResults.add(0.0);
            } else {
                zResults.add(3.0 * q / p);
                zResults.add(-3.0 * q / (2.0 * p));
            }
        }
        HashMap<Vector2D, Double> results = new HashMap<Vector2D, Double>();
        for (Double z : zResults) {
            double t = z - a / 3.0;
            if (!(t >= 0.0) || !(t <= 1.0)) continue;
            Vector2D intersectionPoint = this.interpolateCurvePoint(t);
            results.put(intersectionPoint, t);
        }
        return results;
    }

    public Vector2D getTangentAtSecondPoint() {
        return new Vector2D(this.geometryMatrix.getRow(3));
    }

    public Vector2D getTangentAtFirstPoint() {
        return new Vector2D(this.geometryMatrix.getRow(2));
    }

    public Vector2D getSecondPoint() {
        return new Vector2D(this.geometryMatrix.getRow(1));
    }

    public Vector2D getFirstPoint() {
        return new Vector2D(this.geometryMatrix.getRow(0));
    }

    public Vector2D interpolateCurvePoint(double t) {
        if (t < 0.0 || t > 1.0) {
            throw new IllegalArgumentException("Value of t (" + t + ") is not in the interval of 0.0 to 1.0");
        }
        DoubleMatrix exponentMatrix = this.getExponentMatrix(t);
        DoubleMatrix result = exponentMatrix.multiply(this.hermiteBaseMatrix.multiply(this.geometryMatrix));
        return new Vector2D(result.getRow(0));
    }

    private DoubleMatrix getExponentMatrix(double t) {
        ArrayList<Double> exponentMatrixValues = new ArrayList<Double>();
        for (double e : this.exponents) {
            exponentMatrixValues.add(Math.pow(t, e));
        }
        return new DoubleMatrix(4, 1, exponentMatrixValues);
    }

    public String toString() {
        String p1 = "p1 = (" + this.getFirstPoint().x() + "/" + this.getFirstPoint().y() + ")";
        String p2 = "p2 = (" + this.getSecondPoint().x() + "/" + this.getSecondPoint().y() + ")";
        String t1 = "t1 = (" + this.getTangentAtFirstPoint().x() + "/" + this.getTangentAtFirstPoint().y() + ")";
        String t2 = "t2 = (" + this.getTangentAtSecondPoint().x() + "/" + this.getTangentAtSecondPoint().y() + ")";
        return "Hermite Curve: " + p1 + ", " + p2 + ", " + t1 + ", " + t2;
    }
}

