/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.maneuverdetection.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.CourseChange;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.maneuverdetection.ManeuverDetector;
import com.sap.sailing.domain.maneuverdetection.TrackTimeInfo;
import com.sap.sailing.domain.maneuverdetection.impl.AbstractManeuverDetectorImpl;
import com.sap.sailing.domain.maneuverdetection.impl.ApproximatedFixesCalculatorImpl;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.impl.ManeuverCurveBoundariesImpl;
import com.sap.sailing.domain.tracking.impl.ManeuverWithCoarseGrainedBoundariesImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LowGPSSamplingRateManeuverDetectorImpl
extends AbstractManeuverDetectorImpl
implements ManeuverDetector {
    public LowGPSSamplingRateManeuverDetectorImpl(TrackedRace trackedRace, Competitor competitor) {
        super(trackedRace, competitor);
    }

    @Override
    public List<Maneuver> detectManeuvers() {
        ApproximatedFixesCalculatorImpl approximatedFixesCalculator;
        Iterable<GPSFixMoving> approximatedFixes;
        ArrayList<Maneuver> result = new ArrayList<Maneuver>();
        TrackTimeInfo startAndEndTimePoints = this.getTrackTimeInfo();
        if (startAndEndTimePoints != null && Util.size(approximatedFixes = (approximatedFixesCalculator = new ApproximatedFixesCalculatorImpl(this.trackedRace, this.competitor)).approximate(startAndEndTimePoints.getTrackStartTimePoint(), startAndEndTimePoints.getTrackEndTimePoint())) > 2) {
            Iterator<GPSFixMoving> approximationPointsIter = approximatedFixes.iterator();
            GPSFixMoving previous = approximationPointsIter.next();
            GPSFixMoving current = approximationPointsIter.next();
            do {
                GPSFixMoving next = approximationPointsIter.next();
                SpeedWithBearing speedWithBearingOnApproximationFromPreviousToCurrent = previous.getSpeedAndBearingRequiredToReach((GPSFix)current);
                SpeedWithBearing speedWithBearingOnApproximationFromCurrentToNext = current.getSpeedAndBearingRequiredToReach((GPSFix)next);
                CourseChange courseChange = speedWithBearingOnApproximationFromPreviousToCurrent.getCourseChangeRequiredToReach(speedWithBearingOnApproximationFromCurrentToNext);
                speedWithBearingOnApproximationFromPreviousToCurrent = speedWithBearingOnApproximationFromCurrentToNext;
                Maneuver maneuver = this.createManeuverFromGroupOfCourseChanges(this.competitor, speedWithBearingOnApproximationFromPreviousToCurrent, current, speedWithBearingOnApproximationFromCurrentToNext, courseChange.getCourseChangeInDegrees());
                result.add(maneuver);
                previous = current;
                current = next;
            } while (approximationPointsIter.hasNext());
        }
        return result;
    }

    private Maneuver createManeuverFromGroupOfCourseChanges(Competitor competitor, SpeedWithBearing speedWithBearingOnApproximationAtBeginning, GPSFixMoving currentFix, SpeedWithBearing speedWithBearingOnApproximationAtEnd, double totalCourseChangeInDegrees) {
        ManeuverType maneuverType;
        SpeedWithBearing highestSpeed;
        SpeedWithBearing lowestSpeed;
        TimePoint maneuverTimePoint = currentFix.getTimePoint();
        Position maneuverPosition = currentFix.getPosition();
        Wind wind = this.trackedRace.getWind(maneuverPosition, maneuverTimePoint);
        Tack tackAfterManeuver = null;
        try {
            tackAfterManeuver = wind == null ? null : this.trackedRace.getTack(maneuverPosition, maneuverTimePoint, speedWithBearingOnApproximationAtEnd.getBearing());
        }
        catch (NoWindException noWindException) {
            // empty catch block
        }
        if (speedWithBearingOnApproximationAtBeginning.compareTo((Object)speedWithBearingOnApproximationAtBeginning) < 0) {
            lowestSpeed = speedWithBearingOnApproximationAtBeginning;
            highestSpeed = speedWithBearingOnApproximationAtEnd;
        } else {
            lowestSpeed = speedWithBearingOnApproximationAtEnd;
            highestSpeed = speedWithBearingOnApproximationAtBeginning;
        }
        ManeuverCurveBoundariesImpl maneuverCurve = new ManeuverCurveBoundariesImpl(maneuverTimePoint.minus(this.getApproximateManeuverDuration().divide(2L)), maneuverTimePoint.plus(this.getApproximateManeuverDuration().times(3.0)), speedWithBearingOnApproximationAtBeginning, speedWithBearingOnApproximationAtEnd, totalCourseChangeInDegrees, (Speed)lowestSpeed, (Speed)highestSpeed);
        if (wind != null) {
            if (this.getNumberOfTacks(maneuverCurve, wind) > 0) {
                maneuverType = ManeuverType.TACK;
            } else if (this.getNumberOfJibes(maneuverCurve, wind) > 0) {
                maneuverType = ManeuverType.JIBE;
            } else {
                Bearing windBearing = wind.getBearing();
                Bearing toWindBeforeManeuver = windBearing.getDifferenceTo(speedWithBearingOnApproximationAtBeginning.getBearing());
                Bearing toWindAfterManeuver = windBearing.getDifferenceTo(speedWithBearingOnApproximationAtEnd.getBearing());
                maneuverType = Math.abs(toWindBeforeManeuver.getDegrees()) < Math.abs(toWindAfterManeuver.getDegrees()) ? ManeuverType.HEAD_UP : ManeuverType.BEAR_AWAY;
            }
        } else {
            maneuverType = ManeuverType.UNKNOWN;
        }
        ManeuverWithCoarseGrainedBoundariesImpl maneuver = new ManeuverWithCoarseGrainedBoundariesImpl(maneuverType, tackAfterManeuver, maneuverPosition, maneuverTimePoint, maneuverCurve);
        return maneuver;
    }
}

