/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.maneuverdetection;

import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.datamining.annotations.Statistic;

public interface ManeuverMainCurveWithEstimationData
extends ManeuverCurveBoundaries {
    public SpeedWithBearing getLowestSpeed();

    public TimePoint getLowestSpeedTimePoint();

    @Statistic(messageKey="PercentageOfMainCurveProgressUntilLowestSpeed", resultDecimals=4)
    default public double getPercentageOfMainCurveProgressUntilLowestSpeed() {
        return this.getTimePointBefore().until(this.getLowestSpeedTimePoint()).asSeconds() / this.getDuration().asSeconds();
    }

    public SpeedWithBearing getHighestSpeed();

    public TimePoint getHighestSpeedTimePoint();

    @Statistic(messageKey="PercentageOfMainCurveProgressUntilHighestSpeed", resultDecimals=4)
    default public double getPercentageOfMainCurveProgressUntilHighestSpeed() {
        return this.getTimePointBefore().until(this.getHighestSpeedTimePoint()).asSeconds() / this.getDuration().asSeconds();
    }

    public TimePoint getTimePointOfMaxTurningRate();

    @Statistic(messageKey="PercentageOfMainCurveProgressUntilMaxTurningRate", resultDecimals=4)
    default public double getPercentageOfMainCurveProgressUntilMaxTurningRate() {
        return this.getTimePointBefore().until(this.getTimePointOfMaxTurningRate()).asSeconds() / this.getDuration().asSeconds();
    }

    @Statistic(messageKey="MaxTurningRateInDegreesPerSecond", resultDecimals=4)
    public double getMaxTurningRateInDegreesPerSecond();

    @Statistic(messageKey="AvgTurningRateInDegreesPerSecond", resultDecimals=4)
    public double getAvgTurningRateInDegreesPerSecond();

    public Bearing getCourseAtMaxTurningRate();

    public int getGpsFixesCount();

    public Duration getLongestIntervalBetweenTwoFixes();
}

