/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.ScoreCorrection;
import com.sap.sailing.domain.leaderboard.ScoreCorrectionListener;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.SettableScoreCorrection;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScoreCorrectionImpl
implements SettableScoreCorrection {
    private static final long serialVersionUID = -7088305215528928135L;
    private static final Logger logger = Logger.getLogger(ScoreCorrectionImpl.class.getName());
    private final ConcurrentMap<Util.Pair<Competitor, RaceColumn>, MaxPointsReason> maxPointsReasons;
    private final ConcurrentMap<Util.Pair<Competitor, RaceColumn>, Double> correctedScores;
    private final ConcurrentMap<Util.Pair<Competitor, RaceColumn>, Double> incrementalScoreCorrection;
    private String comment;
    private TimePoint timePointOfLastCorrectionsValidity;
    private transient Set<ScoreCorrectionListener> scoreCorrectionListeners;
    private final Leaderboard leaderboard;

    public ScoreCorrectionImpl(Leaderboard leaderboard) {
        this.leaderboard = leaderboard;
        this.maxPointsReasons = new ConcurrentHashMap<Util.Pair<Competitor, RaceColumn>, MaxPointsReason>();
        this.correctedScores = new ConcurrentHashMap<Util.Pair<Competitor, RaceColumn>, Double>();
        this.incrementalScoreCorrection = new ConcurrentHashMap<Util.Pair<Competitor, RaceColumn>, Double>();
        this.scoreCorrectionListeners = new HashSet<ScoreCorrectionListener>();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.scoreCorrectionListeners = new HashSet<ScoreCorrectionListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ScoreCorrectionListener> getScoreCorrectionListeners() {
        Set<ScoreCorrectionListener> set = this.scoreCorrectionListeners;
        synchronized (set) {
            return new HashSet<ScoreCorrectionListener>(this.scoreCorrectionListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addScoreCorrectionListener(ScoreCorrectionListener listener) {
        Set<ScoreCorrectionListener> set = this.scoreCorrectionListeners;
        synchronized (set) {
            this.scoreCorrectionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeScoreCorrectionListener(ScoreCorrectionListener listener) {
        Set<ScoreCorrectionListener> set = this.scoreCorrectionListeners;
        synchronized (set) {
            this.scoreCorrectionListeners.remove(listener);
        }
    }

    protected void notifyListeners(Competitor competitor, RaceColumn raceColumn, Double oldCorrectedScore, Double newCorrectedScore) {
        for (ScoreCorrectionListener listener : this.getScoreCorrectionListeners()) {
            listener.correctedScoreChanged(competitor, raceColumn, oldCorrectedScore, newCorrectedScore);
        }
    }

    protected void notifyListenersAboutIncrementalScoreChange(Competitor competitor, RaceColumn raceColumn, Double oldScoreOffsetInPoints, Double newScoreOffsetInPoints) {
        for (ScoreCorrectionListener listener : this.getScoreCorrectionListeners()) {
            listener.incrementalScoreCorrectionChanged(competitor, raceColumn, oldScoreOffsetInPoints, newScoreOffsetInPoints);
        }
    }

    protected void notifyListeners(Competitor competitor, RaceColumn raceColumn, MaxPointsReason oldMaxPointsReason, MaxPointsReason newMaxPointsReason) {
        for (ScoreCorrectionListener listener : this.getScoreCorrectionListeners()) {
            listener.maxPointsReasonChanged(competitor, raceColumn, oldMaxPointsReason, newMaxPointsReason);
        }
    }

    @Override
    public void notifyListenersAboutCarriedPointsChange(Competitor competitor, Double oldCarriedPoints, Double newCarriedPoints) {
        for (ScoreCorrectionListener listener : this.getScoreCorrectionListeners()) {
            listener.carriedPointsChanged(competitor, oldCarriedPoints, newCarriedPoints);
        }
    }

    @Override
    public void notifyListenersAboutIsSuppressedChange(Competitor competitor, boolean suppressed) {
        for (ScoreCorrectionListener listener : this.getScoreCorrectionListeners()) {
            listener.isSuppressedChanged(competitor, suppressed);
        }
    }

    @Override
    public void notifyListenersAboutLastCorrectionsValidityChanged(TimePoint oldTimePointOfLastCorrectionsValidity, TimePoint newTimePointOfLastCorrectionsValidity) {
        for (ScoreCorrectionListener listener : this.getScoreCorrectionListeners()) {
            listener.timePointOfLastCorrectionsValidityChanged(oldTimePointOfLastCorrectionsValidity, newTimePointOfLastCorrectionsValidity);
        }
    }

    @Override
    public void notifyListenersAboutCommentChanged(String oldComment, String newComment) {
        for (ScoreCorrectionListener listener : this.getScoreCorrectionListeners()) {
            listener.commentChanged(oldComment, newComment);
        }
    }

    @Override
    public void setMaxPointsReason(Competitor competitor, RaceColumn raceColumn, MaxPointsReason reason) {
        Util.Pair<Competitor, RaceColumn> key = raceColumn.getKey(competitor);
        MaxPointsReason oldMaxPointsReason = reason == null ? (MaxPointsReason)this.maxPointsReasons.remove(key) : this.maxPointsReasons.put(key, reason);
        this.notifyListeners(competitor, raceColumn, oldMaxPointsReason, reason);
    }

    @Override
    public void correctScore(Competitor competitor, RaceColumn raceColumn, double points) {
        Double oldScore = this.correctedScores.put(raceColumn.getKey(competitor), points);
        this.notifyListeners(competitor, raceColumn, oldScore, points);
    }

    @Override
    public boolean isScoreCorrected(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint) {
        Util.Pair<Competitor, RaceColumn> key = raceColumn.getKey(competitor);
        return this.correctedScores.containsKey(key) && !this.isCertainlyBeforeRaceFinish(timePoint, raceColumn, competitor) || this.maxPointsReasons.containsKey(key) && this.isMaxPointsReasonApplicable((MaxPointsReason)this.maxPointsReasons.get(key), timePoint, raceColumn, competitor);
    }

    @Override
    public void uncorrectScore(Competitor competitor, RaceColumn raceColumn) {
        Double oldScore = (Double)this.correctedScores.remove(raceColumn.getKey(competitor));
        this.notifyListeners(competitor, raceColumn, oldScore, null);
    }

    @Override
    public void correctScoreIncrementally(Competitor competitor, RaceColumn raceColumn, double scoreOffsetInPoints) {
        Double oldScoreOffsetInPoints = this.incrementalScoreCorrection.put(raceColumn.getKey(competitor), scoreOffsetInPoints);
        this.notifyListenersAboutIncrementalScoreChange(competitor, raceColumn, oldScoreOffsetInPoints, scoreOffsetInPoints);
    }

    @Override
    public boolean isScoreCorrectedIncrementally(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint) {
        Util.Pair<Competitor, RaceColumn> key = raceColumn.getKey(competitor);
        return this.incrementalScoreCorrection.containsKey(key) && !this.isCertainlyBeforeRaceFinish(timePoint, raceColumn, competitor) || this.maxPointsReasons.containsKey(key) && this.isMaxPointsReasonApplicable((MaxPointsReason)this.maxPointsReasons.get(key), timePoint, raceColumn, competitor);
    }

    @Override
    public Double getIncementalScoreCorrectionInPoints(Competitor competitor, RaceColumn raceColumn) {
        return (Double)this.incrementalScoreCorrection.get(raceColumn.getKey(competitor));
    }

    @Override
    public void uncorrectScoreIncrementally(Competitor competitor, RaceColumn raceColumn) {
        Double oldScoreOffsetInPoints = (Double)this.incrementalScoreCorrection.remove(raceColumn.getKey(competitor));
        this.notifyListenersAboutIncrementalScoreChange(competitor, raceColumn, oldScoreOffsetInPoints, null);
    }

    private boolean isCertainlyBeforeRaceStart(TimePoint timePoint, RaceColumn raceColumn, Competitor competitor) {
        boolean result;
        TimePoint startOfRace;
        TrackedRace trackedRace = raceColumn.getTrackedRace(competitor);
        if (trackedRace != null && (startOfRace = trackedRace.getStartOfRace()) != null) {
            result = timePoint.before(startOfRace);
        } else {
            boolean preResult = false;
            for (RaceColumn rc : this.getLeaderboard().getRaceColumns()) {
                if (rc == raceColumn) break;
                TrackedRace rcTrackedRace = rc.getTrackedRace(competitor);
                if (rcTrackedRace == null) continue;
                NavigableSet<MarkPassing> markPassings = rcTrackedRace.getMarkPassings(competitor);
                if (markPassings != null && !markPassings.isEmpty()) {
                    MarkPassing lastMarkPassing = (MarkPassing)markPassings.last();
                    if (!timePoint.before(lastMarkPassing.getTimePoint())) continue;
                    preResult = true;
                    break;
                }
                TimePoint endOfRace = rcTrackedRace.getEndOfRace();
                if (endOfRace == null || !timePoint.before(endOfRace)) continue;
                preResult = true;
                break;
            }
            result = preResult;
        }
        return result;
    }

    private boolean isCertainlyBeforeRaceFinish(TimePoint timePoint, RaceColumn raceColumn, Competitor competitor) {
        return this.isCertainlyBeforeRaceFinish(timePoint, raceColumn, competitor, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    private boolean isCertainlyBeforeRaceFinish(TimePoint timePoint, RaceColumn raceColumn, Competitor competitor, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        boolean result;
        TimePoint endOfRace;
        TrackedRace trackedRace = raceColumn.getTrackedRace(competitor);
        TimePoint timePoint2 = trackedRace == null ? null : (endOfRace = trackedRace.getFinishedTime() == null ? trackedRace.getEndOfRace() : trackedRace.getFinishedTime());
        if (endOfRace != null) {
            MarkPassing lastMarkPassing;
            NavigableSet<MarkPassing> markPassings = trackedRace.getMarkPassings(competitor);
            boolean raceFinishedForCompetitor = markPassings != null && !markPassings.isEmpty() && (lastMarkPassing = (MarkPassing)markPassings.last()).getWaypoint() == trackedRace.getRace().getCourse().getLastWaypoint() && !timePoint.before(lastMarkPassing.getTimePoint()) || !timePoint.before(endOfRace);
            result = !raceFinishedForCompetitor;
        } else {
            boolean preResult = false;
            for (RaceColumn rc : this.getLeaderboard().getRaceColumns()) {
                if (rc == raceColumn) break;
                TrackedRace rcTrackedRace = rc.getTrackedRace(competitor);
                if (rcTrackedRace == null) continue;
                NavigableSet<MarkPassing> markPassings = rcTrackedRace.getMarkPassings(competitor);
                if (markPassings != null && !markPassings.isEmpty()) {
                    MarkPassing lastMarkPassing = (MarkPassing)markPassings.last();
                    if (!timePoint.before(lastMarkPassing.getTimePoint())) continue;
                    preResult = true;
                    break;
                }
                TimePoint rcEndOfRace = rcTrackedRace.getEndOfRace();
                if (rcEndOfRace != null) {
                    if (!timePoint.before(rcEndOfRace)) continue;
                    preResult = true;
                    break;
                }
                TimePoint rcStartOfRace = rcTrackedRace.getStartOfRace();
                if (rcStartOfRace == null || !timePoint.before(rcStartOfRace)) continue;
                preResult = true;
                break;
            }
            result = preResult;
        }
        return result;
    }

    @Override
    public MaxPointsReason getMaxPointsReason(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint) {
        return this.getAnnotatedMaxPointsReason(competitor, raceColumn, timePoint).getMaxPointsReason();
    }

    protected AnnotatedMaxPointsReason getAnnotatedMaxPointsReason(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint) {
        boolean calculateScoreDuringRace;
        boolean maxPointsReasonExistsButIsNotApplicableForTimePoint;
        MaxPointsReason maxPointsReason = (MaxPointsReason)this.maxPointsReasons.get(raceColumn.getKey(competitor));
        if (maxPointsReason == null) {
            maxPointsReason = MaxPointsReason.NONE;
            maxPointsReasonExistsButIsNotApplicableForTimePoint = false;
            calculateScoreDuringRace = false;
        } else if (!this.isMaxPointsReasonApplicable(maxPointsReason, timePoint, raceColumn, competitor)) {
            maxPointsReason = MaxPointsReason.NONE;
            maxPointsReasonExistsButIsNotApplicableForTimePoint = true;
            calculateScoreDuringRace = false;
        } else {
            maxPointsReasonExistsButIsNotApplicableForTimePoint = false;
            calculateScoreDuringRace = maxPointsReason.isCalculateScoreDuringRace() && this.isCertainlyBeforeRaceFinish(timePoint, raceColumn, competitor);
        }
        return new AnnotatedMaxPointsReason(maxPointsReason, maxPointsReasonExistsButIsNotApplicableForTimePoint, calculateScoreDuringRace);
    }

    private boolean isMaxPointsReasonApplicable(MaxPointsReason maxPointsReason, TimePoint timePoint, RaceColumn raceColumn, Competitor competitor) {
        return maxPointsReason.isAppliesAtStartOfRace() && !this.isCertainlyBeforeRaceStart(timePoint, raceColumn, competitor) || !this.isCertainlyBeforeRaceFinish(timePoint, raceColumn, competitor);
    }

    @Override
    public ScoreCorrection.Result getCorrectedScore(final Callable<Integer> trackedRankProvider, final Competitor competitor, final RaceColumn raceColumn, final Leaderboard leaderboard, final TimePoint timePoint, final NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, final ScoringScheme scoringScheme, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Double correctedNonMaxedScore;
        Double correctedScore;
        final AnnotatedMaxPointsReason maxPointsReason = this.getAnnotatedMaxPointsReason(competitor, raceColumn, timePoint);
        if (maxPointsReason.getMaxPointsReason() == MaxPointsReason.NONE) {
            correctedScore = maxPointsReason.isMaxPointsReasonExistsButIsNotApplicableForTimePoint() ? this.getUncorrectedScore(competitor, raceColumn, trackedRankProvider, scoringScheme, numberOfCompetitorsInLeaderboardFetcher, timePoint, cache) : this.getCorrectedNonMaxedScore(competitor, raceColumn, trackedRankProvider, scoringScheme, numberOfCompetitorsInLeaderboardFetcher, timePoint, cache);
        } else if (maxPointsReason.isCalculateScoreDuringRace() && this.isCertainlyBeforeRaceFinish(timePoint, raceColumn, competitor) || (correctedNonMaxedScore = (Double)this.correctedScores.get(raceColumn.getKey(competitor))) == null) {
            Double uncorrectedScore;
            Supplier<Double> uncorrectedScoreProvider = () -> this.getUncorrectedScore(competitor, raceColumn, trackedRankProvider, scoringScheme, numberOfCompetitorsInLeaderboardFetcher, timePoint, cache);
            Double incrementalScoreCorrectionForCompetitorInColumn = (Double)this.incrementalScoreCorrection.get(raceColumn.getKey(competitor));
            correctedScore = incrementalScoreCorrectionForCompetitorInColumn != null ? ((uncorrectedScore = uncorrectedScoreProvider.get()) == null ? null : Double.valueOf(uncorrectedScore + incrementalScoreCorrectionForCompetitorInColumn)) : scoringScheme.getPenaltyScore(raceColumn, competitor, maxPointsReason.getMaxPointsReason(), this.getNumberOfCompetitorsInRace(raceColumn, competitor, numberOfCompetitorsInLeaderboardFetcher), numberOfCompetitorsInLeaderboardFetcher, timePoint, leaderboard, uncorrectedScoreProvider);
        } else {
            correctedScore = correctedNonMaxedScore;
        }
        return new ScoreCorrection.Result(){

            @Override
            public MaxPointsReason getMaxPointsReason() {
                return maxPointsReason.getMaxPointsReason();
            }

            @Override
            public Double getCorrectedScore() {
                return correctedScore;
            }

            @Override
            public Double getIncrementalScoreCorrectionInPoints() {
                return (Double)ScoreCorrectionImpl.this.incrementalScoreCorrection.get(raceColumn.getKey(competitor));
            }

            @Override
            public boolean isCorrected() {
                return ScoreCorrectionImpl.this.isScoreCorrected(competitor, raceColumn, this.getTimePoint());
            }

            @Override
            public boolean isCorrectedIncrementally() {
                return ScoreCorrectionImpl.this.isScoreCorrectedIncrementally(competitor, raceColumn, this.getTimePoint());
            }

            @Override
            public TimePoint getTimePoint() {
                return timePoint;
            }

            @Override
            public Double getUncorrectedScore() {
                Double resultUncorrected = 0.0;
                try {
                    resultUncorrected = scoringScheme.getScoreForRank(leaderboard, raceColumn, competitor, (Integer)trackedRankProvider.call(), new Callable<Integer>(){

                        @Override
                        public Integer call() {
                            return ScoreCorrectionImpl.this.getNumberOfCompetitorsInRace(raceColumn, competitor, numberOfCompetitorsInLeaderboardFetcher);
                        }
                    }, numberOfCompetitorsInLeaderboardFetcher, timePoint);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return resultUncorrected;
            }
        };
    }

    protected Integer getNumberOfCompetitorsInRace(RaceColumn raceColumn, Competitor competitor, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher) {
        Integer result;
        TrackedRace trackedRace = raceColumn.getTrackedRace(competitor);
        if (trackedRace == null) {
            int estimatedSizeOfLargestFleet;
            int numberOfCompetitorsInLeaderboard = numberOfCompetitorsInLeaderboardFetcher.getNumberOfCompetitorsInLeaderboard();
            if (raceColumn instanceof RaceColumnInSeries) {
                int numberOfFleets = Util.size((Iterable)((RaceColumnInSeries)raceColumn).getSeries().getFleets());
                estimatedSizeOfLargestFleet = numberOfCompetitorsInLeaderboard / numberOfFleets + (int)Math.signum(numberOfCompetitorsInLeaderboard % numberOfFleets);
            } else {
                estimatedSizeOfLargestFleet = numberOfCompetitorsInLeaderboard;
            }
            result = estimatedSizeOfLargestFleet;
        } else {
            result = Util.size(trackedRace.getRace().getCompetitors());
        }
        return result;
    }

    private Double getCorrectedNonMaxedScore(Competitor competitor, RaceColumn raceColumn, Callable<Integer> trackedRankProvider, ScoringScheme scoringScheme, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Double correctedNonMaxedScore = (Double)this.correctedScores.get(raceColumn.getKey(competitor));
        Double result = correctedNonMaxedScore == null || this.isCertainlyBeforeRaceFinish(timePoint, raceColumn, competitor, cache) ? this.getUncorrectedScore(competitor, raceColumn, trackedRankProvider, scoringScheme, numberOfCompetitorsInLeaderboardFetcher, timePoint, cache) : correctedNonMaxedScore;
        return result;
    }

    private Double getUncorrectedScore(Competitor competitor, RaceColumn raceColumn, Callable<Integer> trackedRankProvider, ScoringScheme scoringScheme, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Double result;
        try {
            int trackedRank = trackedRankProvider.call();
            result = scoringScheme.getScoreForRank(this.leaderboard, raceColumn, competitor, trackedRank, () -> this.getNumberOfCompetitorsInRace(raceColumn, competitor, numberOfCompetitorsInLeaderboardFetcher), numberOfCompetitorsInLeaderboardFetcher, timePoint);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception while computing uncorrected score", e);
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public Double getExplicitScoreCorrection(Competitor competitor, RaceColumn raceColumn) {
        return (Double)this.correctedScores.get(raceColumn.getKey(competitor));
    }

    @Override
    public boolean hasCorrectionFor(RaceColumn raceInLeaderboard) {
        return this.internalHasScoreCorrectionFor(raceInLeaderboard);
    }

    private boolean internalHasScoreCorrectionFor(RaceColumn raceInLeaderboard) {
        for (Util.Pair correctedScoresKey : this.correctedScores.keySet()) {
            if (correctedScoresKey.getB() != raceInLeaderboard) continue;
            return true;
        }
        for (Util.Pair maxPointsReasonsKey : this.maxPointsReasons.keySet()) {
            if (maxPointsReasonsKey.getB() != raceInLeaderboard) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCorrectionForNonTrackedFleet(RaceColumn raceInLeaderboard, Fleet fleet) {
        boolean result;
        if (raceInLeaderboard.getTrackedRace(fleet) == null) {
            result = false;
            for (Competitor competitor : raceInLeaderboard.getAllCompetitors(fleet)) {
                Util.Pair<Competitor, RaceColumn> key = raceInLeaderboard.getKey(competitor);
                if (!this.correctedScores.containsKey(key) && !this.maxPointsReasons.containsKey(key)) continue;
                result = true;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public TimePoint getTimePointOfLastCorrectionsValidity() {
        return this.timePointOfLastCorrectionsValidity;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setTimePointOfLastCorrectionsValidity(TimePoint timePointOfLastCorrectionsValidity) {
        TimePoint oldTimePointOfLastCorrectionsValidity = this.timePointOfLastCorrectionsValidity;
        this.timePointOfLastCorrectionsValidity = timePointOfLastCorrectionsValidity;
        if (!Util.equalsWithNull((Object)oldTimePointOfLastCorrectionsValidity, (Object)timePointOfLastCorrectionsValidity)) {
            this.notifyListenersAboutLastCorrectionsValidityChanged(oldTimePointOfLastCorrectionsValidity, timePointOfLastCorrectionsValidity);
        }
    }

    @Override
    public void setComment(String scoreCorrectionComment) {
        String oldComment = this.comment;
        this.comment = scoreCorrectionComment;
        if (!Util.equalsWithNull((Object)oldComment, (Object)scoreCorrectionComment)) {
            this.notifyListenersAboutCommentChanged(oldComment, scoreCorrectionComment);
        }
    }

    protected Leaderboard getLeaderboard() {
        return this.leaderboard;
    }

    @Override
    public Iterable<RaceColumn> getRaceColumnsThatHaveCorrections() {
        HashSet<RaceColumn> result = new HashSet<RaceColumn>();
        for (Util.Pair correctedScoresKey : this.correctedScores.keySet()) {
            result.add((RaceColumn)correctedScoresKey.getB());
        }
        for (Util.Pair maxPointsReasonsKey : this.maxPointsReasons.keySet()) {
            result.add((RaceColumn)maxPointsReasonsKey.getB());
        }
        return result;
    }

    @Override
    public Iterable<Competitor> getCompetitorsThatHaveCorrectionsIn(RaceColumn raceColumn) {
        HashSet<Competitor> result = new HashSet<Competitor>();
        for (Util.Pair correctedScoresKey : this.correctedScores.keySet()) {
            if (raceColumn != correctedScoresKey.getB()) continue;
            result.add((Competitor)correctedScoresKey.getA());
        }
        for (Util.Pair maxPointsReasonsKey : this.maxPointsReasons.keySet()) {
            if (raceColumn != maxPointsReasonsKey.getB()) continue;
            result.add((Competitor)maxPointsReasonsKey.getA());
        }
        return result;
    }

    private static class AnnotatedMaxPointsReason {
        private final MaxPointsReason maxPointsReason;
        private final boolean maxPointsReasonExistsButIsNotApplicableForTimePoint;
        private final boolean calculateScoreDuringRace;

        public AnnotatedMaxPointsReason(MaxPointsReason maxPointsReason, boolean maxPointsReasonExistsButIsNotApplicableForTimePoint, boolean calculateScoreDuringRace) {
            this.maxPointsReason = maxPointsReason;
            this.maxPointsReasonExistsButIsNotApplicableForTimePoint = maxPointsReasonExistsButIsNotApplicableForTimePoint;
            this.calculateScoreDuringRace = calculateScoreDuringRace;
        }

        public MaxPointsReason getMaxPointsReason() {
            return this.maxPointsReason;
        }

        public boolean isMaxPointsReasonExistsButIsNotApplicableForTimePoint() {
            return this.maxPointsReasonExistsButIsNotApplicableForTimePoint;
        }

        public boolean isCalculateScoreDuringRace() {
            return this.calculateScoreDuringRace;
        }
    }
}

