/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.impl.LowPoint;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.Iterator;
import java.util.concurrent.Callable;

public class LowPointWithEliminationsAndRoundsWinnerGets07
extends LowPoint {
    private static final long serialVersionUID = -2318652113347853873L;
    private static int LOSERS_FINAL_FLEET_ORDERING = 2;

    @Override
    public ScoringSchemeType getType() {
        return ScoringSchemeType.LOW_POINT_WITH_ELIMINATIONS_AND_ROUNDS_WINNER_GETS_07;
    }

    @Override
    public Double getScoreForRank(Leaderboard leaderboard, RaceColumn raceColumn, Competitor competitor, int rank, Callable<Integer> numberOfCompetitorsInRaceFetcher, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, TimePoint timePoint) {
        Double result;
        assert (raceColumn instanceof RaceColumnInSeries);
        RaceColumnInSeries raceColumnInSeries = (RaceColumnInSeries)raceColumn;
        Series series = ((RaceColumnInSeries)raceColumn).getSeries();
        Regatta regatta = series.getRegatta();
        Iterator<? extends Series> seriesInRegattaIter = regatta.getSeries().iterator();
        Series seriesInRegatta = null;
        while (seriesInRegattaIter.hasNext() && (seriesInRegatta = seriesInRegattaIter.next()) != series) {
        }
        if (seriesInRegatta == null) {
            throw new IllegalArgumentException("Race column " + raceColumn + " not found in its owning regatta");
        }
        Fleet fleetOfCompetitor = raceColumn.getFleetOfCompetitor(competitor);
        if (fleetOfCompetitor == null || this.participatesInNextRound(leaderboard, raceColumnInSeries, competitor, timePoint, seriesInRegattaIter)) {
            result = null;
        } else {
            assert (fleetOfCompetitor != null);
            if (rank == 0) {
                if (series.hasSplitFleetContiguousScoring()) {
                    int competitorFleetOrdering = fleetOfCompetitor.getOrdering();
                    int n = this.getNumberOfCompetitorsInBetterFleets(raceColumnInSeries, competitorFleetOrdering);
                    TrackedRace finalTrackedRaceOfCompetitor = raceColumn.getTrackedRace(competitor);
                    int numberOfCompetitorsInCompetitorsFleet = Util.size(finalTrackedRaceOfCompetitor.getRace().getCompetitors());
                    result = ((double)n + 1.0 + (double)n + (double)numberOfCompetitorsInCompetitorsFleet) / 2.0;
                } else {
                    int numberOfCompetitorsInRound = 0;
                    for (Fleet fleet : raceColumn.getFleets()) {
                        TrackedRace trackedRaceInRound = raceColumn.getTrackedRace(fleet);
                        if (trackedRaceInRound == null) continue;
                        numberOfCompetitorsInRound += Util.size(trackedRaceInRound.getRace().getCompetitors());
                    }
                    result = ((double)numberOfCompetitorsInRound + 1.0) / 2.0;
                }
            } else {
                int effectiveRank = this.getEffectiveRank(raceColumn, competitor, rank);
                if (series.hasSplitFleetContiguousScoring()) {
                    result = effectiveRank == 1 ? 0.7 : (double)effectiveRank;
                } else {
                    int n = this.getNumberOfCompetitorsInBetterFleets(raceColumnInSeries, fleetOfCompetitor.getOrdering());
                    int numberOfFleetsWithEqualOrder = this.getNumberOfFleetsWithOrdering(series, fleetOfCompetitor.getOrdering());
                    int numberOfCompetitorsWithSameRankInRound = this.getNumberOfCompetitorsWithSameRankInRound(raceColumnInSeries, competitor, effectiveRank);
                    int bestOverallRankForAnyEqualRankingCompetitor = n + 1 + numberOfFleetsWithEqualOrder * (effectiveRank - 1);
                    int worstOverallRankForAnyEqualRankingCompetitor = bestOverallRankForAnyEqualRankingCompetitor + numberOfCompetitorsWithSameRankInRound - 1;
                    result = ((double)bestOverallRankForAnyEqualRankingCompetitor + (double)worstOverallRankForAnyEqualRankingCompetitor) / 2.0;
                }
            }
        }
        return result;
    }

    @Override
    public boolean isValidInNetScore(Leaderboard leaderboard, RaceColumn raceColumn, Competitor competitor, TimePoint at) {
        RaceColumnInSeries raceColumnInSeries = (RaceColumnInSeries)raceColumn;
        Iterator<? extends Series> seriesInRegattaIter = raceColumnInSeries.getSeries().getRegatta().getSeries().iterator();
        while (seriesInRegattaIter.hasNext() && seriesInRegattaIter.next() != raceColumnInSeries.getSeries()) {
        }
        return !this.participatesInNextRound(leaderboard, (RaceColumnInSeries)raceColumn, competitor, at, seriesInRegattaIter);
    }

    private int getNumberOfFleetsWithOrdering(Series series, int ordering) {
        int result = 0;
        for (Fleet fleet : series.getFleets()) {
            if (fleet.getOrdering() != ordering) continue;
            ++result;
        }
        return result;
    }

    private boolean participatesInNextRound(Leaderboard leaderboard, RaceColumnInSeries raceColumnInSeries, Competitor competitor, TimePoint timePoint, Iterator<? extends Series> seriesInRegattaIter) {
        boolean result;
        if (this.isLastRoundInElimination(raceColumnInSeries, seriesInRegattaIter)) {
            result = false;
        } else {
            TrackedRace trackedRace;
            Series nextSeries = seriesInRegattaIter.next();
            result = leaderboard.getScoreCorrection().isScoreCorrected(competitor, nextSeries.getRaceColumns().iterator().next(), timePoint) || nextSeries.getRaceColumns().iterator().next().getFleetOfCompetitor(competitor) != null && ((trackedRace = raceColumnInSeries.getTrackedRace(competitor)) == null || trackedRace.getEndOfRace() == null || trackedRace.getEndOfRace().before(timePoint));
        }
        return result;
    }

    private int getNumberOfCompetitorsWithSameRankInRound(RaceColumnInSeries raceColumn, Competitor competitor, int rank) {
        int numberOfCompetitorsWithSameRankInRound;
        if (raceColumn.getSeries().hasSplitFleetContiguousScoring()) {
            numberOfCompetitorsWithSameRankInRound = 1;
        } else {
            Fleet fleet = raceColumn.getFleetOfCompetitor(competitor);
            if (fleet == null) {
                numberOfCompetitorsWithSameRankInRound = Util.size((Iterable)raceColumn.getSeries().getFleets());
            } else {
                boolean isWorstRank;
                TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                boolean bl = isWorstRank = rank == Util.size(trackedRace.getRace().getCompetitors());
                if (!isWorstRank) {
                    numberOfCompetitorsWithSameRankInRound = this.getNumberOfFleetsWithSameOrderingAsCompetitor(raceColumn, competitor, fleet);
                } else {
                    int count = 0;
                    for (Fleet f : raceColumn.getSeries().getFleets()) {
                        if (f.getOrdering() != fleet.getOrdering()) continue;
                        TrackedRace trackedRaceForFleet = raceColumn.getTrackedRace(f);
                        if (trackedRaceForFleet == null) {
                            ++count;
                            continue;
                        }
                        if (Util.size(trackedRaceForFleet.getRace().getCompetitors()) < rank) continue;
                        ++count;
                    }
                    numberOfCompetitorsWithSameRankInRound = count;
                }
            }
        }
        return numberOfCompetitorsWithSameRankInRound;
    }

    private int getNumberOfFleetsWithSameOrderingAsCompetitor(RaceColumnInSeries raceColumn, Competitor competitor, Fleet fleetOfCompetitor) {
        int result = 0;
        int orderingOfCompetitorsFleet = fleetOfCompetitor.getOrdering();
        for (Fleet fleet : raceColumn.getFleets()) {
            if (fleet.getOrdering() != orderingOfCompetitorsFleet) continue;
            ++result;
        }
        return result;
    }

    private boolean isLastRoundInElimination(RaceColumnInSeries raceColumn, Iterator<? extends Series> seriesInRegattaIter) {
        boolean result = raceColumn.getFleets().iterator().next().getOrdering() <= LOSERS_FINAL_FLEET_ORDERING ? true : !seriesInRegattaIter.hasNext();
        return result;
    }
}

