/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.impl.AbstractScoringSchemeImpl;
import com.sap.sse.common.TimePoint;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public class HighPoint
extends AbstractScoringSchemeImpl {
    private static final long serialVersionUID = -2767385186133743330L;

    public HighPoint() {
        super(true);
    }

    @Override
    public Double getScoreForRank(Leaderboard leaderboard, RaceColumn raceColumn, Competitor competitor, int rank, Callable<Integer> numberOfCompetitorsInRaceFetcher, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, TimePoint timePoint) {
        Double result;
        if (rank == 0) {
            result = null;
        } else {
            try {
                Integer numberOfCompetitorsInRace = numberOfCompetitorsInRaceFetcher.call();
                if (numberOfCompetitorsInRace == null) {
                    result = null;
                } else {
                    int numberOfCompetitorsDeterminingMaxPoints;
                    int effectiveRank;
                    int competitorFleetOrdering;
                    if (raceColumn.hasSplitFleetContiguousScoring() && (competitorFleetOrdering = raceColumn.getFleetOfCompetitor(competitor).getOrdering()) != 0) {
                        int numberOfCompetitorsInBetterFleets = this.getNumberOfCompetitorsInBetterFleets(raceColumn, competitorFleetOrdering);
                        effectiveRank = rank + numberOfCompetitorsInBetterFleets;
                        numberOfCompetitorsDeterminingMaxPoints = numberOfCompetitorsInLeaderboardFetcher.getNumberOfCompetitorsInLeaderboard();
                    } else {
                        effectiveRank = rank;
                        numberOfCompetitorsDeterminingMaxPoints = numberOfCompetitorsInRace;
                    }
                    result = numberOfCompetitorsDeterminingMaxPoints - effectiveRank + 1;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public Double getPenaltyScore(RaceColumn raceColumn, Competitor competitor, MaxPointsReason maxPointsReason, Integer numberOfCompetitorsInRace, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, TimePoint timePoint, Leaderboard leaderboard, Supplier<Double> uncorrectedScoreProvider) {
        return 0.0;
    }

    @Override
    public ScoringSchemeType getType() {
        return ScoringSchemeType.HIGH_POINT;
    }

    @Override
    public boolean isValidInNetScore(Leaderboard leaderboard, RaceColumn raceColumn, Competitor competitor, TimePoint at) {
        return true;
    }
}

