/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.CPUMeteringType;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.NoWindError;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.ResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.ScoreCorrection;
import com.sap.sailing.domain.leaderboard.ScoreCorrectionListener;
import com.sap.sailing.domain.leaderboard.SettableScoreCorrection;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.impl.AbstractLeaderboardWithCache;
import com.sap.sailing.domain.leaderboard.impl.LeaderboardTotalRankComparator;
import com.sap.sailing.domain.leaderboard.impl.ScoreCorrectionImpl;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.util.impl.RaceColumnListeners;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.ObscuringIterable;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class AbstractSimpleLeaderboardImpl
extends AbstractLeaderboardWithCache
implements RaceColumnListener {
    private static final long serialVersionUID = 330156778603279333L;
    static final Double DOUBLE_0 = 0.0;
    private final SettableScoreCorrection scoreCorrection;
    private ThresholdBasedResultDiscardingRule crossLeaderboardResultDiscardingRule;
    private final Map<Competitor, String> displayNames;
    private final Map<Competitor, Double> carriedPoints = new HashMap<Competitor, Double>();
    private final ConcurrentHashMap<Competitor, Competitor> suppressedCompetitors;
    private final RaceColumnListeners raceColumnListeners = new RaceColumnListeners();

    public AbstractSimpleLeaderboardImpl(ThresholdBasedResultDiscardingRule resultDiscardingRule) {
        this.scoreCorrection = this.createScoreCorrection();
        this.displayNames = new HashMap<Competitor, String>();
        this.crossLeaderboardResultDiscardingRule = resultDiscardingRule;
        this.suppressedCompetitors = new ConcurrentHashMap();
    }

    protected RaceColumnListeners getRaceColumnListeners() {
        return this.raceColumnListeners;
    }

    @Override
    public void trackedRaceUnlinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        this.getRaceColumnListeners().notifyListenersAboutTrackedRaceUnlinked(raceColumn, fleet, trackedRace);
        super.trackedRaceUnlinked(raceColumn, fleet, trackedRace);
    }

    @Override
    public void trackedRaceLinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        this.getRaceColumnListeners().notifyListenersAboutTrackedRaceLinked(raceColumn, fleet, trackedRace);
    }

    @Override
    public void isMedalRaceChanged(RaceColumn raceColumn, boolean newIsMedalRace) {
        this.getRaceColumnListeners().notifyListenersAboutIsMedalRaceChanged(raceColumn, newIsMedalRace);
    }

    @Override
    public void isFleetsCanRunInParallelChanged(RaceColumn raceColumn, boolean newIsFleetsCanRunInParallel) {
        this.getRaceColumnListeners().notifyListenersAboutIsFleetsCanRunInParallelChanged(raceColumn, newIsFleetsCanRunInParallel);
    }

    @Override
    public void isStartsWithZeroScoreChanged(RaceColumn raceColumn, boolean newIsStartsWithZeroScore) {
        this.getRaceColumnListeners().notifyListenersAboutIsStartsWithZeroScoreChanged(raceColumn, newIsStartsWithZeroScore);
    }

    @Override
    public void isFirstColumnIsNonDiscardableCarryForwardChanged(RaceColumn raceColumn, boolean firstColumnIsNonDiscardableCarryForward) {
        this.getRaceColumnListeners().notifyListenersAboutIsFirstColumnIsNonDiscardableCarryForwardChanged(raceColumn, firstColumnIsNonDiscardableCarryForward);
    }

    @Override
    public void hasSplitFleetContiguousScoringChanged(RaceColumn raceColumn, boolean hasSplitFleetContiguousScoring) {
        this.getRaceColumnListeners().notifyListenersAboutHasSplitFleetContiguousScoringChanged(raceColumn, hasSplitFleetContiguousScoring);
    }

    @Override
    public void oneAlwaysStaysOneChanged(RaceColumn raceColumn, boolean oneAlwaysStaysOne) {
        this.getRaceColumnListeners().notifyListenersAboutOneAlwaysStaysOneChanged(raceColumn, oneAlwaysStaysOne);
    }

    @Override
    public void hasCrossFleetMergedRankingChanged(RaceColumn raceColumn, boolean hasCrossFleetMergedRanking) {
        this.getRaceColumnListeners().notifyListenersAboutHasCrossFleetMergedRankingChanged(raceColumn, hasCrossFleetMergedRanking);
    }

    @Override
    public void raceColumnMoved(RaceColumn raceColumn, int newIndex) {
        this.getRaceColumnListeners().notifyListenersAboutRaceColumnMoved(raceColumn, newIndex);
    }

    @Override
    public void raceColumnNameChanged(RaceColumn raceColumn, String oldName, String newName) {
        this.getRaceColumnListeners().notifyListenersAboutRaceColumnNameChanged(raceColumn, oldName, newName);
    }

    @Override
    public void factorChanged(RaceColumn raceColumn, Double oldFactor, Double newFactor) {
        this.getRaceColumnListeners().notifyListenersAboutFactorChanged(raceColumn, oldFactor, newFactor);
    }

    @Override
    public void raceColumnAddedToContainer(RaceColumn raceColumn) {
        this.getRaceColumnListeners().notifyListenersAboutRaceColumnAddedToContainer(raceColumn);
    }

    @Override
    public void raceColumnRemovedFromContainer(RaceColumn raceColumn) {
        this.getRaceColumnListeners().notifyListenersAboutRaceColumnRemovedFromContainer(raceColumn);
    }

    @Override
    public void competitorDisplayNameChanged(Competitor competitor, String oldDisplayName, String displayName) {
        this.getRaceColumnListeners().notifyListenersAboutCompetitorDisplayNameChanged(competitor, oldDisplayName, displayName);
    }

    @Override
    public void resultDiscardingRuleChanged(ResultDiscardingRule oldDiscardingRule, ResultDiscardingRule newDiscardingRule) {
        this.getRaceColumnListeners().notifyListenersAboutResultDiscardingRuleChanged(oldDiscardingRule, newDiscardingRule);
    }

    @Override
    public void maximumNumberOfDiscardsChanged(Integer oldMaximumNumberOfDiscards, Integer newMaximumNumberOfDiscards) {
        this.getRaceColumnListeners().notifyListenersAboutMaximumNumberOfDiscardsChanged(oldMaximumNumberOfDiscards, newMaximumNumberOfDiscards);
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    protected SettableScoreCorrection createScoreCorrection() {
        return new ScoreCorrectionImpl(this);
    }

    @Override
    public SettableScoreCorrection getScoreCorrection() {
        return this.scoreCorrection;
    }

    @Override
    public void addScoreCorrectionListener(ScoreCorrectionListener listener) {
        this.getScoreCorrection().addScoreCorrectionListener(listener);
    }

    @Override
    public void removeScoreCorrectionListener(ScoreCorrectionListener listener) {
        this.getScoreCorrection().removeScoreCorrectionListener(listener);
    }

    @Override
    public String getDisplayName(Competitor competitor) {
        return this.displayNames.get(competitor);
    }

    @Override
    public ResultDiscardingRule getResultDiscardingRule() {
        return this.crossLeaderboardResultDiscardingRule;
    }

    @Override
    public void setCarriedPoints(Competitor competitor, double carriedPoints) {
        Double oldCarriedPoints = this.carriedPoints.put(competitor, carriedPoints);
        if (!Util.equalsWithNull((Object)oldCarriedPoints, (Object)carriedPoints)) {
            this.getScoreCorrection().notifyListenersAboutCarriedPointsChange(competitor, oldCarriedPoints, carriedPoints);
        }
    }

    @Override
    public double getCarriedPoints(Competitor competitor) {
        Double result = this.carriedPoints.get(competitor);
        return result == null ? 0.0 : result;
    }

    @Override
    public Map<Competitor, Double> getCompetitorsForWhichThereAreCarriedPoints() {
        return Collections.unmodifiableMap(this.carriedPoints);
    }

    @Override
    public void unsetCarriedPoints(Competitor competitor) {
        Double oldCarriedPoints = this.carriedPoints.remove(competitor);
        if (oldCarriedPoints != null) {
            this.getScoreCorrection().notifyListenersAboutCarriedPointsChange(competitor, oldCarriedPoints, null);
        }
    }

    @Override
    public boolean hasCarriedPoints() {
        return !this.carriedPoints.isEmpty();
    }

    @Override
    public boolean hasCarriedPoints(Competitor competitor) {
        return this.carriedPoints.containsKey(competitor);
    }

    @Override
    public void setDisplayName(Competitor competitor, String displayName) {
        String oldDisplayName = this.displayNames.get(competitor);
        this.displayNames.put(competitor, displayName);
        if (!Util.equalsWithNull((Object)oldDisplayName, (Object)displayName)) {
            this.getRaceColumnListeners().notifyListenersAboutCompetitorDisplayNameChanged(competitor, oldDisplayName, displayName);
        }
    }

    @Override
    public void setCrossLeaderboardResultDiscardingRule(ThresholdBasedResultDiscardingRule discardingRule) {
        ResultDiscardingRule oldDiscardingRule = this.getResultDiscardingRule();
        this.crossLeaderboardResultDiscardingRule = discardingRule;
        this.getRaceColumnListeners().notifyListenersAboutResultDiscardingRuleChanged(oldDiscardingRule, discardingRule);
    }

    @Override
    public Double getTotalPoints(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getScoreCorrection().getCorrectedScore(() -> this.getTrackedRank(competitor, raceColumn, timePoint, cache), competitor, raceColumn, this, timePoint, new NumberOfCompetitorsFetcherImpl(), this.getScoringScheme(), cache).getCorrectedScore();
    }

    @Override
    public MaxPointsReason getMaxPointsReason(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint) {
        return this.getScoreCorrection().getMaxPointsReason(competitor, raceColumn, timePoint);
    }

    @Override
    public boolean isDiscarded(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint) {
        return this.isDiscarded(competitor, raceColumn, this.getRaceColumns(), timePoint);
    }

    private boolean isDiscarded(Competitor competitor, RaceColumn raceColumn, Iterable<RaceColumn> raceColumnsToConsider, TimePoint timePoint) {
        Set<RaceColumn> discardedRaceColumns = this.getResultDiscardingRule().getDiscardedRaceColumns(competitor, this, raceColumnsToConsider, timePoint, this.getScoringScheme());
        return this.isDiscarded(competitor, raceColumn, timePoint, discardedRaceColumns);
    }

    private boolean isDiscarded(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint, Set<RaceColumn> discardedRaceColumns) {
        return !raceColumn.isMedalRace() && this.getMaxPointsReason(competitor, raceColumn, timePoint).isDiscardable() && discardedRaceColumns.contains(raceColumn);
    }

    @Override
    public Double getNetPoints(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint) {
        return this.getNetPoints(competitor, raceColumn, this.getRaceColumns(), timePoint);
    }

    @Override
    public Double getNetPoints(Competitor competitor, RaceColumn raceColumn, Iterable<RaceColumn> raceColumnsToConsider, TimePoint timePoint) {
        Set<RaceColumn> discardedRaceColumns = this.getResultDiscardingRule().getDiscardedRaceColumns(competitor, this, raceColumnsToConsider, timePoint, this.getScoringScheme());
        return this.getNetPoints(competitor, raceColumn, timePoint, discardedRaceColumns);
    }

    @Override
    public Double getNetPoints(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint, Set<RaceColumn> discardedRaceColumns) {
        return this.getNetPoints(competitor, raceColumn, timePoint, discardedRaceColumns, () -> this.getTotalPoints(competitor, raceColumn, timePoint));
    }

    @Override
    public Double getNetPoints(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint, Set<RaceColumn> discardedRaceColumns, Supplier<Double> totalPointsProvider) {
        Double totalPoints;
        Object result = this.isDiscarded(competitor, raceColumn, timePoint, discardedRaceColumns) ? Double.valueOf(0.0) : ((totalPoints = totalPointsProvider.get()) == null ? null : Double.valueOf(this.getScoringScheme().getScoreScaledByFactor(raceColumn, totalPoints)));
        return result;
    }

    @Override
    public Double getNetPoints(Competitor competitor, TimePoint timePoint) {
        return this.getNetPoints(competitor, this.getRaceColumns(), timePoint);
    }

    @Override
    public Double getNetPoints(Competitor competitor, Iterable<RaceColumn> raceColumnsToConsider, TimePoint timePoint) {
        return this.getScoringScheme().getNetPoints(this, competitor, raceColumnsToConsider, timePoint);
    }

    @Override
    public Iterable<Competitor> getCompetitorsFromBestToWorst(RaceColumn raceColumn, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getCompetitorsFromBestToWorst(raceColumn, timePoint, competitor -> this.getTotalPoints((Competitor)competitor, raceColumn, timePoint, cache), cache);
    }

    @Override
    public Iterable<Competitor> getCompetitorsFromBestToWorst(final RaceColumn raceColumn, TimePoint timePoint, Function<Competitor, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        final HashMap<Competitor, Util.Pair> totalPointsAndFleet = new HashMap<Competitor, Util.Pair>();
        for (Competitor competitor : this.getCompetitors()) {
            Double totalPoints = this.getTotalPoints(competitor, raceColumn, timePoint, cache);
            if (totalPoints == null) continue;
            totalPointsAndFleet.put(competitor, new Util.Pair((Object)totalPoints, (Object)raceColumn.getFleetOfCompetitor(competitor)));
        }
        ArrayList<Competitor> result = new ArrayList<Competitor>(totalPointsAndFleet.keySet());
        Collections.sort(result, new Comparator<Competitor>(){

            @Override
            public int compare(Competitor o1, Competitor o2) {
                int comparisonResult;
                if (o1 == o2) {
                    comparisonResult = 0;
                } else {
                    if (raceColumn.hasSplitFleets() && !raceColumn.hasSplitFleetContiguousScoring()) {
                        Fleet o1Fleet = (Fleet)((Util.Pair)totalPointsAndFleet.get(o1)).getB();
                        Fleet o2Fleet = (Fleet)((Util.Pair)totalPointsAndFleet.get(o2)).getB();
                        comparisonResult = o1Fleet == null ? (o2Fleet == null ? 0 : 1) : (o2Fleet == null ? -1 : o1Fleet.compareTo((Object)o2Fleet));
                    } else {
                        comparisonResult = 0;
                    }
                    if (comparisonResult == 0) {
                        comparisonResult = AbstractSimpleLeaderboardImpl.this.getScoringScheme().getScoreComparator(false).compare((Double)((Util.Pair)totalPointsAndFleet.get(o1)).getA(), (Double)((Util.Pair)totalPointsAndFleet.get(o2)).getA());
                    }
                }
                return comparisonResult;
            }
        });
        return result;
    }

    public List<Competitor> getCompetitorsFromBestToWorst(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getCompetitorsFromBestToWorst(this.getRaceColumns(), timePoint, cache);
    }

    private List<Competitor> getCompetitorsFromBestToWorst(Iterable<RaceColumn> raceColumnsToConsider, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        ArrayList<Competitor> result = new ArrayList<Competitor>();
        for (Competitor competitor : this.getCompetitors()) {
            result.add(competitor);
        }
        Collections.sort(result, this.getTotalRankComparator(raceColumnsToConsider, timePoint, cache));
        return result;
    }

    protected Comparator<? super Competitor> getTotalRankComparator(Iterable<RaceColumn> raceColumnsToConsider, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return new LeaderboardTotalRankComparator(this, timePoint, this.getScoringScheme(), false, raceColumnsToConsider, cache);
    }

    @Override
    public RaceColumn getRaceColumnByName(String columnName) {
        RaceColumn result = null;
        for (RaceColumn r : this.getRaceColumns()) {
            if (!r.getName().equals(columnName)) continue;
            result = r;
            break;
        }
        return result;
    }

    @Override
    public Competitor getCompetitorByName(String competitorName) {
        for (Competitor competitor : this.getAllCompetitors()) {
            if (!competitor.getName().equals(competitorName)) continue;
            return competitor;
        }
        return null;
    }

    @Override
    public boolean countRaceForComparisonWithDiscardingThresholds(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint) {
        TrackedRace trackedRaceForCompetitorInColumn;
        return this.getScoringScheme().isValidInNetScore(this, raceColumn, competitor, timePoint) && (this.getScoreCorrection().isScoreCorrected(competitor, raceColumn, timePoint) || (trackedRaceForCompetitorInColumn = raceColumn.getTrackedRace(competitor)) != null && trackedRaceForCompetitorInColumn.hasStarted(timePoint) && trackedRaceForCompetitorInColumn.getRank(competitor, timePoint) != 0);
    }

    @Override
    public void addRaceColumnListener(RaceColumnListener listener) {
        this.getRaceColumnListeners().addRaceColumnListener(listener);
    }

    @Override
    public void removeRaceColumnListener(RaceColumnListener listener) {
        this.getRaceColumnListeners().removeRaceColumnListener(listener);
    }

    @Override
    public Leaderboard.Entry getEntry(Competitor competitor, RaceColumn race, TimePoint timePoint) throws NoWindException {
        Set<RaceColumn> discardedRaceColumns = this.getResultDiscardingRule().getDiscardedRaceColumns(competitor, this, this.getRaceColumns(), timePoint, this.getScoringScheme());
        return this.getEntry(competitor, race, timePoint, discardedRaceColumns);
    }

    @Override
    public Leaderboard.Entry getEntry(Competitor competitor, RaceColumn race, TimePoint timePoint, Set<RaceColumn> discardedRaceColumns, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Callable<Integer> trackedRankProvider = () -> this.getTrackedRank(competitor, race, timePoint, cache);
        ScoreCorrection.Result correctedResults = this.getScoreCorrection().getCorrectedScore(trackedRankProvider, competitor, race, this, timePoint, new NumberOfCompetitorsFetcherImpl(), this.getScoringScheme(), cache);
        boolean discarded = this.isDiscarded(competitor, race, timePoint, discardedRaceColumns);
        Double correctedScore = correctedResults.getCorrectedScore();
        Double correctedScoreScaledByColumnFactor = correctedScore == null ? null : Double.valueOf(this.getScoringScheme().getScoreScaledByFactor(race, correctedScore));
        return new EntryImpl(trackedRankProvider, correctedScoreScaledByColumnFactor, () -> correctedResults.getUncorrectedScore(), correctedResults.isCorrected(), discarded ? DOUBLE_0 : correctedScoreScaledByColumnFactor, correctedResults.getMaxPointsReason(), correctedResults.getIncrementalScoreCorrectionInPoints(), discarded, race.getFleetOfCompetitor(competitor));
    }

    @Override
    public Map<RaceColumn, List<Competitor>> getRankedCompetitorsFromBestToWorstAfterEachRaceColumn(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) throws NoWindException {
        LinkedHashMap<RaceColumn, List<Competitor>> result = new LinkedHashMap<RaceColumn, List<Competitor>>();
        ArrayList<RaceColumn> raceColumnsToConsider = new ArrayList<RaceColumn>();
        for (RaceColumn raceColumn : this.getRaceColumns()) {
            raceColumnsToConsider.add(raceColumn);
            result.put(raceColumn, this.getCompetitorsFromBestToWorst(raceColumnsToConsider, timePoint, cache));
        }
        return result;
    }

    @Override
    public Map<RaceColumn, Map<Competitor, Double>> getNetPointsSumAfterRaceColumn(TimePoint timePoint) throws NoWindException {
        LinkedHashMap<RaceColumn, Map<Competitor, Double>> result = new LinkedHashMap<RaceColumn, Map<Competitor, Double>>();
        ArrayList<RaceColumn> raceColumnsToConsider = new ArrayList<RaceColumn>();
        HashMap futures = new HashMap();
        for (RaceColumn raceColumn : this.getRaceColumns()) {
            raceColumnsToConsider.add(raceColumn);
            ArrayList finalRaceColumnsToConsider = new ArrayList(raceColumnsToConsider);
            futures.put(raceColumn, executor.submit(this.cpuMeterCallable(() -> {
                HashMap<Competitor, Double> netPointsSumPerCompetitorInColumn = new HashMap<Competitor, Double>();
                for (Competitor competitor : this.getCompetitors()) {
                    netPointsSumPerCompetitorInColumn.put(competitor, this.getNetPoints(competitor, finalRaceColumnsToConsider, timePoint));
                }
                Map map2 = result;
                synchronized (map2) {
                    return netPointsSumPerCompetitorInColumn;
                }
            }, CPUMeteringType.NET_POINTS_SUM.name())));
        }
        for (RaceColumn raceColumn : this.getRaceColumns()) {
            try {
                result.put(raceColumn, (Map)((Future)futures.get(raceColumn)).get());
            }
            catch (InterruptedException | ExecutionException e) {
                if (e.getCause() instanceof NoWindError) {
                    throw ((NoWindError)e.getCause()).getCause();
                }
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public Map<Util.Pair<Competitor, RaceColumn>, Leaderboard.Entry> getContent(TimePoint timePoint) throws NoWindException {
        HashMap<Util.Pair<Competitor, RaceColumn>, Leaderboard.Entry> result = new HashMap<Util.Pair<Competitor, RaceColumn>, Leaderboard.Entry>();
        HashMap<Competitor, Set<RaceColumn>> discardedRaces = new HashMap<Competitor, Set<RaceColumn>>();
        for (RaceColumn raceColumn : this.getRaceColumns()) {
            for (Competitor competitor : this.getCompetitors()) {
                Callable<Integer> trackedRankProvider = () -> this.getTrackedRank(competitor, raceColumn, timePoint);
                ScoreCorrection.Result correctedResults = this.getScoreCorrection().getCorrectedScore(trackedRankProvider, competitor, raceColumn, this, timePoint, new NumberOfCompetitorsFetcherImpl(), this.getScoringScheme());
                Set<RaceColumn> discardedRacesForCompetitor = (Set<RaceColumn>)discardedRaces.get(competitor);
                if (discardedRacesForCompetitor == null) {
                    discardedRacesForCompetitor = this.getResultDiscardingRule().getDiscardedRaceColumns(competitor, this, this.getRaceColumns(), timePoint, this.getScoringScheme());
                    discardedRaces.put(competitor, discardedRacesForCompetitor);
                }
                boolean discarded = discardedRacesForCompetitor.contains(raceColumn);
                Double correctedScore = correctedResults.getCorrectedScore();
                Double correctedScoreScaledByColumnFactor = correctedScore == null ? null : Double.valueOf(this.getScoringScheme().getScoreScaledByFactor(raceColumn, correctedScore));
                EntryImpl entry = new EntryImpl(trackedRankProvider, correctedScoreScaledByColumnFactor, () -> correctedResults.getUncorrectedScore(), correctedResults.isCorrected(), discarded ? DOUBLE_0 : correctedScoreScaledByColumnFactor, correctedResults.getMaxPointsReason(), correctedResults.getIncrementalScoreCorrectionInPoints(), discarded, raceColumn.getFleetOfCompetitor(competitor));
                result.put((Util.Pair<Competitor, RaceColumn>)new Util.Pair((Object)competitor, (Object)raceColumn), entry);
            }
        }
        return result;
    }

    @Override
    public boolean canAddRaceColumnToContainer(RaceColumn newRaceColumn) {
        boolean result = true;
        for (RaceColumn raceColumn : this.getRaceColumns()) {
            if (!raceColumn.getName().equals(newRaceColumn.getName())) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public TimePoint getTimePointOfLatestModification() {
        TimePoint result = null;
        for (TrackedRace trackedRace : this.getTrackedRaces()) {
            if (result != null && (trackedRace.getTimePointOfNewestEvent() == null || !trackedRace.getTimePointOfNewestEvent().after(result))) continue;
            result = trackedRace.getTimePointOfNewestEvent();
        }
        TimePoint timePointOfLastScoreCorrection = this.getScoreCorrection().getTimePointOfLastCorrectionsValidity();
        if (timePointOfLastScoreCorrection != null && (result == null || timePointOfLastScoreCorrection.after(result))) {
            result = timePointOfLastScoreCorrection;
        }
        return result;
    }

    @Override
    public Util.Pair<GPSFixMoving, Speed> getMaximumSpeedOverGround(Competitor competitor, TimePoint timePoint) {
        Util.Pair<GPSFixMoving, Speed> result = null;
        for (TrackedRace trackedRace : this.getTrackedRaces()) {
            NavigableSet<MarkPassing> markPassings;
            if (!Util.contains(trackedRace.getRace().getCompetitors(), (Object)competitor) || (markPassings = trackedRace.getMarkPassings(competitor)).isEmpty()) continue;
            TimePoint from = ((MarkPassing)markPassings.first()).getTimePoint();
            TimePoint to = timePoint.after(((MarkPassing)markPassings.last()).getTimePoint()) && ((MarkPassing)markPassings.last()).getWaypoint() == trackedRace.getRace().getCourse().getLastWaypoint() ? ((MarkPassing)markPassings.last()).getTimePoint() : timePoint;
            Util.Pair<GPSFixMoving, Speed> maxSpeed = trackedRace.getTrack(competitor).getMaximumSpeedOverGround(from, to);
            if (result != null && result.getB() != null && (maxSpeed == null || maxSpeed.getB() == null || ((Speed)maxSpeed.getB()).compareTo((Object)((Speed)result.getB())) <= 0)) continue;
            result = maxSpeed;
        }
        return result;
    }

    @Override
    public Speed getAverageSpeedOverGround(Competitor competitor, TimePoint timePoint) {
        Speed result = null;
        Duration totalTimeSailed = this.getTotalTimeSailed(competitor, timePoint);
        Distance totalDistanceSailed = this.getTotalDistanceTraveled(competitor, timePoint);
        if (totalDistanceSailed != null && totalTimeSailed != null && !totalTimeSailed.equals(Duration.NULL)) {
            result = totalDistanceSailed.inTime(totalTimeSailed);
        }
        return result;
    }

    @Override
    public Iterable<Competitor> getCompetitors() {
        Iterable<Competitor> result;
        if (Util.isEmpty(this.getSuppressedCompetitors())) {
            result = this.getAllCompetitors();
        } else {
            Iterable<Competitor> allCompetitors = this.getAllCompetitors();
            HashSet<Competitor> suppressed = new HashSet<Competitor>();
            Util.addAll(this.getSuppressedCompetitors(), suppressed);
            result = this.getCompetitorIterableSkippingSuppressed(allCompetitors, suppressed);
        }
        return result;
    }

    @Override
    public Iterable<Competitor> getCompetitors(RaceColumn raceColumn, Fleet fleet) {
        return this.getCompetitorIterableSkippingSuppressed(this.getAllCompetitors(raceColumn, fleet), this.getSuppressedCompetitors());
    }

    protected Iterable<Competitor> getCompetitorIterableSkippingSuppressed(Iterable<Competitor> allCompetitors, Iterable<Competitor> suppressed) {
        return new ObscuringIterable(allCompetitors, suppressed);
    }

    @Override
    public Iterable<Competitor> getSuppressedCompetitors() {
        return new HashSet<Competitor>(this.suppressedCompetitors.keySet());
    }

    @Override
    public boolean isSuppressed(Competitor competitor) {
        return this.suppressedCompetitors.containsKey(competitor);
    }

    @Override
    public void setSuppressed(Competitor competitor, boolean suppressed) {
        if (competitor == null) {
            throw new IllegalArgumentException("Cannot change suppression for a null competitor");
        }
        if (suppressed) {
            this.suppressedCompetitors.put(competitor, competitor);
        } else {
            this.suppressedCompetitors.remove(competitor);
        }
        this.getScoreCorrection().notifyListenersAboutIsSuppressedChange(competitor, suppressed);
    }

    @Override
    public TimePoint getNowMinusDelay() {
        TimePoint now = MillisecondsTimePoint.now();
        Long delayToLiveInMillis = this.getDelayToLiveInMillis();
        TimePoint timePoint = delayToLiveInMillis == null ? now : now.minus(delayToLiveInMillis.longValue());
        return timePoint;
    }

    @Override
    public void raceLogEventAdded(RaceColumn raceColumn, RaceLogIdentifier raceLogIdentifier, RaceLogEvent event) {
        this.getRaceColumnListeners().notifyListenersAboutRaceLogEventAdded(raceColumn, raceLogIdentifier, event);
        super.raceLogEventAdded(raceColumn, raceLogIdentifier, event);
    }

    @Override
    public void regattaLogEventAdded(RegattaLogEvent event) {
        this.getRaceColumnListeners().notifyListenersAboutRegattaLogEventAdded(event);
        super.regattaLogEventAdded(event);
    }

    public String toString() {
        return String.valueOf(this.getName()) + " " + Util.join((String)", ", this.getCourseAreas()) + " " + (this.getScoringScheme() != null ? this.getScoringScheme().getType().name() : "<No scoring scheme set>");
    }

    @Override
    public NumberOfCompetitorsInLeaderboardFetcher getNumberOfCompetitorsInLeaderboardFetcher() {
        return new NumberOfCompetitorsFetcherImpl();
    }

    @Override
    public BoatClass getBoatClass() {
        HashSet<Boat> allBoats = new HashSet<Boat>();
        for (RaceColumn raceColumn : this.getRaceColumns()) {
            Map<Competitor, Boat> competitorsAndTheirBoats = raceColumn.getAllCompetitorsAndTheirBoats();
            allBoats.addAll(competitorsAndTheirBoats.values());
        }
        return (BoatClass)Util.getDominantObject((Iterable)StreamSupport.stream(allBoats.spliterator(), false).map(b -> b.getBoatClass()).collect(Collectors.toList()));
    }

    class EntryImpl
    implements Leaderboard.Entry {
        private final Callable<Integer> trackedRankProvider;
        private final Double totalPoints;
        private final Callable<Double> totalPointsUncorrectedProvider;
        private final Double incrementalScoreCorrectionInPoints;
        private final boolean isTotalPointsCorrected;
        private final Double netPoints;
        private final MaxPointsReason maxPointsReason;
        private final boolean discarded;
        private final Fleet fleet;

        private EntryImpl(Callable<Integer> trackedRankProvider, Double totalPoints, Callable<Double> totalPointsUncorrectedProvider, boolean isTotalPointsCorrected, Double netPoints, MaxPointsReason maxPointsReason, Double incrementalScoreCorrectionInPoints, boolean discarded, Fleet fleet) {
            this.trackedRankProvider = trackedRankProvider;
            this.totalPoints = totalPoints;
            this.totalPointsUncorrectedProvider = totalPointsUncorrectedProvider;
            this.isTotalPointsCorrected = isTotalPointsCorrected;
            this.incrementalScoreCorrectionInPoints = incrementalScoreCorrectionInPoints;
            this.netPoints = netPoints;
            this.maxPointsReason = maxPointsReason;
            this.discarded = discarded;
            this.fleet = fleet;
        }

        @Override
        public int getTrackedRank() {
            try {
                return this.trackedRankProvider.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Double getTotalPoints() {
            return this.totalPoints;
        }

        @Override
        public Double getIncrementalScoreCorrectionInPoints() {
            return this.incrementalScoreCorrectionInPoints;
        }

        @Override
        public boolean isTotalPointsCorrected() {
            return this.isTotalPointsCorrected;
        }

        @Override
        public Double getNetPoints() {
            return this.netPoints;
        }

        @Override
        public MaxPointsReason getMaxPointsReason() {
            return this.maxPointsReason;
        }

        @Override
        public boolean isDiscarded() {
            return this.discarded;
        }

        @Override
        public Fleet getFleet() {
            return this.fleet;
        }

        @Override
        public Double getTotalPointsUncorrected() {
            try {
                return this.totalPointsUncorrectedProvider.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class NumberOfCompetitorsFetcherImpl
    implements NumberOfCompetitorsInLeaderboardFetcher {
        private int numberOfCompetitors = -1;
        private int numberOfCompetitorsWithoutMaxPointReason = -1;

        @Override
        public int getNumberOfCompetitorsInLeaderboard() {
            if (this.numberOfCompetitors == -1) {
                this.numberOfCompetitors = Util.size(AbstractSimpleLeaderboardImpl.this.getCompetitors());
            }
            return this.numberOfCompetitors;
        }

        @Override
        public int getNumberOfCompetitorsWithoutMaxPointReason(RaceColumn column, TimePoint timePoint) {
            if (this.numberOfCompetitorsWithoutMaxPointReason == -1) {
                this.numberOfCompetitorsWithoutMaxPointReason = 0;
                for (Competitor competitor : AbstractSimpleLeaderboardImpl.this.getCompetitors()) {
                    MaxPointsReason maxPointReason = AbstractSimpleLeaderboardImpl.this.getScoreCorrection().getMaxPointsReason(competitor, column, timePoint);
                    this.numberOfCompetitorsWithoutMaxPointReason += maxPointReason == MaxPointsReason.NONE ? 1 : 0;
                }
            }
            return this.numberOfCompetitorsWithoutMaxPointReason;
        }
    }
}

