/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.caching;

import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.sharding.ShardingType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.sharding.ShardingContext;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LiveLeaderboardUpdater
implements Runnable {
    private static final Logger logger = Logger.getLogger(LiveLeaderboardUpdater.class.getName());
    private static final long UPDATE_TIMEOUT_IN_MILLIS = 60000L;
    private static final long MINIMUM_TIME_BETWEEN_UPDATES = 1000L;
    private final Leaderboard leaderboard;
    private LeaderboardDTO currentLiveLeaderboard;
    private Exception currentException;
    private final Set<String> columnNamesForWhichCurrentLiveLeaderboardHasTheDetails;
    private boolean currentLiveLeaderboardHasOverallDetails;
    private boolean running;
    private final Map<String, TimePoint> timePointOfLastRequestForColumnDetails;
    private TimePoint timePointOfLastRequestForOverallDetails;
    private TimePoint lastRequest;
    private int cacheHitCount;
    private int cacheMissCount;
    private Thread thread;
    private TrackedRegattaRegistry trackedRegattaRegistry;
    private DomainFactory baseDomainFactory;

    public LiveLeaderboardUpdater(Leaderboard leaderboard, TrackedRegattaRegistry trackedRegattaRegistry, DomainFactory baseDomainFactory) {
        this.leaderboard = leaderboard;
        this.trackedRegattaRegistry = trackedRegattaRegistry;
        this.baseDomainFactory = baseDomainFactory;
        this.timePointOfLastRequestForColumnDetails = new HashMap<String, TimePoint>();
        this.columnNamesForWhichCurrentLiveLeaderboardHasTheDetails = new HashSet<String>();
    }

    private Leaderboard getLeaderboard() {
        return this.leaderboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeaderboardDTO getLiveLeaderboard(Collection<String> namesOfRaceColumnsForWhichToLoadLegDetails, boolean addOverallDetails) throws NoWindException, ExecutionException {
        LeaderboardDTO result = null;
        this.updateRequestTimes(namesOfRaceColumnsForWhichToLoadLegDetails, addOverallDetails);
        this.ensureRunning();
        LiveLeaderboardUpdater liveLeaderboardUpdater = this;
        synchronized (liveLeaderboardUpdater) {
            if (this.running && this.columnNamesForWhichCurrentLiveLeaderboardHasTheDetails.containsAll(namesOfRaceColumnsForWhichToLoadLegDetails) && (!addOverallDetails || this.currentLiveLeaderboardHasOverallDetails) && (result = this.currentLiveLeaderboard) != null) {
                ++this.cacheHitCount;
            }
        }
        if (result == null) {
            ++this.cacheMissCount;
            liveLeaderboardUpdater = this;
            synchronized (liveLeaderboardUpdater) {
                while (result == null) {
                    if (this.columnNamesForWhichCurrentLiveLeaderboardHasTheDetails.containsAll(namesOfRaceColumnsForWhichToLoadLegDetails) && (!addOverallDetails || this.currentLiveLeaderboardHasOverallDetails)) {
                        result = this.currentLiveLeaderboard;
                    }
                    if (result == null) {
                        logger.finest(() -> "waiting for leaderboard for " + namesOfRaceColumnsForWhichToLoadLegDetails + " and addOverallDetails=" + addOverallDetails);
                        this.ensureRunning();
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            logger.log(Level.INFO, "interrupted while waiting for LiveLeaderboardCache update", e);
                        }
                        if (this.currentException != null) {
                            throw new ExecutionException(this.currentException);
                        }
                        if (this.columnNamesForWhichCurrentLiveLeaderboardHasTheDetails.containsAll(namesOfRaceColumnsForWhichToLoadLegDetails) && (!addOverallDetails || this.currentLiveLeaderboardHasOverallDetails)) {
                            result = this.currentLiveLeaderboard;
                            logger.finest(() -> "successfully waited for leaderboard for " + namesOfRaceColumnsForWhichToLoadLegDetails + " and addOverallDetails=" + addOverallDetails);
                        } else {
                            logger.finest(() -> "waiting for leaderboard for " + namesOfRaceColumnsForWhichToLoadLegDetails + " and addOverallDetails=" + addOverallDetails + " unsuccessful. Need to try again...");
                        }
                    } else {
                        logger.finest(() -> "leaderboard for " + namesOfRaceColumnsForWhichToLoadLegDetails + " and addOverallDetails=" + addOverallDetails + " was provided in the meantime");
                    }
                    if (result != null) continue;
                    this.updateRequestTimes(namesOfRaceColumnsForWhichToLoadLegDetails, addOverallDetails);
                    this.ensureRunning();
                }
            }
        }
        logger.info(LiveLeaderboardUpdater.class.getSimpleName() + " for " + this.getLeaderboard().getName() + " cache hits/misses: " + this.cacheHitCount + "/" + this.cacheMissCount);
        return result;
    }

    private synchronized void ensureRunning() {
        if (!this.running) {
            this.start();
        }
    }

    private synchronized void start() {
        this.running = true;
        try {
            this.thread = new Thread((Runnable)this, "LiveLeaderboardUpdater for leaderboard " + this.getLeaderboard().getName());
            this.thread.setDaemon(true);
            this.thread.start();
        }
        catch (Exception e) {
            this.running = false;
            logger.log(Level.SEVERE, "Error creating LiveLeaderboardUpdater thread for leadedrboard " + this.getLeaderboard().getName(), e);
            throw e;
        }
    }

    private synchronized void updateRequestTimes(Collection<String> namesOfRaceColumnsForWhichToLoadLegDetails, boolean addOverallDetails) {
        this.lastRequest = this.getLeaderboard().getNowMinusDelay();
        for (String nameOfRaceColumn : namesOfRaceColumnsForWhichToLoadLegDetails) {
            if (this.timePointOfLastRequestForColumnDetails.containsKey(nameOfRaceColumn) && !this.lastRequest.after(this.timePointOfLastRequestForColumnDetails.get(nameOfRaceColumn))) continue;
            this.timePointOfLastRequestForColumnDetails.put(nameOfRaceColumn, this.lastRequest);
        }
        if (addOverallDetails && (this.timePointOfLastRequestForOverallDetails == null || this.lastRequest.after(this.timePointOfLastRequestForOverallDetails))) {
            this.timePointOfLastRequestForOverallDetails = this.lastRequest;
        }
    }

    private synchronized void updateCacheContents(Collection<String> namesOfRaceColumnsForWhichToLoadLegDetails, boolean addOverallDetails, LeaderboardDTO result) {
        this.currentException = null;
        this.columnNamesForWhichCurrentLiveLeaderboardHasTheDetails.clear();
        this.columnNamesForWhichCurrentLiveLeaderboardHasTheDetails.addAll(namesOfRaceColumnsForWhichToLoadLegDetails);
        this.currentLiveLeaderboard = result;
        this.currentLiveLeaderboardHasOverallDetails = addOverallDetails;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        assert (this.running);
        try {
            try {
                ShardingContext.setShardingConstraint(ShardingType.LEADERBOARDNAME, this.leaderboard.getName());
                logger.info("Starting " + LiveLeaderboardUpdater.class.getSimpleName() + " thread for leaderboard " + this.leaderboard.getName());
                while (true) {
                    TimePoint computeLeaderboardByNameFinishedAt;
                    long millisToSleep;
                    TimePoint now = MillisecondsTimePoint.now();
                    Long delayToLiveInMillis = this.getLeaderboard().getDelayToLiveInMillis();
                    TimePoint timePoint = delayToLiveInMillis == null ? now : now.minus(delayToLiveInMillis.longValue());
                    LiveLeaderboardUpdater liveLeaderboardUpdater = this;
                    synchronized (liveLeaderboardUpdater) {
                        if (timePoint.asMillis() - this.lastRequest.asMillis() >= 60000L) {
                            this.running = false;
                            this.currentLiveLeaderboard = null;
                            break;
                        }
                    }
                    TimePoint timeLastUpdateWasStarted = now;
                    try {
                        Set<String> namesOfRaceColumnsForWhichToLoadLegDetails = this.getColumnNamesForWhichToFetchDetails(timePoint);
                        boolean addOverallDetails = this.getOverallDetails(timePoint);
                        LeaderboardDTO newCacheValue = this.leaderboard.computeDTO(timePoint, namesOfRaceColumnsForWhichToLoadLegDetails, addOverallDetails, false, this.trackedRegattaRegistry, this.baseDomainFactory, false);
                        this.updateCacheContents(namesOfRaceColumnsForWhichToLoadLegDetails, addOverallDetails, newCacheValue);
                    }
                    catch (NoWindException e) {
                        logger.log(Level.SEVERE, "Exception during re-calculating the live leaderboard " + this.leaderboard.getName(), e);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e1) {
                            logger.throwing(LiveLeaderboardUpdater.class.getName(), "run", e1);
                        }
                    }
                    if ((millisToSleep = 1000L - ((computeLeaderboardByNameFinishedAt = MillisecondsTimePoint.now()).asMillis() - timeLastUpdateWasStarted.asMillis())) <= 0L) continue;
                    try {
                        Thread.sleep(millisToSleep);
                    }
                    catch (InterruptedException e) {
                        logger.throwing(LiveLeaderboardUpdater.class.getName(), "run", e);
                    }
                }
                logger.info(LiveLeaderboardUpdater.class.getSimpleName() + " thread for leaderboard " + this.leaderboard.getName() + " ending");
            }
            catch (Exception e) {
                LiveLeaderboardUpdater liveLeaderboardUpdater = this;
                synchronized (liveLeaderboardUpdater) {
                    this.running = false;
                    this.currentLiveLeaderboard = null;
                    this.currentException = e;
                    this.notifyAll();
                }
                logger.log(Level.SEVERE, "exception updating live leaderboard " + this.leaderboard.getName(), e);
                ShardingContext.clearShardingConstraint(ShardingType.LEADERBOARDNAME);
            }
        }
        finally {
            ShardingContext.clearShardingConstraint(ShardingType.LEADERBOARDNAME);
        }
    }

    private boolean getOverallDetails(TimePoint timePoint) {
        return this.timePointOfLastRequestForOverallDetails != null && !timePoint.after(this.timePointOfLastRequestForOverallDetails.plus(60000L));
    }

    private Set<String> getColumnNamesForWhichToFetchDetails(TimePoint timePoint) {
        HashSet<String> result = new HashSet<String>();
        TimePoint expiredIfBefore = timePoint.minus(60000L);
        for (Map.Entry<String, TimePoint> e : this.timePointOfLastRequestForColumnDetails.entrySet()) {
            if (!e.getValue().after(expiredIfBefore)) continue;
            result.add(e.getKey());
        }
        return result;
    }
}

