/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.impl.RaceColumnListenerWithDefaultAction;
import com.sap.sailing.domain.tracking.RaceExecutionOrderProvider;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.util.SmartFutureCache;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractRaceExecutionOrderProvider
implements RaceExecutionOrderProvider,
RaceColumnListenerWithDefaultAction {
    private static final long serialVersionUID = 4795731834688229568L;
    private transient SmartFutureCache<String, Map<TrackedRace, Set<TrackedRace>>, SmartFutureCache.EmptyUpdateInterval> previousRacesByRaceCache;
    private final String RACES_ORDER_LIST_CACHE_KEY = "racesOrderCacheKey";
    private final String RACES_ORDER_LIST_LOCKS_NAME = this.getClass().getName();

    public AbstractRaceExecutionOrderProvider() {
        this.previousRacesByRaceCache = this.createRacesOrderCache();
        this.triggerUpdate();
    }

    @Override
    public void defaultAction() {
        this.triggerUpdate();
    }

    @Override
    public void triggerUpdate() {
        this.previousRacesByRaceCache.triggerUpdate((Object)"racesOrderCacheKey", null);
    }

    private Map<TrackedRace, Set<TrackedRace>> getPreviousRacesByRace() {
        return (Map)this.previousRacesByRaceCache.get((Object)"racesOrderCacheKey", true);
    }

    protected abstract Map<Fleet, Iterable<? extends RaceColumn>> getRaceColumnsOfSeries();

    private Map<TrackedRace, Set<TrackedRace>> reloadAndGetPreviousRacesByRace() {
        HashMap<TrackedRace, Set<TrackedRace>> previousRacesByRace = new HashMap<TrackedRace, Set<TrackedRace>>();
        for (Map.Entry<Fleet, Iterable<? extends RaceColumn>> raceColumnsInSeries : this.getRaceColumnsOfSeries().entrySet()) {
            this.addPreviousRaces(previousRacesByRace, raceColumnsInSeries.getKey(), raceColumnsInSeries.getValue());
        }
        return previousRacesByRace;
    }

    private void addPreviousRaces(Map<TrackedRace, Set<TrackedRace>> previousRacesByRace, Fleet fleet, Iterable<? extends RaceColumn> raceColumns) {
        TrackedRace previousRace = null;
        for (RaceColumn raceColumn : raceColumns) {
            TrackedRace trackedRaceInColumnForFleet = raceColumn.getTrackedRace(fleet);
            if (trackedRaceInColumnForFleet == null) continue;
            Set<TrackedRace> previousRaces = previousRacesByRace.get(trackedRaceInColumnForFleet);
            if (previousRaces == null) {
                previousRaces = new HashSet<TrackedRace>();
                previousRacesByRace.put(trackedRaceInColumnForFleet, previousRaces);
            }
            if (previousRace != null) {
                previousRaces.add(previousRace);
            }
            previousRace = trackedRaceInColumnForFleet;
        }
    }

    private SmartFutureCache<String, Map<TrackedRace, Set<TrackedRace>>, SmartFutureCache.EmptyUpdateInterval> createRacesOrderCache() {
        return new SmartFutureCache((SmartFutureCache.CacheUpdater)new SmartFutureCache.AbstractCacheUpdater<String, Map<TrackedRace, Set<TrackedRace>>, SmartFutureCache.EmptyUpdateInterval>(){

            public Map<TrackedRace, Set<TrackedRace>> computeCacheUpdate(String key, SmartFutureCache.EmptyUpdateInterval updateInterval) throws Exception {
                if (key.equals("racesOrderCacheKey")) {
                    return AbstractRaceExecutionOrderProvider.this.reloadAndGetPreviousRacesByRace();
                }
                Map<TrackedRace, Set<TrackedRace>> emptyMap = Collections.emptyMap();
                return emptyMap;
            }
        }, this.RACES_ORDER_LIST_LOCKS_NAME);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.previousRacesByRaceCache = this.createRacesOrderCache();
    }

    @Override
    public Set<TrackedRace> getPreviousRacesInExecutionOrder(TrackedRace race) {
        Map<TrackedRace, Set<TrackedRace>> previousRacesByRace = this.getPreviousRacesByRace();
        Set<TrackedRace> result = previousRacesByRace != null ? previousRacesByRace.get(race) : Collections.emptySet();
        return result;
    }
}

