/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.swisstimingadapter.impl.SwissTimingRaceTrackerImpl;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sse.common.Util;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.logging.Logger;

public class TMDMessageQueue {
    private static final Logger logger = Logger.getLogger(TMDMessageQueue.class.getName());
    private final SwissTimingRaceTrackerImpl raceTracker;
    private final Set<TMDMessageContents> queuedMessages;

    public TMDMessageQueue(SwissTimingRaceTrackerImpl raceTracker) {
        this.raceTracker = raceTracker;
        this.queuedMessages = new HashSet<TMDMessageContents>();
    }

    public synchronized void enqueue(String raceID, String competitorIdAsString, List<Util.Triple<Integer, Integer, Long>> markIndicesRanksAndTimesSinceStartInMilliseconds) {
        TMDMessageContents message = new TMDMessageContents(raceID, competitorIdAsString, markIndicesRanksAndTimesSinceStartInMilliseconds);
        this.queuedMessages.add(message);
        logger.info("Queued TMD message " + message + " for replay when start time has been received");
    }

    public synchronized void validStartTimeReceived() {
        TMDMessageContents messageContents;
        DynamicTrackedRace trackedRace = this.raceTracker.getTrackedRace();
        Iterator<TMDMessageContents> i = this.queuedMessages.iterator();
        HashMap cleansedMarkPassings = new HashMap();
        while (i.hasNext()) {
            messageContents = i.next();
            Competitor competitor = this.raceTracker.getDomainFactory().getBaseDomainFactory().getExistingCompetitorById((Serializable)UUID.fromString(messageContents.getCompetitorIdAsString()));
            if (competitor == null) {
                logger.info("Received timing data for boat ID " + messageContents.getCompetitorIdAsString() + " in race " + messageContents.getRaceID() + " but couldn't find a competitor with that boat ID in this race. Ignoring.");
                continue;
            }
            NavigableSet oldMarkPassings = trackedRace.getMarkPassings(competitor);
            TreeMap<Integer, MarkPassing> cleansedMarkPassingsForCompetitor = (TreeMap<Integer, MarkPassing>)cleansedMarkPassings.get(competitor);
            if (cleansedMarkPassingsForCompetitor == null) {
                cleansedMarkPassingsForCompetitor = new TreeMap<Integer, MarkPassing>();
                cleansedMarkPassings.put(competitor, cleansedMarkPassingsForCompetitor);
                Course course = trackedRace.getRace().getCourse();
                course.lockForRead();
                try {
                    trackedRace.lockForRead((Iterable)oldMarkPassings);
                    try {
                        for (MarkPassing oldMarkPassing : oldMarkPassings) {
                            int waypointIndex = course.getIndexOfWaypoint(oldMarkPassing.getWaypoint());
                            cleansedMarkPassingsForCompetitor.put(waypointIndex, oldMarkPassing);
                        }
                    }
                    finally {
                        trackedRace.unlockAfterRead((Iterable)oldMarkPassings);
                    }
                }
                finally {
                    course.unlockAfterRead();
                }
            }
            for (Util.Triple<Integer, Integer, Long> markIndexRankAndTimeSinceStartInMilliseconds : messageContents.getMarkIndicesRanksAndTimesSinceStartInMilliseconds()) {
                if (!cleansedMarkPassingsForCompetitor.containsKey(markIndexRankAndTimeSinceStartInMilliseconds.getA())) continue;
                logger.info("Removing mark passing for mark #" + markIndexRankAndTimeSinceStartInMilliseconds.getA() + " for competitor " + competitor.getName() + " because its time point " + ((MarkPassing)cleansedMarkPassingsForCompetitor.get(markIndexRankAndTimeSinceStartInMilliseconds.getA())).getTimePoint() + " was guessed; will replace momentarily...");
                cleansedMarkPassingsForCompetitor.remove(markIndexRankAndTimeSinceStartInMilliseconds.getA());
            }
        }
        for (Map.Entry e : cleansedMarkPassings.entrySet()) {
            trackedRace.updateMarkPassings((Competitor)e.getKey(), ((TreeMap)e.getValue()).values());
        }
        i = this.queuedMessages.iterator();
        while (i.hasNext()) {
            messageContents = i.next();
            logger.info("Re-Playing TMD message " + messageContents + " with new race start time " + trackedRace.getStartOfRace());
            this.raceTracker.receivedTimingData(messageContents.getRaceID(), messageContents.getCompetitorIdAsString(), messageContents.getMarkIndicesRanksAndTimesSinceStartInMilliseconds());
            i.remove();
        }
    }

    private static class TMDMessageContents {
        private final String raceID;
        private final String competitorIdAsString;
        private final List<Util.Triple<Integer, Integer, Long>> markIndicesRanksAndTimesSinceStartInMilliseconds;

        public TMDMessageContents(String raceID, String competitorIdAsString, List<Util.Triple<Integer, Integer, Long>> markIndicesRanksAndTimesSinceStartInMilliseconds) {
            this.raceID = raceID;
            this.competitorIdAsString = competitorIdAsString;
            this.markIndicesRanksAndTimesSinceStartInMilliseconds = markIndicesRanksAndTimesSinceStartInMilliseconds;
        }

        public String getRaceID() {
            return this.raceID;
        }

        public String getCompetitorIdAsString() {
            return this.competitorIdAsString;
        }

        public List<Util.Triple<Integer, Integer, Long>> getMarkIndicesRanksAndTimesSinceStartInMilliseconds() {
            return this.markIndicesRanksAndTimesSinceStartInMilliseconds;
        }

        public String toString() {
            StringBuilder result = new StringBuilder("TMD|" + this.getRaceID() + "|" + this.getCompetitorIdAsString() + "|");
            result.append(this.getMarkIndicesRanksAndTimesSinceStartInMilliseconds().size());
            result.append('|');
            for (Util.Triple<Integer, Integer, Long> markIndexRankAndTimeSinceStartInMilliseconds : this.getMarkIndicesRanksAndTimesSinceStartInMilliseconds()) {
                result.append(markIndexRankAndTimeSinceStartInMilliseconds.getA());
                result.append(';');
                if (markIndexRankAndTimeSinceStartInMilliseconds.getB() != null) {
                    result.append(markIndexRankAndTimeSinceStartInMilliseconds.getB());
                }
                result.append(";<");
                result.append(markIndexRankAndTimeSinceStartInMilliseconds.getC());
                result.append("ms>");
            }
            return result.toString();
        }
    }
}

