/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.impl;

import com.sap.sailing.domain.swisstimingadapter.SailMasterMessage;
import com.sap.sailing.domain.swisstimingadapter.SailMasterTransceiver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Logger;

public class SailMasterTransceiverImpl
implements SailMasterTransceiver {
    private static final Logger logger = Logger.getLogger(SailMasterTransceiverImpl.class.getName());
    private static final byte STX = 2;
    private static final byte ETX = 3;

    @Override
    public synchronized void sendMessage(String message, OutputStream os) throws IOException {
        if (os != null) {
            os.write(2);
            os.write(message.getBytes(Charset.forName("cp1252")));
            os.write(3);
        }
    }

    @Override
    public synchronized void sendMessage(SailMasterMessage message, OutputStream os) throws IOException {
        if (os != null) {
            if (message.getSequenceNumber() == null) {
                this.sendMessage(message.getMessage(), os);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(message.getSequenceNumber());
                sb.append('|');
                sb.append(message.getMessage());
                this.sendMessage(sb.toString(), os);
            }
            os.flush();
        }
    }

    @Override
    public String receiveMessage(InputStream inputStream) throws IOException {
        int read;
        while ((read = inputStream.read()) != -1 && read != 2) {
        }
        String message = null;
        if (read == 2) {
            message = this.readMessage(inputStream);
        } else {
            logger.info("Received EOF in SailMasterTransceiver. Returning null as message.");
        }
        return message;
    }

    private String readMessage(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        int read = is.read();
        while (read != -1 && read != 3) {
            bos.write(read);
            read = is.read();
        }
        String message = new String(bos.toByteArray(), Charset.forName("cp1252"));
        return message;
    }
}

