/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.swisstimingadapter.impl.AbstractSailMasterConnector;
import com.sap.sailing.domain.swisstimingadapter.impl.SwissTimingRaceTrackerImpl;
import com.sap.sailing.manage2sail.Activator;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.util.logging.Logger;

public class SailMasterConnectorForUrlDownload
extends AbstractSailMasterConnector {
    private static final Logger logger = Logger.getLogger(SailMasterConnectorForUrlDownload.class.getName());
    private final URL raceDataUrl;
    private URLConnection urlConnection;

    public SailMasterConnectorForUrlDownload(String raceId, URL raceDataUrl, String raceName, String raceDescription, BoatClass boatClass, SwissTimingRaceTrackerImpl swissTimingRaceTracker) throws InterruptedException, ParseException {
        super(raceId, raceName, raceDescription, boatClass, swissTimingRaceTracker);
        this.raceDataUrl = raceDataUrl;
        this.startReceiverThread();
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        return null;
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return this.urlConnection.getInputStream();
    }

    @Override
    protected void connect() throws IOException, URISyntaxException {
        logger.info("Connecting to " + this.raceDataUrl);
        this.urlConnection = HttpUrlConnectionHelper.redirectConnection((URL)Activator.getInstance().addAccessTokenToManage2SailUrl(this.raceDataUrl));
    }

    @Override
    protected boolean isConnected() throws IOException {
        return this.urlConnection != null && this.getInputStream() != null;
    }

    @Override
    protected void disconnect() throws IOException {
        if (this.urlConnection != null) {
            if (this.urlConnection.getInputStream() != null) {
                this.urlConnection.getInputStream().close();
            }
            this.urlConnection = null;
            this.stop();
        }
    }

    @Override
    protected TrackedRaceStatusEnum getStatusAfterLoadingIsComplete() {
        return TrackedRaceStatusEnum.FINISHED;
    }
}

