/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.swisstimingadapter.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KilometersPerHourSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.swisstimingadapter.Competitor;
import com.sap.sailing.domain.swisstimingadapter.Course;
import com.sap.sailing.domain.swisstimingadapter.Fix;
import com.sap.sailing.domain.swisstimingadapter.Mark;
import com.sap.sailing.domain.swisstimingadapter.MessageType;
import com.sap.sailing.domain.swisstimingadapter.Race;
import com.sap.sailing.domain.swisstimingadapter.RaceStatus;
import com.sap.sailing.domain.swisstimingadapter.RacingStatus;
import com.sap.sailing.domain.swisstimingadapter.SailMasterConnector;
import com.sap.sailing.domain.swisstimingadapter.SailMasterListener;
import com.sap.sailing.domain.swisstimingadapter.SailMasterMessage;
import com.sap.sailing.domain.swisstimingadapter.StartList;
import com.sap.sailing.domain.swisstimingadapter.TrackerType;
import com.sap.sailing.domain.swisstimingadapter.impl.CompetitorWithoutID;
import com.sap.sailing.domain.swisstimingadapter.impl.CourseImpl;
import com.sap.sailing.domain.swisstimingadapter.impl.FixImpl;
import com.sap.sailing.domain.swisstimingadapter.impl.MarkImpl;
import com.sap.sailing.domain.swisstimingadapter.impl.RaceImpl;
import com.sap.sailing.domain.swisstimingadapter.impl.SailMasterMessageImpl;
import com.sap.sailing.domain.swisstimingadapter.impl.SailMasterTransceiverImpl;
import com.sap.sailing.domain.swisstimingadapter.impl.StartListImpl;
import com.sap.sailing.domain.swisstimingadapter.impl.SwissTimingRaceTrackerImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.shared.util.impl.UUIDHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class AbstractSailMasterConnector
extends SailMasterTransceiverImpl
implements SailMasterConnector,
Runnable {
    private static final Logger logger = Logger.getLogger(AbstractSailMasterConnector.class.getName());
    private final DateFormat dateFormat;
    private final Set<SailMasterListener> listeners;
    private final Thread receiverThread;
    private boolean stopped;
    private final String raceId;
    private final String raceName;
    private final String raceDescription;
    private final BoatClass boatClass;
    private String lastTimeZoneSuffix;
    private TimePoint lastRPDMessageTimePoint;
    private TimePoint startTime;
    private final Map<MessageType, BlockingQueue<SailMasterMessage>> unprocessedMessagesByType;
    private long maxSequenceNumber = -1L;
    private Long numberOfStoredMessages;
    private final Object ensureSocketIsOpenSemaphor = new Object();

    protected AbstractSailMasterConnector(String raceId, String raceName, String raceDescription, BoatClass boatClass, SwissTimingRaceTrackerImpl swissTimingRaceTracker) throws InterruptedException, ParseException {
        this.raceId = raceId;
        this.raceName = raceName;
        this.raceDescription = raceDescription;
        this.boatClass = boatClass;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        this.listeners = new HashSet<SailMasterListener>();
        this.unprocessedMessagesByType = new HashMap<MessageType, BlockingQueue<SailMasterMessage>>();
        this.addSailMasterListener(swissTimingRaceTracker);
        this.receiverThread = new Thread((Runnable)this, "SwissTiming SailMaster Receiver");
    }

    protected void startReceiverThread() {
        this.receiverThread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.stopped) {
                try {
                    this.ensureConnected();
                    if (this.stopped || !this.isConnected()) continue;
                    String receivedMessage = this.receiveMessage(this.getInputStream());
                    if (receivedMessage == null) {
                        logger.info("Reached EOF for " + this + "; disconnecting");
                        if (!this.isConnected()) continue;
                        this.disconnect();
                        continue;
                    }
                    SailMasterMessageImpl message = new SailMasterMessageImpl(receivedMessage);
                    if (message.getSequenceNumber() != null) {
                        this.maxSequenceNumber = Math.max(this.maxSequenceNumber, message.getSequenceNumber());
                        if (this.maxSequenceNumber <= this.numberOfStoredMessages) {
                            this.notifyListenersStoredDataProgress(this.raceId, (double)this.maxSequenceNumber / (double)this.numberOfStoredMessages.longValue());
                        }
                    }
                    if (message.isResponse()) {
                        this.rendevouz(message);
                    } else if (message.isEvent()) {
                        logger.fine("notifying message " + message);
                        this.notifyListeners(message);
                    }
                    if (message.getType() != MessageType._STOPSERVER) continue;
                    logger.info("SailMasterConnector received " + MessageType._STOPSERVER.name());
                    this.stop();
                }
                catch (SocketException se) {
                    logger.info("Caught exception " + se + " during socket operation; setting socket to null");
                    this.disconnect();
                    Thread.sleep(1000L);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception in sail master connector " + AbstractSailMasterConnector.class.getName() + ".run for " + this, e);
        }
        logger.info("Stopping Sail Master connector thread for " + this);
        this.stopped = true;
    }

    @Override
    public SailMasterMessage receiveMessage(MessageType type) throws InterruptedException {
        BlockingQueue<SailMasterMessage> blockingQueue = this.getBlockingQueue(type);
        SailMasterMessage result = blockingQueue.take();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlockingQueue<SailMasterMessage> getBlockingQueue(MessageType type) {
        Map<MessageType, BlockingQueue<SailMasterMessage>> map = this.unprocessedMessagesByType;
        synchronized (map) {
            BlockingQueue<SailMasterMessage> blockingQueue = this.unprocessedMessagesByType.get((Object)type);
            if (blockingQueue == null) {
                blockingQueue = new LinkedBlockingQueue<SailMasterMessage>();
                this.unprocessedMessagesByType.put(type, blockingQueue);
            }
            return blockingQueue;
        }
    }

    private void rendevouz(SailMasterMessage message) {
        BlockingQueue<SailMasterMessage> blockingQueue = this.getBlockingQueue(message.getType());
        blockingQueue.offer(message);
    }

    protected void notifyListeners(SailMasterMessage message) {
        if (message.getType() != null) {
            try {
                switch (message.getType()) {
                    case RPD: {
                        this.notifyListenersRPD(message);
                        break;
                    }
                    case RAC: {
                        this.notifyListenersRAC(message);
                        break;
                    }
                    case CCG: {
                        this.notifyListenersCCG(message);
                        break;
                    }
                    case STL: {
                        this.notifyListenersSTL(message);
                        break;
                    }
                    case CAM: {
                        this.notifyListenersCAM(message);
                        break;
                    }
                    case TMD: {
                        this.notifyListenersTMD(message);
                        break;
                    }
                    case WND: {
                        this.notifyListenersWND(message);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception caught during parsing of message '" + message.getMessage() + "' : " + e.getMessage(), e);
            }
        }
    }

    private void notifyListenersStoredDataProgress(String raceID, double progress) {
        for (SailMasterListener listener : this.getListeners()) {
            try {
                listener.storedDataProgress(raceID, progress, this.getStatusAfterLoadingIsComplete());
            }
            catch (Exception e) {
                logger.info("Exception occurred trying to notify listener " + listener + " about progress " + progress);
                logger.throwing(AbstractSailMasterConnector.class.getName(), "notifyStoredDataProgress", e);
            }
        }
    }

    protected abstract TrackedRaceStatusEnum getStatusAfterLoadingIsComplete();

    private void notifyListenersWND(SailMasterMessage message) {
        String raceID = message.getSections()[1];
        int zeroBasedMarkIndex = Integer.valueOf(message.getSections()[2]);
        double windDirectionTrueDegrees = Double.valueOf(message.getSections()[3]);
        double windSpeedInKnots = Double.valueOf(message.getSections()[4]);
        for (SailMasterListener listener : this.getListeners()) {
            try {
                listener.receivedWindData(raceID, zeroBasedMarkIndex, windDirectionTrueDegrees, windSpeedInKnots);
            }
            catch (Exception e) {
                logger.info("Exception occurred trying to notify listener " + listener + " about " + message + ": " + e.getMessage());
                logger.throwing(AbstractSailMasterConnector.class.getName(), "notifyListenersWND", e);
            }
        }
    }

    private void notifyListenersTMD(SailMasterMessage message) {
        String raceID = message.getSections()[1];
        String competitorIdAsString = message.getSections()[2];
        int count = Integer.valueOf(message.getSections()[3]);
        ArrayList<Util.Triple<Integer, Integer, Long>> markIndicesRanksAndTimesSinceStartInMilliseconds = new ArrayList<Util.Triple<Integer, Integer, Long>>();
        int i = 0;
        while (i < count) {
            String[] details = message.getSections()[4 + i].split(";");
            Integer markIndex = details.length <= 0 || details[0].trim().length() == 0 ? null : Integer.valueOf(details[0]);
            Integer rank = details.length <= 1 || details[1].trim().length() == 0 ? null : Integer.valueOf(details[1]);
            Long timeSinceStartInMilliseconds = details.length <= 2 || details[2].trim().length() == 0 ? null : Long.valueOf(this.parseHHMMSSToMilliseconds(details[2]));
            markIndicesRanksAndTimesSinceStartInMilliseconds.add((Util.Triple<Integer, Integer, Long>)new Util.Triple((Object)markIndex, (Object)rank, timeSinceStartInMilliseconds));
            ++i;
        }
        for (SailMasterListener listener : this.getListeners()) {
            try {
                listener.receivedTimingData(raceID, competitorIdAsString, markIndicesRanksAndTimesSinceStartInMilliseconds);
            }
            catch (Exception e) {
                logger.info("Exception occurred trying to notify listener " + listener + " about " + message + ": " + e.getMessage());
                logger.throwing(AbstractSailMasterConnector.class.getName(), "notifyListenersTMD", e);
            }
        }
    }

    private void notifyListenersCAM(SailMasterMessage message) throws ParseException {
        List<Util.Triple<Integer, TimePoint, String>> clockAtMarkResults = this.parseClockAtMarkMessage(message);
        for (SailMasterListener listener : this.getListeners()) {
            try {
                listener.receivedClockAtMark(message.getSections()[1], clockAtMarkResults);
            }
            catch (Exception e) {
                logger.info("Exception occurred trying to notify listener " + listener + " about " + message + ": " + e.getMessage());
                logger.throwing(AbstractSailMasterConnector.class.getName(), "notifyListenersCAM", e);
            }
        }
    }

    private void notifyListenersSTL(SailMasterMessage message) {
        StartList startListMessage = this.parseStartListMessage(message);
        for (SailMasterListener listener : this.getListeners()) {
            try {
                listener.receivedStartList(message.getSections()[1], startListMessage);
            }
            catch (Exception e) {
                logger.info("Exception occurred trying to notify listener " + listener + " about " + message + ": " + e.getMessage());
                logger.throwing(AbstractSailMasterConnector.class.getName(), "notifyListenersSTL", e);
            }
        }
    }

    private void notifyListenersCCG(SailMasterMessage message) {
        Course course = this.parseCourseConfigurationMessage(message);
        for (SailMasterListener listener : this.getListeners()) {
            try {
                listener.receivedCourseConfiguration(message.getSections()[1], course);
            }
            catch (Exception e) {
                logger.info("Exception occurred trying to notify listener " + listener + " about " + message + ": " + e.getMessage());
                logger.throwing(AbstractSailMasterConnector.class.getName(), "notifyListenersCCG", e);
            }
        }
    }

    private void notifyListenersRAC(SailMasterMessage message) {
        List<Race> races = this.parseAvailableRacesMessage(message);
        for (SailMasterListener listener : this.getListeners()) {
            try {
                listener.receivedAvailableRaces(races);
            }
            catch (Exception e) {
                logger.info("Exception occurred trying to notify listener " + listener + " about " + message + ": " + e.getMessage());
                logger.throwing(AbstractSailMasterConnector.class.getName(), "notifyListenersRAC", e);
            }
        }
    }

    private void notifyListenersRPD(SailMasterMessage message) throws ParseException {
        MillisecondsTimePoint startTimeEstimatedStartTime;
        assert (message.getType() == MessageType.RPD);
        String[] sections = message.getSections();
        String raceID = sections[1];
        String[] raceStatusIntAndRacingStatusInt = sections[2].split(",");
        String raceStatusAsString = raceStatusIntAndRacingStatusInt.length > 0 ? raceStatusIntAndRacingStatusInt[0] : null;
        RaceStatus raceStatus = raceStatusAsString == null || raceStatusAsString.trim().isEmpty() ? null : RaceStatus.values()[Integer.valueOf(raceStatusAsString)];
        String racingStatusAsString = raceStatusIntAndRacingStatusInt.length > 1 ? raceStatusIntAndRacingStatusInt[1] : null;
        RacingStatus racingStatus = racingStatusAsString == null || racingStatusAsString.trim().isEmpty() ? null : RacingStatus.values()[Integer.valueOf(racingStatusAsString)];
        MillisecondsTimePoint timePoint = new MillisecondsTimePoint(this.parseTimeAndDateISO(sections[3], raceID));
        this.lastRPDMessageTimePoint = timePoint;
        String dateISO = sections[3].substring(0, sections[3].indexOf(84));
        String startTimeEstimatedStartTimeISO = String.valueOf(dateISO) + "T" + sections[4] + this.lastTimeZoneSuffix;
        MillisecondsTimePoint millisecondsTimePoint = startTimeEstimatedStartTime = sections[4].trim().length() == 0 ? null : new MillisecondsTimePoint(this.parseTimeAndDateISO(startTimeEstimatedStartTimeISO, raceID));
        if (startTimeEstimatedStartTime != null) {
            this.startTime = startTimeEstimatedStartTime;
        }
        Long millisecondsSinceRaceStart = sections[5].trim().length() == 0 ? null : Long.valueOf(this.parseHHMMSSToMilliseconds(sections[5]));
        Integer nextMarkIndexForLeader = sections[6].trim().length() == 0 ? null : Integer.valueOf(sections[6]);
        MeterDistance distanceToNextMarkForLeader = sections[7].trim().length() == 0 ? null : new MeterDistance(Double.valueOf(sections[7]).doubleValue());
        int count = Integer.valueOf(sections[8]);
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        int i = 0;
        while (i < count) {
            String trackedObjectIdAsString;
            boolean postVersion1_0;
            int fixDetailIndex = 0;
            String[] fixSections = sections[9 + i].split(";");
            boolean bl = postVersion1_0 = sections[9 + i].split(";", -1).length >= 14;
            if (fixSections.length > 2 && (trackedObjectIdAsString = fixSections[fixDetailIndex++].trim()) != null && !trackedObjectIdAsString.trim().isEmpty()) {
                String trackerTypeAsString;
                TrackerType trackerType = (trackerTypeAsString = fixSections[fixDetailIndex++]) == null || trackerTypeAsString.trim().isEmpty() ? null : TrackerType.values()[Integer.valueOf(trackerTypeAsString)];
                String ageOfDataInMillisAsString = fixSections[fixDetailIndex++];
                Long ageOfDataInMilliseconds = ageOfDataInMillisAsString == null || ageOfDataInMillisAsString.trim().isEmpty() ? null : Long.valueOf(1000L * Long.valueOf(ageOfDataInMillisAsString));
                String latDegAsString = fixSections[fixDetailIndex++];
                String lngDegAsString = fixSections[fixDetailIndex++];
                DegreePosition position = latDegAsString == null || latDegAsString.trim().isEmpty() || lngDegAsString == null || lngDegAsString.trim().isEmpty() ? null : new DegreePosition(Double.valueOf(latDegAsString).doubleValue(), Double.valueOf(lngDegAsString).doubleValue());
                String sogInKnotsAsString = fixSections[fixDetailIndex++];
                Double speedOverGroundInKnots = sogInKnotsAsString == null || sogInKnotsAsString.trim().isEmpty() ? null : Double.valueOf(sogInKnotsAsString);
                int alsIndex = postVersion1_0 ? fixDetailIndex + 1 : fixDetailIndex;
                int vmgIndex = postVersion1_0 ? fixDetailIndex : fixDetailIndex + 1;
                KnotSpeedImpl averageSpeedOverGround = fixSections[alsIndex].trim().length() == 0 ? null : new KnotSpeedImpl(Double.valueOf(fixSections[alsIndex]).doubleValue());
                KnotSpeedImpl velocityMadeGood = fixSections[vmgIndex].trim().length() == 0 ? null : new KnotSpeedImpl(Double.valueOf(fixSections[vmgIndex]).doubleValue());
                fixDetailIndex += 2;
                String cogAsString = fixSections[fixDetailIndex++];
                DegreeBearingImpl cog = cogAsString == null || cogAsString.trim().isEmpty() ? null : new DegreeBearingImpl(Double.valueOf(cogAsString).doubleValue());
                KnotSpeedWithBearingImpl speed = speedOverGroundInKnots == null || cog == null ? null : new KnotSpeedWithBearingImpl(speedOverGroundInKnots.doubleValue(), (Bearing)cog);
                Integer nextMarkIndex = fixSections.length <= fixDetailIndex || fixSections[fixDetailIndex].trim().length() == 0 ? null : Integer.valueOf(fixSections[fixDetailIndex]);
                Integer rank = fixSections.length <= ++fixDetailIndex || fixSections[fixDetailIndex].trim().length() == 0 ? null : Integer.valueOf(fixSections[fixDetailIndex]);
                MeterDistance distanceToLeader = fixSections.length <= ++fixDetailIndex || fixSections[fixDetailIndex].trim().length() == 0 ? null : new MeterDistance(Double.valueOf(fixSections[fixDetailIndex]).doubleValue());
                MeterDistance distanceToNextMark = fixSections.length <= ++fixDetailIndex || fixSections[fixDetailIndex].trim().length() == 0 ? null : new MeterDistance(Double.valueOf(fixSections[fixDetailIndex]).doubleValue());
                ++fixDetailIndex;
                String boatIRM = postVersion1_0 && fixSections.length > fixDetailIndex ? fixSections[fixDetailIndex++] : null;
                fixes.add(new FixImpl(UUIDHelper.tryUuidConversion((Serializable)((Object)trackedObjectIdAsString)), trackerType, ageOfDataInMilliseconds, (Position)position, (SpeedWithBearing)speed, nextMarkIndex, rank, (Speed)averageSpeedOverGround, (Speed)velocityMadeGood, (Distance)distanceToLeader, (Distance)distanceToNextMark, boatIRM));
            }
            ++i;
        }
        Set<SailMasterListener> allListeners = this.getListeners();
        for (SailMasterListener listener : allListeners) {
            try {
                listener.receivedRacePositionData(raceID, raceStatus, racingStatus, (TimePoint)timePoint, (TimePoint)startTimeEstimatedStartTime, millisecondsSinceRaceStart, nextMarkIndexForLeader, (Distance)distanceToNextMarkForLeader, fixes);
            }
            catch (Exception e) {
                logger.info("Exception occurred trying to notify listener " + listener + " about " + message + ": " + e.getMessage());
                logger.throwing(AbstractSailMasterConnector.class.getName(), "notifyListenersRPD", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<SailMasterListener> getListeners() {
        Set<SailMasterListener> set = this.listeners;
        synchronized (set) {
            return Collections.unmodifiableSet(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        this.stopped = true;
        logger.info("Stopping " + this);
        this.disconnect();
        AbstractSailMasterConnector abstractSailMasterConnector = this;
        synchronized (abstractSailMasterConnector) {
            this.notifyAll();
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSailMasterListener(SailMasterListener listener) {
        Set<SailMasterListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSailMasterListener(SailMasterListener listener) throws IOException {
        Set<SailMasterListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.stop();
            }
        }
    }

    @Override
    public SailMasterMessage sendRequestAndGetResponse(MessageType messageType, String ... args) throws UnknownHostException, IOException, InterruptedException {
        this.ensureConnected();
        return this.sendRequestAndGetResponseAssumingSocketIsOpen(messageType, args);
    }

    private SailMasterMessage sendRequestAndGetResponseAssumingSocketIsOpen(MessageType messageType, String ... args) throws IOException, InterruptedException {
        OutputStream os = this.getOutputStream();
        SailMasterMessage sailMasterMessage = this.createSailMasterMessage(messageType, args);
        this.sendMessage(sailMasterMessage, os);
        return this.receiveMessage(messageType);
    }

    private SailMasterMessage createSailMasterMessage(MessageType messageType, String ... args) {
        StringBuilder requestMessage = new StringBuilder();
        requestMessage.append(messageType.name());
        if (messageType != MessageType.OPN && messageType != MessageType.LSN) {
            requestMessage.append('?');
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            requestMessage.append('|');
            requestMessage.append(arg);
            ++n2;
        }
        SailMasterMessageImpl sailMasterMessage = new SailMasterMessageImpl(requestMessage.toString());
        return sailMasterMessage;
    }

    protected abstract OutputStream getOutputStream() throws IOException;

    protected abstract InputStream getInputStream() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void ensureConnected() throws InterruptedException, NumberFormatException, IOException {
        Object object = this.ensureSocketIsOpenSemaphor;
        synchronized (object) {
            while (!this.stopped) {
                if (this.isConnected()) {
                    return;
                }
                try {
                    this.connect();
                    OutputStream os = this.getOutputStream();
                    InputStream is = this.getInputStream();
                    SailMasterMessage opnRequest = this.createSailMasterMessage(MessageType.OPN, this.raceId);
                    this.sendMessage(opnRequest, os);
                    SailMasterMessageImpl opnResponse = new SailMasterMessageImpl(this.receiveMessage(is));
                    if (opnResponse.getType() != MessageType.OPN || !"OK".equals(opnResponse.getSections()[1])) {
                        logger.info("Recevied non-OK response " + opnResponse + " in " + this + " for our request " + opnRequest + ". Closing socket and stopping because we have no hope for recovery");
                        this.stopped = true;
                        this.disconnect();
                        continue;
                    }
                    logger.info("Received " + opnResponse + " in " + this + " which seems OK. Continuing with " + MessageType.LSN.name() + " request...");
                    this.numberOfStoredMessages = Long.valueOf(opnResponse.getSections()[2]);
                    ArrayList<String> lsnArgs = new ArrayList<String>();
                    lsnArgs.add("ON");
                    if (this.maxSequenceNumber != -1L) {
                        logger.info("Requesting messages starting from sequence number " + (this.maxSequenceNumber + 1L) + " in " + this);
                        lsnArgs.add(Long.valueOf(this.maxSequenceNumber + 1L).toString());
                    } else {
                        logger.info("Requesting messages starting from the beginning in " + this);
                        lsnArgs.add("1");
                    }
                    SailMasterMessage lsnRequest = this.createSailMasterMessage(MessageType.LSN, lsnArgs.toArray(new String[0]));
                    this.sendMessage(lsnRequest, os);
                    SailMasterMessageImpl lsnResponse = new SailMasterMessageImpl(this.receiveMessage(is));
                    if (lsnResponse.getType() != MessageType.LSN || !"OK".equals(lsnResponse.getSections()[1])) {
                        logger.info("Received non-OK response " + lsnResponse + " for our request " + lsnRequest + " in " + this + ". Closing socket and trying again in 1s...");
                        this.disconnectAndWaitABit();
                        continue;
                    }
                    logger.info("Received " + lsnResponse + " which seems to be OK. I think we're connected in " + this + "!");
                }
                catch (IOException | URISyntaxException e) {
                    logger.log(Level.INFO, "Exception trying to establish connection in " + this + ". Trying again in 1s.", e);
                    this.disconnectAndWaitABit();
                }
            }
            return;
        }
    }

    protected abstract void connect() throws IOException, URISyntaxException;

    protected abstract boolean isConnected() throws IOException;

    protected abstract void disconnect() throws IOException;

    private void disconnectAndWaitABit() throws InterruptedException, IOException {
        this.disconnect();
        Thread.sleep(1000L);
    }

    @Override
    public Race getRace() {
        return new RaceImpl(this.raceId, this.raceName, this.raceDescription, this.boatClass);
    }

    private List<Race> parseAvailableRacesMessage(SailMasterMessage availableRacesMessage) {
        this.assertMessageType(MessageType.RAC, availableRacesMessage);
        int count = Integer.valueOf(availableRacesMessage.getSections()[1]);
        ArrayList<Race> result = new ArrayList<Race>();
        int i = 0;
        while (i < count) {
            String[] idAndDescription = availableRacesMessage.getSections()[2 + i].split(";");
            result.add(new RaceImpl(idAndDescription[0], idAndDescription[1], idAndDescription[1], this.boatClass));
            ++i;
        }
        return result;
    }

    @Override
    public Course getCourse(String raceID) throws UnknownHostException, IOException, InterruptedException {
        SailMasterMessage response = this.sendRequestAndGetResponse(MessageType.CCG, raceID);
        String[] sections = response.getSections();
        this.assertResponseType(MessageType.CCG, response);
        this.assertRaceID(raceID, sections[1]);
        return this.parseCourseConfigurationMessage(response);
    }

    private Course parseCourseConfigurationMessage(SailMasterMessage courseConfigurationMessage) {
        this.assertMessageType(MessageType.CCG, courseConfigurationMessage);
        int count = Integer.valueOf(courseConfigurationMessage.getSections()[2]);
        ArrayList<Mark> marks = new ArrayList<Mark>();
        int i = 0;
        while (i < count) {
            int devicesNamesStartIndex;
            String[] markDetails = courseConfigurationMessage.getSections()[3 + i].split(";");
            Mark.MarkType markType = null;
            if (courseConfigurationMessage.getSections()[3 + i].split(";", -1).length == 5) {
                int markTypeIndex = Integer.valueOf(markDetails[2]);
                markType = Mark.MarkType.values()[markTypeIndex];
                devicesNamesStartIndex = 3;
            } else {
                devicesNamesStartIndex = 2;
            }
            marks.add(new MarkImpl(markDetails[1], Integer.valueOf(markDetails[0]), Arrays.asList(markDetails).subList(devicesNamesStartIndex, markDetails.length).stream().filter(idAsString -> Util.hasLength((String)idAsString)).map(idAsString -> UUIDHelper.tryUuidConversion((Serializable)((Object)idAsString))).collect(Collectors.toList()), markType));
            ++i;
        }
        return new CourseImpl(courseConfigurationMessage.getSections()[1], marks);
    }

    @Override
    public TimePoint getLastRPDMessageTimePoint() {
        return this.lastRPDMessageTimePoint;
    }

    private String getLastTimeZoneSuffix(String raceID) {
        String result = this.lastTimeZoneSuffix;
        if (result == null) {
            int offset = TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 1000 / 3600;
            this.lastTimeZoneSuffix = result = String.valueOf(offset < 0 ? "-" : "+") + new DecimalFormat("00").format(offset) + "00";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String prefixTimeWithISOTodayAndSuffixWithTimezoneIndicator(String time, String raceID) {
        DateFormat dateFormat = this.dateFormat;
        synchronized (dateFormat) {
            return String.valueOf(this.dateFormat.format(new Date()).substring(0, "yyyy-mm-ddT".length())) + time + this.getLastTimeZoneSuffix(raceID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date parseTimeAndDateISO(String timeAndDateISO, String raceID) throws ParseException {
        char timeZoneIndicator = timeAndDateISO.charAt(timeAndDateISO.length() - 6);
        if ((timeZoneIndicator == '+' || timeZoneIndicator == '-') && timeAndDateISO.charAt(timeAndDateISO.length() - 3) == ':') {
            timeAndDateISO = String.valueOf(timeAndDateISO.substring(0, timeAndDateISO.length() - 3)) + timeAndDateISO.substring(timeAndDateISO.length() - 2);
            this.lastTimeZoneSuffix = timeAndDateISO.substring(timeAndDateISO.length() - 5);
        }
        DateFormat dateFormat = this.dateFormat;
        synchronized (dateFormat) {
            return this.dateFormat.parse(timeAndDateISO);
        }
    }

    private void assertRaceID(String raceID, String section) {
        if (!section.equals(raceID)) {
            throw new RuntimeException("Expected race ID " + raceID + " but received " + section);
        }
    }

    private void assertMarkIndex(int markIndex, String section) {
        if (Integer.valueOf(section) != markIndex) {
            throw new RuntimeException("Expected marker index " + markIndex + " in response but received " + section);
        }
    }

    private void assertBoatID(String boatID, String section) {
        if (!section.equals(boatID)) {
            throw new RuntimeException("Expected boat ID " + boatID + " in response but received " + section);
        }
    }

    private void assertMessageType(MessageType expectedMessageType, SailMasterMessage message) {
        if (message.getType() != expectedMessageType) {
            throw new RuntimeException("Expected a " + (Object)((Object)expectedMessageType) + " message type but got " + (Object)((Object)message.getType()));
        }
    }

    private void assertResponseType(MessageType responseType, SailMasterMessage message) {
        if (!message.isResponse()) {
            throw new RuntimeException("Expected a response message but got " + message);
        }
        if (message.getType() != responseType) {
            throw new RuntimeException("Expected a " + (Object)((Object)responseType) + " response for a " + (Object)((Object)responseType) + " request but got " + (Object)((Object)message.getType()));
        }
    }

    private void assertLeg(String leg, String section) {
        if (!section.equals(leg)) {
            throw new RuntimeException("Expected leg " + leg + " in response but received " + section);
        }
    }

    @Override
    public StartList getStartList(String raceID) throws UnknownHostException, IOException, InterruptedException {
        SailMasterMessage response = this.sendRequestAndGetResponse(MessageType.STL, raceID);
        String[] sections = response.getSections();
        this.assertResponseType(MessageType.STL, response);
        this.assertRaceID(raceID, sections[1]);
        return this.parseStartListMessage(response);
    }

    private StartList parseStartListMessage(SailMasterMessage startListMessage) {
        this.assertMessageType(MessageType.STL, startListMessage);
        ArrayList<Competitor> competitors = new ArrayList<Competitor>();
        int count = Integer.valueOf(startListMessage.getSections()[2]);
        int i = 0;
        while (i < count) {
            String[] competitorDetails = startListMessage.getSections()[3 + i].split(";");
            competitors.add(new CompetitorWithoutID(competitorDetails[0], competitorDetails[1], competitorDetails[2]));
            ++i;
        }
        return new StartListImpl(startListMessage.getSections()[1], competitors);
    }

    @Override
    public TimePoint getStartTime() throws UnknownHostException, IOException, ParseException, InterruptedException {
        return this.startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date parseTimePrefixedWithISOToday(String timeHHMMSS, String raceID) throws ParseException {
        DateFormat dateFormat = this.dateFormat;
        synchronized (dateFormat) {
            return this.dateFormat.parse(this.prefixTimeWithISOTodayAndSuffixWithTimezoneIndicator(timeHHMMSS, raceID));
        }
    }

    @Override
    public Distance getDistanceToMark(String raceID, int markIndex, String boatID) throws UnknownHostException, IOException, InterruptedException {
        SailMasterMessage response = this.sendRequestAndGetResponse(MessageType.DTM, raceID, "" + markIndex, boatID);
        String[] sections = response.getSections();
        this.assertResponseType(MessageType.DTM, response);
        this.assertRaceID(raceID, sections[1]);
        this.assertMarkIndex(markIndex, sections[2]);
        this.assertBoatID(boatID, sections[3]);
        return sections.length <= 4 || sections[4].trim().length() == 0 ? null : new MeterDistance(Double.valueOf(sections[4]).doubleValue());
    }

    @Override
    public Speed getCurrentBoatSpeed(String raceID, String boatID) throws UnknownHostException, IOException, InterruptedException {
        SailMasterMessage response = this.sendRequestAndGetResponse(MessageType.CBS, raceID, boatID);
        String[] sections = response.getSections();
        this.assertResponseType(MessageType.CBS, response);
        this.assertRaceID(raceID, sections[1]);
        this.assertBoatID(boatID, sections[2]);
        return new KilometersPerHourSpeedImpl(3.6 * Double.valueOf(sections[3]));
    }

    @Override
    public Distance getDistanceBetweenBoats(String raceID, String boatID1, String boatID2) throws UnknownHostException, IOException, InterruptedException {
        Distance.NullDistance result;
        if (boatID1.equals(boatID2)) {
            result = Distance.NULL;
        } else {
            SailMasterMessage response = this.sendRequestAndGetResponse(MessageType.DBB, raceID, boatID1, boatID2);
            String[] sections = response.getSections();
            this.assertResponseType(MessageType.DBB, response);
            this.assertRaceID(raceID, sections[1]);
            this.assertBoatID(boatID1, sections[2]);
            this.assertBoatID(boatID2, sections[3]);
            result = sections.length <= 4 || sections[4].trim().length() == 0 ? null : new MeterDistance(Double.valueOf(sections[4]).doubleValue());
        }
        return result;
    }

    @Override
    public Speed getAverageBoatSpeed(String raceID, String leg, String boatID) throws UnknownHostException, IOException, InterruptedException {
        SailMasterMessage response = this.sendRequestAndGetResponse(MessageType.ABS, raceID, leg, boatID);
        String[] sections = response.getSections();
        this.assertResponseType(MessageType.ABS, response);
        this.assertRaceID(raceID, sections[1]);
        this.assertLeg(leg, sections[2]);
        this.assertBoatID(boatID, sections[3]);
        return new KilometersPerHourSpeedImpl(3.6 * Double.valueOf(sections[4]));
    }

    @Override
    public Map<Integer, Util.Pair<Integer, Long>> getMarkPassingTimesInMillisecondsSinceRaceStart(String raceID, String boatID) throws UnknownHostException, IOException, InterruptedException {
        SailMasterMessage response = this.sendRequestAndGetResponse(MessageType.TMD, raceID, boatID);
        String[] sections = response.getSections();
        this.assertResponseType(MessageType.TMD, response);
        this.assertRaceID(raceID, sections[1]);
        this.assertBoatID(boatID, sections[2]);
        int count = Integer.valueOf(sections[3]);
        HashMap<Integer, Util.Pair<Integer, Long>> result = new HashMap<Integer, Util.Pair<Integer, Long>>();
        int i = 0;
        while (i < count) {
            String[] markTimeDetail = sections[4 + i].split(";");
            Long millisecondsSinceStart = markTimeDetail.length <= 2 || markTimeDetail[2].trim().length() == 0 ? null : Long.valueOf(this.parseHHMMSSToMilliseconds(markTimeDetail[2]));
            result.put(Integer.valueOf(markTimeDetail[0]), (Util.Pair<Integer, Long>)new Util.Pair(markTimeDetail.length <= 1 || markTimeDetail[1].trim().length() == 0 ? null : Integer.valueOf(markTimeDetail[1]), (Object)millisecondsSinceStart));
            ++i;
        }
        return result;
    }

    @Override
    public List<Util.Triple<Integer, TimePoint, String>> getClockAtMark(String raceID) throws ParseException, UnknownHostException, IOException, InterruptedException {
        SailMasterMessage response = this.sendRequestAndGetResponse(MessageType.CAM, raceID);
        String[] sections = response.getSections();
        this.assertResponseType(MessageType.CAM, response);
        this.assertRaceID(raceID, sections[1]);
        List<Util.Triple<Integer, TimePoint, String>> result = this.parseClockAtMarkMessage(response);
        return result;
    }

    private List<Util.Triple<Integer, TimePoint, String>> parseClockAtMarkMessage(SailMasterMessage clockAtMarkMessage) throws ParseException {
        this.assertMessageType(MessageType.CAM, clockAtMarkMessage);
        ArrayList<Util.Triple<Integer, TimePoint, String>> result = new ArrayList<Util.Triple<Integer, TimePoint, String>>();
        int count = Integer.valueOf(clockAtMarkMessage.getSections()[2]);
        int i = 0;
        while (i < count) {
            String[] clockAtMarkDetail = clockAtMarkMessage.getSections()[3 + i].split(";");
            int markIndex = Integer.valueOf(clockAtMarkDetail[0]);
            MillisecondsTimePoint timePoint = clockAtMarkDetail.length <= 1 || clockAtMarkDetail[1].trim().length() == 0 ? null : new MillisecondsTimePoint(this.parseTimePrefixedWithISOToday(clockAtMarkDetail[1], clockAtMarkMessage.getRaceID()));
            result.add((Util.Triple<Integer, TimePoint, String>)new Util.Triple((Object)markIndex, (Object)timePoint, clockAtMarkDetail.length <= 2 ? null : clockAtMarkDetail[2]));
            ++i;
        }
        return result;
    }

    private long parseHHMMSSToMilliseconds(String hhmmss) {
        String[] timeDetail = hhmmss.split(":");
        long millisecondsSinceStart = 1000L * (Long.valueOf(timeDetail[2]) + 60L * Long.valueOf(timeDetail[1]) + 3600L * Long.valueOf(timeDetail[0]));
        return millisecondsSinceStart;
    }

    @Override
    public void enableRacePositionData() throws UnknownHostException, IOException, InterruptedException {
        this.sendRequestAndGetResponse(MessageType.RPD, "1");
    }

    @Override
    public void disableRacePositionData() throws UnknownHostException, IOException, InterruptedException {
        this.sendRequestAndGetResponse(MessageType.RPD, "0");
    }
}

