/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.SafeHtmlCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.landscape.ui.client.LandscapeManagementWriteServiceAsync;
import com.sap.sailing.landscape.ui.client.LinkBuilder;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sailing.landscape.ui.shared.AwsShardDTO;
import com.sap.sailing.landscape.ui.shared.LeaderboardNameDTO;
import com.sap.sailing.landscape.ui.shared.SailingApplicationReplicaSetDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.TableWrapperWithMultiSelectionAndFilter;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.landscape.aws.common.shared.ShardTargetGroupName;
import com.sap.sse.security.ui.client.component.SelectedElementsCountingButton;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ShardManagementPanel
extends SimplePanel {
    private final ErrorReporter errorReporter;
    private final LandscapeManagementWriteServiceAsync landscapeManagementService;
    private final TableWrapperWithMultiSelectionAndFilter<LeaderboardNameDTO, StringMessages, AdminConsoleTableResources> regattasTable;
    private final TableWrapperWithMultiSelectionAndFilter<AwsShardDTO, StringMessages, AdminConsoleTableResources> shardTable;
    private final TableWrapperWithMultiSelectionAndFilter<LeaderboardNameDTO, StringMessages, AdminConsoleTableResources> selectedKeysTable;
    private final TextBox bearerTokenText;
    private SailingApplicationReplicaSetDTO<String> replicaSet;
    private final BusyIndicator busyIndicator;
    private String region;
    private List<LeaderboardNameDTO> leaderboards;
    private Map<AwsShardDTO, Iterable<String>> shardsAndShardingKeys;
    private final CaptionPanel leaderboardCaption;
    private final CaptionPanel leaderboardsInShardCaption;
    private final Button addButton;
    private final Button deleteButton;
    private final SelectedElementsCountingButton<AwsShardDTO> removeShardButton;
    private final StringMessages stringMessages;
    private boolean hasAnythingChanged;
    private final String optionalKeyName;
    private final byte[] privateKeyEncryptionPassphrase;

    public ShardManagementPanel(LandscapeManagementWriteServiceAsync landscapeManagementService, ErrorReporter errorReporter, StringMessages stringMessages, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) {
        this.stringMessages = stringMessages;
        this.optionalKeyName = optionalKeyName;
        this.privateKeyEncryptionPassphrase = privateKeyEncryptionPassphrase;
        this.hasAnythingChanged = false;
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setWidth("100%");
        this.add((Widget)mainPanel);
        this.errorReporter = errorReporter;
        this.landscapeManagementService = landscapeManagementService;
        HorizontalPanel actionPanel = new HorizontalPanel();
        actionPanel.setSpacing(5);
        Button refreshButton = new Button(stringMessages.refresh());
        refreshButton.addClickHandler(event -> this.refresh());
        actionPanel.add((Widget)refreshButton);
        this.regattasTable = new TableWrapperWithMultiSelectionAndFilter<LeaderboardNameDTO, StringMessages, AdminConsoleTableResources>(stringMessages, errorReporter, false, Optional.empty(), (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class), Optional.empty(), Optional.empty(), null){

            protected Iterable<String> getSearchableStrings(LeaderboardNameDTO t) {
                HashSet<String> res = new HashSet<String>();
                res.add(t.getName());
                return res;
            }
        };
        SelectedElementsCountingButton addShard = new SelectedElementsCountingButton(stringMessages.addShard(), (SetSelectionModel)this.regattasTable.getSelectionModel(), e -> this.addShard(), true);
        actionPanel.add((Widget)addShard);
        this.shardTable = new TableWrapperWithMultiSelectionAndFilter<AwsShardDTO, StringMessages, AdminConsoleTableResources>(stringMessages, errorReporter, false, Optional.empty(), (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class), Optional.empty(), Optional.empty(), null){

            protected Iterable<String> getSearchableStrings(AwsShardDTO t) {
                HashSet<String> res = new HashSet<String>();
                res.add(t.getName());
                return res;
            }
        };
        this.removeShardButton = new SelectedElementsCountingButton(stringMessages.remove(), (SetSelectionModel)this.shardTable.getSelectionModel(), rs -> rs.getName(), arg_0 -> ((StringMessages)stringMessages).doYouReallyWantToRemoveSelectedElements(arg_0), e -> this.removeShard());
        actionPanel.add(this.removeShardButton);
        mainPanel.add((Widget)actionPanel);
        Grid userCredentials = new Grid(1, 2);
        this.bearerTokenText = new TextBox();
        Label bearerHintText = new Label(stringMessages.bearerTokenOrNullForApplicationReplicaSetToArchive(""));
        userCredentials.setWidget(0, 0, (Widget)bearerHintText);
        userCredentials.setWidget(0, 1, (Widget)this.bearerTokenText);
        mainPanel.add((Widget)userCredentials);
        this.shardTable.addColumn(t -> t.getName(), stringMessages.shardName());
        this.shardTable.addColumn(t -> String.join((CharSequence)", ", t.getLeaderboardNames()), stringMessages.shardingKeys());
        SafeHtmlCell targetGroupCell = new SafeHtmlCell();
        Column<AwsShardDTO, SafeHtml> targetGroupColumn = new Column<AwsShardDTO, SafeHtml>((Cell)targetGroupCell){

            public SafeHtml getValue(AwsShardDTO shard) {
                return new LinkBuilder().setTargetGroupName(shard.getTargetGroupName()).setRegion(ShardManagementPanel.this.region).setPathMode(LinkBuilder.pathModes.TargetGroupSearch).build();
            }
        };
        this.shardTable.addColumn((Column)targetGroupColumn, stringMessages.targetGroup());
        SafeHtmlCell ausoScalingGroupCell = new SafeHtmlCell();
        Column<AwsShardDTO, SafeHtml> autoScalingGroupColumn = new Column<AwsShardDTO, SafeHtml>((Cell)ausoScalingGroupCell){

            public SafeHtml getValue(AwsShardDTO shard) {
                return new LinkBuilder().setAutoScalingGroupName(shard.getAutoScalingGroupName()).setRegion(ShardManagementPanel.this.region).setPathMode(LinkBuilder.pathModes.AutoScalingGroupSearch).build();
            }
        };
        this.shardTable.addColumn((Column)autoScalingGroupColumn, stringMessages.autoScalingGroup());
        ((RefreshableMultiSelectionModel)this.shardTable.getSelectionModel()).addSelectionChangeHandler(event -> {
            this.updateSelectedKeysTable();
            this.updateAddDeleteButton();
        });
        this.leaderboardCaption = new CaptionPanel(stringMessages.unshardedLeaderboards());
        this.regattasTable.addColumn(t -> t.getName(), stringMessages.name());
        ((RefreshableMultiSelectionModel)this.regattasTable.getSelectionModel()).addSelectionChangeHandler(event -> this.updateAddDeleteButton());
        this.leaderboardCaption.add(this.regattasTable);
        HorizontalPanel tableRow = new HorizontalPanel();
        this.busyIndicator = new SimpleBusyIndicator();
        this.leaderboardsInShardCaption = new CaptionPanel(stringMessages.leaderboardsInShard());
        this.selectedKeysTable = new TableWrapperWithMultiSelectionAndFilter<LeaderboardNameDTO, StringMessages, AdminConsoleTableResources>(stringMessages, errorReporter, false, Optional.empty(), (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class), Optional.empty(), Optional.empty(), null){

            protected Iterable<String> getSearchableStrings(LeaderboardNameDTO t) {
                HashSet<String> result = new HashSet<String>();
                if (t != null && !t.getName().isEmpty()) {
                    result.add(t.getName());
                }
                return result;
            }
        };
        this.selectedKeysTable.addColumn(t -> t.getName(), stringMessages.name());
        ((RefreshableMultiSelectionModel)this.selectedKeysTable.getSelectionModel()).addSelectionChangeHandler(event -> this.updateAddDeleteButton());
        this.leaderboardsInShardCaption.add(this.selectedKeysTable);
        this.addButton = new Button("<");
        this.addButton.addClickHandler(event -> this.addLeaderboardsToShard());
        this.deleteButton = new Button(">");
        this.deleteButton.addClickHandler(event -> this.removeLeaderboardsFromShard());
        HorizontalPanel insideShardPanel = new HorizontalPanel();
        VerticalPanel buttonPanel = new VerticalPanel();
        SimplePanel spaceholder = new SimplePanel();
        spaceholder.setHeight("60px");
        SimplePanel keysSpaceholder = new SimplePanel();
        buttonPanel.add((Widget)spaceholder);
        buttonPanel.add((Widget)this.addButton);
        buttonPanel.add((Widget)this.deleteButton);
        tableRow.add((Widget)insideShardPanel);
        insideShardPanel.add(this.shardTable);
        insideShardPanel.add((Widget)keysSpaceholder);
        keysSpaceholder.add((Widget)this.leaderboardsInShardCaption);
        insideShardPanel.add((Widget)buttonPanel);
        insideShardPanel.add((Widget)this.leaderboardCaption);
        mainPanel.add((Widget)tableRow);
        mainPanel.add((Widget)this.busyIndicator);
        this.updateAddDeleteButton();
    }

    private void updateSelectedKeysTable() {
        if (((RefreshableMultiSelectionModel)this.shardTable.getSelectionModel()).getSelectedSet().size() == 1) {
            this.selectedKeysTable.refresh(Util.map(((AwsShardDTO)((RefreshableMultiSelectionModel)this.shardTable.getSelectionModel()).getSelectedSet().iterator().next()).getLeaderboardNames(), LeaderboardNameDTO::new));
        } else {
            this.selectedKeysTable.clear();
        }
    }

    private void updateAddDeleteButton() {
        this.addButton.setEnabled(((RefreshableMultiSelectionModel)this.shardTable.getSelectionModel()).getSelectedSet().size() == 1 && ((RefreshableMultiSelectionModel)this.regattasTable.getSelectionModel()).getSelectedSet().size() > 0);
        this.deleteButton.setEnabled(((RefreshableMultiSelectionModel)this.shardTable.getSelectionModel()).getSelectedSet().size() == 1 && ((RefreshableMultiSelectionModel)this.selectedKeysTable.getSelectionModel()).getSelectedSet().size() > 0);
    }

    public void refresh() {
        this.getLeaderboards();
    }

    private void display() {
        ArrayList<String> takenLeaderboardNames = new ArrayList<String>();
        for (Map.Entry<AwsShardDTO, Iterable<String>> s : this.shardsAndShardingKeys.entrySet()) {
            for (String leaderboardName : s.getKey().getLeaderboardNames()) {
                takenLeaderboardNames.add(leaderboardName);
            }
        }
        Iterable leaderboardsToDisplay = Util.filter(this.leaderboards, leaderboardNameDTO -> !takenLeaderboardNames.contains(leaderboardNameDTO.getName()));
        this.regattasTable.refresh(leaderboardsToDisplay);
        this.shardTable.refresh(this.shardsAndShardingKeys.keySet());
    }

    private void setBusy(boolean b) {
        this.busyIndicator.setBusy(b);
    }

    private void getLeaderboards() {
        this.setBusy(true);
        this.landscapeManagementService.getLeaderboardNames(this.replicaSet, this.getBearerToken(), new AsyncCallback<ArrayList<LeaderboardNameDTO>>(){

            public void onSuccess(ArrayList<LeaderboardNameDTO> result) {
                ShardManagementPanel.this.leaderboards = result;
                ShardManagementPanel.this.getShards();
            }

            public void onFailure(Throwable caught) {
                ShardManagementPanel.this.errorReporter.reportError(ShardManagementPanel.this.stringMessages.errorFetchingLeaderboardNames(caught.getMessage()));
                ShardManagementPanel.this.setBusy(false);
            }
        });
    }

    private String getBearerToken() {
        return Util.hasLength((String)this.bearerTokenText.getValue()) ? this.bearerTokenText.getValue() : null;
    }

    private void getShards() {
        this.setBusy(true);
        this.landscapeManagementService.getShards(this.replicaSet, this.region, this.getBearerToken(), this.optionalKeyName, this.privateKeyEncryptionPassphrase, new AsyncCallback<Map<AwsShardDTO, Iterable<String>>>(){

            public void onFailure(Throwable caught) {
                ShardManagementPanel.this.errorReporter.reportError(caught.getMessage());
                ShardManagementPanel.this.setBusy(false);
            }

            public void onSuccess(Map<AwsShardDTO, Iterable<String>> result) {
                ShardManagementPanel.this.shardsAndShardingKeys = result;
                ShardManagementPanel.this.setBusy(false);
                ShardManagementPanel.this.display();
            }
        });
    }

    private void addShard() {
        final Set selectedLeaderboards = ((RefreshableMultiSelectionModel)this.regattasTable.getSelectionModel()).getSelectedSet();
        if (this.replicaSet != null) {
            DataEntryDialog<String> nameRequest = new DataEntryDialog<String>(this.stringMessages.shardName(), this.stringMessages.enterShardName(), this.stringMessages.ok(), this.stringMessages.cancel(), (DataEntryDialog.Validator)new DataEntryDialog.Validator<String>(){

                public String getErrorMessage(String valueToValidate) {
                    String errorMessage;
                    if (!Util.hasLength((String)valueToValidate)) {
                        errorMessage = ShardManagementPanel.this.stringMessages.pleaseProvideANonEmptyShardName();
                    } else {
                        try {
                            ShardTargetGroupName.create((String)ShardManagementPanel.this.replicaSet.getReplicaSetName(), (String)valueToValidate, (String)"S-");
                            errorMessage = null;
                        }
                        catch (IllegalArgumentException e) {
                            errorMessage = ShardManagementPanel.this.stringMessages.shardNameInvalid(valueToValidate, e.getMessage());
                        }
                    }
                    return errorMessage;
                }
            }, (DataEntryDialog.DialogCallback)new DataEntryDialog.DialogCallback<String>(){

                public void ok(final String newShardName) {
                    ShardManagementPanel.this.hasAnythingChanged = true;
                    ArrayList<LeaderboardNameDTO> l = new ArrayList<LeaderboardNameDTO>();
                    l.addAll(selectedLeaderboards);
                    ShardManagementPanel.this.busyIndicator.setBusy(true);
                    ShardManagementPanel.this.landscapeManagementService.addShard(newShardName, l, ShardManagementPanel.this.replicaSet, ShardManagementPanel.this.getBearerToken(), ShardManagementPanel.this.region, ShardManagementPanel.this.optionalKeyName, ShardManagementPanel.this.privateKeyEncryptionPassphrase, new AsyncCallback<Void>(){

                        public void onSuccess(Void result) {
                            ShardManagementPanel.this.busyIndicator.setBusy(false);
                            Notification.notify((String)ShardManagementPanel.this.stringMessages.shardCreatedSuccessfully(newShardName), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                            ShardManagementPanel.this.refresh();
                        }

                        public void onFailure(Throwable caught) {
                            ShardManagementPanel.this.busyIndicator.setBusy(false);
                            ShardManagementPanel.this.errorReporter.reportError(caught.getMessage());
                        }
                    });
                }

                public void cancel() {
                }
            }){
                private final TextBox nameTextBox;
                {
                    this.nameTextBox = this.createTextBox("", 20);
                }

                protected Widget getAdditionalWidget() {
                    return this.nameTextBox;
                }

                protected FocusWidget getInitialFocusWidget() {
                    return this.nameTextBox;
                }

                protected String getResult() {
                    return this.nameTextBox.getText();
                }
            };
            nameRequest.show();
        }
    }

    private void removeShard() {
        this.setBusy(true);
        for (final AwsShardDTO selection : ((RefreshableMultiSelectionModel)this.shardTable.getSelectionModel()).getSelectedSet()) {
            this.hasAnythingChanged = true;
            this.landscapeManagementService.removeShard(selection, this.replicaSet, this.region, this.optionalKeyName, this.privateKeyEncryptionPassphrase, new AsyncCallback<Void>(){

                public void onFailure(Throwable caught) {
                    ShardManagementPanel.this.errorReporter.reportError(caught.getMessage());
                    ShardManagementPanel.this.setBusy(false);
                }

                public void onSuccess(Void result) {
                    Notification.notify((String)ShardManagementPanel.this.stringMessages.deletedShard(selection.getName()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                    ShardManagementPanel.this.refresh();
                }
            });
        }
    }

    private void addLeaderboardsToShard() {
        this.setBusy(true);
        if (!((RefreshableMultiSelectionModel)this.regattasTable.getSelectionModel()).getSelectedSet().isEmpty() && ((RefreshableMultiSelectionModel)this.shardTable.getSelectionModel()).getSelectedSet().size() == 1) {
            final Set selectedLeaderboards = ((RefreshableMultiSelectionModel)this.regattasTable.getSelectionModel()).getSelectedSet();
            final AwsShardDTO shard = (AwsShardDTO)((RefreshableMultiSelectionModel)this.shardTable.getSelectionModel()).getSelectedSet().iterator().next();
            this.hasAnythingChanged = true;
            this.landscapeManagementService.appendShardingKeysToShard(selectedLeaderboards, this.region, shard.getName(), this.replicaSet, this.getBearerToken(), this.optionalKeyName, this.privateKeyEncryptionPassphrase, new AsyncCallback<Void>(){

                public void onFailure(Throwable caught) {
                    ShardManagementPanel.this.setBusy(false);
                    ShardManagementPanel.this.errorReporter.reportError(caught.getMessage());
                }

                public void onSuccess(Void result) {
                    ShardManagementPanel.this.setBusy(false);
                    Notification.notify((String)ShardManagementPanel.this.stringMessages.successfullyAppendedShardingKeysToShard(Util.join((String)", ", (Iterable)selectedLeaderboards), shard.getName()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                    ShardManagementPanel.this.refresh();
                }
            });
        }
    }

    private void removeLeaderboardsFromShard() {
        this.setBusy(true);
        if (!((RefreshableMultiSelectionModel)this.selectedKeysTable.getSelectionModel()).getSelectedSet().isEmpty() && ((RefreshableMultiSelectionModel)this.shardTable.getSelectionModel()).getSelectedSet().size() == 1) {
            final Set selectedLeaderboards = ((RefreshableMultiSelectionModel)this.selectedKeysTable.getSelectionModel()).getSelectedSet();
            final AwsShardDTO shard = (AwsShardDTO)((RefreshableMultiSelectionModel)this.shardTable.getSelectionModel()).getSelectedSet().iterator().next();
            this.hasAnythingChanged = true;
            this.landscapeManagementService.removeShardingKeysFromShard(selectedLeaderboards, this.region, shard.getName(), this.replicaSet, this.getBearerToken(), this.optionalKeyName, this.privateKeyEncryptionPassphrase, new AsyncCallback<Void>(){

                public void onFailure(Throwable caught) {
                    ShardManagementPanel.this.setBusy(false);
                    ShardManagementPanel.this.errorReporter.reportError(caught.getMessage());
                }

                public void onSuccess(Void result) {
                    Notification.notify((String)ShardManagementPanel.this.stringMessages.successfullyRemovedLeaderboardsFromShard(Util.join((String)", ", (Iterable)selectedLeaderboards), shard.getName()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                    ShardManagementPanel.this.refresh();
                }
            });
        }
    }

    public void setReplicaSet(SailingApplicationReplicaSetDTO<String> replicaset) {
        this.replicaSet = replicaset;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Boolean hasAnythingChanged() {
        return this.hasAnythingChanged;
    }
}

