/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.landscape.ui.client.LandscapeDialogUtil;
import com.sap.sailing.landscape.ui.client.LandscapeManagementWriteServiceAsync;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sailing.landscape.ui.shared.AwsInstanceDTO;
import com.sap.sailing.landscape.ui.shared.SailingAnalyticsProcessDTO;
import com.sap.sailing.landscape.ui.shared.SailingApplicationReplicaSetDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.HashMap;

public class MoveAllAwayFromHostDialog
extends DataEntryDialog<String> {
    private final ListBox instanceTypeListBox;
    private final Label instanceTypeLabel;
    private final String SAME_AS_MASTER = "__same_as_master__";

    public MoveAllAwayFromHostDialog(LandscapeManagementWriteServiceAsync landscapeManagementService, AwsInstanceDTO fromHost, Iterable<SailingApplicationReplicaSetDTO<String>> replicaSets, StringMessages stringMessages, ErrorReporter errorReporter, DataEntryDialog.DialogCallback<String> callback) {
        super(stringMessages.moveAllApplicationProcessesAwayFromMaster(), MoveAllAwayFromHostDialog.getMessage(fromHost, replicaSets, stringMessages), stringMessages.ok(), stringMessages.cancel(), null, callback);
        this.instanceTypeListBox = LandscapeDialogUtil.createInstanceTypeListBoxWithAdditionalDefaultEntry(this, stringMessages.sameAsExistingHost(), "__same_as_master__", landscapeManagementService, stringMessages, stringMessages.sameAsExistingHost(), errorReporter, false);
        this.instanceTypeLabel = new Label();
    }

    private static String getMessage(AwsInstanceDTO host, Iterable<SailingApplicationReplicaSetDTO<String>> replicaSets, StringMessages stringMessages) {
        HashMap<String, SailingAnalyticsProcessDTO> masterProcessesOnHostByReplicaSetName = new HashMap<String, SailingAnalyticsProcessDTO>();
        HashMap replicaProcessesOnHostByReplicaSetName = new HashMap();
        for (SailingApplicationReplicaSetDTO<String> replicaSet : replicaSets) {
            if (replicaSet.getMaster().getHost().getInstanceId().equals(host.getInstanceId())) {
                masterProcessesOnHostByReplicaSetName.put(replicaSet.getName(), replicaSet.getMaster());
                continue;
            }
            Util.stream(replicaSet.getReplicas()).filter(replica -> replica.getHost().getInstanceId().equals(host.getInstanceId())).forEach(replicaOnHost -> {
                SailingAnalyticsProcessDTO sailingAnalyticsProcessDTO = replicaProcessesOnHostByReplicaSetName.put(replicaSet.getName(), replicaOnHost);
            });
        }
        return stringMessages.moveTheFollowingMasterAndReplicaProcessesAway(host.getInstanceId(), String.join((CharSequence)", ", Util.map(masterProcessesOnHostByReplicaSetName.entrySet(), e -> MoveAllAwayFromHostDialog.getProcessFromReplicaSetForMessage((String)e.getKey(), (SailingAnalyticsProcessDTO)e.getValue(), stringMessages))), String.join((CharSequence)", ", Util.map(replicaProcessesOnHostByReplicaSetName.entrySet(), e -> MoveAllAwayFromHostDialog.getProcessFromReplicaSetForMessage((String)e.getKey(), (SailingAnalyticsProcessDTO)e.getValue(), stringMessages))));
    }

    private static String getProcessFromReplicaSetForMessage(String replicaSetName, SailingAnalyticsProcessDTO process, StringMessages stringMessages) {
        return stringMessages.processOfReplicaSet(process.getPort(), replicaSetName);
    }

    protected ListBox getInstanceTypeListBox() {
        return this.instanceTypeListBox;
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(1, 2);
        int row = 0;
        result.setWidget(row, 0, (Widget)this.instanceTypeLabel);
        result.setWidget(row++, 1, (Widget)this.getInstanceTypeListBox());
        return result;
    }

    public Focusable getInitialFocusWidget() {
        return this.getInstanceTypeListBox();
    }

    protected String getResult() {
        return this.getInstanceTypeListBox().getSelectedValue().equals("__same_as_master__") ? null : this.getInstanceTypeListBox().getSelectedValue();
    }
}

