/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.landscape.ui.client.LandscapeDialogUtil;
import com.sap.sailing.landscape.ui.client.LandscapeManagementWriteServiceAsync;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sailing.landscape.ui.shared.MongoEndpointDTO;
import com.sap.sailing.landscape.ui.shared.MongoLaunchParametersDTO;
import com.sap.sailing.landscape.ui.shared.MongoProcessDTO;
import com.sap.sailing.landscape.ui.shared.MongoScalingInstructionsDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.TableWrapperWithMultiSelectionAndFilter;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.Arrays;
import java.util.Optional;

public class MongoScalingDialog
extends DataEntryDialog<MongoScalingInstructionsDTO> {
    private final VerticalPanel panel;
    private final TableWrapperWithMultiSelectionAndFilter<MongoProcessDTO, StringMessages, AdminConsoleTableResources> tableForChoosingInstancesToShutDown;
    private final IntegerBox numberOfInstancesToLaunchBox;
    private final IntegerBox voteBox;
    private final IntegerBox priorityBox;
    private final ListBox instanceTypeBox;
    private final String replicaSetPrimary;
    private final String replicaSetName;
    private final String DEFAULT_INSTANCE_TYPE = "I3_2_XLARGE";

    public MongoScalingDialog(MongoEndpointDTO mongoEndpointToScale, StringMessages stringMessages, ErrorReporter errorReporter, LandscapeManagementWriteServiceAsync landscapeManagementService, DataEntryDialog.DialogCallback<MongoScalingInstructionsDTO> dialogCallback) {
        super(stringMessages.scale(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new MongoScalingInstructionsValidator(stringMessages), true, dialogCallback);
        this.replicaSetName = mongoEndpointToScale.getReplicaSetName();
        this.replicaSetPrimary = String.valueOf(mongoEndpointToScale.getHostnamesAndPorts().get(0).getHostname()) + ":" + mongoEndpointToScale.getHostnamesAndPorts().get(0).getPort();
        this.panel = new VerticalPanel();
        this.tableForChoosingInstancesToShutDown = new TableWrapperWithMultiSelectionAndFilter<MongoProcessDTO, StringMessages, AdminConsoleTableResources>(stringMessages, errorReporter, false, Optional.empty(), (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class), Optional.of(hostnameAndPort -> hostnameAndPort.getPort() == 27017), Optional.empty(), stringMessages.showOnlyInstanceYouCanStop()){

            protected Iterable<String> getSearchableStrings(MongoProcessDTO t) {
                return Arrays.asList(t.getHostname(), Integer.toString(t.getPort()));
            }
        };
        ((RefreshableMultiSelectionModel)this.tableForChoosingInstancesToShutDown.getSelectionModel()).addSelectionChangeHandler(e -> this.validateAndUpdate());
        this.tableForChoosingInstancesToShutDown.addColumn(hostnameAndPort -> hostnameAndPort.getHost().getInstanceId(), stringMessages.instanceId());
        this.tableForChoosingInstancesToShutDown.addColumn(hostnameAndPort -> hostnameAndPort.getHostname(), stringMessages.hostname());
        this.tableForChoosingInstancesToShutDown.addColumn(hostnameAndPort -> Integer.toString(hostnameAndPort.getPort()), stringMessages.port());
        this.tableForChoosingInstancesToShutDown.addColumn(hostnameAndPort -> hostnameAndPort.getHost().getLaunchTimePoint().toString(), stringMessages.launchTimePoint(), (mp1, mp2) -> mp1.getHost().getLaunchTimePoint().compareTo((Object)mp2.getHost().getLaunchTimePoint()));
        this.tableForChoosingInstancesToShutDown.refresh(mongoEndpointToScale.getHostnamesAndPorts());
        this.panel.add((Widget)new Label(stringMessages.mongoInstancesToStop()));
        this.panel.add(this.tableForChoosingInstancesToShutDown);
        CaptionPanel launchPanel = new CaptionPanel(stringMessages.mongoInstancesToLaunch());
        Grid grid = new Grid(4, 2);
        int row = 0;
        grid.setWidget(row, 0, (Widget)new Label(stringMessages.numberOfMongoInstancesToLaunch()));
        this.numberOfInstancesToLaunchBox = this.createIntegerBox(0, 2);
        grid.setWidget(row++, 1, (Widget)this.numberOfInstancesToLaunchBox);
        grid.setWidget(row, 0, (Widget)new Label(stringMessages.priority()));
        this.priorityBox = this.createIntegerBox(0, 2);
        grid.setWidget(row++, 1, (Widget)this.priorityBox);
        grid.setWidget(row, 0, (Widget)new Label(stringMessages.votes()));
        this.voteBox = this.createIntegerBox(0, 2);
        grid.setWidget(row++, 1, (Widget)this.voteBox);
        grid.setWidget(row, 0, (Widget)new Label(stringMessages.instanceType()));
        this.instanceTypeBox = LandscapeDialogUtil.createInstanceTypeListBox(this, landscapeManagementService, stringMessages, "I3_2_XLARGE", errorReporter, false);
        grid.setWidget(row++, 1, (Widget)this.instanceTypeBox);
        launchPanel.add((Widget)grid);
        this.panel.add((Widget)launchPanel);
    }

    protected Widget getAdditionalWidget() {
        return this.panel;
    }

    protected MongoScalingInstructionsDTO getResult() {
        MongoLaunchParametersDTO launchParameters = new MongoLaunchParametersDTO(this.replicaSetName, this.replicaSetPrimary, this.priorityBox.getValueOrNullIfUnparsable(), this.voteBox.getValueOrNullIfUnparsable(), this.instanceTypeBox.getSelectedValue(), this.numberOfInstancesToLaunchBox.getValueOrNullIfUnparsable());
        return new MongoScalingInstructionsDTO(this.replicaSetName, ((RefreshableMultiSelectionModel)this.tableForChoosingInstancesToShutDown.getSelectionModel()).getSelectedSet(), launchParameters);
    }

    private static class MongoScalingInstructionsValidator
    implements DataEntryDialog.Validator<MongoScalingInstructionsDTO> {
        private final StringMessages stringMessages;

        public MongoScalingInstructionsValidator(StringMessages stringMessages) {
            this.stringMessages = stringMessages;
        }

        public String getErrorMessage(MongoScalingInstructionsDTO valueToValidate) {
            Iterable hostsAndPortsToShutdownOnNonDefaultPorts;
            String result = valueToValidate == null ? null : (!Util.isEmpty((Iterable)(hostsAndPortsToShutdownOnNonDefaultPorts = Util.filter(valueToValidate.getHostnamesAndPortsToShutDown(), hostnameAndPortToShutDown -> hostnameAndPortToShutDown.getPort() != 27017))) ? this.stringMessages.youCannotShutdownMongoDBInstancesNotRunningOnDefaultPort(Util.joinStrings((String)", ", (Iterable)hostsAndPortsToShutdownOnNonDefaultPorts)) : (valueToValidate.getLaunchParameters().getNumberOfInstances() == null || valueToValidate.getLaunchParameters().getNumberOfInstances() < 0 ? this.stringMessages.youHaveToProvideAPositiveNumberOfInstancesToLaunch() : (valueToValidate.getLaunchParameters().getReplicaSetPriority() == null || valueToValidate.getLaunchParameters().getReplicaSetPriority() < 0 ? this.stringMessages.youHaveToProvideANonNegativePriority() : (valueToValidate.getLaunchParameters().getReplicaSetVotes() == null || valueToValidate.getLaunchParameters().getReplicaSetVotes() < 0 ? this.stringMessages.youHaveToProvideANonNegativeNumberOfVotes() : null))));
            return result;
        }
    }
}

