/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.sap.sailing.landscape.ui.shared.SailingAnalyticsProcessDTO;
import com.sap.sailing.landscape.ui.shared.SailingApplicationReplicaSetDTO;
import com.sap.sse.common.Builder;

public class LinkBuilder
implements Builder<LinkBuilder, SafeHtml> {
    private pathModes pathMode;
    private String region;
    private String instanceId;
    private SailingApplicationReplicaSetDTO<String> replicaSet;
    private String targetGroupName;
    private String autoScalingGroupName;
    private String amiId;
    private String publicIp;
    private String privateIp;

    LinkBuilder setPathMode(pathModes mode) {
        this.pathMode = mode;
        return (LinkBuilder)this.self();
    }

    LinkBuilder setTargetGroupName(String name) {
        this.targetGroupName = name;
        return (LinkBuilder)this.self();
    }

    LinkBuilder setAutoScalingGroupName(String name) {
        this.autoScalingGroupName = name;
        return (LinkBuilder)this.self();
    }

    LinkBuilder setInstanceId(String instanceId) {
        this.instanceId = instanceId;
        return (LinkBuilder)this.self();
    }

    LinkBuilder setAmiId(String amiId) {
        this.amiId = amiId;
        return (LinkBuilder)this.self();
    }

    LinkBuilder setRegion(String region) {
        this.region = region;
        return (LinkBuilder)this.self();
    }

    LinkBuilder setPublicIp(String ip) {
        this.publicIp = ip;
        return (LinkBuilder)this.self();
    }

    LinkBuilder setPrivateIp(String ip) {
        this.privateIp = ip;
        return (LinkBuilder)this.self();
    }

    LinkBuilder setReplicaSet(SailingApplicationReplicaSetDTO<String> replicaSet) {
        this.replicaSet = replicaSet;
        return (LinkBuilder)this.self();
    }

    private String getEc2ConsoleLinkForInstanceId(String instanceId) {
        return String.valueOf(this.getEc2ConsoleBaseUrlForSelectedRegion()) + "#Instances:search=" + instanceId;
    }

    private String getEc2ConsoleLinkForInstancesUsingImageWithId(String imageId) {
        return String.valueOf(this.getEc2ConsoleBaseUrlForSelectedRegion()) + "#Instances:imageId=" + imageId;
    }

    private String getEc2ConsoleLinkForTargetGroupName(String name) {
        return String.valueOf(this.getEc2ConsoleBaseUrlForSelectedRegion()) + "#TargetGroups:search=" + name;
    }

    private String getEc2ConsoleLinkForAutoScalingGroupName(String name) {
        return String.valueOf(this.getEc2ConsoleBaseUrlForSelectedRegion()) + "#AutoScalingGroupDetails:id=" + name + ";view=details";
    }

    private String getEc2ConsoleLinkForAmiId(String amiId) {
        return String.valueOf(this.getEc2ConsoleBaseUrlForSelectedRegion()) + "#Images:visibility=owned-by-me;search=" + amiId;
    }

    private String getEc2ConsoleBaseUrlForSelectedRegion() {
        return "https://" + this.region + ".console.aws.amazon.com/ec2/v2/home?region=" + this.region;
    }

    private void appendEc2Link(SafeHtmlBuilder builder, String ec2Link, String text) {
        builder.appendHtmlConstant("<a target=\"_blank\" href=\"" + ec2Link + "\">");
        builder.appendEscaped(text);
        builder.appendHtmlConstant("</a>");
    }

    private void appendEc2InstanceLink(SafeHtmlBuilder builder, String instanceId) {
        String ec2Link = this.getEc2ConsoleLinkForInstanceId(instanceId);
        this.appendEc2Link(builder, ec2Link, instanceId);
    }

    private void appendEc2InstanceByAmiIdLink(SafeHtmlBuilder builder, String amiId) {
        String ec2Link = this.getEc2ConsoleLinkForInstancesUsingImageWithId(amiId);
        this.appendEc2Link(builder, ec2Link, amiId);
    }

    private void appendEc2AmiLink(SafeHtmlBuilder builder, String amiId) {
        String ec2Link = this.getEc2ConsoleLinkForAmiId(amiId);
        this.appendEc2Link(builder, ec2Link, amiId);
    }

    private void appendEc2TargetGroupLink(SafeHtmlBuilder builder, String name) {
        String ec2Link = this.getEc2ConsoleLinkForTargetGroupName(name);
        this.appendEc2Link(builder, ec2Link, name);
    }

    private void appendEc2AutoScalingGroupLink(SafeHtmlBuilder builder, String name) {
        String ec2Link = this.getEc2ConsoleLinkForAutoScalingGroupName(name);
        this.appendEc2Link(builder, ec2Link, name);
    }

    private String getGwtStatusLink(String host, int port) {
        return String.valueOf(port == 443 ? "https" : "http") + "://" + host + ":" + port + "/gwt/status";
    }

    private void checkAttribute(Object attr, String name) throws Exception {
        if (attr == null) {
            throw new Exception(String.valueOf(name) + " needs to be given!");
        }
    }

    public SafeHtml build() {
        SafeHtmlBuilder builder = new SafeHtmlBuilder();
        try {
            switch (this.pathMode) {
                case ReplicaLinks: {
                    this.checkAttribute(this.replicaSet, "Replicaset");
                    for (SailingAnalyticsProcessDTO replica : this.replicaSet.getReplicas()) {
                        String gwtStatusLink = this.getGwtStatusLink(replica.getHost().getPublicIpAddress(), replica.getPort());
                        builder.appendHtmlConstant("<a target=\"_blank\" href=\"" + gwtStatusLink + "\">");
                        builder.appendEscaped(String.valueOf(replica.getHost().getPublicIpAddress()) + ":" + replica.getPort());
                        builder.appendHtmlConstant("</a>");
                        String replicaInstanceId = replica.getHost().getInstanceId();
                        builder.appendEscaped(" (");
                        builder.appendEscaped(replica.getServerName());
                        builder.appendEscaped(", ");
                        this.appendEc2InstanceLink(builder, replicaInstanceId);
                        builder.appendEscaped(")");
                        builder.appendHtmlConstant("<br>");
                    }
                    break;
                }
                case AmiSearch: {
                    this.checkAttribute(this.replicaSet, "Replicaset");
                    this.checkAttribute(this.region, "Region");
                    if (this.replicaSet.getAutoScalingGroupAmiId() != null) {
                        this.appendEc2AmiLink(builder, this.replicaSet.getAutoScalingGroupAmiId());
                    }
                    break;
                }
                case Hostname: {
                    this.checkAttribute(this.replicaSet, "Replicaset");
                    String hostnameLink = "https://" + this.replicaSet.getHostname();
                    builder.appendHtmlConstant("<a target=\"_blank\" href=\"" + hostnameLink + "\">");
                    builder.appendEscaped(this.replicaSet.getHostname());
                    builder.appendHtmlConstant("</a>");
                    break;
                }
                case ImageSearch: {
                    break;
                }
                case InstanceSearch: {
                    this.checkAttribute(this.region, "Region");
                    this.appendEc2InstanceLink(builder, this.instanceId);
                    break;
                }
                case InstanceByAmiIdSearch: {
                    this.appendEc2InstanceByAmiIdLink(builder, this.amiId);
                    break;
                }
                case Version: {
                    this.checkAttribute(this.replicaSet, "Replicaset");
                    String version = this.replicaSet.getVersion();
                    String releaseNotesLink = this.replicaSet.getReleaseNotesLink();
                    this.appendEc2Link(builder, releaseNotesLink, version);
                    break;
                }
                case MasterHost: {
                    this.checkAttribute(this.replicaSet, "Replicaset");
                    String gwtStatusLink = this.getGwtStatusLink(this.replicaSet.getMaster().getHost().getPublicIpAddress(), this.replicaSet.getMaster().getPort());
                    builder.appendHtmlConstant("<a target=\"_blank\" href=\"" + gwtStatusLink + "\">");
                    builder.appendEscaped(this.replicaSet.getMaster().getHost().getPublicIpAddress());
                    builder.appendHtmlConstant("</a>");
                    break;
                }
                case TargetGroupSearch: {
                    this.checkAttribute(this.region, "Region");
                    this.checkAttribute(this.targetGroupName, "Target Group Name");
                    this.appendEc2TargetGroupLink(builder, this.targetGroupName);
                    break;
                }
                case AutoScalingGroupSearch: {
                    this.checkAttribute(this.region, "Region");
                    this.checkAttribute(this.autoScalingGroupName, "Auto-Scaling Group Name");
                    this.appendEc2AutoScalingGroupLink(builder, this.autoScalingGroupName);
                    break;
                }
                case publicIp: {
                    this.checkAttribute(this.publicIp, "Public Ip");
                    String ipLink = "http://" + this.publicIp;
                    builder.appendHtmlConstant("<a target=\"_blank\" href=\"" + ipLink + "\">");
                    builder.appendEscaped(this.publicIp);
                    builder.appendHtmlConstant("</a>");
                    break;
                }
                case privateIp: {
                    this.checkAttribute(this.privateIp, "Private Ip");
                    String privateIpLink = "http://" + this.privateIp;
                    builder.appendHtmlConstant("<a target=\"_blank\" href=\"" + privateIpLink + "\">");
                    builder.appendEscaped(this.privateIp);
                    builder.appendHtmlConstant("</a>");
                }
            }
        }
        catch (Exception e) {
            builder.appendHtmlConstant("<a target=\"_blank\" >");
            builder.appendEscaped(e.getMessage());
            builder.appendHtmlConstant("</a>");
        }
        return builder.toSafeHtml();
    }

    public static enum pathModes {
        InstanceSearch,
        InstanceByAmiIdSearch,
        ImageSearch,
        AmiSearch,
        Hostname,
        ReplicaLinks,
        Version,
        MasterHost,
        TargetGroupSearch,
        AutoScalingGroupSearch,
        publicIp,
        privateIp;

    }
}

