/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.SafeHtmlCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.DataImportProgress;
import com.sap.sailing.landscape.ui.client.AmazonMachineImagesImagesBarCell;
import com.sap.sailing.landscape.ui.client.ApplicationReplicaSetsImagesBarCell;
import com.sap.sailing.landscape.ui.client.AwsMfaLoginWidget;
import com.sap.sailing.landscape.ui.client.ChangeAutoScalingReplicaInstanceTypeDialog;
import com.sap.sailing.landscape.ui.client.CreateApplicationReplicaSetDialog;
import com.sap.sailing.landscape.ui.client.CreateReverseProxyInClusterDialog;
import com.sap.sailing.landscape.ui.client.DefineRedirectDialog;
import com.sap.sailing.landscape.ui.client.EnsureReplicaStopReplicatingRemoveMasterFromTargetGroupsDialog;
import com.sap.sailing.landscape.ui.client.LandscapeManagementWriteService;
import com.sap.sailing.landscape.ui.client.LandscapeManagementWriteServiceAsync;
import com.sap.sailing.landscape.ui.client.LinkBuilder;
import com.sap.sailing.landscape.ui.client.MongoEndpointsImagesBarCell;
import com.sap.sailing.landscape.ui.client.MongoScalingDialog;
import com.sap.sailing.landscape.ui.client.MoveAllAwayFromHostDialog;
import com.sap.sailing.landscape.ui.client.MoveMasterProcessDialog;
import com.sap.sailing.landscape.ui.client.ReverseProxyImagesBarCell;
import com.sap.sailing.landscape.ui.client.ShardManagementDialog;
import com.sap.sailing.landscape.ui.client.SshKeyManagementPanel;
import com.sap.sailing.landscape.ui.client.SwitchToReplicaOnSharedInstanceDialog;
import com.sap.sailing.landscape.ui.client.UpgradeApplicationReplicaSetDialog;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sailing.landscape.ui.shared.AmazonMachineImageDTO;
import com.sap.sailing.landscape.ui.shared.AvailabilityZoneDTO;
import com.sap.sailing.landscape.ui.shared.AwsInstanceDTO;
import com.sap.sailing.landscape.ui.shared.CompareServersResultDTO;
import com.sap.sailing.landscape.ui.shared.MongoEndpointDTO;
import com.sap.sailing.landscape.ui.shared.MongoScalingInstructionsDTO;
import com.sap.sailing.landscape.ui.shared.ProcessDTO;
import com.sap.sailing.landscape.ui.shared.ReleaseDTO;
import com.sap.sailing.landscape.ui.shared.ReverseProxyDTO;
import com.sap.sailing.landscape.ui.shared.SSHKeyPairDTO;
import com.sap.sailing.landscape.ui.shared.SailingAnalyticsProcessDTO;
import com.sap.sailing.landscape.ui.shared.SailingApplicationReplicaSetDTO;
import com.sap.sse.common.Duration;
import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.common.Util;
import com.sap.sse.common.util.NaturalComparator;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.EntryPointHelper;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.celltable.ActionsColumn;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.celltable.TableWrapperWithMultiSelectionAndFilter;
import com.sap.sse.gwt.client.celltable.TableWrapperWithSingleSelectionAndFilter;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.landscape.aws.common.shared.RedirectDTO;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.SelectedElementsCountingButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class LandscapeManagementPanel
extends SimplePanel {
    private final LandscapeManagementWriteServiceAsync landscapeManagementService;
    private final TableWrapperWithSingleSelectionAndFilter<String, StringMessages, AdminConsoleTableResources> regionsTable;
    private final TableWrapperWithSingleSelectionAndFilter<MongoEndpointDTO, StringMessages, AdminConsoleTableResources> mongoEndpointsTable;
    private final BusyIndicator mongoEndpointsBusy;
    private final TableWrapperWithSingleSelectionAndFilter<AmazonMachineImageDTO, StringMessages, AdminConsoleTableResources> machineImagesTable;
    private final BusyIndicator machineImagesBusy;
    private final SshKeyManagementPanel sshKeyManagementPanel;
    private final TableWrapperWithMultiSelectionAndFilter<SailingApplicationReplicaSetDTO<String>, StringMessages, AdminConsoleTableResources> applicationReplicaSetsTable;
    private final SimpleBusyIndicator applicationReplicaSetsBusy;
    private final ErrorReporter errorReporter;
    private final AwsMfaLoginWidget mfaLoginWidget;
    private TableWrapperWithMultiSelectionAndFilter<ReverseProxyDTO, StringMessages, AdminConsoleTableResources> proxiesTable;
    private final BusyIndicator proxiesTableBusy;
    private static final String AWS_DEFAULT_REGION_USER_PREFERENCE = "aws.region.default";
    private static final Duration DURATION_TO_WAIT_BETWEEN_REPLICA_SET_UPGRADE_REQUESTS = Duration.ONE_MINUTE;
    private static final Duration DEFAULT_DURATION_TO_WAIT_BEFORE_COMPARE_SERVERS = Duration.ONE_MINUTE.times(5L);
    private static final int DEFAULT_NUMBER_OF_COMPARE_SERVERS_ATTEMPTS = 5;
    private static final int DEFAULT_SETUPBAR_HEIGHT = 300;
    private static final int DEFAULT_AMOUNT_SSHKEYS_PER_PAGE = 3;

    public LandscapeManagementPanel(final StringMessages stringMessages, UserService userService, AdminConsoleTableResources tableResources, final ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.landscapeManagementService = this.initAndRegisterLandscapeManagementService();
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.setWidth("100%");
        this.add((Widget)mainPanel);
        HorizontalPanel awsCredentialsAndSshKeys = new HorizontalPanel();
        mainPanel.add((Widget)awsCredentialsAndSshKeys);
        CaptionPanel awsCredentialsPanel = new CaptionPanel(stringMessages.awsCredentials());
        awsCredentialsPanel.setHeight("300px");
        awsCredentialsAndSshKeys.add((Widget)awsCredentialsPanel);
        this.mfaLoginWidget = new AwsMfaLoginWidget(this.landscapeManagementService, errorReporter, userService, stringMessages);
        this.mfaLoginWidget.addListener(validSession -> this.refreshAllThatNeedsAwsCredentials());
        awsCredentialsPanel.add((Widget)this.mfaLoginWidget);
        this.regionsTable = new TableWrapperWithSingleSelectionAndFilter<String, StringMessages, AdminConsoleTableResources>(stringMessages, errorReporter, false, Optional.empty(), (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class), Optional.empty(), Optional.empty(), null){

            protected Iterable<String> getSearchableStrings(String t) {
                return Collections.singleton(t);
            }
        };
        this.sshKeyManagementPanel = new SshKeyManagementPanel(stringMessages, userService, this.landscapeManagementService, tableResources, errorReporter, this.mfaLoginWidget, (RefreshableSingleSelectionModel<String>)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()), 3);
        CaptionPanel sshKeysCaptionPanel = new CaptionPanel(stringMessages.sshKeys());
        sshKeysCaptionPanel.setHeight("300px");
        this.regionsTable.addColumn((Column)new TextColumn<String>(){

            public String getValue(String s) {
                return s;
            }
        }, stringMessages.region(), (Comparator)new NaturalComparator());
        CaptionPanel regionsCaptionPanel = new CaptionPanel(stringMessages.region());
        SimplePanel regionPanel = new SimplePanel();
        ScrollPanel regionScrollPanel = new ScrollPanel();
        regionsCaptionPanel.setHeight("300px");
        regionScrollPanel.setHeight("265px");
        regionScrollPanel.setAlwaysShowScrollBars(true);
        regionPanel.add(this.regionsTable);
        regionScrollPanel.add((Widget)regionPanel);
        regionsCaptionPanel.add((Widget)regionScrollPanel);
        awsCredentialsAndSshKeys.add((Widget)regionsCaptionPanel);
        this.refreshRegionsTable(userService);
        awsCredentialsAndSshKeys.add((Widget)sshKeysCaptionPanel);
        sshKeysCaptionPanel.add((Widget)this.sshKeyManagementPanel);
        this.mongoEndpointsTable = new TableWrapperWithSingleSelectionAndFilter<MongoEndpointDTO, StringMessages, AdminConsoleTableResources>(stringMessages, errorReporter, false, Optional.empty(), (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class), Optional.empty(), Optional.empty(), null){

            protected Iterable<String> getSearchableStrings(MongoEndpointDTO mongoEndpointDTO) {
                HashSet<String> result = new HashSet<String>();
                if (mongoEndpointDTO.getReplicaSetName() != null) {
                    result.add(mongoEndpointDTO.getReplicaSetName());
                }
                for (ProcessDTO processDTO : mongoEndpointDTO.getHostnamesAndPorts()) {
                    result.add(processDTO.getHost().getInstanceId());
                    result.add(processDTO.getHostname());
                    result.add(Integer.toString(processDTO.getPort()));
                }
                return result;
            }
        };
        this.mongoEndpointsTable.addColumn(mongoEndpointDTO -> mongoEndpointDTO.getReplicaSetName(), stringMessages.replicaSet());
        this.mongoEndpointsTable.addColumn((Column)new TextColumn<MongoEndpointDTO>(){

            public String getValue(MongoEndpointDTO mongoEndpointDTO) {
                return Util.joinStrings((String)",", (Iterable)Util.map(mongoEndpointDTO.getHostnamesAndPorts(), hostnameAndPort -> String.valueOf(hostnameAndPort.getHostname()) + ":" + hostnameAndPort.getPort() + " (" + hostnameAndPort.getHost().getInstanceId() + ")"));
            }
        }, stringMessages.hostname());
        ActionsColumn mongoEndpointsActionColumn = new ActionsColumn((ImagesBarCell)new MongoEndpointsImagesBarCell(stringMessages), (mongoEndpoint, action) -> true);
        mongoEndpointsActionColumn.addAction("SCALE", mongoEndpointToScale -> this.scaleMongoEndpoint(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), (MongoEndpointDTO)mongoEndpointToScale));
        this.mongoEndpointsTable.addColumn((Column)mongoEndpointsActionColumn, stringMessages.actions());
        final CaptionPanel mongoEndpointsCaptionPanel = new CaptionPanel(stringMessages.mongoEndpoints());
        VerticalPanel mongoEndpointsVerticalPanel = new VerticalPanel();
        mongoEndpointsCaptionPanel.add((Widget)mongoEndpointsVerticalPanel);
        mongoEndpointsVerticalPanel.add(this.mongoEndpointsTable);
        this.mongoEndpointsBusy = new SimpleBusyIndicator();
        mongoEndpointsVerticalPanel.add((Widget)this.mongoEndpointsBusy);
        mainPanel.add((Widget)mongoEndpointsCaptionPanel);
        this.applicationReplicaSetsTable = new TableWrapperWithMultiSelectionAndFilter<SailingApplicationReplicaSetDTO<String>, StringMessages, AdminConsoleTableResources>(stringMessages, errorReporter, false, Optional.of(new EntityIdentityComparator<SailingApplicationReplicaSetDTO<String>>(){

            public boolean representSameEntity(SailingApplicationReplicaSetDTO<String> dto1, SailingApplicationReplicaSetDTO<String> dto2) {
                return dto1.getName().equals(dto2.getName());
            }

            public int hashCode(SailingApplicationReplicaSetDTO<String> t) {
                return t.getName().hashCode();
            }
        }), (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class), Optional.empty(), Optional.empty(), null){

            protected Iterable<String> getSearchableStrings(SailingApplicationReplicaSetDTO<String> t) {
                HashSet<String> result = new HashSet<String>();
                result.add(t.getReplicaSetName());
                result.add(t.getMaster().getHostname());
                result.add(Integer.toString(t.getMaster().getPort()));
                result.add(t.getMaster().getServerName());
                result.add(t.getMaster().getHost().getInstanceId());
                if (t.getAutoScalingGroupAmiId() != null) {
                    result.add(t.getAutoScalingGroupAmiId());
                }
                for (SailingAnalyticsProcessDTO replica : t.getReplicas()) {
                    result.add(replica.getHostname());
                    result.add(replica.getServerName());
                    result.add(replica.getHost().getInstanceId());
                }
                return result;
            }
        };
        this.applicationReplicaSetsTable.addColumn(rs -> rs.getReplicaSetName(), stringMessages.name(), (rs1, rs2) -> rs1.getReplicaSetName().toLowerCase().compareTo(rs2.getReplicaSetName().toLowerCase()));
        SafeHtmlCell versionCell = new SafeHtmlCell();
        Column<SailingApplicationReplicaSetDTO<String>, SafeHtml> versionColumn = new Column<SailingApplicationReplicaSetDTO<String>, SafeHtml>((Cell)versionCell){

            public SafeHtml getValue(SailingApplicationReplicaSetDTO<String> replicaSet) {
                return new LinkBuilder().setReplicaSet(replicaSet).setPathMode(LinkBuilder.pathModes.Version).build();
            }
        };
        this.applicationReplicaSetsTable.addColumn((Column)versionColumn, stringMessages.versionHeader(), (rs1, rs2) -> new NaturalComparator().compare(rs1.getVersion(), rs2.getVersion()));
        SafeHtmlCell masterCell = new SafeHtmlCell();
        Column<SailingApplicationReplicaSetDTO<String>, SafeHtml> masterColumn = new Column<SailingApplicationReplicaSetDTO<String>, SafeHtml>((Cell)masterCell){

            public SafeHtml getValue(SailingApplicationReplicaSetDTO<String> replicaSet) {
                return new LinkBuilder().setPathMode(LinkBuilder.pathModes.MasterHost).setReplicaSet(replicaSet).build();
            }
        };
        this.applicationReplicaSetsTable.addColumn((Column)masterColumn, stringMessages.masterHostName(), (rs1, rs2) -> new NaturalComparator().compare(rs1.getMaster().getHost().getPublicIpAddress(), rs2.getMaster().getHost().getPublicIpAddress()));
        this.applicationReplicaSetsTable.addColumn(rs -> Integer.toString(rs.getMaster().getPort()), stringMessages.masterPort());
        SafeHtmlCell hostnameCell = new SafeHtmlCell();
        Column<SailingApplicationReplicaSetDTO<String>, SafeHtml> hostnameColumn = new Column<SailingApplicationReplicaSetDTO<String>, SafeHtml>((Cell)hostnameCell){

            public SafeHtml getValue(SailingApplicationReplicaSetDTO<String> replicaSet) {
                return new LinkBuilder().setReplicaSet(replicaSet).setPathMode(LinkBuilder.pathModes.Hostname).build();
            }
        };
        this.applicationReplicaSetsTable.addColumn((Column)hostnameColumn, stringMessages.hostname(), (rs1, rs2) -> new NaturalComparator().compare(rs1.getHostname(), rs2.getMaster().getHostname()));
        SafeHtmlCell masterInstanceIdCell = new SafeHtmlCell();
        Column<SailingApplicationReplicaSetDTO<String>, SafeHtml> masterInstanceIdColumn = new Column<SailingApplicationReplicaSetDTO<String>, SafeHtml>((Cell)masterInstanceIdCell){

            public SafeHtml getValue(SailingApplicationReplicaSetDTO<String> replicaSet) {
                return new LinkBuilder().setRegion((String)((RefreshableSingleSelectionModel)LandscapeManagementPanel.this.regionsTable.getSelectionModel()).getSelectedObject()).setInstanceId(replicaSet.getMaster().getHost().getInstanceId()).setPathMode(LinkBuilder.pathModes.InstanceSearch).build();
            }
        };
        this.applicationReplicaSetsTable.addColumn((Column)masterInstanceIdColumn, stringMessages.masterInstanceId(), (rs1, rs2) -> new NaturalComparator().compare(rs1.getMaster().getHost().getInstanceId(), rs2.getMaster().getHost().getInstanceId()));
        this.applicationReplicaSetsTable.addColumn(rs -> "" + rs.getMaster().getStartTimePoint(), stringMessages.startTimePoint(), (rs1, rs2) -> Comparator.nullsLast(Comparator.naturalOrder()).compare(rs1.getMaster().getStartTimePoint(), rs2.getMaster().getStartTimePoint()));
        SafeHtmlCell replicasCell = new SafeHtmlCell();
        Column<SailingApplicationReplicaSetDTO<String>, SafeHtml> replicasColumn = new Column<SailingApplicationReplicaSetDTO<String>, SafeHtml>((Cell)replicasCell){

            public SafeHtml getValue(SailingApplicationReplicaSetDTO<String> replicaSet) {
                LinkBuilder linkBuilder = new LinkBuilder();
                linkBuilder.setReplicaSet(replicaSet);
                linkBuilder.setPathMode(LinkBuilder.pathModes.ReplicaLinks).setRegion((String)((RefreshableSingleSelectionModel)LandscapeManagementPanel.this.regionsTable.getSelectionModel()).getSelectedObject());
                return linkBuilder.build();
            }
        };
        this.applicationReplicaSetsTable.addColumn((Column)replicasColumn, stringMessages.replicas());
        this.applicationReplicaSetsTable.addColumn(rs -> rs.getDefaultRedirectPath(), stringMessages.defaultRedirectPath());
        SafeHtmlCell autoScalingGroupAmiIdCell = new SafeHtmlCell();
        Column<SailingApplicationReplicaSetDTO<String>, SafeHtml> autoScalingGroupAmiIdColumn = new Column<SailingApplicationReplicaSetDTO<String>, SafeHtml>((Cell)autoScalingGroupAmiIdCell){

            public SafeHtml getValue(SailingApplicationReplicaSetDTO<String> replicaSet) {
                return new LinkBuilder().setReplicaSet(replicaSet).setRegion((String)((RefreshableSingleSelectionModel)LandscapeManagementPanel.this.regionsTable.getSelectionModel()).getSelectedObject()).setPathMode(LinkBuilder.pathModes.AmiSearch).build();
            }
        };
        this.applicationReplicaSetsTable.addColumn((Column)autoScalingGroupAmiIdColumn, stringMessages.machineImageId(), (rs1, rs2) -> new NaturalComparator().compare(rs1.getAutoScalingGroupAmiId(), rs2.getAutoScalingGroupAmiId()));
        ActionsColumn applicationReplicaSetsActionColumn = new ActionsColumn((ImagesBarCell)new ApplicationReplicaSetsImagesBarCell(userService, stringMessages), (applicationReplicaSet, action) -> true);
        applicationReplicaSetsActionColumn.addAction("ARCHIVE", applicationReplicaSetToArchive -> this.archiveApplicationReplicaSet(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), (SailingApplicationReplicaSetDTO<String>)applicationReplicaSetToArchive));
        applicationReplicaSetsActionColumn.addAction("UPGRADE", applicationReplicaSetToUpgrade -> this.upgradeApplicationReplicaSet(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), Collections.singleton(applicationReplicaSetToUpgrade)));
        applicationReplicaSetsActionColumn.addAction("DEFINE_LANDING_PAGE", applicationReplicaSetForWhichToDefineLandingPage -> this.defineLandingPage(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), (SailingApplicationReplicaSetDTO<String>)applicationReplicaSetForWhichToDefineLandingPage));
        applicationReplicaSetsActionColumn.addAction("CREATE_LOAD_BALANGER_MAPPING", applicationReplicaSetForWhichToDefineLoadBalancerMapping -> this.createDefaultLoadBalancerMappings(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), (SailingApplicationReplicaSetDTO<String>)applicationReplicaSetForWhichToDefineLoadBalancerMapping));
        applicationReplicaSetsActionColumn.addAction("LAUNCH_ANOTHER_REPLICA_SET_ON_THIS_MASTER", applicationReplicaSetOnWhichToDeployMaster -> this.createApplicationReplicaSetWithMasterOnExistingHost(stringMessages, (SailingApplicationReplicaSetDTO<String>)applicationReplicaSetOnWhichToDeployMaster));
        applicationReplicaSetsActionColumn.addAction(ApplicationReplicaSetsImagesBarCell.ACTION_REMOVE, applicationReplicaSetToRemove -> this.removeApplicationReplicaSet(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), (SailingApplicationReplicaSetDTO<String>)applicationReplicaSetToRemove));
        applicationReplicaSetsActionColumn.addAction("ACTION_ENSURE_ONE_REPLICA_THEN_STOP_REPLICATING_AND_REMOVE_MASTER_FROM_TARGET_GROUPS", applicationReplicaSetForWhichToEnsureAtLeastOneReplicaStopReplicatingAndRemoveMasterFromTargetGroups -> this.ensureAtLeastOneReplicaExistsStopReplicatingAndRemoveMasterFromTargetGroups(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), Collections.singleton(applicationReplicaSetForWhichToEnsureAtLeastOneReplicaStopReplicatingAndRemoveMasterFromTargetGroups)));
        applicationReplicaSetsActionColumn.addAction("ACTION_SWITCH_TO_REPLICA_ON_SHARED_INSTANCE", applicationReplicaSetToUpgrade -> this.switchToReplicaOnSharedInstance(stringMessages, Collections.singleton(applicationReplicaSetToUpgrade)));
        applicationReplicaSetsActionColumn.addAction("ACTION_SWITCH_TO_AUTO_SCALING_REPLICAS_ONLY", applicationReplicaSetToUpgrade -> this.switchToAutoScalingReplicasOnly(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), Collections.singleton(applicationReplicaSetToUpgrade)));
        applicationReplicaSetsActionColumn.addAction("ACTION_SCALE_AUTO_SCALING_REPLICAS_UP_DOWN", applicationReplicaSetToUpgrade -> this.scaleAutoScalingReplicasUpDown(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), Collections.singleton(applicationReplicaSetToUpgrade)));
        applicationReplicaSetsActionColumn.addAction("ACTION_OPEN_SHARD_MANAGEMENT", selectedReplicaSet -> this.openShardManagementPanel(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), (SailingApplicationReplicaSetDTO<String>)selectedReplicaSet, this.sshKeyManagementPanel.getSelectedKeyPair().getName(), this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null));
        applicationReplicaSetsActionColumn.addAction("ACTION_MOVE_ALL_APPLICATION_PROCESSES_AWAY_FROM", applicationReplicaSetWhoseMastersHostToDecommission -> this.moveAllApplicationProcessesAwayFrom(stringMessages, (SailingApplicationReplicaSetDTO<String>)applicationReplicaSetWhoseMastersHostToDecommission));
        final CaptionPanel applicationReplicaSetsCaptionPanel = new CaptionPanel(stringMessages.applicationReplicaSets());
        VerticalPanel applicationReplicaSetsVerticalPanel = new VerticalPanel();
        HorizontalPanel applicationReplicaSetsButtonPanel = new HorizontalPanel();
        applicationReplicaSetsVerticalPanel.add((Widget)applicationReplicaSetsButtonPanel);
        final Button applicationReplicaSetsRefreshButton = new Button(stringMessages.refresh());
        applicationReplicaSetsButtonPanel.add((Widget)applicationReplicaSetsRefreshButton);
        applicationReplicaSetsRefreshButton.addClickHandler(e -> this.refreshApplicationReplicaSetsTable());
        final Button addApplicationReplicaSetButton = new Button(stringMessages.add());
        applicationReplicaSetsButtonPanel.add((Widget)addApplicationReplicaSetButton);
        addApplicationReplicaSetButton.addClickHandler(e -> this.createApplicationReplicaSet(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject()));
        SelectedElementsCountingButton removeApplicationReplicaSetButton = new SelectedElementsCountingButton(stringMessages.remove(), (SetSelectionModel)this.applicationReplicaSetsTable.getSelectionModel(), rs -> rs.getName(), arg_0 -> ((StringMessages)StringMessages.INSTANCE).doYouReallyWantToRemoveSelectedElements(arg_0), e -> this.removeApplicationReplicaSets(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), ((RefreshableMultiSelectionModel)this.applicationReplicaSetsTable.getSelectionModel()).getSelectedSet()));
        this.disableButtonWhenLocalReplicaSetIsSelected((Button)removeApplicationReplicaSetButton, userService);
        this.disableButtonWhenArchive((Button)removeApplicationReplicaSetButton);
        applicationReplicaSetsButtonPanel.add((Widget)removeApplicationReplicaSetButton);
        SelectedElementsCountingButton upgradeApplicationReplicaSetButton = new SelectedElementsCountingButton(stringMessages.upgrade(), (SetSelectionModel)this.applicationReplicaSetsTable.getSelectionModel(), e -> this.upgradeApplicationReplicaSet(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), ((RefreshableMultiSelectionModel)this.applicationReplicaSetsTable.getSelectionModel()).getSelectedSet()));
        this.disableButtonWhenLocalReplicaSetIsSelected((Button)upgradeApplicationReplicaSetButton, userService);
        this.disableButtonWhenArchive((Button)upgradeApplicationReplicaSetButton);
        applicationReplicaSetsButtonPanel.add((Widget)upgradeApplicationReplicaSetButton);
        SelectedElementsCountingButton stopReplicatingAndUnregisterMasterButton = new SelectedElementsCountingButton(stringMessages.stopReplicating(), (SetSelectionModel)this.applicationReplicaSetsTable.getSelectionModel(), e -> this.ensureAtLeastOneReplicaExistsStopReplicatingAndRemoveMasterFromTargetGroups(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), ((RefreshableMultiSelectionModel)this.applicationReplicaSetsTable.getSelectionModel()).getSelectedSet()));
        applicationReplicaSetsButtonPanel.add((Widget)stopReplicatingAndUnregisterMasterButton);
        SelectedElementsCountingButton useOnlyAutoScalingReplicasButton = new SelectedElementsCountingButton(stringMessages.switchToAutoScalingReplicasOnly(), (SetSelectionModel)this.applicationReplicaSetsTable.getSelectionModel(), e -> this.switchToAutoScalingReplicasOnly(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), ((RefreshableMultiSelectionModel)this.applicationReplicaSetsTable.getSelectionModel()).getSelectedSet()));
        applicationReplicaSetsButtonPanel.add((Widget)useOnlyAutoScalingReplicasButton);
        SelectedElementsCountingButton useSharedInsteadOfDedicatedAutoScalingReplicasButton = new SelectedElementsCountingButton(stringMessages.switchToReplicaOnSharedInstance(), (SetSelectionModel)this.applicationReplicaSetsTable.getSelectionModel(), e -> this.switchToReplicaOnSharedInstance(stringMessages, ((RefreshableMultiSelectionModel)this.applicationReplicaSetsTable.getSelectionModel()).getSelectedSet()));
        applicationReplicaSetsButtonPanel.add((Widget)useSharedInsteadOfDedicatedAutoScalingReplicasButton);
        this.disableButtonWhenArchive((Button)useSharedInsteadOfDedicatedAutoScalingReplicasButton);
        SelectedElementsCountingButton scaleAutoScalingReplicasUpDown = new SelectedElementsCountingButton(stringMessages.scaleAutoScalingReplicasUpOrDown(), (SetSelectionModel)this.applicationReplicaSetsTable.getSelectionModel(), e -> this.scaleAutoScalingReplicasUpDown(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), ((RefreshableMultiSelectionModel)this.applicationReplicaSetsTable.getSelectionModel()).getSelectedSet()));
        this.disableButtonWhenArchive((Button)scaleAutoScalingReplicasUpDown);
        applicationReplicaSetsButtonPanel.add((Widget)scaleAutoScalingReplicasUpDown);
        applicationReplicaSetsCaptionPanel.add((Widget)applicationReplicaSetsVerticalPanel);
        applicationReplicaSetsVerticalPanel.add(this.applicationReplicaSetsTable);
        this.applicationReplicaSetsBusy = new SimpleBusyIndicator();
        applicationReplicaSetsVerticalPanel.add((Widget)this.applicationReplicaSetsBusy);
        mainPanel.add((Widget)applicationReplicaSetsCaptionPanel);
        this.machineImagesTable = new TableWrapperWithSingleSelectionAndFilter<AmazonMachineImageDTO, StringMessages, AdminConsoleTableResources>(stringMessages, errorReporter, false, Optional.empty(), (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class), Optional.of(this::isNewest), Optional.empty(), stringMessages.showNewestOnlyPerType()){

            protected Iterable<String> getSearchableStrings(AmazonMachineImageDTO t) {
                return Arrays.asList(t.getRegionId(), t.getId(), t.getName(), t.getState());
            }
        };
        SelectedElementsCountingButton updateAutoScalingReplicaAmisButton = new SelectedElementsCountingButton(stringMessages.updateAmiForAutoScalingReplicas(), (SetSelectionModel)this.applicationReplicaSetsTable.getSelectionModel(), e -> this.updateAutoScalingReplicaAmi(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), ((RefreshableMultiSelectionModel)this.applicationReplicaSetsTable.getSelectionModel()).getSelectedSet(), (AmazonMachineImageDTO)((RefreshableSingleSelectionModel)this.machineImagesTable.getSelectionModel()).getSelectedObject()));
        applicationReplicaSetsButtonPanel.add((Widget)updateAutoScalingReplicaAmisButton);
        applicationReplicaSetsActionColumn.addAction("ACTION_UPDATE_AMI_FOR_AUTO_SCALING_REPLICAS", applicationReplicaSetToUpdateAutoScalingReplicaAmiFor -> this.updateAutoScalingReplicaAmi(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), Collections.singleton(applicationReplicaSetToUpdateAutoScalingReplicaAmiFor), ((RefreshableSingleSelectionModel)this.machineImagesTable.getSelectionModel()).getSelectedObject() == null || ((AmazonMachineImageDTO)((RefreshableSingleSelectionModel)this.machineImagesTable.getSelectionModel()).getSelectedObject()).getType().equals("sailing-analytics-server") ? null : (AmazonMachineImageDTO)((RefreshableSingleSelectionModel)this.machineImagesTable.getSelectionModel()).getSelectedObject()));
        applicationReplicaSetsActionColumn.addAction("ACTION_MOVE_MASTER_TO_OTHER_INSTANCE", applicationReplicaSetToMoveMasterFor -> this.moveMasterToOtherInstance(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), Collections.singleton(applicationReplicaSetToMoveMasterFor)));
        this.applicationReplicaSetsTable.addColumn((Column)applicationReplicaSetsActionColumn, stringMessages.actions());
        SafeHtmlCell amiIdCell = new SafeHtmlCell();
        Column<AmazonMachineImageDTO, SafeHtml> amiIdColumn = new Column<AmazonMachineImageDTO, SafeHtml>((Cell)amiIdCell){

            public SafeHtml getValue(AmazonMachineImageDTO ami) {
                return new LinkBuilder().setRegion((String)((RefreshableSingleSelectionModel)LandscapeManagementPanel.this.regionsTable.getSelectionModel()).getSelectedObject()).setAmiId(ami.getId()).setPathMode(LinkBuilder.pathModes.InstanceByAmiIdSearch).build();
            }
        };
        this.machineImagesTable.addColumn((Column)amiIdColumn, stringMessages.id());
        this.machineImagesTable.addColumn(object -> object.getRegionId(), stringMessages.region());
        this.machineImagesTable.addColumn(object -> object.getName(), stringMessages.name());
        this.machineImagesTable.addColumn(object -> object.getType(), stringMessages.imageType());
        this.machineImagesTable.addColumn(object -> object.getState(), stringMessages.state());
        this.machineImagesTable.addColumn((Column)new TextColumn<AmazonMachineImageDTO>(){

            public String getValue(AmazonMachineImageDTO object) {
                return object.getCreationTimePoint().toString();
            }
        }, stringMessages.createdAt(), Comparator.nullsLast((t1, t2) -> t1.getCreationTimePoint().compareTo((Object)t2.getCreationTimePoint())));
        ActionsColumn machineImagesActionColumn = new ActionsColumn((ImagesBarCell)new AmazonMachineImagesImagesBarCell(stringMessages), (machineImage, action) -> true);
        machineImagesActionColumn.addAction(AmazonMachineImagesImagesBarCell.ACTION_REMOVE, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, machineImageToRemove -> this.removeMachineImage(stringMessages, (AmazonMachineImageDTO)machineImageToRemove));
        machineImagesActionColumn.addAction("UPGRADE", machineImageToUpgrade -> this.upgradeMachineImage(stringMessages, (AmazonMachineImageDTO)machineImageToUpgrade, this.getApplicationReplicaSetsToUpgradeAutoScalingReplicaAmisFor((AmazonMachineImageDTO)machineImageToUpgrade)));
        this.machineImagesTable.addColumn((Column)machineImagesActionColumn, stringMessages.actions());
        final CaptionPanel machineImagesCaptionPanel = new CaptionPanel(stringMessages.machineImages());
        VerticalPanel machineImagesVerticalPanel = new VerticalPanel();
        machineImagesCaptionPanel.add((Widget)machineImagesVerticalPanel);
        Button machineTableRefreshButton = new Button(stringMessages.refresh());
        machineImagesVerticalPanel.add((Widget)machineTableRefreshButton);
        machineTableRefreshButton.addClickHandler(event -> this.refreshMachineImagesTable());
        machineImagesVerticalPanel.add(this.machineImagesTable);
        this.machineImagesBusy = new SimpleBusyIndicator();
        machineImagesVerticalPanel.add((Widget)this.machineImagesBusy);
        mainPanel.add((Widget)machineImagesCaptionPanel);
        SafeHtmlCell amiForProxyCell = new SafeHtmlCell();
        SafeHtmlCell instanceIdCell = new SafeHtmlCell();
        SafeHtmlCell instancePublicIpCell = new SafeHtmlCell();
        SafeHtmlCell instancePrivateIpCell = new SafeHtmlCell();
        Column<ReverseProxyDTO, SafeHtml> amiProxyProxiesColumn = new Column<ReverseProxyDTO, SafeHtml>((Cell)amiForProxyCell){

            public SafeHtml getValue(ReverseProxyDTO proxy) {
                return new LinkBuilder().setAmiId(proxy.getImageId()).setRegion((String)((RefreshableSingleSelectionModel)LandscapeManagementPanel.this.regionsTable.getSelectionModel()).getSelectedObject()).setPathMode(LinkBuilder.pathModes.InstanceByAmiIdSearch).build();
            }
        };
        Column<ReverseProxyDTO, SafeHtml> instanceIdProxiesColumn = new Column<ReverseProxyDTO, SafeHtml>((Cell)instanceIdCell){

            public SafeHtml getValue(ReverseProxyDTO reverseProxy) {
                return new LinkBuilder().setInstanceId(reverseProxy.getInstanceId()).setRegion((String)((RefreshableSingleSelectionModel)LandscapeManagementPanel.this.regionsTable.getSelectionModel()).getSelectedObject()).setPathMode(LinkBuilder.pathModes.InstanceSearch).build();
            }
        };
        Column<ReverseProxyDTO, SafeHtml> instancePublicIpProxiesColumn = new Column<ReverseProxyDTO, SafeHtml>((Cell)instancePublicIpCell){

            public SafeHtml getValue(ReverseProxyDTO reverseProxy) {
                return new LinkBuilder().setRegion((String)((RefreshableSingleSelectionModel)LandscapeManagementPanel.this.regionsTable.getSelectionModel()).getSelectedObject()).setPathMode(LinkBuilder.pathModes.publicIp).setPublicIp(reverseProxy.getPublicIpAddress()).build();
            }
        };
        Column<ReverseProxyDTO, SafeHtml> instancePrivateIpProxiesColumn = new Column<ReverseProxyDTO, SafeHtml>((Cell)instancePrivateIpCell){

            public SafeHtml getValue(ReverseProxyDTO reverseProxy) {
                return new LinkBuilder().setRegion((String)((RefreshableSingleSelectionModel)LandscapeManagementPanel.this.regionsTable.getSelectionModel()).getSelectedObject()).setPathMode(LinkBuilder.pathModes.privateIp).setPrivateIp(reverseProxy.getPrivateIpAddress()).build();
            }
        };
        this.proxiesTable = new TableWrapperWithMultiSelectionAndFilter<ReverseProxyDTO, StringMessages, AdminConsoleTableResources>(stringMessages, errorReporter, false, Optional.empty(), (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class), Optional.empty(), Optional.empty(), null){

            protected Iterable<String> getSearchableStrings(ReverseProxyDTO reverseProxyDTO) {
                HashSet<String> result = new HashSet<String>();
                if (reverseProxyDTO.getInstanceId() != null) {
                    result.add(reverseProxyDTO.getInstanceId());
                    result.add(reverseProxyDTO.getPrivateIpAddress());
                    result.add(reverseProxyDTO.getPublicIpAddress());
                    result.add(reverseProxyDTO.getRegion());
                }
                return result;
            }
        };
        this.proxiesTable.addColumn(reverseProxyDTO -> reverseProxyDTO.getName(), stringMessages.name());
        this.proxiesTable.addColumn((Column)instanceIdProxiesColumn, stringMessages.instanceId());
        this.proxiesTable.addColumn((Column)amiProxyProxiesColumn, stringMessages.id());
        this.proxiesTable.addColumn((Column)instancePublicIpProxiesColumn, stringMessages.publicIp());
        this.proxiesTable.addColumn((Column)instancePrivateIpProxiesColumn, stringMessages.privateIp());
        this.proxiesTable.addColumn(reverseProxyDTO -> reverseProxyDTO.getAvailabilityZoneName(), stringMessages.availabilityZone());
        this.proxiesTable.addColumn(reverseProxyDTO -> reverseProxyDTO.getHealth(), stringMessages.state());
        this.proxiesTable.addColumn(reverseProxyDTO -> reverseProxyDTO.getLaunchTimePoint().toString(), stringMessages.startTimePoint(), (rp1, rp2) -> rp1.getLaunchTimePoint().compareTo((Object)rp2.getLaunchTimePoint()));
        ActionsColumn proxiesActionColumn = new ActionsColumn((ImagesBarCell)new ReverseProxyImagesBarCell(stringMessages), (revProxy, action) -> true);
        proxiesActionColumn.addAction(ReverseProxyImagesBarCell.ACTION_REMOVE, reverseProxy -> {
            if (reverseProxy.isDisposable()) {
                this.removeReverseProxy((ReverseProxyDTO)reverseProxy, reverseProxy.getRegion(), stringMessages);
            } else {
                errorReporter.reportError(stringMessages.invalidOperationForThisProxy());
            }
        });
        proxiesActionColumn.addAction("Rotate httpd logs", reverseProxy -> this.rotateHttpdLogs((ReverseProxyDTO)reverseProxy, stringMessages));
        this.proxiesTable.addColumn((Column)proxiesActionColumn, stringMessages.actions());
        final CaptionPanel proxiesTableCaptionPanel = new CaptionPanel(stringMessages.reverseProxies());
        VerticalPanel proxiesTableVerticalPanel = new VerticalPanel();
        HorizontalPanel proxiesTableButtonPanel = new HorizontalPanel();
        Button proxiesTableRefreshButton = new Button(stringMessages.refresh());
        Button proxiesTableAddButton = new Button(stringMessages.add());
        SelectedElementsCountingButton removeProxiesButton = new SelectedElementsCountingButton(stringMessages.remove(), (SetSelectionModel)this.proxiesTable.getSelectionModel(), proxy -> proxy.getName(), arg_0 -> ((StringMessages)StringMessages.INSTANCE).doYouReallyWantToRemoveSelectedElements(arg_0), e -> this.removeReverseProxies(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), ((RefreshableMultiSelectionModel)this.proxiesTable.getSelectionModel()).getSelectedSet()));
        proxiesTableRefreshButton.addClickHandler(event -> this.refreshProxiesTable());
        proxiesTableAddButton.addClickHandler(event -> this.addReverseProxyToCluster(stringMessages, (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject()));
        proxiesTableButtonPanel.add((Widget)proxiesTableRefreshButton);
        proxiesTableButtonPanel.add((Widget)proxiesTableAddButton);
        proxiesTableButtonPanel.add((Widget)removeProxiesButton);
        proxiesTableVerticalPanel.add((Widget)proxiesTableButtonPanel);
        proxiesTableVerticalPanel.add(this.proxiesTable);
        this.proxiesTableBusy = new SimpleBusyIndicator();
        proxiesTableVerticalPanel.add((Widget)this.proxiesTableBusy);
        proxiesTableCaptionPanel.add((Widget)proxiesTableVerticalPanel);
        mainPanel.add((Widget)proxiesTableCaptionPanel);
        ((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).addSelectionChangeHandler(e -> {
            String selectedRegion = (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject();
            this.refreshAllThatNeedsAwsCredentials();
            this.storeRegionSelection(userService, selectedRegion);
        });
        AsyncCallback<Boolean> validatePassphraseCallback = new AsyncCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                LandscapeManagementPanel.this.sshKeyManagementPanel.setPassphraseValidation(result, stringMessages);
                addApplicationReplicaSetButton.setVisible(result.booleanValue());
                applicationReplicaSetsRefreshButton.setVisible(result.booleanValue());
                applicationReplicaSetsCaptionPanel.setVisible(result.booleanValue());
                machineImagesCaptionPanel.setVisible(result.booleanValue());
                mongoEndpointsCaptionPanel.setVisible(result.booleanValue());
                proxiesTableCaptionPanel.setVisible(result.booleanValue());
                if (result.booleanValue()) {
                    LandscapeManagementPanel.this.refreshApplicationReplicaSetsTable();
                }
            }

            public void onFailure(Throwable caught) {
                errorReporter.reportError(stringMessages.passphraseCheckError());
            }
        };
        this.sshKeyManagementPanel.addSshKeySelectionChangedHandler(arg_0 -> this.lambda$65(stringMessages, (AsyncCallback)validatePassphraseCallback, arg_0));
        this.sshKeyManagementPanel.addOnPassphraseChangedListener(arg_0 -> this.lambda$66(stringMessages, (AsyncCallback)validatePassphraseCallback, arg_0));
        this.validatePassphrase(stringMessages, validatePassphraseCallback);
    }

    private void openShardManagementPanel(StringMessages stringMessages, String region, SailingApplicationReplicaSetDTO<String> replicaset, String optionalKeyName, byte[] privateKeyEncryptionPassphrase) {
        new ShardManagementDialog(this.landscapeManagementService, replicaset, region, this.errorReporter, stringMessages, optionalKeyName, privateKeyEncryptionPassphrase, new DataEntryDialog.DialogCallback<Boolean>(){

            public void ok(Boolean hasAnythingChanged) {
                if (hasAnythingChanged.booleanValue()) {
                    LandscapeManagementPanel.this.refreshApplicationReplicaSetsTable();
                }
            }

            public void cancel() {
            }
        }).show();
    }

    private void disableButtonWhenLocalReplicaSetIsSelected(Button button, UserService userService) {
        ((RefreshableMultiSelectionModel)this.applicationReplicaSetsTable.getSelectionModel()).addSelectionChangeHandler(e -> button.setEnabled(!((RefreshableMultiSelectionModel)this.applicationReplicaSetsTable.getSelectionModel()).getSelectedSet().stream().filter(arsDTO -> arsDTO.isLocalReplicaSet(userService)).findAny().isPresent()));
    }

    private void disableButtonWhenArchive(Button button) {
        ((RefreshableMultiSelectionModel)this.applicationReplicaSetsTable.getSelectionModel()).addSelectionChangeHandler(e -> button.setEnabled(!((RefreshableMultiSelectionModel)this.applicationReplicaSetsTable.getSelectionModel()).getSelectedSet().stream().filter(arsDTO -> arsDTO.isArchive()).findAny().isPresent()));
    }

    private void validatePassphrase(StringMessages stringMessages, AsyncCallback<Boolean> callback) {
        this.landscapeManagementService.verifyPassphrase((String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), this.sshKeyManagementPanel.getSelectedKeyPair(), this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption(), callback);
    }

    private void moveMasterToOtherInstance(final StringMessages stringMessages, String regionId, final Set<SailingApplicationReplicaSetDTO<String>> replicaSetsForWhichToMoveMaster) {
        new MoveMasterProcessDialog(this.landscapeManagementService, stringMessages, this.errorReporter, new DataEntryDialog.DialogCallback<MoveMasterProcessDialog.MoveMasterToOtherInstanceInstructions>(){

            public void ok(MoveMasterProcessDialog.MoveMasterToOtherInstanceInstructions instructions) {
                Iterator<SailingApplicationReplicaSetDTO<String>> replicaSetIterator = replicaSetsForWhichToMoveMaster.iterator();
                if (replicaSetIterator.hasNext()) {
                    LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(true);
                    this.moveMasterToOtherInstance(instructions, replicaSetIterator, stringMessages);
                }
            }

            private void moveMasterToOtherInstance(MoveMasterProcessDialog.MoveMasterToOtherInstanceInstructions instructions, Iterator<SailingApplicationReplicaSetDTO<String>> replicaSetIterator, StringMessages stringMessages2) {
                if (!$assertionsDisabled && !replicaSetIterator.hasNext()) {
                    throw new AssertionError();
                }
                SailingApplicationReplicaSetDTO<String> replicaSet = replicaSetIterator.next();
                LandscapeManagementPanel.this.landscapeManagementService.moveMasterToOtherInstance(replicaSet, instructions.isSharedMasterInstance(), instructions.getInstanceTypeOrNull(), LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair() == null ? null : LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair().getName(), LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null, instructions.getMasterReplicationBearerToken(), instructions.getReplicaReplicationBearerToken(), instructions.getOptionalMemoryInMegabytesOrNull(), instructions.getOptionalMemoryTotalSizeFactorOrNull(), new ApplicationReplicaSetActionChainingCallback<MoveMasterProcessDialog.MoveMasterToOtherInstanceInstructions>(replicaSetIterator, replicaSet, (i, sri) -> this.moveMasterToOtherInstance(instructions, replicaSetIterator, stringMessages2), instructions, replicaSetName -> stringMessages2.successfullyMovedMasterOfReplicaSet((String)replicaSetName)));
            }

            public void cancel() {
            }
        }).show();
    }

    private void switchToReplicaOnSharedInstance(final StringMessages stringMessages, final Set<SailingApplicationReplicaSetDTO<String>> selectedSet) {
        new SwitchToReplicaOnSharedInstanceDialog(stringMessages, this.errorReporter, this.landscapeManagementService, new DataEntryDialog.DialogCallback<SwitchToReplicaOnSharedInstanceDialog.SwitchToReplicaOnSharedInstanceDialogInstructions>(){

            public void ok(SwitchToReplicaOnSharedInstanceDialog.SwitchToReplicaOnSharedInstanceDialogInstructions instructions) {
                Iterator<SailingApplicationReplicaSetDTO<String>> replicaSetIterator = selectedSet.iterator();
                if (replicaSetIterator.hasNext()) {
                    LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(true);
                    this.scaleSingleAutoScalingReplicaSetUpDown(instructions, replicaSetIterator, stringMessages);
                }
            }

            private void scaleSingleAutoScalingReplicaSetUpDown(SwitchToReplicaOnSharedInstanceDialog.SwitchToReplicaOnSharedInstanceDialogInstructions instructions, Iterator<SailingApplicationReplicaSetDTO<String>> replicaSetIterator, StringMessages stringMessages2) {
                if (!$assertionsDisabled && !replicaSetIterator.hasNext()) {
                    throw new AssertionError();
                }
                SailingApplicationReplicaSetDTO<String> replicaSet = replicaSetIterator.next();
                LandscapeManagementPanel.this.landscapeManagementService.useSingleSharedInsteadOfDedicatedAutoScalingReplica(replicaSet, LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair() == null ? null : LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair().getName(), LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null, instructions.getReplicaReplicationBearerToken(), instructions.getOptionalMemoryInMegabytesOrNull(), instructions.getOptionalMemoryTotalSizeFactorOrNull(), instructions.getOptionalSharedReplicaInstanceType(), new ApplicationReplicaSetActionChainingCallback<SwitchToReplicaOnSharedInstanceDialog.SwitchToReplicaOnSharedInstanceDialogInstructions>(replicaSetIterator, replicaSet, (i, rsi) -> this.scaleSingleAutoScalingReplicaSetUpDown((SwitchToReplicaOnSharedInstanceDialog.SwitchToReplicaOnSharedInstanceDialogInstructions)i, rsi, stringMessages2), instructions, replicaSetName -> stringMessages2.successfullyCreatedReplicaSet((String)replicaSetName)));
            }

            public void cancel() {
            }
        }).show();
    }

    private void switchToAutoScalingReplicasOnly(final StringMessages stringMessages, String selectedObject, Iterable<SailingApplicationReplicaSetDTO<String>> replicaSets) {
        this.applicationReplicaSetsBusy.setBusy(true);
        final int[] count = new int[]{Util.size(replicaSets)};
        String optionalKeyName = this.sshKeyManagementPanel.getSelectedKeyPair().getName();
        byte[] privateKeyEncryptionPassphrase = this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null;
        for (final SailingApplicationReplicaSetDTO<String> replicaSet : replicaSets) {
            this.landscapeManagementService.useDedicatedAutoScalingReplicasInsteadOfShared(replicaSet, optionalKeyName, privateKeyEncryptionPassphrase, new AsyncCallback<SailingApplicationReplicaSetDTO<String>>(){

                public void onFailure(Throwable caught) {
                    LandscapeManagementPanel.this.errorReporter.reportError(stringMessages.problemSwitchingReplicaSetToAutoReplicasOnly(replicaSet.getName(), caught.getMessage()), true);
                    count[0] = count[0] - 1;
                    if (count[0] <= 0) {
                        LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                    }
                }

                public void onSuccess(SailingApplicationReplicaSetDTO<String> result) {
                    if (result != null) {
                        LandscapeManagementPanel.this.applicationReplicaSetsTable.replaceBasedOnEntityIdentityComparator(result);
                        LandscapeManagementPanel.this.applicationReplicaSetsTable.refresh();
                        Notification.notify((String)stringMessages.successfullySwitchedReplicaSetToAutoReplicasOnly(replicaSet.getName()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                    }
                    if ((count[0] = count[0] - 1) <= 0) {
                        LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                    }
                }
            });
        }
    }

    private void scaleAutoScalingReplicasUpDown(final StringMessages stringMessages, String selectedObject, final Set<SailingApplicationReplicaSetDTO<String>> selectedSet) {
        new ChangeAutoScalingReplicaInstanceTypeDialog(this.landscapeManagementService, stringMessages, this.errorReporter, new DataEntryDialog.DialogCallback<String>(){

            public void ok(String instanceTypeName) {
                Iterator<SailingApplicationReplicaSetDTO<String>> replicaSetIterator = selectedSet.iterator();
                if (replicaSetIterator.hasNext()) {
                    LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(true);
                    this.scaleSingleAutoScalingReplicaSetUpDown(instanceTypeName, replicaSetIterator, stringMessages);
                }
            }

            private void scaleSingleAutoScalingReplicaSetUpDown(String instanceTypeName, Iterator<SailingApplicationReplicaSetDTO<String>> replicaSetIterator, StringMessages stringMessages2) {
                if (!$assertionsDisabled && !replicaSetIterator.hasNext()) {
                    throw new AssertionError();
                }
                SailingApplicationReplicaSetDTO<String> replicaSet = replicaSetIterator.next();
                String optionalKeyName = LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair().getName();
                byte[] privateKeyEncryptionPassphrase = LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null;
                LandscapeManagementPanel.this.landscapeManagementService.changeAutoScalingReplicasInstanceType(replicaSet, instanceTypeName, optionalKeyName, privateKeyEncryptionPassphrase, new ApplicationReplicaSetActionChainingCallback<String>(replicaSetIterator, replicaSet, (itn, rsi) -> this.scaleSingleAutoScalingReplicaSetUpDown((String)itn, rsi, stringMessages2), instanceTypeName, replicaSetName -> stringMessages2.successfullyScaledAutoScalingReplicasForReplicaSet((String)replicaSetName)));
            }

            public void cancel() {
            }
        }).show();
    }

    private Iterable<SailingApplicationReplicaSetDTO<String>> getApplicationReplicaSetsToUpgradeAutoScalingReplicaAmisFor(AmazonMachineImageDTO amiBeingUpdated) {
        Set selection = ((RefreshableMultiSelectionModel)this.applicationReplicaSetsTable.getSelectionModel()).getSelectedSet();
        Iterable result = selection == null || selection.isEmpty() ? Util.filter((Iterable)this.applicationReplicaSetsTable.getFilterPanel().getAll(), rs -> rs.getAutoScalingGroupAmiId().equals(amiBeingUpdated.getId())) : selection;
        return result;
    }

    private void updateAutoScalingReplicaAmi(StringMessages stringMessages, String regionId, Iterable<SailingApplicationReplicaSetDTO<String>> applicationReplicaSetsToUpdateAutoScalingReplicaAmiFor, AmazonMachineImageDTO amiOrNullForLatest) {
        ArrayList<SailingApplicationReplicaSetDTO<String>> applicationReplicaSetsToUpdate = new ArrayList<SailingApplicationReplicaSetDTO<String>>();
        Util.addAll(applicationReplicaSetsToUpdateAutoScalingReplicaAmiFor, applicationReplicaSetsToUpdate);
        this.updateAutoScalingReplicaAmis(stringMessages, regionId, applicationReplicaSetsToUpdate, amiOrNullForLatest);
    }

    private void updateAutoScalingReplicaAmis(final StringMessages stringMessages, String regionId, ArrayList<SailingApplicationReplicaSetDTO<String>> applicationReplicaSetsToUpdate, AmazonMachineImageDTO amiOrNullForLatest) {
        this.applicationReplicaSetsBusy.setBusy(true);
        this.landscapeManagementService.updateImageForReplicaSets(regionId, applicationReplicaSetsToUpdate, amiOrNullForLatest, this.sshKeyManagementPanel.getSelectedKeyPair().getName(), this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null, new AsyncCallback<ArrayList<SailingApplicationReplicaSetDTO<String>>>(){

            public void onFailure(Throwable caught) {
                LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
            }

            public void onSuccess(ArrayList<SailingApplicationReplicaSetDTO<String>> result) {
                LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                for (SailingApplicationReplicaSetDTO<String> updatedReplicaSet : result) {
                    LandscapeManagementPanel.this.applicationReplicaSetsTable.replaceBasedOnEntityIdentityComparator(updatedReplicaSet);
                    Notification.notify((String)stringMessages.successfullyUpdatedMachineImageForAutoScalingReplicas(updatedReplicaSet.getName(), updatedReplicaSet.getAutoScalingGroupAmiId()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                }
                LandscapeManagementPanel.this.applicationReplicaSetsTable.refresh();
            }
        });
    }

    private void ensureAtLeastOneReplicaExistsStopReplicatingAndRemoveMasterFromTargetGroups(final StringMessages stringMessages, String selectedObject, final Iterable<SailingApplicationReplicaSetDTO<String>> applicationReplicaSetsForWhichToEnsureAtLeastOneReplicaStopReplicatingAndRemoveMasterFromTargetGroups) {
        final String selectedRegion = (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject();
        new EnsureReplicaStopReplicatingRemoveMasterFromTargetGroupsDialog(stringMessages, this.errorReporter, new DataEntryDialog.DialogCallback<String>(){

            public void ok(String replicaReplicationBearerToken) {
                LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(true);
                final int[] howManyMoreToGo = new int[]{Util.size((Iterable)applicationReplicaSetsForWhichToEnsureAtLeastOneReplicaStopReplicatingAndRemoveMasterFromTargetGroups)};
                for (final SailingApplicationReplicaSetDTO applicationReplicaSetForWhichToEnsureAtLeastOneReplicaStopReplicatingAndRemoveMasterFromTargetGroups : applicationReplicaSetsForWhichToEnsureAtLeastOneReplicaStopReplicatingAndRemoveMasterFromTargetGroups) {
                    LandscapeManagementPanel.this.landscapeManagementService.ensureAtLeastOneReplicaExistsStopReplicatingAndRemoveMasterFromTargetGroups(selectedRegion, applicationReplicaSetForWhichToEnsureAtLeastOneReplicaStopReplicatingAndRemoveMasterFromTargetGroups, LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair().getName(), LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null, replicaReplicationBearerToken, new AsyncCallback<Boolean>(){

                        public void onFailure(Throwable caught) {
                            LandscapeManagementPanel.this.decrementHowManyMoreToGoAndSetNonBusyIfDone(howManyMoreToGo);
                            LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                        }

                        public void onSuccess(Boolean result) {
                            LandscapeManagementPanel.this.decrementHowManyMoreToGoAndSetNonBusyIfDone(howManyMoreToGo);
                            Notification.notify((String)stringMessages.successfullyStoppedReplicatingAndRemovedMasterFromTargetGroups(applicationReplicaSetForWhichToEnsureAtLeastOneReplicaStopReplicatingAndRemoveMasterFromTargetGroups.getName()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                        }
                    });
                }
            }

            public void cancel() {
            }
        }).show();
    }

    private void decrementHowManyMoreToGoAndSetNonBusyIfDone(int[] howManyMoreToGo) {
        howManyMoreToGo[0] = howManyMoreToGo[0] - 1;
        if (howManyMoreToGo[0] <= 0) {
            this.applicationReplicaSetsBusy.setBusy(false);
        }
    }

    private void defineLandingPage(final StringMessages stringMessages, final String selectedRegion, final SailingApplicationReplicaSetDTO<String> applicationReplicaSetToDefineLandingPageFor) {
        if (this.sshKeyManagementPanel.getSelectedKeyPair() == null) {
            Notification.notify((String)stringMessages.pleaseSelectSshKeyPair(), (Notification.NotificationType)Notification.NotificationType.INFO);
        } else {
            new DefineRedirectDialog(applicationReplicaSetToDefineLandingPageFor, stringMessages, this.errorReporter, this.landscapeManagementService, new DataEntryDialog.DialogCallback<RedirectDTO>(){

                public void ok(final RedirectDTO redirect) {
                    LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(true);
                    LandscapeManagementPanel.this.landscapeManagementService.defineDefaultRedirect(selectedRegion, applicationReplicaSetToDefineLandingPageFor.getHostname(), redirect, LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair().getName(), LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption(), new AsyncCallback<Void>(){

                        public void onFailure(Throwable caught) {
                            LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                            LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                        }

                        public void onSuccess(Void result) {
                            LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                            String newDefaultRedirect = RedirectDTO.toString((String)redirect.getPath(), (Optional)redirect.getQuery());
                            LandscapeManagementPanel.this.applicationReplicaSetsTable.getFilterPanel().remove((Object)applicationReplicaSetToDefineLandingPageFor);
                            LandscapeManagementPanel.this.applicationReplicaSetsTable.getFilterPanel().add(new SailingApplicationReplicaSetDTO(applicationReplicaSetToDefineLandingPageFor.getReplicaSetName(), applicationReplicaSetToDefineLandingPageFor.getMaster(), applicationReplicaSetToDefineLandingPageFor.getReplicas(), applicationReplicaSetToDefineLandingPageFor.getVersion(), applicationReplicaSetToDefineLandingPageFor.getReleaseNotesLink(), applicationReplicaSetToDefineLandingPageFor.getHostname(), newDefaultRedirect, applicationReplicaSetToDefineLandingPageFor.getAutoScalingGroupAmiId()));
                            Notification.notify((String)stringMessages.successfullyUpdatedLandingPage(), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                        }
                    });
                }

                public void cancel() {
                }
            }).show();
        }
    }

    private void createApplicationReplicaSet(final StringMessages stringMessages, final String regionId) {
        this.landscapeManagementService.getReleases(new AsyncCallback<ArrayList<ReleaseDTO>>(){

            public void onFailure(Throwable caught) {
                LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
            }

            public void onSuccess(ArrayList<ReleaseDTO> result) {
                new CreateApplicationReplicaSetDialog(LandscapeManagementPanel.this.landscapeManagementService, false, result.stream().map(r -> r.getName())::iterator, stringMessages, LandscapeManagementPanel.this.errorReporter, new DataEntryDialog.DialogCallback<CreateApplicationReplicaSetDialog.CreateApplicationReplicaSetInstructions>(){

                    public void ok(final CreateApplicationReplicaSetDialog.CreateApplicationReplicaSetInstructions instructions) {
                        LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(true);
                        LandscapeManagementPanel.this.landscapeManagementService.createApplicationReplicaSet(regionId, instructions.getName(), instructions.isSharedMasterInstance(), instructions.getOptionalSharedInstanceType(), instructions.getDedicatedInstanceType(), instructions.isDynamicLoadBalancerMapping(), instructions.getReleaseNameOrNullForLatestMaster(), LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair() == null ? null : LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair().getName(), LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null, instructions.getMasterReplicationBearerToken(), instructions.getReplicaReplicationBearerToken(), instructions.getOptionalDomainName(), instructions.isFirstReplicaOnSharedInstance() ? Integer.valueOf(0) : null, null, instructions.getOptionalMemoryInMegabytesOrNull(), instructions.getOptionalMemoryTotalSizeFactorOrNull(), instructions.getOptionalIgtimiRiotPort(), new AsyncCallback<SailingApplicationReplicaSetDTO<String>>(){

                            public void onFailure(Throwable caught) {
                                LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                                LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                            }

                            public void onSuccess(SailingApplicationReplicaSetDTO<String> result) {
                                LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                                Notification.notify((String)stringMessages.successfullyCreatedReplicaSet(instructions.getName()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                                if (result != null) {
                                    LandscapeManagementPanel.this.applicationReplicaSetsTable.getFilterPanel().add(result);
                                }
                            }
                        });
                    }

                    public void cancel() {
                    }
                }, regionId.equals("eu-west-1")).show();
            }
        });
    }

    private void moveAllApplicationProcessesAwayFrom(final StringMessages stringMessages, SailingApplicationReplicaSetDTO<String> applicationReplicaSetOnWhichToDeployMaster) {
        final AwsInstanceDTO fromHost = applicationReplicaSetOnWhichToDeployMaster.getMaster().getHost();
        new MoveAllAwayFromHostDialog(this.landscapeManagementService, fromHost, this.applicationReplicaSetsTable.getDataProvider().getList(), stringMessages, this.errorReporter, new DataEntryDialog.DialogCallback<String>(){

            public void ok(String optionalInstanceTypeName) {
                LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(true);
                LandscapeManagementPanel.this.landscapeManagementService.moveAllApplicationProcessesAwayFrom(fromHost, optionalInstanceTypeName, LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair() == null ? null : LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair().getName(), LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null, new AsyncCallback<Void>(){

                    public void onFailure(Throwable caught) {
                        LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                        LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                    }

                    public void onSuccess(Void result) {
                        LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                        Notification.notify((String)stringMessages.successfullyMovedAllProcessesAwayFromHost(fromHost.getInstanceId()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                        LandscapeManagementPanel.this.refreshApplicationReplicaSetsTable();
                    }
                });
            }

            public void cancel() {
            }
        }).show();
    }

    private void createApplicationReplicaSetWithMasterOnExistingHost(final StringMessages stringMessages, final SailingApplicationReplicaSetDTO<String> applicationReplicaSetOnWhichToDeployMaster) {
        this.landscapeManagementService.getReleases(new AsyncCallback<ArrayList<ReleaseDTO>>(){

            public void onFailure(Throwable caught) {
                LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
            }

            public void onSuccess(ArrayList<ReleaseDTO> result) {
                new CreateApplicationReplicaSetDialog(LandscapeManagementPanel.this.landscapeManagementService, true, result.stream().map(r -> r.getName())::iterator, stringMessages, LandscapeManagementPanel.this.errorReporter, new DataEntryDialog.DialogCallback<CreateApplicationReplicaSetDialog.CreateApplicationReplicaSetInstructions>(){

                    public void ok(final CreateApplicationReplicaSetDialog.CreateApplicationReplicaSetInstructions instructions) {
                        LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(true);
                        LandscapeManagementPanel.this.landscapeManagementService.deployApplicationToExistingHost(instructions.getName(), applicationReplicaSetOnWhichToDeployMaster.getMaster().getHost(), instructions.getDedicatedInstanceType(), instructions.isDynamicLoadBalancerMapping(), instructions.getReleaseNameOrNullForLatestMaster(), LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair() == null ? null : LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair().getName(), LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null, instructions.getMasterReplicationBearerToken(), instructions.getReplicaReplicationBearerToken(), instructions.getOptionalDomainName(), instructions.isFirstReplicaOnSharedInstance() ? Integer.valueOf(0) : null, null, instructions.getOptionalMemoryInMegabytesOrNull(), instructions.getOptionalMemoryTotalSizeFactorOrNull(), instructions.getOptionalIgtimiRiotPort(), LandscapeManagementPanel.this.getMasterHostFromFirstSelectedApplicationReplicaSetThatIsNot(applicationReplicaSetOnWhichToDeployMaster), new AsyncCallback<SailingApplicationReplicaSetDTO<String>>(){

                            public void onFailure(Throwable caught) {
                                LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                                LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                            }

                            public void onSuccess(SailingApplicationReplicaSetDTO<String> result) {
                                LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                                Notification.notify((String)stringMessages.successfullyCreatedReplicaSet(instructions.getName()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                                if (result != null) {
                                    LandscapeManagementPanel.this.applicationReplicaSetsTable.getFilterPanel().add(result);
                                }
                            }
                        });
                    }

                    public void cancel() {
                    }
                }, ((String)((RefreshableSingleSelectionModel)LandscapeManagementPanel.this.regionsTable.getSelectionModel()).getSelectedObject()).equals("eu-west-1")).show();
            }
        });
    }

    private AwsInstanceDTO getMasterHostFromFirstSelectedApplicationReplicaSetThatIsNot(SailingApplicationReplicaSetDTO<String> applicationReplicaSetOnWhichToDeployMaster) {
        for (SailingApplicationReplicaSetDTO selectedReplicaSet : ((RefreshableMultiSelectionModel)this.applicationReplicaSetsTable.getSelectionModel()).getSelectedSet()) {
            if (selectedReplicaSet.getName().equals(applicationReplicaSetOnWhichToDeployMaster.getName())) continue;
            return selectedReplicaSet.getMaster().getHost();
        }
        return null;
    }

    private void removeApplicationReplicaSet(StringMessages stringMessages, String regionId, SailingApplicationReplicaSetDTO<String> applicationReplicaSetToRemove) {
        if (Window.confirm((String)stringMessages.reallyRemoveApplicationReplicaSet(applicationReplicaSetToRemove.getName()))) {
            this.removeApplicationReplicaSets(stringMessages, regionId, Collections.singleton(applicationReplicaSetToRemove));
        }
    }

    private void removeApplicationReplicaSets(StringMessages stringMessages, String regionId, Iterable<SailingApplicationReplicaSetDTO<String>> applicationReplicaSetsToRemove) {
        this.applicationReplicaSetsBusy.setBusy(true);
        Iterator<SailingApplicationReplicaSetDTO<String>> replicaSetIterator = applicationReplicaSetsToRemove.iterator();
        if (replicaSetIterator.hasNext()) {
            this.applicationReplicaSetsBusy.setBusy(true);
            this.removeApplicationReplicaSet(regionId, replicaSetIterator, stringMessages);
        }
    }

    private void removeApplicationReplicaSet(String regionId, Iterator<SailingApplicationReplicaSetDTO<String>> replicaSetIterator, final StringMessages stringMessages) {
        assert (replicaSetIterator.hasNext());
        final MongoEndpointDTO selectedMongoEndpointForDBArchiving = (MongoEndpointDTO)((RefreshableSingleSelectionModel)this.mongoEndpointsTable.getSelectionModel()).getSelectedObject();
        SailingApplicationReplicaSetDTO<String> applicationReplicaSetToRemove = replicaSetIterator.next();
        final ApplicationReplicaSetActionChainingCallback<String> applicationReplicaSetActionChainingCallback = new ApplicationReplicaSetActionChainingCallback<String>(replicaSetIterator, applicationReplicaSetToRemove, (rId, rsi) -> this.removeApplicationReplicaSet((String)rId, rsi, stringMessages), regionId, replicaSetName -> stringMessages.successfullyRemovedApplicationReplicaSet((String)replicaSetName));
        this.landscapeManagementService.removeApplicationReplicaSet(regionId, applicationReplicaSetToRemove, selectedMongoEndpointForDBArchiving, this.sshKeyManagementPanel.getSelectedKeyPair() == null ? null : this.sshKeyManagementPanel.getSelectedKeyPair().getName(), this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null, new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                applicationReplicaSetActionChainingCallback.onFailure(caught);
            }

            public void onSuccess(String mongoDbArchivingErrorMessage) {
                applicationReplicaSetActionChainingCallback.onSuccess(null);
                if (mongoDbArchivingErrorMessage != null) {
                    LandscapeManagementPanel.this.errorReporter.reportError(stringMessages.errorArchivingMongoDBTo(selectedMongoEndpointForDBArchiving.getReplicaSetName(), mongoDbArchivingErrorMessage));
                }
            }
        });
    }

    private void archiveApplicationReplicaSet(final StringMessages stringMessages, final String regionId, final SailingApplicationReplicaSetDTO<String> applicationReplicaSetToArchive) {
        final MongoEndpointDTO selectedMongoEndpointForDBArchiving = (MongoEndpointDTO)((RefreshableSingleSelectionModel)this.mongoEndpointsTable.getSelectionModel()).getSelectedObject();
        new DataEntryDialog<ReplicaSetArchivingParameters>(stringMessages.archive(), stringMessages.archive(), stringMessages.ok(), stringMessages.cancel(), null, (DataEntryDialog.DialogCallback)new DataEntryDialog.DialogCallback<ReplicaSetArchivingParameters>(){

            public void ok(final ReplicaSetArchivingParameters bearerTokensAndWhetherToRemoveReplicaSet) {
                LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(true);
                LandscapeManagementPanel.this.landscapeManagementService.archiveReplicaSet(regionId, applicationReplicaSetToArchive, bearerTokensAndWhetherToRemoveReplicaSet.getBearerTokenOrNullForApplicationReplicaSetToArchive(), bearerTokensAndWhetherToRemoveReplicaSet.getBearerTokenOrNullForArchive(), bearerTokensAndWhetherToRemoveReplicaSet.getDurationToWaitBeforeAndBetweenCompareServerAttempts(), bearerTokensAndWhetherToRemoveReplicaSet.getNumberOfTimesToTryCompareServers(), bearerTokensAndWhetherToRemoveReplicaSet.isRemoveApplicationReplicaSet(), selectedMongoEndpointForDBArchiving, LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair().getName(), LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null, new AsyncCallback<Util.Triple<DataImportProgress, CompareServersResultDTO, String>>(){

                    public void onFailure(Throwable caught) {
                        LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                        LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                    }

                    public void onSuccess(Util.Triple<DataImportProgress, CompareServersResultDTO, String> result) {
                        LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                        String mongoDBArchivingErrorMessage = (String)result.getC();
                        if (result == null || result.getA() == null || ((DataImportProgress)result.getA()).failed()) {
                            LandscapeManagementPanel.this.errorReporter.reportError(stringMessages.errorDuringImport(result == null || result.getA() == null ? "" : ((DataImportProgress)result.getA()).getErrorMessage()));
                        } else if (result.getB() == null) {
                            LandscapeManagementPanel.this.errorReporter.reportError(stringMessages.errorWhileComparingServerContent());
                        } else if (((CompareServersResultDTO)result.getB()).hasDiffs()) {
                            LandscapeManagementPanel.this.errorReporter.reportError(stringMessages.differencesInServerContentFound(((CompareServersResultDTO)result.getB()).getServerAName(), ((CompareServersResultDTO)result.getB()).getADiffs().toString(), ((CompareServersResultDTO)result.getB()).getServerBName(), ((CompareServersResultDTO)result.getB()).getBDiffs().toString()));
                        } else if (mongoDBArchivingErrorMessage != null) {
                            LandscapeManagementPanel.this.errorReporter.reportError(stringMessages.errorArchivingMongoDBTo(selectedMongoEndpointForDBArchiving != null ? selectedMongoEndpointForDBArchiving.getReplicaSetName() : "", mongoDBArchivingErrorMessage));
                        }
                        if (result != null && result.getA() != null && !((DataImportProgress)result.getA()).failed() && result.getB() != null && !((CompareServersResultDTO)result.getB()).hasDiffs()) {
                            if (bearerTokensAndWhetherToRemoveReplicaSet.isRemoveApplicationReplicaSet()) {
                                LandscapeManagementPanel.this.applicationReplicaSetsTable.getFilterPanel().remove((Object)applicationReplicaSetToArchive);
                            }
                            Notification.notify((String)stringMessages.successfullyArchivedReplicaSet(applicationReplicaSetToArchive.getName()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                        }
                    }
                });
            }

            public void cancel() {
            }
        }){
            private final TextBox bearerTokenOrNullForApplicationReplicaSetToArchiveBox;
            private final TextBox bearerTokenOrNullForArchiveBox;
            private final IntegerBox numberOfMinutesBeforeAndBetweenCompareServersBox;
            private final IntegerBox numberOfCompareServersAttemptsBox;
            private final CheckBox removeReplicaSetBox;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                this.bearerTokenOrNullForApplicationReplicaSetToArchiveBox = this.createTextBox("");
                this.bearerTokenOrNullForArchiveBox = this.createTextBox("");
                this.numberOfMinutesBeforeAndBetweenCompareServersBox = this.createIntegerBox((int)DEFAULT_DURATION_TO_WAIT_BEFORE_COMPARE_SERVERS.asMinutes(), 3);
                this.numberOfCompareServersAttemptsBox = this.createIntegerBox(5, 3);
                this.removeReplicaSetBox = this.createCheckbox(stringMessages2.removeArchivedReplicaSet());
            }

            protected Widget getAdditionalWidget() {
                Grid result = new Grid(5, 2);
                int row = 0;
                result.setWidget(row, 0, (Widget)new Label(stringMessages.bearerTokenOrNullForApplicationReplicaSetToArchive(applicationReplicaSetToArchive.getName())));
                result.setWidget(row++, 1, (Widget)this.bearerTokenOrNullForApplicationReplicaSetToArchiveBox);
                result.setWidget(row, 0, (Widget)new Label(stringMessages.bearerTokenOrNullForArchive()));
                result.setWidget(row++, 1, (Widget)this.bearerTokenOrNullForArchiveBox);
                result.setWidget(row, 0, (Widget)new Label(stringMessages.numberOfMinutesBeforeAndBetweenCompareServers()));
                result.setWidget(row++, 1, (Widget)this.numberOfMinutesBeforeAndBetweenCompareServersBox);
                result.setWidget(row, 0, (Widget)new Label(stringMessages.numberOfCompareServersAttempts()));
                result.setWidget(row++, 1, (Widget)this.numberOfCompareServersAttemptsBox);
                result.setWidget(row++, 0, (Widget)this.removeReplicaSetBox);
                return result;
            }

            protected Focusable getInitialFocusWidget() {
                return this.bearerTokenOrNullForApplicationReplicaSetToArchiveBox;
            }

            protected ReplicaSetArchivingParameters getResult() {
                return new ReplicaSetArchivingParameters(Util.hasLength((String)this.bearerTokenOrNullForApplicationReplicaSetToArchiveBox.getValue()) ? this.bearerTokenOrNullForApplicationReplicaSetToArchiveBox.getValue() : null, Util.hasLength((String)this.bearerTokenOrNullForArchiveBox.getValue()) ? this.bearerTokenOrNullForArchiveBox.getValue() : null, this.removeReplicaSetBox.getValue(), this.numberOfMinutesBeforeAndBetweenCompareServersBox.getValue() == null ? DEFAULT_DURATION_TO_WAIT_BEFORE_COMPARE_SERVERS : Duration.ONE_MINUTE.times((long)((Integer)this.numberOfMinutesBeforeAndBetweenCompareServersBox.getValue()).intValue()), this.numberOfCompareServersAttemptsBox.getValue() == null ? 5 : (Integer)this.numberOfCompareServersAttemptsBox.getValue());
            }
        }.show();
    }

    private void createDefaultLoadBalancerMappings(final StringMessages stringMessages, final String regionId, final SailingApplicationReplicaSetDTO<String> applicationReplicaSetToCreateLoadBalancerMappingFor) {
        new DataEntryDialog<Util.Triple<Boolean, String, Boolean>>(stringMessages.createLoadBalancerMapping(), stringMessages.createLoadBalancerMapping(), stringMessages.ok(), stringMessages.cancel(), null, (DataEntryDialog.DialogCallback)new DataEntryDialog.DialogCallback<Util.Triple<Boolean, String, Boolean>>(){

            public void ok(Util.Triple<Boolean, String, Boolean> useDynamicLoadBalancerAndOptionalDomainNameAndForceDNSUpdate) {
                LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(true);
                LandscapeManagementPanel.this.landscapeManagementService.createDefaultLoadBalancerMappings(regionId, applicationReplicaSetToCreateLoadBalancerMappingFor, (Boolean)useDynamicLoadBalancerAndOptionalDomainNameAndForceDNSUpdate.getA(), (String)useDynamicLoadBalancerAndOptionalDomainNameAndForceDNSUpdate.getB(), (Boolean)useDynamicLoadBalancerAndOptionalDomainNameAndForceDNSUpdate.getC(), new AsyncCallback<SailingApplicationReplicaSetDTO<String>>(){

                    public void onFailure(Throwable caught) {
                        LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                        LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                    }

                    public void onSuccess(SailingApplicationReplicaSetDTO<String> result) {
                        LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                        LandscapeManagementPanel.this.applicationReplicaSetsTable.getFilterPanel().remove((Object)applicationReplicaSetToCreateLoadBalancerMappingFor);
                        LandscapeManagementPanel.this.applicationReplicaSetsTable.getFilterPanel().add(result);
                        Notification.notify((String)stringMessages.successfullyCreatedLoadBalancerMappingFor(applicationReplicaSetToCreateLoadBalancerMappingFor.getName()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                    }
                });
            }

            public void cancel() {
            }
        }){
            private final CheckBox useDynamicLoadBalancerCheckbox;
            private final TextBox optionalDomainNameBox;
            private final CheckBox forceDNSUpdateCheckbox;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                this.useDynamicLoadBalancerCheckbox = this.createCheckbox(stringMessages2.useDynamicLoadBalancer());
                this.optionalDomainNameBox = this.createTextBox("sapsailing.com");
                this.forceDNSUpdateCheckbox = this.createCheckbox(stringMessages2.forceDNSUpdate());
            }

            protected Widget getAdditionalWidget() {
                VerticalPanel result = new VerticalPanel();
                result.add((Widget)this.useDynamicLoadBalancerCheckbox);
                HorizontalPanel domainNamePanel = new HorizontalPanel();
                result.add((Widget)domainNamePanel);
                domainNamePanel.add((Widget)new Label(stringMessages.domainName()));
                domainNamePanel.add((Widget)this.optionalDomainNameBox);
                result.add((Widget)this.forceDNSUpdateCheckbox);
                return result;
            }

            protected Focusable getInitialFocusWidget() {
                return this.useDynamicLoadBalancerCheckbox;
            }

            protected Util.Triple<Boolean, String, Boolean> getResult() {
                return new Util.Triple((Object)this.useDynamicLoadBalancerCheckbox.getValue(), (Object)(Util.hasLength((String)this.optionalDomainNameBox.getValue()) ? this.optionalDomainNameBox.getValue() : null), (Object)this.forceDNSUpdateCheckbox.getValue());
            }
        }.show();
    }

    private void upgradeApplicationReplicaSet(final StringMessages stringMessages, final String regionId, final Iterable<SailingApplicationReplicaSetDTO<String>> replicaSets) {
        this.landscapeManagementService.getReleases(new AsyncCallback<ArrayList<ReleaseDTO>>(){

            public void onFailure(Throwable caught) {
                LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
            }

            public void onSuccess(ArrayList<ReleaseDTO> result) {
                new UpgradeApplicationReplicaSetDialog(LandscapeManagementPanel.this.landscapeManagementService, result.stream().map(r -> r.getName())::iterator, stringMessages, LandscapeManagementPanel.this.errorReporter, new DataEntryDialog.DialogCallback<UpgradeApplicationReplicaSetDialog.UpgradeApplicationReplicaSetInstructions>(){

                    public void ok(final UpgradeApplicationReplicaSetDialog.UpgradeApplicationReplicaSetInstructions upgradeInstructions) {
                        LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(true);
                        final int[] howManyMoreToGo = new int[]{Util.size((Iterable)replicaSets)};
                        Duration timeToWaitUntilUpgradingNextReplicaSet = Duration.NULL;
                        for (final SailingApplicationReplicaSetDTO replicaSet : replicaSets) {
                            new Timer(){

                                public void run() {
                                    LandscapeManagementPanel.this.landscapeManagementService.upgradeApplicationReplicaSet(regionId, replicaSet, upgradeInstructions.getReleaseNameOrNullForLatestMaster(), LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair() == null ? null : LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair().getName(), LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? LandscapeManagementPanel.this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null, upgradeInstructions.getReplicaReplicationBearerToken(), new AsyncCallback<SailingApplicationReplicaSetDTO<String>>(){

                                        public void onFailure(Throwable caught) {
                                            LandscapeManagementPanel.this.decrementHowManyMoreToGoAndSetNonBusyIfDone(howManyMoreToGo);
                                            LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                                        }

                                        public void onSuccess(SailingApplicationReplicaSetDTO<String> result) {
                                            LandscapeManagementPanel.this.decrementHowManyMoreToGoAndSetNonBusyIfDone(howManyMoreToGo);
                                            if (result != null) {
                                                Notification.notify((String)stringMessages.successfullyUpgradedApplicationReplicaSet(result.getName(), result.getVersion()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                                                LandscapeManagementPanel.this.applicationReplicaSetsTable.replaceBasedOnEntityIdentityComparator(result);
                                                LandscapeManagementPanel.this.applicationReplicaSetsTable.refresh();
                                            } else {
                                                Notification.notify((String)stringMessages.upgradingApplicationReplicaSetFailed(replicaSet.getName()), (Notification.NotificationType)Notification.NotificationType.ERROR);
                                            }
                                        }
                                    });
                                }
                            }.schedule((int)timeToWaitUntilUpgradingNextReplicaSet.asMillis());
                            timeToWaitUntilUpgradingNextReplicaSet = timeToWaitUntilUpgradingNextReplicaSet.plus(DURATION_TO_WAIT_BETWEEN_REPLICA_SET_UPGRADE_REQUESTS);
                        }
                    }

                    public void cancel() {
                    }
                }).show();
            }
        });
    }

    private void refreshRegionsTable(final UserService userService) {
        this.landscapeManagementService.getRegions(new AsyncCallback<ArrayList<String>>(){

            public void onFailure(Throwable caught) {
                LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
            }

            public void onSuccess(ArrayList<String> regions) {
                LandscapeManagementPanel.this.regionsTable.refresh(regions);
                userService.getPreference(LandscapeManagementPanel.AWS_DEFAULT_REGION_USER_PREFERENCE, (AsyncCallback)new AsyncCallback<String>(){

                    public void onFailure(Throwable caught) {
                        GWT.log((String)("Couldn't obtain aws.region.default preference for user " + userService.getCurrentUser().getName()));
                    }

                    public void onSuccess(String defaultRegion) {
                        LandscapeManagementPanel.this.regionsTable.getFilterPanel().search(defaultRegion);
                        ((RefreshableSingleSelectionModel)LandscapeManagementPanel.this.regionsTable.getSelectionModel()).setSelected((Object)defaultRegion, true);
                    }
                });
            }
        });
    }

    private void refreshAllThatNeedsAwsCredentials() {
        this.refreshMongoEndpointsTable();
        this.refreshApplicationReplicaSetsTable();
        this.refreshMachineImagesTable();
        this.refreshProxiesTable();
        this.sshKeyManagementPanel.showKeysInRegion(this.mfaLoginWidget.hasValidSessionCredentials() ? (String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject() : null);
    }

    private void removeReverseProxies(StringMessages stringMessages, String regionId, Iterable<ReverseProxyDTO> reverseProxiesToRemove) {
        Iterator<ReverseProxyDTO> iterator = reverseProxiesToRemove.iterator();
        while (iterator.hasNext()) {
            this.removeReverseProxy(iterator.next(), regionId, stringMessages);
        }
    }

    private void removeReverseProxy(ReverseProxyDTO instance, String regionId, StringMessages stringMessages) {
        if (this.sshKeyManagementPanel.getSelectedKeyPair() == null) {
            Notification.notify((String)stringMessages.pleaseSelectSshKeyPair(), (Notification.NotificationType)Notification.NotificationType.INFO);
        } else {
            this.proxiesTableBusy.setBusy(true);
            this.landscapeManagementService.removeReverseProxy(instance, regionId, this.sshKeyManagementPanel.getSelectedKeyPair().getName(), this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null, new AsyncCallback<Void>(){

                public void onFailure(Throwable caught) {
                    LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                    LandscapeManagementPanel.this.proxiesTableBusy.setBusy(false);
                }

                public void onSuccess(Void result) {
                    LandscapeManagementPanel.this.proxiesTableBusy.setBusy(false);
                    LandscapeManagementPanel.this.refreshProxiesTable();
                }
            });
        }
    }

    private void addReverseProxyToCluster(final StringMessages stringMessages, final String region) {
        if (this.sshKeyManagementPanel.getSelectedKeyPair() == null || ((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject() == null) {
            Notification.notify((String)stringMessages.pleaseSelectSshKeyPair(), (Notification.NotificationType)Notification.NotificationType.INFO);
        } else {
            this.landscapeManagementService.describeAvailabilityZones((String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), new AsyncCallback<ArrayList<AvailabilityZoneDTO>>(){

                public void onSuccess(ArrayList<AvailabilityZoneDTO> result) {
                    LandscapeManagementPanel.this.showReverseProxyDialog(stringMessages, region, result);
                }

                public void onFailure(Throwable caught) {
                    LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                }
            });
        }
    }

    private void showReverseProxyDialog(final StringMessages stringMessages, String region, ArrayList<AvailabilityZoneDTO> availabilityZones) {
        new CreateReverseProxyInClusterDialog(stringMessages, this.errorReporter, this.landscapeManagementService, region, this.proxiesTable.getTable().getVisibleItems(), availabilityZones, new DataEntryDialog.DialogCallback<CreateReverseProxyInClusterDialog.CreateReverseProxyInstructions>(){

            public void ok(CreateReverseProxyInClusterDialog.CreateReverseProxyInstructions editedObject) {
                editedObject.setKey(LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair() == null ? null : LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair().getName());
                LandscapeManagementPanel.this.proxiesTableBusy.setBusy(true);
                LandscapeManagementPanel.this.landscapeManagementService.addReverseProxy(editedObject.getName(), editedObject.getInstanceType(), editedObject.getRegion(), editedObject.getKey(), editedObject.getAvailabilityZoneDTO(), new AsyncCallback<Void>(){

                    public void onSuccess(Void result) {
                        Notification.notify((String)stringMessages.unlockedSuccessfully(), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                        LandscapeManagementPanel.this.proxiesTableBusy.setBusy(false);
                        LandscapeManagementPanel.this.refreshProxiesTable();
                    }

                    public void onFailure(Throwable caught) {
                        LandscapeManagementPanel.this.proxiesTableBusy.setBusy(false);
                        LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                    }
                });
            }

            public void cancel() {
            }
        }).show();
    }

    private void refreshProxiesTable() {
        this.proxiesTable.getFilterPanel().removeAll();
        if (this.mfaLoginWidget.hasValidSessionCredentials() && ((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject() != null) {
            this.proxiesTableBusy.setBusy(true);
            this.landscapeManagementService.getReverseProxies((String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), new AsyncCallback<ArrayList<ReverseProxyDTO>>(){

                public void onFailure(Throwable caught) {
                    LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                    LandscapeManagementPanel.this.proxiesTableBusy.setBusy(false);
                }

                public void onSuccess(ArrayList<ReverseProxyDTO> reverseProxyDTOs) {
                    LandscapeManagementPanel.this.proxiesTable.refresh(reverseProxyDTOs);
                    LandscapeManagementPanel.this.proxiesTableBusy.setBusy(false);
                }
            });
        }
    }

    private void rotateHttpdLogs(final ReverseProxyDTO reverseProxy, final StringMessages stringMessages) {
        if (this.sshKeyManagementPanel.getSelectedKeyPair() == null) {
            Notification.notify((String)stringMessages.pleaseSelectSshKeyPair(), (Notification.NotificationType)Notification.NotificationType.INFO);
        } else {
            this.landscapeManagementService.rotateHttpdLogs(reverseProxy, reverseProxy.getRegion(), this.sshKeyManagementPanel.getSelectedKeyPair().getName(), this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption() != null ? this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes() : null, new AsyncCallback<Void>(){

                public void onFailure(Throwable caught) {
                    LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                }

                public void onSuccess(Void result) {
                    Notification.notify((String)stringMessages.successfullyRotatedHttpdLogsOnInstance(reverseProxy.getInstanceId()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                }
            });
        }
    }

    private void storeRegionSelection(UserService userService, String selectedRegion) {
        if (selectedRegion != null) {
            userService.setPreference(AWS_DEFAULT_REGION_USER_PREFERENCE, selectedRegion, (AsyncCallback)new AsyncCallback<Void>(){

                public void onFailure(Throwable caught) {
                }

                public void onSuccess(Void result) {
                }
            });
        }
    }

    private void scaleMongoEndpoint(final StringMessages stringMessages, final String selectedRegion, MongoEndpointDTO mongoEndpointToScale) {
        if (this.sshKeyManagementPanel.getSelectedKeyPair() == null) {
            Notification.notify((String)stringMessages.pleaseSelectSshKeyPair(), (Notification.NotificationType)Notification.NotificationType.INFO);
        } else {
            new MongoScalingDialog(mongoEndpointToScale, stringMessages, this.errorReporter, this.landscapeManagementService, new DataEntryDialog.DialogCallback<MongoScalingInstructionsDTO>(){

                public void ok(MongoScalingInstructionsDTO mongoScalingInstructions) {
                    LandscapeManagementPanel.this.mongoEndpointsBusy.setBusy(true);
                    LandscapeManagementPanel.this.landscapeManagementService.scaleMongo(selectedRegion, mongoScalingInstructions, LandscapeManagementPanel.this.sshKeyManagementPanel.getSelectedKeyPair().getName(), new AsyncCallback<Void>(){

                        public void onFailure(Throwable caught) {
                            LandscapeManagementPanel.this.mongoEndpointsBusy.setBusy(false);
                            LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                        }

                        public void onSuccess(Void result) {
                            LandscapeManagementPanel.this.mongoEndpointsBusy.setBusy(false);
                            Notification.notify((String)stringMessages.successfullyScaledMongoDB(), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                            LandscapeManagementPanel.this.refreshMongoEndpointsTable();
                        }
                    });
                }

                public void cancel() {
                }
            }).show();
        }
    }

    private boolean isNewest(AmazonMachineImageDTO ami) {
        Comparator timePointComparator = Comparator.nullsLast(Comparator.reverseOrder());
        Comparator imageByTimePointComparator = (i1, i2) -> timePointComparator.compare(i1.getCreationTimePoint(), i2.getCreationTimePoint());
        return ami.getCreationTimePoint().equals(this.machineImagesTable.getDataProvider().getList().stream().filter(imageFromTable -> imageFromTable.getType().equals(ami.getType())).sorted(imageByTimePointComparator).findFirst().get().getCreationTimePoint());
    }

    private void refreshMongoEndpointsTable() {
        this.mongoEndpointsTable.getFilterPanel().removeAll();
        if (this.mfaLoginWidget.hasValidSessionCredentials() && ((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject() != null) {
            this.mongoEndpointsBusy.setBusy(true);
            this.landscapeManagementService.getMongoEndpoints((String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), new AsyncCallback<ArrayList<MongoEndpointDTO>>(){

                public void onFailure(Throwable caught) {
                    LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                    LandscapeManagementPanel.this.mongoEndpointsBusy.setBusy(false);
                }

                public void onSuccess(ArrayList<MongoEndpointDTO> mongoEndpointDTOs) {
                    LandscapeManagementPanel.this.mongoEndpointsTable.refresh(mongoEndpointDTOs);
                    LandscapeManagementPanel.this.mongoEndpointsBusy.setBusy(false);
                }
            });
        }
    }

    private void refreshApplicationReplicaSetsTable() {
        this.applicationReplicaSetsTable.getFilterPanel().removeAll();
        if (this.mfaLoginWidget.hasValidSessionCredentials() && ((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject() != null && Util.hasLength((String)this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption())) {
            this.applicationReplicaSetsBusy.setBusy(true);
            SSHKeyPairDTO selectedSshKeyPair = this.sshKeyManagementPanel.getSelectedKeyPair();
            this.landscapeManagementService.getApplicationReplicaSets((String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), selectedSshKeyPair == null ? null : selectedSshKeyPair.getName(), this.sshKeyManagementPanel.getPassphraseForPrivateKeyDecryption().getBytes(), new AsyncCallback<ArrayList<SailingApplicationReplicaSetDTO<String>>>(){

                public void onFailure(Throwable caught) {
                    LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                    LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                }

                public void onSuccess(ArrayList<SailingApplicationReplicaSetDTO<String>> applicationReplicaSetDTOs) {
                    LandscapeManagementPanel.this.applicationReplicaSetsTable.refresh(applicationReplicaSetDTOs);
                    LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
                }
            });
        }
    }

    private void refreshMachineImagesTable() {
        this.machineImagesTable.getFilterPanel().removeAll();
        if (this.mfaLoginWidget.hasValidSessionCredentials() && ((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject() != null) {
            this.machineImagesBusy.setBusy(true);
            this.landscapeManagementService.getAmazonMachineImages((String)((RefreshableSingleSelectionModel)this.regionsTable.getSelectionModel()).getSelectedObject(), new AsyncCallback<ArrayList<AmazonMachineImageDTO>>(){

                public void onFailure(Throwable caught) {
                    LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                    LandscapeManagementPanel.this.machineImagesBusy.setBusy(false);
                }

                public void onSuccess(ArrayList<AmazonMachineImageDTO> machineImagesDTOs) {
                    LandscapeManagementPanel.this.machineImagesTable.refresh(machineImagesDTOs);
                    LandscapeManagementPanel.this.machineImagesBusy.setBusy(false);
                }
            });
        }
    }

    private void upgradeMachineImage(final StringMessages stringMessages, final AmazonMachineImageDTO machineImageToUpgrade, final Iterable<SailingApplicationReplicaSetDTO<String>> selectedApplicationReplicaSetsToUpdate) {
        Notification.notify((String)stringMessages.startedImageUpgrade(machineImageToUpgrade.getName(), machineImageToUpgrade.getId(), machineImageToUpgrade.getRegionId()), (Notification.NotificationType)Notification.NotificationType.INFO);
        this.machineImagesBusy.setBusy(true);
        this.landscapeManagementService.upgradeAmazonMachineImage(machineImageToUpgrade.getRegionId(), machineImageToUpgrade.getId(), new AsyncCallback<AmazonMachineImageDTO>(){

            public void onFailure(Throwable caught) {
                LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                LandscapeManagementPanel.this.machineImagesBusy.setBusy(false);
            }

            public void onSuccess(AmazonMachineImageDTO result) {
                LandscapeManagementPanel.this.machineImagesBusy.setBusy(false);
                LandscapeManagementPanel.this.refreshMachineImagesTable();
                Notification.notify((String)stringMessages.successfullyUpgradedMachineImage(machineImageToUpgrade.getName(), machineImageToUpgrade.getId(), machineImageToUpgrade.getRegionId(), result.getName()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                if (Util.equalsWithNull((Object)result.getType(), (Object)"sailing-analytics-server") && selectedApplicationReplicaSetsToUpdate != null && !Util.isEmpty((Iterable)selectedApplicationReplicaSetsToUpdate) && Window.confirm((String)stringMessages.updateSelectedReplicaSetAmisToo(Util.join((String)", ", (Iterable)selectedApplicationReplicaSetsToUpdate)))) {
                    LandscapeManagementPanel.this.updateAutoScalingReplicaAmi(stringMessages, machineImageToUpgrade.getRegionId(), selectedApplicationReplicaSetsToUpdate, result);
                }
            }
        });
    }

    private void removeMachineImage(final StringMessages stringMessages, final AmazonMachineImageDTO machineImageToRemove) {
        if (Window.confirm((String)stringMessages.doYouReallyWantToRemoveMachineImage(machineImageToRemove.getName(), machineImageToRemove.getId(), machineImageToRemove.getRegionId()))) {
            this.landscapeManagementService.removeAmazonMachineImage(machineImageToRemove.getRegionId(), machineImageToRemove.getId(), new AsyncCallback<Void>(){

                public void onFailure(Throwable caught) {
                    LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage());
                }

                public void onSuccess(Void result) {
                    LandscapeManagementPanel.this.machineImagesTable.remove((Object)machineImageToRemove);
                    Notification.notify((String)stringMessages.successfullyRemovedMachineImage(machineImageToRemove.getName(), machineImageToRemove.getId(), machineImageToRemove.getRegionId()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                }
            });
        }
    }

    private LandscapeManagementWriteServiceAsync initAndRegisterLandscapeManagementService() {
        LandscapeManagementWriteServiceAsync result = (LandscapeManagementWriteServiceAsync)GWT.create(LandscapeManagementWriteService.class);
        EntryPointHelper.registerASyncService((ServiceDefTarget)((ServiceDefTarget)result), (String)"service/landscape", (Util.Pair[])new Util.Pair[]{HttpRequestHeaderConstants.HEADER_FORWARD_TO_MASTER});
        return result;
    }

    private /* synthetic */ void lambda$65(StringMessages stringMessages, AsyncCallback asyncCallback, SelectionChangeEvent event) {
        this.validatePassphrase(stringMessages, (AsyncCallback<Boolean>)asyncCallback);
    }

    private /* synthetic */ void lambda$66(StringMessages stringMessages, AsyncCallback asyncCallback, ChangeEvent event) {
        this.validatePassphrase(stringMessages, (AsyncCallback<Boolean>)asyncCallback);
    }

    private class ApplicationReplicaSetActionChainingCallback<INSTRUCTIONS>
    implements AsyncCallback<SailingApplicationReplicaSetDTO<String>> {
        private final Iterator<SailingApplicationReplicaSetDTO<String>> replicaSetIterator;
        private final SailingApplicationReplicaSetDTO<String> replicaSet;
        private final ApplicationReplicaSetChainingAction<INSTRUCTIONS> action;
        private final INSTRUCTIONS instructions;
        private final Function<String, String> successMessageSupplier;

        public ApplicationReplicaSetActionChainingCallback(Iterator<SailingApplicationReplicaSetDTO<String>> replicaSetIterator, SailingApplicationReplicaSetDTO<String> replicaSet, ApplicationReplicaSetChainingAction<INSTRUCTIONS> action, INSTRUCTIONS instructions, Function<String, String> successMessageSupplier) {
            this.replicaSetIterator = replicaSetIterator;
            this.replicaSet = replicaSet;
            this.action = action;
            this.instructions = instructions;
            this.successMessageSupplier = successMessageSupplier;
        }

        public void onFailure(Throwable caught) {
            LandscapeManagementPanel.this.errorReporter.reportError(caught.getMessage() == null ? caught.getClass().getName() : caught.getMessage());
            if (!this.replicaSetIterator.hasNext()) {
                LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
            } else {
                this.action.run(this.instructions, this.replicaSetIterator);
            }
        }

        public void onSuccess(SailingApplicationReplicaSetDTO<String> result) {
            Notification.notify((String)this.successMessageSupplier.apply(this.replicaSet.getName()), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
            if (result != null) {
                LandscapeManagementPanel.this.applicationReplicaSetsTable.replaceBasedOnEntityIdentityComparator(result);
            } else {
                LandscapeManagementPanel.this.applicationReplicaSetsTable.remove(this.replicaSet);
            }
            if (!this.replicaSetIterator.hasNext()) {
                LandscapeManagementPanel.this.applicationReplicaSetsBusy.setBusy(false);
            } else {
                this.action.run(this.instructions, this.replicaSetIterator);
            }
        }
    }

    private static interface ApplicationReplicaSetChainingAction<INSTRUCTIONS> {
        public void run(INSTRUCTIONS var1, Iterator<SailingApplicationReplicaSetDTO<String>> var2);
    }

    private static class ReplicaSetArchivingParameters {
        private final String bearerTokenOrNullForApplicationReplicaSetToArchive;
        private final String bearerTokenOrNullForArchive;
        private final boolean removeApplicationReplicaSet;
        private final Duration durationToWaitBeforeAndBetweenCompareServerAttempts;
        private final int numberOfTimesToTryCompareServers;

        public ReplicaSetArchivingParameters(String bearerTokenOrNullForApplicationReplicaSetToArchive, String bearerTokenOrNullForArchive, boolean removeApplicationReplicaSet, Duration durationToWaitBeforeAndBetweenCompareServerAttempts, int numberOfTimesToTryCompareServers) {
            this.bearerTokenOrNullForApplicationReplicaSetToArchive = bearerTokenOrNullForApplicationReplicaSetToArchive;
            this.bearerTokenOrNullForArchive = bearerTokenOrNullForArchive;
            this.removeApplicationReplicaSet = removeApplicationReplicaSet;
            this.durationToWaitBeforeAndBetweenCompareServerAttempts = durationToWaitBeforeAndBetweenCompareServerAttempts;
            this.numberOfTimesToTryCompareServers = numberOfTimesToTryCompareServers;
        }

        public String getBearerTokenOrNullForApplicationReplicaSetToArchive() {
            return this.bearerTokenOrNullForApplicationReplicaSetToArchive;
        }

        public String getBearerTokenOrNullForArchive() {
            return this.bearerTokenOrNullForArchive;
        }

        public boolean isRemoveApplicationReplicaSet() {
            return this.removeApplicationReplicaSet;
        }

        public Duration getDurationToWaitBeforeAndBetweenCompareServerAttempts() {
            return this.durationToWaitBeforeAndBetweenCompareServerAttempts;
        }

        public int getNumberOfTimesToTryCompareServers() {
            return this.numberOfTimesToTryCompareServers;
        }
    }
}

