/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.landscape.ui.client.AbstractApplicationReplicaSetDialog;
import com.sap.sailing.landscape.ui.client.LandscapeDialogUtil;
import com.sap.sailing.landscape.ui.client.LandscapeManagementWriteServiceAsync;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.controls.IntegerBox;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;

public class CreateApplicationReplicaSetDialog
extends AbstractApplicationReplicaSetDialog<CreateApplicationReplicaSetInstructions> {
    private final StringMessages stringMessages;
    private final boolean useExistingSharedMasterInstance;
    private final TextBox nameBox;
    private final CheckBox sharedMasterInstanceBox;
    private final CheckBox startWithReplicaOnSharedInstanceBox;
    private final ListBox dedicatedInstanceTypeListBox;
    private final Label dedicatedInstanceTypeLabel;
    private final ListBox sharedInstanceTypeListBox;
    private final Label sharedInstanceTypeLabel;
    private final CheckBox dynamicLoadBalancerCheckBox;
    private final TextBox domainNameBox;
    private final IntegerBox memoryInMegabytesBox;
    private final IntegerBox memoryTotalSizeFactorBox;
    private final IntegerBox igtimiRiotPortBox;
    private boolean memoryAsFactorToTotalMemoryAdjusted;

    public CreateApplicationReplicaSetDialog(LandscapeManagementWriteServiceAsync landscapeManagementService, boolean useExistingSharedMasterInstance, Iterable<String> releaseNames, StringMessages stringMessages, ErrorReporter errorReporter, DataEntryDialog.DialogCallback<CreateApplicationReplicaSetInstructions> callback, boolean mayUseDynamicLoadBalancer) {
        super(stringMessages.createApplicationReplicaSet(), landscapeManagementService, releaseNames, stringMessages, errorReporter, new Validator(stringMessages, landscapeManagementService), callback);
        this.stringMessages = stringMessages;
        this.useExistingSharedMasterInstance = useExistingSharedMasterInstance;
        this.nameBox = this.createTextBox("", 40);
        this.dynamicLoadBalancerCheckBox = mayUseDynamicLoadBalancer ? this.createCheckbox(stringMessages.useDynamicLoadBalancer()) : null;
        this.domainNameBox = this.createTextBox("sapsailing.com", 40);
        this.dedicatedInstanceTypeListBox = LandscapeDialogUtil.createInstanceTypeListBox(this, landscapeManagementService, stringMessages, "C5_2_XLARGE", errorReporter, false);
        this.dedicatedInstanceTypeLabel = new Label();
        this.sharedInstanceTypeListBox = LandscapeDialogUtil.createInstanceTypeListBox(this, landscapeManagementService, stringMessages, "I3_2_XLARGE", errorReporter, false);
        this.sharedInstanceTypeLabel = new Label();
        this.memoryInMegabytesBox = this.createIntegerBox(null, 7);
        this.memoryTotalSizeFactorBox = this.createIntegerBox(null, 2);
        this.memoryTotalSizeFactorBox.addValueChangeHandler(e -> {
            boolean bl = this.memoryAsFactorToTotalMemoryAdjusted = true;
        });
        if (useExistingSharedMasterInstance) {
            this.memoryTotalSizeFactorBox.setValue((Object)4);
        }
        this.memoryInMegabytesBox.addValueChangeHandler(e -> this.memoryTotalSizeFactorBox.setEnabled(e.getValue() == null));
        this.igtimiRiotPortBox = this.createIntegerBox(null, 10);
        this.igtimiRiotPortBox.getElement().setAttribute("placeholder", stringMessages.examplePort(6000));
        this.startWithReplicaOnSharedInstanceBox = this.createCheckbox(stringMessages.firstReplicaOnSharedInstance());
        this.startWithReplicaOnSharedInstanceBox.addValueChangeHandler(e -> this.updateInstanceTypesBasedOnSharedMasterInstanceBox());
        this.startWithReplicaOnSharedInstanceBox.setValue(Boolean.valueOf(useExistingSharedMasterInstance));
        this.sharedMasterInstanceBox = this.createCheckbox(stringMessages.sharedMasterInstance());
        this.sharedMasterInstanceBox.addValueChangeHandler(e -> this.updateInstanceTypesBasedOnSharedMasterInstanceBox());
        this.sharedMasterInstanceBox.setValue(Boolean.valueOf(useExistingSharedMasterInstance));
        this.sharedMasterInstanceBox.setEnabled(!useExistingSharedMasterInstance);
        this.updateInstanceTypesBasedOnSharedMasterInstanceBox();
        this.validateAndUpdate();
    }

    private void updateInstanceTypesBasedOnSharedMasterInstanceBox() {
        this.dedicatedInstanceTypeLabel.setText(this.sharedMasterInstanceBox.getValue() != false ? this.stringMessages.autoScalingReplicaInstanceType() : this.stringMessages.dedicatedMasterAndAutoScalingReplicaInstanceType());
        if (this.sharedMasterInstanceBox.getValue().booleanValue()) {
            if (this.startWithReplicaOnSharedInstanceBox.getValue().booleanValue()) {
                this.setVisibilityOfSharedInstanceTypeSelection(true);
                this.sharedInstanceTypeLabel.setText(this.useExistingSharedMasterInstance ? this.stringMessages.sharedReplicaInstanceType() : this.stringMessages.sharedMasterAndReplicaInstanceType());
            } else {
                this.setVisibilityOfSharedInstanceTypeSelection(!this.useExistingSharedMasterInstance);
                this.sharedInstanceTypeLabel.setText(this.stringMessages.sharedMasterInstanceType());
            }
        } else if (this.startWithReplicaOnSharedInstanceBox.getValue().booleanValue()) {
            this.setVisibilityOfSharedInstanceTypeSelection(true);
            this.sharedInstanceTypeLabel.setText(this.stringMessages.sharedReplicaInstanceType());
        } else {
            this.setVisibilityOfSharedInstanceTypeSelection(false);
        }
        if (!this.memoryAsFactorToTotalMemoryAdjusted) {
            if (this.sharedMasterInstanceBox.getValue().booleanValue() || this.startWithReplicaOnSharedInstanceBox.getValue().booleanValue()) {
                this.memoryTotalSizeFactorBox.setValue((Object)4);
            } else {
                this.memoryTotalSizeFactorBox.setText("");
            }
        }
    }

    private void setVisibilityOfSharedInstanceTypeSelection(boolean show) {
        this.sharedInstanceTypeLabel.setVisible(show);
        this.sharedInstanceTypeListBox.setVisible(show);
    }

    protected ListBox getDedicatedInstanceTypeListBox() {
        return this.dedicatedInstanceTypeListBox;
    }

    protected ListBox getSharedInstanceTypeListBox() {
        return this.sharedInstanceTypeListBox;
    }

    protected CheckBox getStartWithReplicaOnSharedInstanceBox() {
        return this.startWithReplicaOnSharedInstanceBox;
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(13, 2);
        int row = 0;
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.name()));
        result.setWidget(row++, 1, (Widget)this.nameBox);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.release()));
        result.setWidget(row++, 1, (Widget)this.getReleaseNameBox());
        if (!this.useExistingSharedMasterInstance) {
            result.setWidget(row, 0, (Widget)new Label(this.stringMessages.sharedMasterInstance()));
            result.setWidget(row++, 1, (Widget)this.sharedMasterInstanceBox);
        }
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.firstReplicaOnSharedInstance()));
        result.setWidget(row++, 1, (Widget)this.getStartWithReplicaOnSharedInstanceBox());
        result.setWidget(row, 0, (Widget)this.dedicatedInstanceTypeLabel);
        result.setWidget(row++, 1, (Widget)this.getDedicatedInstanceTypeListBox());
        result.setWidget(row, 0, (Widget)this.sharedInstanceTypeLabel);
        result.setWidget(row++, 1, (Widget)this.getSharedInstanceTypeListBox());
        if (this.dynamicLoadBalancerCheckBox != null) {
            result.setWidget(row, 0, (Widget)new Label(this.stringMessages.useDynamicLoadBalancer()));
            result.setWidget(row++, 1, (Widget)this.dynamicLoadBalancerCheckBox);
        }
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.bearerTokenForSecurityReplication()));
        result.setWidget(row++, 1, (Widget)this.getMasterReplicationBearerTokenBox());
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.replicaReplicationBearerToken()));
        result.setWidget(row++, 1, (Widget)this.getReplicaReplicationBearerTokenBox());
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.domainName()));
        result.setWidget(row++, 1, (Widget)this.domainNameBox);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.memoryInMegabytes()));
        result.setWidget(row++, 1, (Widget)this.memoryInMegabytesBox);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.memoryTotalSizeFactor()));
        result.setWidget(row++, 1, (Widget)this.memoryTotalSizeFactorBox);
        result.setWidget(row, 0, (Widget)new Label(this.stringMessages.igtimiRiotPort()));
        result.setWidget(row++, 1, (Widget)this.igtimiRiotPortBox);
        return result;
    }

    public FocusWidget getInitialFocusWidget() {
        return this.nameBox;
    }

    protected CreateApplicationReplicaSetInstructions getResult() {
        return new CreateApplicationReplicaSetInstructions(this.nameBox.getValue(), this.sharedMasterInstanceBox.getValue(), this.getDedicatedInstanceTypeListBox().getSelectedValue(), this.getSharedInstanceTypeListBox().getSelectedValue(), this.getReleaseNameBoxValue(), this.dynamicLoadBalancerCheckBox == null ? false : this.dynamicLoadBalancerCheckBox.getValue(), this.getMasterReplicationBearerTokenBox().getValue(), this.getReplicaReplicationBearerTokenBox().getValue(), this.domainNameBox.getValue(), (Integer)this.memoryInMegabytesBox.getValue(), (Integer)this.memoryTotalSizeFactorBox.getValue(), (Integer)this.igtimiRiotPortBox.getValue(), this.startWithReplicaOnSharedInstanceBox.getValue());
    }

    public static class CreateApplicationReplicaSetInstructions
    extends AbstractApplicationReplicaSetDialog.AbstractApplicationReplicaSetInstructions {
        private final String name;
        private final boolean sharedMasterInstance;
        private final String dedicatedInstanceType;
        private final String optionalSharedInstanceType;
        private final boolean dynamicLoadBalancerMapping;
        private final String optionalDomainName;
        private final Integer optionalMemoryInMegabytesOrNull;
        private final Integer optionalMemoryTotalSizeFactorOrNull;
        private final Integer optionalIgtimiRiotPort;
        private final boolean firstReplicaOnSharedInstance;

        public CreateApplicationReplicaSetInstructions(String name, boolean sharedMasterInstance, String dedicatedInstanceType, String optionalSharedInstanceType, String releaseNameOrNullForLatestMaster, boolean dynamicLoadBalancerMapping, String masterReplicationBearerToken, String replicaReplicationBearerToken, String optionalDomainName, Integer optionalMemoryInMegabytesOrNull, Integer optionalMemoryTotalSizeFactorOrNull, Integer optionalIgtimiRiotPort, boolean firstReplicaOnSharedInstance) {
            super(releaseNameOrNullForLatestMaster, masterReplicationBearerToken, replicaReplicationBearerToken);
            this.name = name;
            this.sharedMasterInstance = sharedMasterInstance;
            this.dynamicLoadBalancerMapping = dynamicLoadBalancerMapping;
            this.optionalDomainName = Util.hasLength((String)optionalDomainName) ? optionalDomainName : null;
            this.dedicatedInstanceType = dedicatedInstanceType;
            this.optionalSharedInstanceType = optionalSharedInstanceType;
            this.optionalMemoryInMegabytesOrNull = optionalMemoryInMegabytesOrNull;
            this.optionalMemoryTotalSizeFactorOrNull = optionalMemoryTotalSizeFactorOrNull;
            this.firstReplicaOnSharedInstance = firstReplicaOnSharedInstance;
            this.optionalIgtimiRiotPort = optionalIgtimiRiotPort;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSharedMasterInstance() {
            return this.sharedMasterInstance;
        }

        public boolean isDynamicLoadBalancerMapping() {
            return this.dynamicLoadBalancerMapping;
        }

        public String getOptionalDomainName() {
            return this.optionalDomainName;
        }

        public String getDedicatedInstanceType() {
            return this.dedicatedInstanceType;
        }

        public String getOptionalSharedInstanceType() {
            return this.optionalSharedInstanceType;
        }

        public Integer getOptionalMemoryInMegabytesOrNull() {
            return this.optionalMemoryInMegabytesOrNull;
        }

        public Integer getOptionalMemoryTotalSizeFactorOrNull() {
            return this.optionalMemoryTotalSizeFactorOrNull;
        }

        public Integer getOptionalIgtimiRiotPort() {
            return this.optionalIgtimiRiotPort;
        }

        public boolean isFirstReplicaOnSharedInstance() {
            return this.firstReplicaOnSharedInstance;
        }
    }

    private static class Validator
    implements DataEntryDialog.Validator<CreateApplicationReplicaSetInstructions> {
        private final StringMessages stringMessages;
        private final LandscapeManagementWriteServiceAsync landscapeManagementService;

        public Validator(StringMessages stringMessages, LandscapeManagementWriteServiceAsync landscapeManagementService) {
            this.stringMessages = stringMessages;
            this.landscapeManagementService = landscapeManagementService;
        }

        public void validate(CreateApplicationReplicaSetInstructions valueToValidate, final AsyncCallback<String> callback, AsyncActionsExecutor validationExecutor) {
            String localErrorMessage = this.getErrorMessage(valueToValidate);
            if (localErrorMessage != null) {
                validationExecutor.execute(cb -> cb.onSuccess((Object)localErrorMessage), "validation", callback);
            } else {
                this.landscapeManagementService.hasDNSResourceRecordsForReplicaSet(valueToValidate.getName(), valueToValidate.getOptionalDomainName(), new AsyncCallback<Boolean>(){

                    public void onFailure(Throwable caught) {
                        callback.onFailure(caught);
                    }

                    public void onSuccess(Boolean hasDNSResourceRecordsForReplicaSet) {
                        if (hasDNSResourceRecordsForReplicaSet.booleanValue()) {
                            callback.onSuccess((Object)stringMessages.dnsNameAlreadyInUse());
                        } else {
                            callback.onSuccess(null);
                        }
                    }
                });
            }
        }

        public String getErrorMessage(CreateApplicationReplicaSetInstructions valueToValidate) {
            String result = !Util.hasLength((String)valueToValidate.getDedicatedInstanceType()) ? this.stringMessages.pleaseSelectInstanceTypeForNewMaster() : (!Util.hasLength((String)valueToValidate.getName()) ? this.stringMessages.pleaseProvideApplicationReplicaSetName() : null);
            return result;
        }
    }
}

