/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.text.shared.SafeHtmlRenderer;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sailing.landscape.ui.shared.SailingApplicationReplicaSetDTO;
import com.sap.sse.gwt.client.IconResources;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.ui.client.UserService;
import java.util.ArrayList;

public class ApplicationReplicaSetsImagesBarCell
extends ImagesBarCell {
    static final String ACTION_REMOVE = HasPermissions.DefaultActions.DELETE.name();
    static final String ACTION_UPGRADE = "UPGRADE";
    static final String ACTION_ARCHIVE = "ARCHIVE";
    static final String ACTION_DEFINE_LANDING_PAGE = "DEFINE_LANDING_PAGE";
    static final String ACTION_CREATE_LOAD_BALANCER_MAPPING = "CREATE_LOAD_BALANGER_MAPPING";
    static final String ACTION_LAUNCH_ANOTHER_REPLICA_SET_ON_THIS_MASTER = "LAUNCH_ANOTHER_REPLICA_SET_ON_THIS_MASTER";
    static final String ACTION_ENSURE_ONE_REPLICA_THEN_STOP_REPLICATING_AND_REMOVE_MASTER_FROM_TARGET_GROUPS = "ACTION_ENSURE_ONE_REPLICA_THEN_STOP_REPLICATING_AND_REMOVE_MASTER_FROM_TARGET_GROUPS";
    static final String ACTION_UPDATE_AMI_FOR_AUTO_SCALING_REPLICAS = "ACTION_UPDATE_AMI_FOR_AUTO_SCALING_REPLICAS";
    static final String ACTION_SWITCH_TO_AUTO_SCALING_REPLICAS_ONLY = "ACTION_SWITCH_TO_AUTO_SCALING_REPLICAS_ONLY";
    static final String ACTION_SWITCH_TO_REPLICA_ON_SHARED_INSTANCE = "ACTION_SWITCH_TO_REPLICA_ON_SHARED_INSTANCE";
    static final String ACTION_MOVE_MASTER_TO_OTHER_INSTANCE = "ACTION_MOVE_MASTER_TO_OTHER_INSTANCE";
    static final String ACTION_SCALE_AUTO_SCALING_REPLICAS_UP_DOWN = "ACTION_SCALE_AUTO_SCALING_REPLICAS_UP_DOWN";
    static final String ACTION_OPEN_SHARD_MANAGEMENT = "ACTION_OPEN_SHARD_MANAGEMENT";
    static final String ACTION_MOVE_ALL_APPLICATION_PROCESSES_AWAY_FROM = "ACTION_MOVE_ALL_APPLICATION_PROCESSES_AWAY_FROM";
    private final StringMessages stringMessages;
    private final UserService userService;

    public ApplicationReplicaSetsImagesBarCell(UserService userService, StringMessages stringMessages) {
        this.stringMessages = stringMessages;
        this.userService = userService;
    }

    public ApplicationReplicaSetsImagesBarCell(SafeHtmlRenderer<String> renderer, UserService userService, StringMessages stringMessages) {
        this(userService, stringMessages);
    }

    protected Iterable<ImagesBarCell.ImageSpec> getImageSpecs() {
        SailingApplicationReplicaSetDTO applicationReplicaSet = (SailingApplicationReplicaSetDTO)this.getContext().getKey();
        ArrayList<ImagesBarCell.ImageSpec> result = new ArrayList<ImagesBarCell.ImageSpec>();
        if (!applicationReplicaSet.isLocalReplicaSet(this.userService) && !applicationReplicaSet.isArchive()) {
            result.add(new ImagesBarCell.ImageSpec((ImagesBarCell)this, ACTION_ARCHIVE, this.stringMessages.archive(), IconResources.INSTANCE.archiveIcon()));
            result.add(new ImagesBarCell.ImageSpec((ImagesBarCell)this, ACTION_REMOVE, this.stringMessages.remove(), IconResources.INSTANCE.removeIcon()));
        }
        if (!applicationReplicaSet.isArchive()) {
            result.add(new ImagesBarCell.ImageSpec((ImagesBarCell)this, ACTION_DEFINE_LANDING_PAGE, this.stringMessages.defineLandingPage(), IconResources.INSTANCE.editIcon()));
        }
        result.add(new ImagesBarCell.ImageSpec((ImagesBarCell)this, ACTION_CREATE_LOAD_BALANCER_MAPPING, this.stringMessages.createLoadBalancerMapping(), IconResources.INSTANCE.loadBalancerIcon()));
        result.add(new ImagesBarCell.ImageSpec((ImagesBarCell)this, ACTION_LAUNCH_ANOTHER_REPLICA_SET_ON_THIS_MASTER, this.stringMessages.launchAnotherReplicaSetOnThisMaster(), IconResources.INSTANCE.launchAnotherReplicaSetOnThisMasterIcon()));
        if (!applicationReplicaSet.isLocalReplicaSet(this.userService) && !applicationReplicaSet.isArchive()) {
            result.add(new ImagesBarCell.ImageSpec((ImagesBarCell)this, ACTION_UPGRADE, this.stringMessages.upgrade(), IconResources.INSTANCE.refreshIcon()));
        }
        if (!applicationReplicaSet.isArchive()) {
            result.add(new ImagesBarCell.ImageSpec((ImagesBarCell)this, ACTION_ENSURE_ONE_REPLICA_THEN_STOP_REPLICATING_AND_REMOVE_MASTER_FROM_TARGET_GROUPS, this.stringMessages.ensureAtLeastOneReplicaExistsStopReplicatingAndRemoveMasterFromTargetGroups(), IconResources.INSTANCE.unlinkIcon()));
        }
        if (applicationReplicaSet.getAutoScalingGroupAmiId() != null) {
            result.add(new ImagesBarCell.ImageSpec((ImagesBarCell)this, ACTION_UPDATE_AMI_FOR_AUTO_SCALING_REPLICAS, this.stringMessages.updateAmiForAutoScalingReplicas(), IconResources.INSTANCE.redGearsIcon()));
            result.add(new ImagesBarCell.ImageSpec((ImagesBarCell)this, ACTION_SWITCH_TO_AUTO_SCALING_REPLICAS_ONLY, this.stringMessages.switchToAutoScalingReplicasOnly(), IconResources.INSTANCE.scaleUpIcon()));
            result.add(new ImagesBarCell.ImageSpec((ImagesBarCell)this, ACTION_OPEN_SHARD_MANAGEMENT, this.stringMessages.openShardManagement(), IconResources.INSTANCE.shardManagementIcon()));
        }
        if (!applicationReplicaSet.isArchive()) {
            result.add(new ImagesBarCell.ImageSpec((ImagesBarCell)this, ACTION_SWITCH_TO_REPLICA_ON_SHARED_INSTANCE, this.stringMessages.switchToReplicaOnSharedInstance(), IconResources.INSTANCE.scaleDownIcon()));
        }
        if (!applicationReplicaSet.isLocalReplicaSet(this.userService) && !applicationReplicaSet.isArchive()) {
            result.add(new ImagesBarCell.ImageSpec((ImagesBarCell)this, ACTION_MOVE_MASTER_TO_OTHER_INSTANCE, this.stringMessages.moveMasterToOtherInstance(), IconResources.INSTANCE.moveIcon()));
        }
        if (!applicationReplicaSet.isArchive()) {
            result.add(new ImagesBarCell.ImageSpec((ImagesBarCell)this, ACTION_SCALE_AUTO_SCALING_REPLICAS_UP_DOWN, this.stringMessages.scaleAutoScalingReplicasUpOrDown(), IconResources.INSTANCE.scaleIcon()));
        }
        if (applicationReplicaSet.getMaster().getHost().isShared()) {
            result.add(new ImagesBarCell.ImageSpec((ImagesBarCell)this, ACTION_MOVE_ALL_APPLICATION_PROCESSES_AWAY_FROM, this.stringMessages.moveAllApplicationProcessesAwayFromMaster(), IconResources.INSTANCE.moveAway()));
        }
        return result;
    }
}

