/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.fileupload.FileUploadWithLocalFileContent;

public class AddSshKeyDialog
extends DataEntryDialog<Util.Triple<String, String, String>> {
    private final TextBox keyPairNameBox;
    private final TextArea publicKeyArea;
    private final TextArea privateKeyArea;
    private final FileUpload publicKeyFileChooser;
    private final FileUpload privateKeyFileChooser;
    private final StringMessages stringMessages;

    public AddSshKeyDialog(final StringMessages stringMessages, DataEntryDialog.DialogCallback<Util.Triple<String, String, String>> callback) {
        super(stringMessages.sshKeys(), stringMessages.sshKeys(), stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new DataEntryDialog.Validator<Util.Triple<String, String, String>>(){

            public String getErrorMessage(Util.Triple<String, String, String> valueToValidate) {
                if (!Util.hasLength((String)((String)valueToValidate.getA()))) {
                    return stringMessages.pleaseProvideKeyPairName();
                }
                if (!Util.hasLength((String)((String)valueToValidate.getB()))) {
                    return stringMessages.pleaseProvidePublicKey();
                }
                if (!Util.hasLength((String)((String)valueToValidate.getC()))) {
                    return stringMessages.pleaseProvidePrivateKey();
                }
                return null;
            }
        }, callback);
        this.stringMessages = stringMessages;
        this.keyPairNameBox = this.createTextBox("", 20);
        this.publicKeyArea = this.createTextArea("");
        this.publicKeyArea.setCharacterWidth(80);
        this.publicKeyArea.setHeight("5em");
        this.privateKeyArea = this.createTextArea("");
        this.privateKeyArea.setCharacterWidth(80);
        this.privateKeyArea.setHeight("5em");
        this.publicKeyFileChooser = new FileUpload();
        this.copyFileContentsToTextAreaUponSelection(this.publicKeyFileChooser, this.publicKeyArea);
        this.privateKeyFileChooser = new FileUpload();
        this.copyFileContentsToTextAreaUponSelection(this.privateKeyFileChooser, this.privateKeyArea);
    }

    private void copyFileContentsToTextAreaUponSelection(FileUpload fileUploadToTakeFileFrom, TextArea textAreaToCopyFileContentsTo) {
        FileUploadWithLocalFileContent fuwlfc = new FileUploadWithLocalFileContent(fileUploadToTakeFileFrom);
        fileUploadToTakeFileFrom.addChangeHandler(e -> {
            if (fileUploadWithLocalFileContent.getFileList().length == 1) {
                fuwlfc.getFileContents(0, contents -> {
                    textAreaToCopyFileContentsTo.setText(new String(contents));
                    this.validateAndUpdate();
                });
            }
        });
    }

    protected Widget getAdditionalWidget() {
        FormPanel result = new FormPanel();
        VerticalPanel verticalPanel = new VerticalPanel();
        result.add((Widget)verticalPanel);
        verticalPanel.add((Widget)new Label(this.stringMessages.name()));
        verticalPanel.add((Widget)this.keyPairNameBox);
        verticalPanel.add((Widget)new Label(this.stringMessages.publicKey()));
        verticalPanel.add((Widget)this.publicKeyFileChooser);
        verticalPanel.add((Widget)this.publicKeyArea);
        verticalPanel.add((Widget)new Label(this.stringMessages.privateKey()));
        verticalPanel.add((Widget)this.privateKeyFileChooser);
        verticalPanel.add((Widget)this.privateKeyArea);
        return result;
    }

    protected Focusable getInitialFocusWidget() {
        return this.keyPairNameBox;
    }

    protected Util.Triple<String, String, String> getResult() {
        return new Util.Triple((Object)this.keyPairNameBox.getValue(), (Object)this.publicKeyArea.getValue(), (Object)this.privateKeyArea.getValue());
    }
}

