/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.expeditionconnector.impl;

import com.sap.sailing.expeditionconnector.ExpeditionMessage;
import com.sap.sailing.expeditionconnector.UDPExpeditionReceiver;
import com.sap.sailing.expeditionconnector.impl.ExpeditionMessageImpl;
import com.sap.sailing.udpconnector.UDPMessageParser;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.net.DatagramPacket;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpeditionMessageParser
implements UDPMessageParser<ExpeditionMessage> {
    private static final Logger logger = Logger.getLogger(ExpeditionMessageParser.class.getName());
    private UDPExpeditionReceiver receiver;

    public ExpeditionMessageParser(UDPExpeditionReceiver receiver) {
        this.receiver = receiver;
    }

    public ExpeditionMessage parse(DatagramPacket p) {
        String packetAsString = new String(p.getData(), p.getOffset(), p.getLength()).trim().replaceAll(" ", "");
        if (packetAsString.length() > 0) {
            Pattern completeLinePattern = Pattern.compile("#([0-9]*)((,([0-9][0-9]*),(-?[0-9]*(\\.[0-9]*)?))*)\\*X?([0-9a-fA-F][0-9a-fA-F]*)");
            Matcher m = completeLinePattern.matcher(packetAsString);
            boolean valid = m.matches();
            if (valid) {
                int boatID = Integer.valueOf(m.group(1));
                String variableValuePairs = m.group(2).trim().substring(",".length());
                HashMap<Integer, Double> values = new HashMap<Integer, Double>();
                String[] variablesAndValuesInterleaved = variableValuePairs.split(",");
                long now = System.currentTimeMillis();
                Long diff = this.receiver.getLastKnownMessageDelayInMillis(boatID);
                MillisecondsTimePoint defaultForMessageTimePoint = diff != null ? new MillisecondsTimePoint(now - diff) : null;
                int i = 0;
                while (i < variablesAndValuesInterleaved.length) {
                    int variableID = Integer.valueOf(variablesAndValuesInterleaved[i++]);
                    double variableValue = Double.valueOf(variablesAndValuesInterleaved[i]);
                    values.put(variableID, variableValue);
                    ++i;
                }
                int checksum = Integer.valueOf(m.group(m.groupCount()), 16);
                valid = valid && this.checksumOk(checksum, packetAsString);
                ExpeditionMessageImpl result = defaultForMessageTimePoint == null ? new ExpeditionMessageImpl(boatID, values, valid, packetAsString) : new ExpeditionMessageImpl(boatID, values, valid, (TimePoint)defaultForMessageTimePoint, packetAsString);
                if (result.hasValue(146)) {
                    this.receiver.updateLastKnownMessageDelay(boatID, now - result.getTimePoint().asMillis());
                }
                return result;
            }
            logger.warning("Unparsable expedition message: " + packetAsString);
            return null;
        }
        return null;
    }

    private boolean checksumOk(int checksum, String packetAsString) {
        int b = this.computeChecksum(packetAsString);
        return b == checksum;
    }

    int computeChecksum(String packetAsString) {
        int b = 0;
        int posOfLastCharToAddToChecksum = packetAsString.lastIndexOf(42);
        if (packetAsString.length() > posOfLastCharToAddToChecksum && packetAsString.charAt(posOfLastCharToAddToChecksum + 1) == 'X') {
            ++posOfLastCharToAddToChecksum;
        }
        String checksumString = packetAsString.substring(0, posOfLastCharToAddToChecksum);
        byte[] byArray = checksumString.getBytes();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte stringByte = byArray[n2];
            b ^= stringByte;
            ++n2;
        }
        return b;
    }
}

