/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication;

import com.sap.sse.common.Duration;
import com.sap.sse.common.WithID;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.OperationWithResultWithIdWrapper;
import com.sap.sse.replication.OperationsToMasterSendingQueue;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Optional;
import java.util.logging.Logger;

public interface OperationsToMasterSender<S, O extends OperationWithResult<S, ?>>
extends OperationsToMasterSendingQueue,
WithID {
    public static final Logger logger = Logger.getLogger(OperationsToMasterSender.class.getName());
    public static final /* synthetic */ boolean $assertionsDisabled;

    public ReplicationMasterDescriptor getMasterDescriptor();

    public void writeOperation(OperationWithResult<?, ?> var1, OutputStream var2, boolean var3) throws IOException;

    default public <T> void sendReplicaInitiatedOperationToMaster(OperationWithResult<S, T> operation) throws IOException {
        ReplicationMasterDescriptor masterDescriptor = this.getMasterDescriptor();
        assert (masterDescriptor != null);
        OperationWithResultWithIdWrapper operationWithResultWithIdWrapper = new OperationWithResultWithIdWrapper(operation);
        this.addOperationSentToMasterForReplication(operationWithResultWithIdWrapper);
        URL url = masterDescriptor.getSendReplicaInitiatedOperationToMasterURL(this.getId().toString());
        HttpURLConnection connection = (HttpURLConnection)HttpUrlConnectionHelper.redirectConnectionWithBearerToken((URL)url, (Duration)Duration.ONE_MINUTE.times(10L), (String)"POST", (String)masterDescriptor.getBearerToken(), (String)"application/octet-stream", Optional.of(outputStream -> {
            logger.fine("Sending operation " + operation + " to master " + masterDescriptor + "'s replicable with ID " + this + " for initial execution and replication");
            DataOutputStream dos = new DataOutputStream(outputStream);
            dos.writeUTF(this.getId().toString());
            this.writeOperation(operationWithResultWithIdWrapper, outputStream, true);
        }));
        int responseCode = connection.getResponseCode();
        if (responseCode < 300 || responseCode >= 500 || responseCode == 404) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), HttpUrlConnectionHelper.getCharsetFromConnectionOrDefault((URLConnection)connection, (String)"UTF-8")));
            bufferedReader.close();
        } else {
            logger.warning("An HTTP error " + responseCode + " was returned from the master when trying to apply operation " + operationWithResultWithIdWrapper + ". The operation is expected to have failed on the server and will not be enqueued for retry.");
        }
    }

    public void addOperationSentToMasterForReplication(OperationWithResultWithIdWrapper<S, ?> var1);

    public boolean hasSentOperationToMaster(OperationWithResult<S, ?> var1);
}

