/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.deckmanadapter.impl;

import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.deckmanadapter.DeckmanAdapter;
import com.sap.sailing.domain.deckmanadapter.LogFile;
import com.sap.sailing.domain.deckmanadapter.Record;
import com.sap.sailing.domain.deckmanadapter.impl.DeckmanAdapterFactoryImpl;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.domain.trackimport.GPSFixImporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public class DeckmanGPSFixImporter
implements GPSFixImporter {
    public boolean importFixes(InputStream inputStream, Charset charset, GPSFixImporter.Callback callback, boolean inferSpeedAndBearing, String sourceName) throws FormatNotSupportedException, IOException {
        DeckmanAdapter deckmanAdapter = DeckmanAdapterFactoryImpl.INSTANCE.createDeckmanAdapter();
        TrackFileImportDeviceIdentifierImpl device = new TrackFileImportDeviceIdentifierImpl(sourceName, String.valueOf(this.getType()) + "@" + new Date());
        AtomicBoolean importedFixes = new AtomicBoolean(false);
        try {
            LogFile i = deckmanAdapter.parseLogFile(new InputStreamReader(inputStream));
            while (i.hasNext()) {
                Record record = (Record)i.next();
                callback.addFix((GPSFix)new GPSFixMovingImpl(record.getPosition(), record.getTimePoint(), record.getGpsFix().getSpeed(), record.getGpsFix().getOptionalTrueHeading()), (TrackFileImportDeviceIdentifier)device);
                importedFixes.set(true);
            }
            return importedFixes.get();
        }
        catch (RuntimeException e) {
            if (e.getCause() != null) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new FormatNotSupportedException("Error reading Deckman CSV file", e.getCause());
            }
            throw new FormatNotSupportedException("Error reading Deckman CSV file", (Throwable)e);
        }
    }

    public Iterable<String> getSupportedFileExtensions() {
        return Arrays.asList("csv");
    }

    public String getType() {
        return "Deckman";
    }
}

