/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.gateway.impl;

import com.igtimi.IgtimiData;
import com.igtimi.IgtimiStream;
import com.sap.sailing.domain.igtimiadapter.DataAccessWindow;
import com.sap.sailing.domain.igtimiadapter.Device;
import com.sap.sailing.domain.igtimiadapter.datatypes.Type;
import com.sap.sailing.domain.igtimiadapter.gateway.impl.AbstractRiotServerResource;
import com.sap.sailing.domain.igtimiadapter.gateway.impl.Activator;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotServer;
import com.sap.sse.common.MultiTimeRange;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.http.client.ClientProtocolException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

@Path(value="/api/v1/resources")
public class RiotResourcesResource
extends AbstractRiotServerResource {
    protected static final String RESOURCES = "/resources";
    private static final String DATA = "/data";
    private static final String LATEST = "/latest";

    @Path(value="/data/latest")
    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getLatestDatum(@QueryParam(value="serial_numbers[]") Set<String> serialNumbers, @QueryParam(value="type") int type) throws ParseException, IOException {
        RiotServer riot = Activator.getInstance().getRiotServer();
        JSONObject result = new JSONObject();
        Subject subject = SecurityUtils.getSubject();
        Set<String> serialNumbersToUse = serialNumbers == null || serialNumbers.isEmpty() ? Util.map((Iterable)this.getRiotService().getDevices(), d -> d.getSerialNumber()) : serialNumbers;
        Iterable<DataAccessWindow> daws = this.getDataAccessWindowsReadableBySubject(MultiTimeRange.of((TimeRange[])new TimeRange[]{TimeRange.create(null, null)}), serialNumbersToUse);
        Map<String, MultiTimeRange> multiTimeRangesPerDeviceSerialNumber = this.getTimeRangesByDeviceSerialNumber(daws);
        for (String serialNumber : serialNumbersToUse) {
            IgtimiStream.Msg lastMessage;
            Device device = this.getRiotService().getDeviceBySerialNumber(serialNumber);
            if (device == null || !subject.isPermitted(device.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ)) || (lastMessage = riot.getLastMessage(serialNumber, IgtimiData.DataPoint.DataCase.forNumber((int)type), multiTimeRangesPerDeviceSerialNumber.get(serialNumber))) == null) continue;
            JSONArray singleMessage = new JSONArray();
            singleMessage.add((Object)Base64.getEncoder().encodeToString(lastMessage.toByteArray()));
            result.put((Object)serialNumber, (Object)singleMessage);
        }
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/data")
    public Response getResourcesData(@Context UriInfo ui) throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        MultivaluedMap queryParams = ui.getQueryParameters();
        String startTimeString = (String)queryParams.getFirst((Object)"start_time");
        TimePoint startTime = startTimeString == null ? null : TimePoint.of((Long)Long.valueOf(startTimeString));
        String endTimeString = (String)queryParams.getFirst((Object)"end_time");
        TimePoint endTime = endTimeString == null ? null : TimePoint.of((Long)Long.valueOf(endTimeString));
        Iterable serialNumbers = queryParams.get((Object)"serial_numbers[]") == null ? Util.map((Iterable)this.getRiotService().getDevices(), d -> d.getSerialNumber()) : (Iterable)queryParams.get((Object)"serial_numbers[]");
        HashMap<Type, Double> typesAndCompression = new HashMap<Type, Double>();
        HashSet<IgtimiData.DataPoint.DataCase> dataCases = new HashSet<IgtimiData.DataPoint.DataCase>();
        IgtimiData.DataPoint.DataCase[] dataCaseArray = IgtimiData.DataPoint.DataCase.values();
        int n = dataCaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IgtimiData.DataPoint.DataCase dataCase = dataCaseArray[n2];
            String typesAndCompressionKey = "types[" + dataCase.getNumber() + "]";
            if (queryParams.containsKey((Object)typesAndCompressionKey)) {
                dataCases.add(dataCase);
                Type type = Type.valueOf((int)dataCase.getNumber());
                if (type != null) {
                    typesAndCompression.put(type, Double.valueOf((String)queryParams.getFirst((Object)typesAndCompressionKey)));
                }
            }
            ++n2;
        }
        TimeRange requestedTimeRange = TimeRange.create((TimePoint)startTime, (TimePoint)endTime);
        Subject subject = SecurityUtils.getSubject();
        Iterable serialNumbersOfDevicesUserCanRead = Util.filter((Iterable)serialNumbers, serialNumber -> subject.isPermitted(this.getRiotService().getDeviceBySerialNumber(serialNumber).getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ)));
        Iterable<DataAccessWindow> daws = this.getDataAccessWindowsReadableBySubject(MultiTimeRange.of((TimeRange[])new TimeRange[]{requestedTimeRange}), serialNumbersOfDevicesUserCanRead);
        Map<String, MultiTimeRange> multiTimeRangesPerDeviceSerialNumber = this.getTimeRangesByDeviceSerialNumber(daws);
        JSONObject result = new JSONObject();
        Base64.Encoder base64Encoder = Base64.getEncoder();
        for (Map.Entry<String, MultiTimeRange> deviceSerialNumberAndMultiTimeRange : multiTimeRangesPerDeviceSerialNumber.entrySet()) {
            MultiTimeRange timeRangeIntersectionBetweenRequestAndDAWs = deviceSerialNumberAndMultiTimeRange.getValue().intersection(requestedTimeRange);
            if (timeRangeIntersectionBetweenRequestAndDAWs.isEmpty()) continue;
            Iterable messagesForDAW = this.getRiotService().getMessages(deviceSerialNumberAndMultiTimeRange.getKey(), timeRangeIntersectionBetweenRequestAndDAWs, dataCases);
            JSONArray arrayForDevice = (JSONArray)result.computeIfAbsent((Object)deviceSerialNumberAndMultiTimeRange.getKey(), d -> new JSONArray());
            for (IgtimiStream.Msg message : messagesForDAW) {
                arrayForDevice.add((Object)new String(base64Encoder.encode(message.toByteArray())));
            }
        }
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    private Map<String, MultiTimeRange> getTimeRangesByDeviceSerialNumber(Iterable<DataAccessWindow> daws) {
        HashMap<String, MultiTimeRange> result = new HashMap<String, MultiTimeRange>();
        for (DataAccessWindow daw : daws) {
            result.compute(daw.getDeviceSerialNumber(), (serialNumber, multiTimeRange) -> multiTimeRange == null ? MultiTimeRange.of((TimeRange[])new TimeRange[]{daw.getTimeRange()}) : multiTimeRange.union(daw.getTimeRange()));
        }
        return result;
    }

    private Iterable<DataAccessWindow> getDataAccessWindowsReadableBySubject(MultiTimeRange timeRanges, Iterable<String> serialNumbers) {
        Subject subject = SecurityUtils.getSubject();
        return Util.filter((Iterable)this.getRiotService().getDataAccessWindows(serialNumbers, timeRanges), daw -> subject.isPermitted(daw.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ)));
    }
}

