/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.gateway.impl;

import com.sap.sailing.domain.igtimiadapter.Device;
import com.sap.sailing.domain.igtimiadapter.gateway.impl.AbstractRiotServerResource;
import com.sap.sailing.domain.igtimiadapter.impl.DeviceDeserializer;
import com.sap.sailing.domain.igtimiadapter.impl.DeviceSerializer;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotServer;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.http.client.ClientProtocolException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Path(value="/api/v1/devices")
public class RiotDevicesResource
extends AbstractRiotServerResource {
    protected static final String DEVICES = "/devices";

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getDevices() throws ClientProtocolException, IllegalStateException, IOException, ParseException {
        RiotServer riot = this.getRiotService();
        SecurityService securityService = this.getSecurityService();
        JSONObject result = new JSONObject();
        JSONArray resourcesJson = new JSONArray();
        result.put((Object)"devices", (Object)resourcesJson);
        for (Device device : riot.getDevices()) {
            if (!securityService.hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)device)) continue;
            resourcesJson.add((Object)new DeviceSerializer().createJsonFromDevice(device));
        }
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @POST
    @Consumes(value={"application/json;charset=UTF-8"})
    public Response postDevice(@Context HttpServletRequest request) throws IOException, ParseException {
        RiotServer riot = this.getRiotService();
        SecurityService securityService = this.getSecurityService();
        ServletInputStream inputStream = request.getInputStream();
        JSONObject deviceJson = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader((InputStream)inputStream));
        Device device = new DeviceDeserializer().createDeviceFromJson(deviceJson);
        securityService.setOwnershipCheckPermissionForObjectCreationAndRevertOnError(device.getPermissionType(), device.getIdentifier().getTypeRelativeObjectIdentifier(), device.getName(), () -> riot.createDevice(device.getSerialNumber()));
        return Response.ok().build();
    }

    @Path(value="{id}")
    @DELETE
    public Response deleteDevice(@PathParam(value="id") long id) throws IOException, ParseException {
        RiotServer riot = this.getRiotService();
        SecurityService securityService = this.getSecurityService();
        Device device = riot.getDeviceById(id);
        if (device != null) {
            securityService.checkCurrentUserDeletePermission((WithQualifiedObjectIdentifier)device);
            riot.removeDevice(id);
            securityService.deleteAllDataForRemovedObject(device.getIdentifier());
        }
        return Response.ok().build();
    }
}

