/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.gateway.impl;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.igtimiadapter.DataAccessWindow;
import com.sap.sailing.domain.igtimiadapter.gateway.impl.AbstractRiotServerResource;
import com.sap.sailing.domain.igtimiadapter.gateway.impl.Activator;
import com.sap.sailing.domain.igtimiadapter.impl.DataAccessWindowDeserializer;
import com.sap.sailing.domain.igtimiadapter.impl.DataAccessWindowSerializer;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotServer;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.http.client.ClientProtocolException;
import org.apache.shiro.SecurityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@Path(value="/api/v1/data_access_windows")
public class RiotDataAccessWindowsResource
extends AbstractRiotServerResource {
    protected static final String DATA_ACCESS_WINDOWS = "/data_access_windows";

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getDataAccessWindows(@QueryParam(value="permission") String permission, @QueryParam(value="start_time") String startTime, @QueryParam(value="end_time") String endTime, @QueryParam(value="serial_numbers[]") Set<String> serialNumbers, @QueryParam(value="stream_ids[]") Set<String> streamIds) throws ClientProtocolException, IllegalStateException, IOException, ParseException {
        RiotServer riot = Activator.getInstance().getRiotServer();
        JSONObject result = new JSONObject();
        JSONArray dawsJson = new JSONArray();
        result.put((Object)"data_access_windows", (Object)dawsJson);
        for (DataAccessWindow daw : riot.getDataAccessWindows()) {
            if (!SecurityUtils.getSubject().isPermitted(daw.getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ)) || !serialNumbers.isEmpty() && !serialNumbers.contains(daw.getDeviceSerialNumber()) || !TimeRange.create((TimePoint)(startTime == null ? null : TimePoint.of((Long)Long.valueOf(startTime))), endTime == null ? null : TimePoint.of((Long)Long.valueOf(endTime))).intersects(daw.getTimeRange())) continue;
            JSONObject dataAccessWindowJson = new JSONObject();
            dataAccessWindowJson.put((Object)"data_access_window", (Object)new DataAccessWindowSerializer().createJsonFromDataAccessWindow(daw));
            dawsJson.add((Object)dataAccessWindowJson);
        }
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @POST
    @Consumes(value={"application/json;charset=UTF-8"})
    public Response postDataAccessWindow(@Context HttpServletRequest request) throws IOException, ParseException {
        RiotServer riot = this.getRiotService();
        SecurityService securityService = this.getSecurityService();
        ServletInputStream inputStream = request.getInputStream();
        JSONObject dawJson = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader((InputStream)inputStream));
        DataAccessWindow daw = new DataAccessWindowDeserializer().createDataAccessWindowFromJson(dawJson);
        DataAccessWindow newDaw = (DataAccessWindow)securityService.setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.IGTIMI_DATA_ACCESS_WINDOW, daw.getIdentifier().getTypeRelativeObjectIdentifier(), daw.getName(), () -> riot.createDataAccessWindow(daw.getDeviceSerialNumber(), daw.getStartTime(), daw.getEndTime()));
        return Response.ok((Object)this.streamingOutput(new DataAccessWindowSerializer().createJsonFromDataAccessWindow(newDaw))).build();
    }

    @Path(value="{id}")
    @DELETE
    public Response deleteDataAccessWindow(@PathParam(value="id") long id) throws IOException, ParseException {
        RiotServer riot = this.getRiotService();
        SecurityService securityService = this.getSecurityService();
        DataAccessWindow daw = riot.getDataAccessWindowById(id);
        if (daw != null) {
            securityService.checkCurrentUserDeletePermission((WithQualifiedObjectIdentifier)daw);
            riot.removeDataAccessWindow(id);
            securityService.deleteAllDataForRemovedObject(daw.getIdentifier());
        }
        return Response.ok().build();
    }
}

